/*

    Copyright 2004 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#ifdef WIN32
    #include <direct.h>
    #include <malloc.h>
#else
    #include <unistd.h>
#endif








#define VER         "0.1.3"
#define BUFFSZ      16384
#define FNAMESZ     516








void myread(char *name, int size, FILE *fd);
void create_dir(char *name);
void filecopy(FILE *fdout, FILE *fdin, unsigned long size);
void std_err(void);
void io_err(void);







struct intro {
    unsigned long   sign;
    unsigned long   unknown1;
    unsigned char   title[80];
    unsigned long   tot;
    unsigned long   unknown2;
} intro;




struct offsets {
    unsigned long   fnameoff;       // don't use it
    unsigned long   len;
    unsigned long   off;
    unsigned long   unknown1;
    unsigned long   unknown2;
} offsets;








int main(int argc, char *argv[]) {
    FILE            *fd,
                    *fdname,
                    *fddata,
                    *fdout;
    unsigned char   *filename;
    unsigned long   offname,
                    written;
    int             err;
    struct  stat    xstat;



    setbuf(stdout, NULL);


    fputs("\n"
        "POD2 files extractor "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\nUsage: %s <file.POD> <destination_dir>\n",
            argv[0]);
        exit(1);
    }


    fd = fopen(argv[1], "rb");
    if(!fd) std_err();




    err = fread(&intro, sizeof(intro), 1, fd);
    if(err != 1) io_err();

    if(intro.sign != 0x32444f50) {
        fputs("\nError: file is not a valid POD2 file supported by this tool\n", stdout);
        exit(1);
    }


    printf(
        "Title: %s\n"
        "Files: %lu\n",
        intro.title, intro.tot);


    fdname = fopen(argv[1], "rb");
    if(!fdname) std_err();
    fddata = fopen(argv[1], "rb");
    if(!fddata) std_err();



    offname = (intro.tot * sizeof(offsets)) + sizeof(intro);
    err = fseek(fdname, offname, SEEK_SET);
    if(err < 0) std_err();


    err = chdir(argv[2]);
    if(err < 0) std_err();


    fputs("\n"
        "Files:\n"
        "------\n", stdout);



    filename = malloc(FNAMESZ);
    if(!filename) std_err();



    written = 0;
    for(; intro.tot > 0; intro.tot--) {

        err = fread(&offsets, sizeof(offsets), 1, fd);
        if(err != 1) io_err();


        myread(filename, FNAMESZ, fdname);
        printf("%s\n", filename);


        err = stat(filename, &xstat);
        if(!err) {
            fputs("File already exists, want you overwrite it (y/n)? ", stdout);
            fflush(stdin);
            do { err = fgetc(stdin); } while(err == '\n');
            if((err != 'y') && (err != 'Y')) {
                fputs("  *SKIPPED*\n", stdout);
                continue;
            }
        }


        create_dir(filename);

        fdout = fopen(filename, "wb");
        if(!fdout) std_err();

        err = fseek(fddata, offsets.off, SEEK_SET);
        if(err < 0) std_err();

        if(offsets.len) filecopy(fdout, fddata, offsets.len);

        fclose(fdout);
        written++;
    }


    fclose(fd);
    fclose(fdname);
    fclose(fddata);

    printf("\nFiles extracted: %lu\n", written);

    return(0);
}









void myread(char *name, int size, FILE *fd) {
    for(; size > 0; size--, name++) {
        *name = fgetc(fd);
        if(!*name) break;
    }
}









void create_dir(char *name) {
    char    *stri,
            *strf;

        /* security */
    stri = name;
    while(1) {
        if((*stri == '/') || (*stri == '\\') || (stri[1] == ':')) {
            *stri = '_';
        } else break;
        stri++;
    }

    stri = name;
    while(1) {
        strf = strchr(stri, '\\');
        if(!strf) {
            strf = strchr(stri, '/');
            if(!strf) break;
        }
        *strf = 0x00;

        if(*stri == '.') *stri = '_';   // security
        stri = strf + 1;
#ifdef WIN32
        mkdir(name);
        *strf = '\\';
#else
        mkdir(name, 0);
        *strf = '/';
#endif
    }
}








void filecopy(FILE *fdout, FILE *fdin, unsigned long size) {
    unsigned char   *buff;
    int             err;
    unsigned long   len;

    buff = alloca(BUFFSZ);
    if(!buff) std_err();

    len = BUFFSZ;
    do {
        if(len > size) len = size;

        err = fread(buff, len, 1, fdin);
        if(err != 1) io_err();

        err = fwrite(buff, len, 1, fdout);
        if(err != 1) io_err();

        size -= len;
    } while(size);
}









void std_err(void) {
    perror("\nError");
    exit(1);
}







void io_err(void) {
    fputs("\nError: I/O error, the file is incomplete or the disk space is finished\n", stdout);
    exit(1);
}




