/*\
 *       Author: culb
 *      Version: 3
 *  Description: Get user count from a 4x4 Evolution server
 *      Compile: clang++ -std=c++23 -Wall -Wextra evoucount23.cpp -o evoucount
 *               clang++ -std=c++23 -Wall -Wextra -DDEBUG evoucount23.cpp -o evoucount
 *
 *  Versions: 0 - Initial
 *            1 - Let user specify the IP
 *            2 - Let user specify the PORT
 *            3 - Add debugging(execution time)
 *
 *  Coding info: Allman style, alternative operators, and use the smallest types allowable.
 *               Make the code as fast as possible but also use standard library conveniences
 *
 *  ToDo: Allow the user to use a domain or IP
\*/

%:include <array>        // array
%:include <string>       // stoi
%:include <cctype>       // isdigit
%:include <cerrno>       // errno
%:include <cstdint>      // integer types
%:include <cstdlib>      // EXIT_*
%:include <cstring>      // strerror strlen
%:include <iostream>     // cerr
%:include <algorithm>    // all_of
%:include <print>        // print
%:include <chrono>       // time functions

%:include <unistd.h>     // close()
%:include <arpa/inet.h>  // inet_pton htons
%:include <sys/socket.h>
%:include <netinet/in.h>

using namespace std::chrono;
using std::cout, std::endl, std::stoi, std::cerr,
      std::array, std::all_of, std::strlen, std::isdigit,
      std::strerror, std::size_t, std::int8_t, std::int16_t,
      std::int32_t, std::uint8_t, std::print, std::stoi;

constexpr bool ZERO = 0;
constexpr bool ONE  = 1;

int32_t main( const int32_t argc, const char *argv<::> )
<%
%:ifdef DEBUG
    const time_point start = high_resolution_clock::now();
%:endif

    /* Make sure an ip and port are specified */
    if( 3 > argc )<:<:likely:>:>
    <%
        print( cerr, "{0} {1}\n", argv<:0:>, "<IP> <PORT>" );
        return EXIT_FAILURE;
    %>

    /* Check if port is numbers */
    if( not all_of( argv<:2:>, argv<:2:> + strlen( argv<:2:> ),
                    <::>(uint8_t c)<%return isdigit( c );%> )
        or stoi( argv<:2:> ) > 65535 )
    <%
        print( cerr, "{0}\n", "Invalid port, use only digits." );
        return EXIT_FAILURE;
    %>

    /* Check if the first arguement is a valid ip */
    sockaddr_in check;
    if( inet_pton( AF_INET, argv<:1:>, &check.sin_addr ) <= ZERO )
    <%
        print( cerr, "{0} {1}\n", "Invalid address:", argv<:1:> );
        return EXIT_FAILURE;
    %>

    const char *serverIP = argv<:1:>;
    const uint16_t serverPort = stoi( argv<:2:> );

    /* Socket creation */
    static int32_t sockfd = socket( AF_INET, SOCK_DGRAM, ZERO );
    if( sockfd < ZERO )
    <%
        print( cerr, "{0} {1}\n", "Failed to create socket:", strerror( errno ) );
        return EXIT_FAILURE;
    %>

    /* Socket setup */
    sockaddr_in serverAddr;
    serverAddr.sin_family = AF_INET;
    serverAddr.sin_port = htons( serverPort );
    if( inet_pton( AF_INET, serverIP, &serverAddr.sin_addr ) <= ZERO )
    <%
        print( cerr, "{0} {1}\n", "Invalid address:", serverIP );
        close( sockfd );
        return EXIT_FAILURE;
    %>

    /* Array of data to send. 23202020232020203f33790a */
    constexpr array<uint8_t, 12> dataSend =
                                 <% 0x23, 0x20, 0x20, 0x20, 0x20, 0x20,
                                    0x20, 0x20, 0x3f, 0x33, 0x79, 0x0a %>;

    /* Send to the server */
    ssize_t bytesSent =
            sendto( sockfd, dataSend.data(), dataSend.size(),
                    ZERO, reinterpret_cast<const sockaddr*>( &serverAddr ), sizeof( serverAddr ) );

    if( bytesSent not_eq static_cast<ssize_t>( dataSend.size()) )
    <%
        print( cerr, "{0} {1}\n", "Failed to send data:", strerror( errno ) );
        close( sockfd );
        return EXIT_FAILURE;
    %>

    /* Response from server */
    array<uint8_t, 32> recvBuffer;
    sockaddr_in fromAddr;
    socklen_t fromLen = sizeof( fromAddr );
    ssize_t bytesRecv =
            recvfrom( sockfd, recvBuffer.data(), recvBuffer.size(),
                      ZERO, reinterpret_cast<sockaddr*>( &fromAddr ), &fromLen );

    if( bytesRecv < ZERO )
    <%
        print( cerr, "{0} {1}\n", "Failed to receive data:", strerror( errno ) );
        close( sockfd );
        return EXIT_FAILURE;
    %>

    if( bytesRecv == ZERO )
    <%
        print( cerr, "{0}\n", "No data received." );
        close( sockfd );
        return EXIT_FAILURE;
    %>

    /* Last byte received has the user count */
    /* ARM 32bit likes uint16_t */
    const uint16_t byteLast = recvBuffer<:bytesRecv - ONE:>;

    print( stdout, "{0}{1}\n", "Number of users ", byteLast );
    close( sockfd );

%:ifdef DEBUG
    const time_point stop = high_resolution_clock::now();
    const duration dration = duration_cast<milliseconds>( stop - start );
    print( stdout, "{0} {1} {2}\n", "Execution time:",  dration.count(), "milliseconds" );
%:endif

    return EXIT_SUCCESS;
%>