-- Adminer 4.7.8 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP DATABASE IF EXISTS `track_database`;
CREATE DATABASE `track_database` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_bin */ /*!80016 DEFAULT ENCRYPTION='N' */;
USE `track_database`;

DROP TABLE IF EXISTS `evo1`;
CREATE TABLE `evo1` (
  `url` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `track_title` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `author` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '.',
  `filesize` int NOT NULL,
  `track_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '.',
  `extension` varchar(1) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `track_date` date NOT NULL,
  `downloads` int NOT NULL DEFAULT '10',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO `evo1` (`url`, `track_title`, `description`, `author`, `filesize`, `track_type`, `extension`, `track_date`, `downloads`, `id`) VALUES
('http://tonkas.hopto.org/EVO1/!!ARENA.ZIP',	'!!ARENA.ZIP',	'!!ARENA.ZIP',	'.',	633932,	'circuit',	'z',	'2001-01-01',	10,	1),
('http://tonkas.hopto.org/EVO1/!!CHALL.ZIP',	'!!CHALL.ZIP',	'!!CHALL.ZIP',	'.',	856648,	'circuit',	'z',	'2001-01-01',	10,	2),
('http://tonkas.hopto.org/EVO1/!!COAST.ZIP',	'!!COAST.ZIP',	'!!COAST.ZIP',	'.',	1045961,	'circuit',	'z',	'2001-01-01',	10,	3),
('http://tonkas.hopto.org/EVO1/!!HOLE.ZIP',	'!!HOLE.ZIP',	'!!HOLE.ZIP',	'.',	1087640,	'circuit',	'z',	'2001-01-01',	10,	4),
('http://tonkas.hopto.org/EVO1/!!RACES.ZIP',	'!!RACES.ZIP',	'!!RACES.ZIP',	'.',	2898932,	'circuit',	'z',	'2001-01-01',	10,	5),
('http://tonkas.hopto.org/EVO1/!FUNRUN.ZIP',	'!FUNRUN.ZIP',	'!FUNRUN.ZIP',	'.',	2858162,	'circuit',	'z',	'2001-01-01',	10,	6),
('http://tonkas.hopto.org/EVO1/!KMountains.zip',	'!KMountains.zip',	'!KMountains.zip',	'.',	525456,	'circuit',	'z',	'2000-12-20',	10,	7),
('http://tonkas.hopto.org/EVO1/!TD1.LTE',	'!TD1.LTE',	'!TD1.LTE',	'.',	53327,	'circuit',	'l',	'2001-11-16',	10,	8),
('http://tonkas.hopto.org/EVO1/!TD2A.LTE',	'!TD2A.LTE',	'!TD2A.LTE',	'.',	70774,	'circuit',	'l',	'2001-05-30',	10,	9),
('http://tonkas.hopto.org/EVO1/!TD3.LTE',	'!TD3.LTE',	'!TD3.LTE',	'.',	65375,	'circuit',	'l',	'2001-05-30',	10,	10),
('http://tonkas.hopto.org/EVO1/!td4.lte',	'!td4.lte',	'!td4.lte',	'.',	58310,	'circuit',	'l',	'2004-12-16',	10,	11),
('http://tonkas.hopto.org/EVO1/!td6.lte',	'!td6.lte',	'!td6.lte',	'.',	59737,	'circuit',	'l',	'2004-05-18',	10,	12),
('http://tonkas.hopto.org/EVO1/!TDBAJA1.ZIP',	'!TDBAJA1.ZIP',	'!TDBAJA1.ZIP',	'.',	3145837,	'circuit',	'z',	'2000-12-31',	10,	13),
('http://tonkas.hopto.org/EVO1/007spy.lte',	'007spy.lte',	'007spy.lte',	'.',	42020,	'circuit',	'l',	'2021-01-26',	10,	14),
('http://tonkas.hopto.org/EVO1/0degrees.lte',	'0degrees.lte',	'0degrees.lte',	'.',	75139,	'circuit',	'l',	'2021-01-26',	10,	15),
('http://tonkas.hopto.org/EVO1/121drag_2.lte',	'121drag_2.lte',	'121drag_2.lte',	'.',	44630,	'circuit',	'l',	'2021-01-26',	10,	16),
('http://tonkas.hopto.org/EVO1/1FORDSX.ZIP',	'1FORDSX.ZIP',	'1FORDSX.ZIP',	'.',	2939951,	'circuit',	'z',	'2001-03-03',	10,	17),
('http://tonkas.hopto.org/EVO1/1LEFTOTHERRIGHT.LTE',	'1LEFTOTHERRIGHT.LTE',	'1LEFTOTHERRIGHT.LTE',	'.',	67556,	'circuit',	'l',	'2001-01-09',	10,	18),
('http://tonkas.hopto.org/EVO1/2001SX.pod',	'2001SX.pod',	'2001SX.pod',	'.',	4735745,	'circuit',	'p',	'2021-01-25',	10,	19),
('http://tonkas.hopto.org/EVO1/2001SX.ZIP',	'2001SX.ZIP',	'2001SX.ZIP',	'.',	1863255,	'circuit',	'z',	'2001-01-09',	10,	20),
('http://tonkas.hopto.org/EVO1/204ASPHALTOVAL.LTE',	'204ASPHALTOVAL.LTE',	'204ASPHALTOVAL.LTE',	'.',	26515,	'circuit',	'l',	'2001-02-24',	10,	21),
('http://tonkas.hopto.org/EVO1/204badream.lte',	'204badream.lte',	'204badream.lte',	'.',	30761,	'circuit',	'l',	'2001-07-06',	10,	22),
('http://tonkas.hopto.org/EVO1/204bristol.lte',	'204bristol.lte',	'204bristol.lte',	'.',	26435,	'circuit',	'l',	'2005-11-20',	10,	23),
('http://tonkas.hopto.org/EVO1/204BULLRING.LTE',	'204BULLRING.LTE',	'204BULLRING.LTE',	'.',	25887,	'circuit',	'l',	'2001-07-29',	10,	24),
('http://tonkas.hopto.org/EVO1/204canyon.lte',	'204canyon.lte',	'204canyon.lte',	'.',	46448,	'circuit',	'l',	'2003-05-31',	10,	25),
('http://tonkas.hopto.org/EVO1/204CL3DIRT.LTE',	'204CL3DIRT.LTE',	'204CL3DIRT.LTE',	'.',	46296,	'circuit',	'l',	'2001-08-27',	10,	26),
('http://tonkas.hopto.org/EVO1/204CL3PAVED.LTE',	'204CL3PAVED.LTE',	'204CL3PAVED.LTE',	'.',	26180,	'circuit',	'l',	'2001-08-27',	10,	27),
('http://tonkas.hopto.org/EVO1/204contour.lte',	'204contour.lte',	'204contour.lte',	'.',	32507,	'circuit',	'l',	'2005-02-05',	10,	28),
('http://tonkas.hopto.org/EVO1/204EVENFLO.LTE',	'204EVENFLO.LTE',	'204EVENFLO.LTE',	'.',	38987,	'circuit',	'l',	'2001-05-29',	10,	29),
('http://tonkas.hopto.org/EVO1/204FAULTLINE.LTE',	'204FAULTLINE.LTE',	'204FAULTLINE.LTE',	'.',	56522,	'circuit',	'l',	'2003-06-04',	10,	30),
('http://tonkas.hopto.org/EVO1/204FINDERALLY1A.LTE',	'204FINDERALLY1A.LTE',	'204FINDERALLY1A.LTE',	'.',	31219,	'circuit',	'l',	'2001-08-14',	10,	31),
('http://tonkas.hopto.org/EVO1/204gp.lte',	'204gp.lte',	'204gp.lte',	'.',	19942,	'circuit',	'l',	'2005-04-04',	10,	32),
('http://tonkas.hopto.org/EVO1/204HAPPYVALLEY.LTE',	'204HAPPYVALLEY.LTE',	'204HAPPYVALLEY.LTE',	'.',	61685,	'circuit',	'l',	'2003-05-31',	10,	33),
('http://tonkas.hopto.org/EVO1/204JAM.LTE',	'204JAM.LTE',	'204JAM.LTE',	'.',	49650,	'circuit',	'l',	'2007-02-07',	10,	34),
('http://tonkas.hopto.org/EVO1/204noescape.lte',	'204noescape.lte',	'204noescape.lte',	'.',	21291,	'circuit',	'l',	'2004-04-02',	10,	35),
('http://tonkas.hopto.org/EVO1/204PARABOLA.LTE',	'204PARABOLA.LTE',	'204PARABOLA.LTE',	'.',	35779,	'circuit',	'l',	'2001-08-30',	10,	36),
('http://tonkas.hopto.org/EVO1/204phagaroui.lte',	'204phagaroui.lte',	'204phagaroui.lte',	'.',	78948,	'circuit',	'l',	'2002-10-13',	10,	37),
('http://tonkas.hopto.org/EVO1/204ROADRACE (9).LTE',	'204ROADRACE (9).LTE',	'204ROADRACE (9).LTE',	'.',	31800,	'circuit',	'l',	'2021-01-26',	10,	38),
('http://tonkas.hopto.org/EVO1/204ROADRACE.LTE',	'204ROADRACE.LTE',	'204ROADRACE.LTE',	'.',	31800,	'circuit',	'l',	'2001-08-23',	10,	39),
('http://tonkas.hopto.org/EVO1/204scenic.lte',	'204scenic.lte',	'204scenic.lte',	'.',	62971,	'circuit',	'l',	'2021-01-26',	10,	40),
('http://tonkas.hopto.org/EVO1/204SERPENT.LTE',	'204SERPENT.LTE',	'204SERPENT.LTE',	'.',	29677,	'circuit',	'l',	'2004-01-14',	10,	41),
('http://tonkas.hopto.org/EVO1/204SLIDE.LTE',	'204SLIDE.LTE',	'204SLIDE.LTE',	'.',	29509,	'circuit',	'l',	'2001-10-26',	10,	42),
('http://tonkas.hopto.org/EVO1/204STEEL.LTE',	'204STEEL.LTE',	'204STEEL.LTE',	'.',	28208,	'circuit',	'l',	'2006-11-04',	10,	43),
('http://tonkas.hopto.org/EVO1/204summit.lte',	'204summit.lte',	'204summit.lte',	'.',	37764,	'circuit',	'l',	'2001-07-30',	10,	44),
('http://tonkas.hopto.org/EVO1/204TUNNEL.LTE',	'204TUNNEL.LTE',	'204TUNNEL.LTE',	'.',	20597,	'circuit',	'l',	'2001-07-10',	10,	45),
('http://tonkas.hopto.org/EVO1/204velocitys.lte',	'204velocitys.lte',	'204velocitys.lte',	'.',	28127,	'circuit',	'l',	'2001-08-27',	10,	46),
('http://tonkas.hopto.org/EVO1/204vortex.lte',	'204vortex.lte',	'204vortex.lte',	'.',	32063,	'circuit',	'l',	'2004-04-02',	10,	47),
('http://tonkas.hopto.org/EVO1/204weave.lte',	'204weave.lte',	'204weave.lte',	'.',	41741,	'circuit',	'l',	'2007-09-23',	10,	48),
('http://tonkas.hopto.org/EVO1/204xcountry.lte',	'204xcountry.lte',	'204xcountry.lte',	'.',	59532,	'circuit',	'l',	'2001-09-06',	10,	49),
('http://tonkas.hopto.org/EVO1/206wrc.lte',	'206wrc.lte',	'206wrc.lte',	'.',	33074,	'circuit',	'l',	'2007-08-31',	10,	50),
('http://tonkas.hopto.org/EVO1/2extreme.lte',	'2extreme.lte',	'2extreme.lte',	'.',	15052,	'circuit',	'l',	'2004-05-07',	10,	51),
('http://tonkas.hopto.org/EVO1/2S6.LTE',	'2S6.LTE',	'2S6.LTE',	'.',	57061,	'circuit',	'l',	'2001-06-05',	10,	52),
('http://tonkas.hopto.org/EVO1/2tbr.lte',	'2tbr.lte',	'2tbr.lte',	'.',	23287,	'circuit',	'l',	'2006-01-18',	10,	53),
('http://tonkas.hopto.org/EVO1/360RC.LTE',	'360RC.LTE',	'360RC.LTE',	'.',	52032,	'circuit',	'l',	'2001-09-07',	10,	54),
('http://tonkas.hopto.org/EVO1/4X4.LTE',	'4X4.LTE',	'4X4.LTE',	'.',	70737,	'circuit',	'l',	'2001-10-28',	10,	55),
('http://tonkas.hopto.org/EVO1/4X4.ZIP',	'4X4.ZIP',	'4X4.ZIP',	'.',	1027889,	'circuit',	'z',	'2001-01-09',	10,	56),
('http://tonkas.hopto.org/EVO1/4X4ACADEMY.LTE',	'4X4ACADEMY.LTE',	'4X4ACADEMY.LTE',	'.',	62167,	'circuit',	'l',	'2001-05-29',	10,	57),
('http://tonkas.hopto.org/EVO1/4x4GOAT (10).LTE',	'4x4GOAT (10).LTE',	'4x4GOAT (10).LTE',	'.',	45966,	'circuit',	'l',	'2021-01-26',	10,	58),
('http://tonkas.hopto.org/EVO1/4x4GOAT.LTE',	'4x4GOAT.LTE',	'4x4GOAT.LTE',	'.',	45966,	'circuit',	'l',	'2001-07-01',	10,	59),
('http://tonkas.hopto.org/EVO1/4x4in.lte',	'4x4in.lte',	'4x4in.lte',	'.',	5509,	'circuit',	'l',	'2021-01-26',	10,	60),
('http://tonkas.hopto.org/EVO1/4x4ing.lte',	'4x4ing.lte',	'4x4ing.lte',	'.',	10219,	'circuit',	'l',	'2021-01-26',	10,	61),
('http://tonkas.hopto.org/EVO1/4x4Project.exe',	'4x4Project.exe',	'4x4Project.exe',	'.',	86016,	'circuit',	'e',	'2001-04-03',	10,	62),
('http://tonkas.hopto.org/EVO1/4X4RACE.ZIP',	'4X4RACE.ZIP',	'4X4RACE.ZIP',	'.',	1938558,	'circuit',	'z',	'2001-01-07',	10,	63),
('http://tonkas.hopto.org/EVO1/4x4snowrun2.lte',	'4x4snowrun2.lte',	'4x4snowrun2.lte',	'.',	10681,	'circuit',	'l',	'2006-09-17',	10,	64),
('http://tonkas.hopto.org/EVO1/4x4_ISLAND.zip',	'4x4_ISLAND.zip',	'4x4_ISLAND.zip',	'.',	568746,	'circuit',	'z',	'2000-12-05',	10,	65),
('http://tonkas.hopto.org/EVO1/4x4_WIDOWMAKER.zip',	'4x4_WIDOWMAKER.zip',	'4x4_WIDOWMAKER.zip',	'.',	520273,	'circuit',	'z',	'2000-12-03',	10,	66),
('http://tonkas.hopto.org/EVO1/81RMR.ZIP',	'81RMR.ZIP',	'81RMR.ZIP',	'.',	1095850,	'circuit',	'z',	'2001-01-27',	10,	67),
('http://tonkas.hopto.org/EVO1/8MILE.pod',	'8MILE.pod',	'8MILE.pod',	'.',	4826274,	'circuit',	'p',	'2021-01-25',	10,	68),
('http://tonkas.hopto.org/EVO1/AAAAA.LTE',	'AAAAA.LTE',	'AAAAA.LTE',	'.',	41178,	'circuit',	'l',	'2006-12-21',	10,	69),
('http://tonkas.hopto.org/EVO1/ab.lte',	'ab.lte',	'ab.lte',	'.',	21812,	'circuit',	'l',	'2007-02-07',	10,	70),
('http://tonkas.hopto.org/EVO1/Abcdefg.lte',	'Abcdefg.lte',	'Abcdefg.lte',	'.',	30047,	'circuit',	'l',	'2021-01-26',	10,	71),
('http://tonkas.hopto.org/EVO1/abmount(2)(1).lte',	'abmount(2)(1).lte',	'abmount(2)(1).lte',	'.',	15380,	'circuit',	'l',	'2008-08-09',	10,	72),
('http://tonkas.hopto.org/EVO1/accden.lte',	'accden.lte',	'accden.lte',	'.',	41684,	'circuit',	'l',	'2021-01-26',	10,	73),
('http://tonkas.hopto.org/EVO1/ACCELSTA.ZIP',	'ACCELSTA.ZIP',	'ACCELSTA.ZIP',	'.',	2167867,	'circuit',	'z',	'2001-04-12',	10,	74),
('http://tonkas.hopto.org/EVO1/acidsprings.pod',	'acidsprings.pod',	'acidsprings.pod',	'.',	1314846,	'circuit',	'p',	'2007-11-23',	10,	75),
('http://tonkas.hopto.org/EVO1/ADBOMBTAG.LTE',	'ADBOMBTAG.LTE',	'ADBOMBTAG.LTE',	'.',	6982,	'circuit',	'l',	'2021-01-26',	10,	76),
('http://tonkas.hopto.org/EVO1/adelantate.lte',	'adelantate.lte',	'adelantate.lte',	'.',	27331,	'circuit',	'l',	'2021-01-26',	10,	77),
('http://tonkas.hopto.org/EVO1/adkinghill.lte',	'adkinghill.lte',	'adkinghill.lte',	'.',	6995,	'circuit',	'l',	'2021-01-26',	10,	78),
('http://tonkas.hopto.org/EVO1/ADRIANS.LTE',	'ADRIANS.LTE',	'ADRIANS.LTE',	'.',	67586,	'circuit',	'l',	'2001-07-11',	10,	79),
('http://tonkas.hopto.org/EVO1/AFTERHOURS.LTE',	'AFTERHOURS.LTE',	'AFTERHOURS.LTE',	'.',	78036,	'circuit',	'l',	'2001-02-02',	10,	80),
('http://tonkas.hopto.org/EVO1/AHOYTHERE.LTE',	'AHOYTHERE.LTE',	'AHOYTHERE.LTE',	'.',	59091,	'circuit',	'l',	'2021-01-26',	10,	81),
('http://tonkas.hopto.org/EVO1/Airzone.lte',	'Airzone.lte',	'Airzone.lte',	'.',	82122,	'circuit',	'l',	'2021-01-26',	10,	82),
('http://tonkas.hopto.org/EVO1/AKOROFFROAD.pod',	'AKOROFFROAD.pod',	'AKOROFFROAD.pod',	'.',	1235396,	'circuit',	'p',	'2005-07-02',	10,	83),
('http://tonkas.hopto.org/EVO1/akortryout.lte',	'akortryout.lte',	'akortryout.lte',	'.',	92206,	'circuit',	'l',	'2006-04-05',	10,	84),
('http://tonkas.hopto.org/EVO1/ALL-LTES.ZIP',	'ALL-LTES.ZIP',	'ALL-LTES.ZIP',	'.',	22654294,	'circuit',	'z',	'2003-04-27',	10,	85),
('http://tonkas.hopto.org/EVO1/ALL.LTE',	'ALL.LTE',	'ALL.LTE',	'.',	10575,	'circuit',	'l',	'2021-01-26',	10,	86),
('http://tonkas.hopto.org/EVO1/ALLEN0.LTE',	'ALLEN0.LTE',	'ALLEN0.LTE',	'.',	10201,	'circuit',	'l',	'2021-01-26',	10,	87),
('http://tonkas.hopto.org/EVO1/Ama.lte',	'Ama.lte',	'Ama.lte',	'.',	21815,	'circuit',	'l',	'2001-05-29',	10,	88),
('http://tonkas.hopto.org/EVO1/amazing.lte',	'amazing.lte',	'amazing.lte',	'.',	80912,	'circuit',	'l',	'2005-02-05',	10,	89),
('http://tonkas.hopto.org/EVO1/Amazonpit.zip',	'Amazonpit.zip',	'Amazonpit.zip',	'.',	1582226,	'circuit',	'z',	'2001-01-05',	10,	90),
('http://tonkas.hopto.org/EVO1/AMTS.LTE',	'AMTS.LTE',	'AMTS.LTE',	'.',	82712,	'circuit',	'l',	'2004-01-18',	10,	91),
('http://tonkas.hopto.org/EVO1/Anti.lte',	'Anti.lte',	'Anti.lte',	'.',	47223,	'circuit',	'l',	'2002-07-24',	10,	92),
('http://tonkas.hopto.org/EVO1/AO1-5.LTE',	'AO1-5.LTE',	'AO1-5.LTE',	'.',	78790,	'circuit',	'l',	'2003-06-04',	10,	93),
('http://tonkas.hopto.org/EVO1/ap.lte',	'ap.lte',	'ap.lte',	'.',	46021,	'circuit',	'l',	'2021-01-26',	10,	94),
('http://tonkas.hopto.org/EVO1/AREA51.LTE',	'AREA51.LTE',	'AREA51.LTE',	'.',	30621,	'circuit',	'l',	'2001-02-04',	10,	95),
('http://tonkas.hopto.org/EVO1/Area51.zip',	'Area51.zip',	'Area51.zip',	'.',	29521,	'circuit',	'z',	'2001-02-08',	10,	96),
('http://tonkas.hopto.org/EVO1/Arena.lte',	'Arena.lte',	'Arena.lte',	'.',	22310,	'circuit',	'l',	'2001-04-01',	10,	97),
('http://tonkas.hopto.org/EVO1/ARENA.ZIP',	'ARENA.ZIP',	'ARENA.ZIP',	'.',	5407,	'circuit',	'z',	'2001-02-24',	10,	98),
('http://tonkas.hopto.org/EVO1/Arena2.lte',	'Arena2.lte',	'Arena2.lte',	'.',	6249,	'circuit',	'l',	'2001-02-19',	10,	99),
('http://tonkas.hopto.org/EVO1/ARENATAG.ZIP',	'ARENATAG.ZIP',	'ARENATAG.ZIP',	'.',	568478,	'circuit',	'z',	'2001-01-25',	10,	100),
('http://tonkas.hopto.org/EVO1/ARiverRuns.lte',	'ARiverRuns.lte',	'ARiverRuns.lte',	'.',	50439,	'circuit',	'l',	'2001-02-11',	10,	101),
('http://tonkas.hopto.org/EVO1/arizonadoida.lte',	'arizonadoida.lte',	'arizonadoida.lte',	'.',	85412,	'circuit',	'l',	'2021-01-26',	10,	102),
('http://tonkas.hopto.org/EVO1/arizonaheat.lte',	'arizonaheat.lte',	'arizonaheat.lte',	'.',	69814,	'circuit',	'l',	'2001-10-24',	10,	103),
('http://tonkas.hopto.org/EVO1/arizonaheat2.lte',	'arizonaheat2.lte',	'arizonaheat2.lte',	'.',	67980,	'circuit',	'l',	'2021-01-26',	10,	104),
('http://tonkas.hopto.org/EVO1/arizonahillclimb.lte',	'arizonahillclimb.lte',	'arizonahillclimb.lte',	'.',	93654,	'circuit',	'l',	'2003-03-19',	10,	105),
('http://tonkas.hopto.org/EVO1/arizonaoff.lte',	'arizonaoff.lte',	'arizonaoff.lte',	'.',	73198,	'circuit',	'l',	'2002-05-25',	10,	106),
('http://tonkas.hopto.org/EVO1/ARMADILLO.LTE',	'ARMADILLO.LTE',	'ARMADILLO.LTE',	'.',	60158,	'circuit',	'l',	'2021-01-26',	10,	107),
('http://tonkas.hopto.org/EVO1/ARTICULATION.LTE',	'ARTICULATION.LTE',	'ARTICULATION.LTE',	'.',	7735,	'circuit',	'l',	'2021-01-26',	10,	108),
('http://tonkas.hopto.org/EVO1/ASD.LTE',	'ASD.LTE',	'ASD.LTE',	'.',	56297,	'circuit',	'l',	'2021-01-26',	10,	109),
('http://tonkas.hopto.org/EVO1/ashhole.lte',	'ashhole.lte',	'ashhole.lte',	'.',	98974,	'circuit',	'l',	'2005-05-03',	10,	110),
('http://tonkas.hopto.org/EVO1/atohillrider.lte',	'atohillrider.lte',	'atohillrider.lte',	'.',	44459,	'circuit',	'l',	'2021-01-26',	10,	111),
('http://tonkas.hopto.org/EVO1/atojumpbn.lte',	'atojumpbn.lte',	'atojumpbn.lte',	'.',	68511,	'circuit',	'l',	'2021-01-26',	10,	112),
('http://tonkas.hopto.org/EVO1/atosnowtc.lte',	'atosnowtc.lte',	'atosnowtc.lte',	'.',	69893,	'circuit',	'l',	'2007-01-05',	10,	113),
('http://tonkas.hopto.org/EVO1/atvraceway.lte',	'atvraceway.lte',	'atvraceway.lte',	'.',	79263,	'circuit',	'l',	'2021-01-26',	10,	114),
('http://tonkas.hopto.org/EVO1/atw.lte',	'atw.lte',	'atw.lte',	'.',	5466,	'circuit',	'l',	'2021-01-26',	10,	115),
('http://tonkas.hopto.org/EVO1/AX.LTE',	'AX.LTE',	'AX.LTE',	'.',	10841,	'circuit',	'l',	'2003-01-08',	10,	116),
('http://tonkas.hopto.org/EVO1/AZME.LTE',	'AZME.LTE',	'AZME.LTE',	'.',	10158,	'circuit',	'l',	'2002-05-10',	10,	117),
('http://tonkas.hopto.org/EVO1/AZR.LTE',	'AZR.LTE',	'AZR.LTE',	'.',	80139,	'circuit',	'l',	'2021-01-26',	10,	118),
('http://tonkas.hopto.org/EVO1/BA.LTE',	'BA.LTE',	'BA.LTE',	'.',	56128,	'circuit',	'l',	'2021-01-26',	10,	119),
('http://tonkas.hopto.org/EVO1/BAA.LTE',	'BAA.LTE',	'BAA.LTE',	'.',	57096,	'circuit',	'l',	'2021-01-26',	10,	120),
('http://tonkas.hopto.org/EVO1/backdoorrace.lte',	'backdoorrace.lte',	'backdoorrace.lte',	'.',	8002,	'circuit',	'l',	'2021-01-26',	10,	121),
('http://tonkas.hopto.org/EVO1/BACKROAD.LTE',	'BACKROAD.LTE',	'BACKROAD.LTE',	'.',	25969,	'circuit',	'l',	'2004-03-14',	10,	122),
('http://tonkas.hopto.org/EVO1/backroads.lte',	'backroads.lte',	'backroads.lte',	'.',	51164,	'circuit',	'l',	'2001-07-31',	10,	123),
('http://tonkas.hopto.org/EVO1/backtrack.lte',	'backtrack.lte',	'backtrack.lte',	'.',	73206,	'circuit',	'l',	'2001-08-26',	10,	124),
('http://tonkas.hopto.org/EVO1/badgers_rnd_n_rnd.lte',	'badgers_rnd_n_rnd.lte',	'badgers_rnd_n_rnd.lte',	'.',	45719,	'circuit',	'l',	'2001-05-30',	10,	125),
('http://tonkas.hopto.org/EVO1/BADLANDS.LTE',	'BADLANDS.LTE',	'BADLANDS.LTE',	'.',	84145,	'circuit',	'l',	'2001-06-06',	10,	126),
('http://tonkas.hopto.org/EVO1/BAHAHAHA.ZIP',	'BAHAHAHA.ZIP',	'BAHAHAHA.ZIP',	'.',	4084017,	'circuit',	'z',	'2001-02-15',	10,	127),
('http://tonkas.hopto.org/EVO1/Baja Hill.lte',	'Baja Hill.lte',	'Baja Hill.lte',	'.',	84493,	'circuit',	'l',	'2001-03-20',	10,	128),
('http://tonkas.hopto.org/EVO1/Baja1000.lte',	'Baja1000.lte',	'Baja1000.lte',	'.',	85969,	'circuit',	'l',	'2001-06-05',	10,	129),
('http://tonkas.hopto.org/EVO1/Baja2001BETA.zip',	'Baja2001BETA.zip',	'Baja2001BETA.zip',	'.',	1625735,	'circuit',	'z',	'2001-02-02',	10,	130),
('http://tonkas.hopto.org/EVO1/Baja2001BETA0_5.zip',	'Baja2001BETA0_5.zip',	'Baja2001BETA0_5.zip',	'.',	1844874,	'circuit',	'z',	'2001-02-08',	10,	131),
('http://tonkas.hopto.org/EVO1/BAJACAL.LTE',	'BAJACAL.LTE',	'BAJACAL.LTE',	'.',	35148,	'circuit',	'l',	'2001-08-30',	10,	132),
('http://tonkas.hopto.org/EVO1/BAJACALI.LTE',	'BAJACALI.LTE',	'BAJACALI.LTE',	'.',	35506,	'circuit',	'l',	'2002-01-21',	10,	133),
('http://tonkas.hopto.org/EVO1/bajaforest.lte',	'bajaforest.lte',	'bajaforest.lte',	'.',	74536,	'circuit',	'l',	'2003-03-04',	10,	134),
('http://tonkas.hopto.org/EVO1/BAJALAND.LTE',	'BAJALAND.LTE',	'BAJALAND.LTE',	'.',	52881,	'circuit',	'l',	'2003-01-25',	10,	135),
('http://tonkas.hopto.org/EVO1/BajaRace.zip',	'BajaRace.zip',	'BajaRace.zip',	'.',	133546,	'circuit',	'z',	'2001-01-21',	10,	136),
('http://tonkas.hopto.org/EVO1/bangbangbang.lte',	'bangbangbang.lte',	'bangbangbang.lte',	'.',	19688,	'circuit',	'l',	'2021-01-26',	10,	137),
('http://tonkas.hopto.org/EVO1/batadega.pod',	'batadega.pod',	'batadega.pod',	'.',	11531058,	'circuit',	'p',	'2021-01-25',	10,	138),
('http://tonkas.hopto.org/EVO1/BATADEGA.ZIP',	'BATADEGA.ZIP',	'BATADEGA.ZIP',	'.',	3127589,	'circuit',	'z',	'2001-08-27',	10,	139),
('http://tonkas.hopto.org/EVO1/BATMAN.LTE',	'BATMAN.LTE',	'BATMAN.LTE',	'.',	10889,	'circuit',	'l',	'2021-01-26',	10,	140),
('http://tonkas.hopto.org/EVO1/BATTLEBYGOTEN.LTE',	'BATTLEBYGOTEN.LTE',	'BATTLEBYGOTEN.LTE',	'.',	4683,	'circuit',	'l',	'2021-01-26',	10,	141),
('http://tonkas.hopto.org/EVO1/BATTLEBYGOTEN2.LTE',	'BATTLEBYGOTEN2.LTE',	'BATTLEBYGOTEN2.LTE',	'.',	3808,	'circuit',	'l',	'2021-01-26',	10,	142),
('http://tonkas.hopto.org/EVO1/BATTLEBYGOTEN3.LTE',	'BATTLEBYGOTEN3.LTE',	'BATTLEBYGOTEN3.LTE',	'.',	4875,	'circuit',	'l',	'2021-01-26',	10,	143),
('http://tonkas.hopto.org/EVO1/BATTLEBYGOTEN4.LTE',	'BATTLEBYGOTEN4.LTE',	'BATTLEBYGOTEN4.LTE',	'.',	5180,	'circuit',	'l',	'2021-01-26',	10,	144),
('http://tonkas.hopto.org/EVO1/battlezone.zip',	'battlezone.zip',	'battlezone.zip',	'.',	185391,	'circuit',	'z',	'2001-01-15',	10,	145),
('http://tonkas.hopto.org/EVO1/BAYOUBOOGIE.LTE',	'BAYOUBOOGIE.LTE',	'BAYOUBOOGIE.LTE',	'.',	46920,	'circuit',	'l',	'2001-04-04',	10,	146),
('http://tonkas.hopto.org/EVO1/BAYOUBOOGIE2.LTE',	'BAYOUBOOGIE2.LTE',	'BAYOUBOOGIE2.LTE',	'.',	47666,	'circuit',	'l',	'2001-03-03',	10,	147),
('http://tonkas.hopto.org/EVO1/BC.LTE',	'BC.LTE',	'BC.LTE',	'.',	13058,	'circuit',	'l',	'2021-01-26',	10,	148),
('http://tonkas.hopto.org/EVO1/BCDESERT.LTE',	'BCDESERT.LTE',	'BCDESERT.LTE',	'.',	18377,	'circuit',	'l',	'2021-01-26',	10,	149),
('http://tonkas.hopto.org/EVO1/bcisland.LTE',	'bcisland.LTE',	'bcisland.LTE',	'.',	26290,	'circuit',	'l',	'2021-01-26',	10,	150),
('http://tonkas.hopto.org/EVO1/BCTROPIC.LTE',	'BCTROPIC.LTE',	'BCTROPIC.LTE',	'.',	26247,	'circuit',	'l',	'2021-01-26',	10,	151),
('http://tonkas.hopto.org/EVO1/BCXCROSS.LTE',	'BCXCROSS.LTE',	'BCXCROSS.LTE',	'.',	12520,	'circuit',	'l',	'2021-01-26',	10,	152),
('http://tonkas.hopto.org/EVO1/BD.pod',	'BD.pod',	'BD.pod',	'.',	8217679,	'circuit',	'p',	'2021-01-25',	10,	153),
('http://tonkas.hopto.org/EVO1/BEACH.LTE',	'BEACH.LTE',	'BEACH.LTE',	'.',	22524,	'circuit',	'l',	'2001-11-04',	10,	154),
('http://tonkas.hopto.org/EVO1/BEACHb3.LTE',	'BEACHb3.LTE',	'BEACHb3.LTE',	'.',	15003,	'circuit',	'l',	'2001-02-10',	10,	155),
('http://tonkas.hopto.org/EVO1/BEACHbeta2.LTE',	'BEACHbeta2.LTE',	'BEACHbeta2.LTE',	'.',	14145,	'circuit',	'l',	'2001-02-08',	10,	156),
('http://tonkas.hopto.org/EVO1/beachrally.lte',	'beachrally.lte',	'beachrally.lte',	'.',	62547,	'circuit',	'l',	'2007-05-30',	10,	157),
('http://tonkas.hopto.org/EVO1/bebanbeach.lte',	'bebanbeach.lte',	'bebanbeach.lte',	'.',	34103,	'circuit',	'l',	'2002-05-07',	10,	158),
('http://tonkas.hopto.org/EVO1/BENNYDOG.LTE',	'BENNYDOG.LTE',	'BENNYDOG.LTE',	'.',	14853,	'circuit',	'l',	'2001-02-14',	10,	159),
('http://tonkas.hopto.org/EVO1/BENNYDOG2.LTE',	'BENNYDOG2.LTE',	'BENNYDOG2.LTE',	'.',	15356,	'circuit',	'l',	'2001-08-27',	10,	160),
('http://tonkas.hopto.org/EVO1/berphase.lte',	'berphase.lte',	'berphase.lte',	'.',	86633,	'circuit',	'l',	'2021-01-26',	10,	161),
('http://tonkas.hopto.org/EVO1/BESTJ.LTE',	'BESTJ.LTE',	'BESTJ.LTE',	'.',	38430,	'circuit',	'l',	'2021-01-26',	10,	162),
('http://tonkas.hopto.org/EVO1/beware.lte',	'beware.lte',	'beware.lte',	'.',	100305,	'circuit',	'l',	'2005-05-05',	10,	163),
('http://tonkas.hopto.org/EVO1/bewareofdog.lte',	'bewareofdog.lte',	'bewareofdog.lte',	'.',	32021,	'circuit',	'l',	'2001-07-02',	10,	164),
('http://tonkas.hopto.org/EVO1/bigair.lte',	'bigair.lte',	'bigair.lte',	'.',	58848,	'circuit',	'l',	'2007-10-17',	10,	165),
('http://tonkas.hopto.org/EVO1/bigjumps.lte',	'bigjumps.lte',	'bigjumps.lte',	'.',	79133,	'circuit',	'l',	'2004-08-22',	10,	166),
('http://tonkas.hopto.org/EVO1/birtrack.lte',	'birtrack.lte',	'birtrack.lte',	'.',	78726,	'circuit',	'l',	'2005-02-21',	10,	167),
('http://tonkas.hopto.org/EVO1/BKRDIRTTRACK.lte',	'BKRDIRTTRACK.lte',	'BKRDIRTTRACK.lte',	'.',	12922,	'circuit',	'l',	'2021-01-26',	10,	168),
('http://tonkas.hopto.org/EVO1/Bkrrally2a.lte',	'Bkrrally2a.lte',	'Bkrrally2a.lte',	'.',	20662,	'circuit',	'l',	'2021-01-26',	10,	169),
('http://tonkas.hopto.org/EVO1/bkrrally2b.lte',	'bkrrally2b.lte',	'bkrrally2b.lte',	'.',	20729,	'circuit',	'l',	'2008-08-02',	10,	170),
('http://tonkas.hopto.org/EVO1/bkrspeedway.lte',	'bkrspeedway.lte',	'bkrspeedway.lte',	'.',	22278,	'circuit',	'l',	'2001-10-12',	10,	171),
('http://tonkas.hopto.org/EVO1/BKRSTREET.LTE',	'BKRSTREET.LTE',	'BKRSTREET.LTE',	'.',	20175,	'circuit',	'l',	'2021-01-26',	10,	172),
('http://tonkas.hopto.org/EVO1/bkr_canyon.lte',	'bkr_canyon.lte',	'bkr_canyon.lte',	'.',	35518,	'circuit',	'l',	'2001-09-21',	10,	173),
('http://tonkas.hopto.org/EVO1/bkr_corkscrew.lte',	'bkr_corkscrew.lte',	'bkr_corkscrew.lte',	'.',	39554,	'circuit',	'l',	'2021-01-26',	10,	174),
('http://tonkas.hopto.org/EVO1/bkr_drag.lte',	'bkr_drag.lte',	'bkr_drag.lte',	'.',	32540,	'circuit',	'l',	'2021-01-26',	10,	175),
('http://tonkas.hopto.org/EVO1/bkr_enduro.lte',	'bkr_enduro.lte',	'bkr_enduro.lte',	'.',	63881,	'circuit',	'l',	'2001-09-21',	10,	176),
('http://tonkas.hopto.org/EVO1/bkr_skyrumble.lte',	'bkr_skyrumble.lte',	'bkr_skyrumble.lte',	'.',	26232,	'circuit',	'l',	'2021-01-26',	10,	177),
('http://tonkas.hopto.org/EVO1/bkr_tryout.lte',	'bkr_tryout.lte',	'bkr_tryout.lte',	'.',	35167,	'circuit',	'l',	'2021-01-26',	10,	178),
('http://tonkas.hopto.org/EVO1/BLA(1).LTE',	'BLA(1).LTE',	'BLA(1).LTE',	'.',	39384,	'circuit',	'l',	'2007-02-18',	10,	179),
('http://tonkas.hopto.org/EVO1/BLACKGOLDV3.LTE',	'BLACKGOLDV3.LTE',	'BLACKGOLDV3.LTE',	'.',	56582,	'circuit',	'l',	'2021-01-26',	10,	180),
('http://tonkas.hopto.org/EVO1/BLACKMARKET.LTE',	'BLACKMARKET.LTE',	'BLACKMARKET.LTE',	'.',	62573,	'circuit',	'l',	'2021-01-26',	10,	181),
('http://tonkas.hopto.org/EVO1/blackpass.lte',	'blackpass.lte',	'blackpass.lte',	'.',	64665,	'circuit',	'l',	'2021-01-26',	10,	182),
('http://tonkas.hopto.org/EVO1/blametonka.lte',	'blametonka.lte',	'blametonka.lte',	'.',	25148,	'circuit',	'l',	'2006-02-26',	10,	183),
('http://tonkas.hopto.org/EVO1/blametonka2.lte',	'blametonka2.lte',	'blametonka2.lte',	'.',	14711,	'circuit',	'l',	'2002-05-08',	10,	184),
('http://tonkas.hopto.org/EVO1/BLAMETONKAE2.LTE',	'BLAMETONKAE2.LTE',	'BLAMETONKAE2.LTE',	'.',	22171,	'circuit',	'l',	'2003-12-15',	10,	185),
('http://tonkas.hopto.org/EVO1/Blaze.lte',	'Blaze.lte',	'Blaze.lte',	'.',	5266,	'circuit',	'l',	'2021-01-26',	10,	186),
('http://tonkas.hopto.org/EVO1/BLOOD.ZIP',	'BLOOD.ZIP',	'BLOOD.ZIP',	'.',	2485912,	'circuit',	'z',	'2001-02-21',	10,	187),
('http://tonkas.hopto.org/EVO1/Bloody1.LTE',	'Bloody1.LTE',	'Bloody1.LTE',	'.',	32727,	'circuit',	'l',	'2001-04-01',	10,	188),
('http://tonkas.hopto.org/EVO1/bloody2a.pod',	'bloody2a.pod',	'bloody2a.pod',	'.',	16886866,	'circuit',	'p',	'2008-01-20',	10,	189),
('http://tonkas.hopto.org/EVO1/BOGUS.LTE',	'BOGUS.LTE',	'BOGUS.LTE',	'.',	43438,	'circuit',	'l',	'2001-07-13',	10,	190),
('http://tonkas.hopto.org/EVO1/Bombtag.lte',	'Bombtag.lte',	'Bombtag.lte',	'.',	15701,	'circuit',	'l',	'2021-01-26',	10,	191),
('http://tonkas.hopto.org/EVO1/BOMBTAGIT.LTE',	'BOMBTAGIT.LTE',	'BOMBTAGIT.LTE',	'.',	58908,	'circuit',	'l',	'2021-01-26',	10,	192),
('http://tonkas.hopto.org/EVO1/bone.lte',	'bone.lte',	'bone.lte',	'.',	32226,	'circuit',	'l',	'2021-01-26',	10,	193),
('http://tonkas.hopto.org/EVO1/booo.lte',	'booo.lte',	'booo.lte',	'.',	34514,	'circuit',	'l',	'2007-10-12',	10,	194),
('http://tonkas.hopto.org/EVO1/borc.lte',	'borc.lte',	'borc.lte',	'.',	44128,	'circuit',	'l',	'2005-07-21',	10,	195),
('http://tonkas.hopto.org/EVO1/borntobewild.lte',	'borntobewild.lte',	'borntobewild.lte',	'.',	94026,	'circuit',	'l',	'2001-08-05',	10,	196),
('http://tonkas.hopto.org/EVO1/BR.LTE',	'BR.LTE',	'BR.LTE',	'.',	55632,	'circuit',	'l',	'2021-01-26',	10,	197),
('http://tonkas.hopto.org/EVO1/brain_twister.lte',	'brain_twister.lte',	'brain_twister.lte',	'.',	85969,	'circuit',	'l',	'2021-01-26',	10,	198),
('http://tonkas.hopto.org/EVO1/brarizona.lte',	'brarizona.lte',	'brarizona.lte',	'.',	24247,	'circuit',	'l',	'2021-01-26',	10,	199),
('http://tonkas.hopto.org/EVO1/Brasil_Race_Truck.LTE',	'Brasil_Race_Truck.LTE',	'Brasil_Race_Truck.LTE',	'.',	23954,	'circuit',	'l',	'2021-01-26',	10,	200),
('http://tonkas.hopto.org/EVO1/breathe.lte',	'breathe.lte',	'breathe.lte',	'.',	74419,	'circuit',	'l',	'2005-06-16',	10,	201),
('http://tonkas.hopto.org/EVO1/BRIDGEFAR.zip',	'BRIDGEFAR.zip',	'BRIDGEFAR.zip',	'.',	2624974,	'circuit',	'z',	'2001-02-15',	10,	202),
('http://tonkas.hopto.org/EVO1/BRISTOL.LTE',	'BRISTOL.LTE',	'BRISTOL.LTE',	'.',	11975,	'circuit',	'l',	'2021-01-26',	10,	203),
('http://tonkas.hopto.org/EVO1/BRNTLAND.LTE',	'BRNTLAND.LTE',	'BRNTLAND.LTE',	'.',	51656,	'circuit',	'l',	'2001-10-03',	10,	204),
('http://tonkas.hopto.org/EVO1/BRUSHCREEK.LTE',	'BRUSHCREEK.LTE',	'BRUSHCREEK.LTE',	'.',	53008,	'circuit',	'l',	'2021-01-26',	10,	205),
('http://tonkas.hopto.org/EVO1/Bsib.lte',	'Bsib.lte',	'Bsib.lte',	'.',	32499,	'circuit',	'l',	'2021-01-26',	10,	206),
('http://tonkas.hopto.org/EVO1/BTZDRAG.LTE',	'BTZDRAG.LTE',	'BTZDRAG.LTE',	'.',	7317,	'circuit',	'l',	'2001-02-03',	10,	207),
('http://tonkas.hopto.org/EVO1/buceta.lte',	'buceta.lte',	'buceta.lte',	'.',	31621,	'circuit',	'l',	'2021-01-26',	10,	208),
('http://tonkas.hopto.org/EVO1/BUDLITE.LTE',	'BUDLITE.LTE',	'BUDLITE.LTE',	'.',	50618,	'circuit',	'l',	'2002-04-19',	10,	209),
('http://tonkas.hopto.org/EVO1/budspeed.lte',	'budspeed.lte',	'budspeed.lte',	'.',	75059,	'circuit',	'l',	'2005-05-02',	10,	210),
('http://tonkas.hopto.org/EVO1/bumpngrind.lte',	'bumpngrind.lte',	'bumpngrind.lte',	'.',	60039,	'circuit',	'l',	'2006-07-14',	10,	211),
('http://tonkas.hopto.org/EVO1/bumpyride.lte',	'bumpyride.lte',	'bumpyride.lte',	'.',	80528,	'circuit',	'l',	'2001-12-16',	10,	212),
('http://tonkas.hopto.org/EVO1/Burn.lte',	'Burn.lte',	'Burn.lte',	'.',	45826,	'circuit',	'l',	'2021-01-26',	10,	213),
('http://tonkas.hopto.org/EVO1/BUSTNBOP.LTE',	'BUSTNBOP.LTE',	'BUSTNBOP.LTE',	'.',	31586,	'circuit',	'l',	'2001-07-29',	10,	214),
('http://tonkas.hopto.org/EVO1/byeric.lte',	'byeric.lte',	'byeric.lte',	'.',	55084,	'circuit',	'l',	'2005-10-17',	10,	215),
('http://tonkas.hopto.org/EVO1/BZ2000.ZIP',	'BZ2000.ZIP',	'BZ2000.ZIP',	'.',	368991,	'circuit',	'z',	'2001-01-15',	10,	216),
('http://tonkas.hopto.org/EVO1/c1logrun.lte',	'c1logrun.lte',	'c1logrun.lte',	'.',	35164,	'circuit',	'l',	'2021-01-26',	10,	217),
('http://tonkas.hopto.org/EVO1/CADESERT.LTE',	'CADESERT.LTE',	'CADESERT.LTE',	'.',	9117,	'circuit',	'l',	'2003-01-25',	10,	218),
('http://tonkas.hopto.org/EVO1/CAJUN.ZIP',	'CAJUN.ZIP',	'CAJUN.ZIP',	'.',	6028427,	'circuit',	'z',	'2001-08-27',	10,	219),
('http://tonkas.hopto.org/EVO1/CAMELTROPHEY94.LTE',	'CAMELTROPHEY94.LTE',	'CAMELTROPHEY94.LTE',	'.',	7255,	'circuit',	'l',	'2021-01-26',	10,	220),
('http://tonkas.hopto.org/EVO1/camping.lte',	'camping.lte',	'camping.lte',	'.',	39194,	'circuit',	'l',	'2004-05-11',	10,	221),
('http://tonkas.hopto.org/EVO1/canudo.lte',	'canudo.lte',	'canudo.lte',	'.',	47633,	'circuit',	'l',	'2006-02-23',	10,	222),
('http://tonkas.hopto.org/EVO1/canyon-run.lte',	'canyon-run.lte',	'canyon-run.lte',	'.',	25302,	'circuit',	'l',	'2002-03-07',	10,	223),
('http://tonkas.hopto.org/EVO1/canyon-run2.lte',	'canyon-run2.lte',	'canyon-run2.lte',	'.',	37070,	'circuit',	'l',	'2004-12-16',	10,	224),
('http://tonkas.hopto.org/EVO1/Canyonc.zip',	'Canyonc.zip',	'Canyonc.zip',	'.',	1409001,	'circuit',	'z',	'2001-01-15',	10,	225),
('http://tonkas.hopto.org/EVO1/CANYONRUN.LTE',	'CANYONRUN.LTE',	'CANYONRUN.LTE',	'.',	25319,	'circuit',	'l',	'2005-01-28',	10,	226),
('http://tonkas.hopto.org/EVO1/CANYOUSAYJUMPS.LTE',	'CANYOUSAYJUMPS.LTE',	'CANYOUSAYJUMPS.LTE',	'.',	17851,	'circuit',	'l',	'2021-01-26',	10,	227),
('http://tonkas.hopto.org/EVO1/CASCADERACE.pod',	'CASCADERACE.pod',	'CASCADERACE.pod',	'.',	1927368,	'circuit',	'p',	'2005-04-01',	10,	228),
('http://tonkas.hopto.org/EVO1/CASCADERACEH.pod',	'CASCADERACEH.pod',	'CASCADERACEH.pod',	'.',	7135499,	'circuit',	'p',	'2005-04-01',	10,	229),
('http://tonkas.hopto.org/EVO1/CASH.LTE',	'CASH.LTE',	'CASH.LTE',	'.',	4679,	'circuit',	'l',	'2001-02-12',	10,	230),
('http://tonkas.hopto.org/EVO1/casinoff.lte',	'casinoff.lte',	'casinoff.lte',	'.',	99159,	'circuit',	'l',	'2007-12-01',	10,	231),
('http://tonkas.hopto.org/EVO1/CAVERAV.LTE',	'CAVERAV.LTE',	'CAVERAV.LTE',	'.',	31009,	'circuit',	'l',	'2003-03-05',	10,	232),
('http://tonkas.hopto.org/EVO1/CB.lte',	'CB.lte',	'CB.lte',	'.',	64637,	'circuit',	'l',	'2021-01-26',	10,	233),
('http://tonkas.hopto.org/EVO1/CBPDRIFT.lte',	'CBPDRIFT.lte',	'CBPDRIFT.lte',	'.',	33577,	'circuit',	'l',	'2021-01-26',	10,	234),
('http://tonkas.hopto.org/EVO1/CDOBATTLERUMBLE.zip',	'CDOBATTLERUMBLE.zip',	'CDOBATTLERUMBLE.zip',	'.',	127576,	'circuit',	'z',	'2001-02-10',	10,	235),
('http://tonkas.hopto.org/EVO1/CDOPSYCHORUMBLE.LTE',	'CDOPSYCHORUMBLE.LTE',	'CDOPSYCHORUMBLE.LTE',	'.',	3732,	'circuit',	'l',	'2001-01-16',	10,	236),
('http://tonkas.hopto.org/EVO1/CDOPSYCHORUMBLE.zip',	'CDOPSYCHORUMBLE.zip',	'CDOPSYCHORUMBLE.zip',	'.',	3352,	'circuit',	'z',	'2001-01-17',	10,	237),
('http://tonkas.hopto.org/EVO1/CDORUMBLE.LTE',	'CDORUMBLE.LTE',	'CDORUMBLE.LTE',	'.',	6710,	'circuit',	'l',	'2000-12-29',	10,	238),
('http://tonkas.hopto.org/EVO1/CDORUMBLE2.0.lte',	'CDORUMBLE2.0.lte',	'CDORUMBLE2.0.lte',	'.',	6881,	'circuit',	'l',	'2001-11-07',	10,	239),
('http://tonkas.hopto.org/EVO1/CDORUMBLE2.0.zip',	'CDORUMBLE2.0.zip',	'CDORUMBLE2.0.zip',	'.',	6335,	'circuit',	'z',	'2001-01-15',	10,	240),
('http://tonkas.hopto.org/EVO1/CDORUMBLE2_0.lte',	'CDORUMBLE2_0.lte',	'CDORUMBLE2_0.lte',	'.',	6881,	'circuit',	'l',	'2021-01-26',	10,	241),
('http://tonkas.hopto.org/EVO1/CDORumbleTrack.zip',	'CDORumbleTrack.zip',	'CDORumbleTrack.zip',	'.',	6196,	'circuit',	'z',	'2001-01-09',	10,	242),
('http://tonkas.hopto.org/EVO1/CDOUNDERWARUMBLE.LTE',	'CDOUNDERWARUMBLE.LTE',	'CDOUNDERWARUMBLE.LTE',	'.',	4718,	'circuit',	'l',	'2001-01-22',	10,	243),
('http://tonkas.hopto.org/EVO1/CDOUNDERWARUMBLE.zip',	'CDOUNDERWARUMBLE.zip',	'CDOUNDERWARUMBLE.zip',	'.',	4150,	'circuit',	'z',	'2001-01-22',	10,	244),
('http://tonkas.hopto.org/EVO1/cgnoffroad.lte',	'cgnoffroad.lte',	'cgnoffroad.lte',	'.',	26601,	'circuit',	'l',	'2006-04-06',	10,	245),
('http://tonkas.hopto.org/EVO1/CHAINS-L.LTE',	'CHAINS-L.LTE',	'CHAINS-L.LTE',	'.',	81528,	'circuit',	'l',	'2001-02-14',	10,	246),
('http://tonkas.hopto.org/EVO1/CHAINS-M.LTE',	'CHAINS-M.LTE',	'CHAINS-M.LTE',	'.',	81049,	'circuit',	'l',	'2001-09-14',	10,	247),
('http://tonkas.hopto.org/EVO1/Chains-s.lte',	'Chains-s.lte',	'Chains-s.lte',	'.',	80532,	'circuit',	'l',	'2001-02-14',	10,	248),
('http://tonkas.hopto.org/EVO1/Chains-x (11).lte',	'Chains-x (11).lte',	'Chains-x (11).lte',	'.',	83587,	'circuit',	'l',	'2021-01-26',	10,	249),
('http://tonkas.hopto.org/EVO1/chains-x.lte',	'chains-x.lte',	'chains-x.lte',	'.',	83587,	'circuit',	'l',	'2004-10-24',	10,	250),
('http://tonkas.hopto.org/EVO1/challenge.lte',	'challenge.lte',	'challenge.lte',	'.',	65309,	'circuit',	'l',	'2004-06-25',	10,	251),
('http://tonkas.hopto.org/EVO1/challenge11.lte',	'challenge11.lte',	'challenge11.lte',	'.',	50531,	'circuit',	'l',	'2002-05-07',	10,	252),
('http://tonkas.hopto.org/EVO1/challenge11f.lte',	'challenge11f.lte',	'challenge11f.lte',	'.',	50104,	'circuit',	'l',	'2002-04-25',	10,	253),
('http://tonkas.hopto.org/EVO1/challenge12.lte',	'challenge12.lte',	'challenge12.lte',	'.',	64956,	'circuit',	'l',	'2002-04-29',	10,	254),
('http://tonkas.hopto.org/EVO1/challenge15.lte',	'challenge15.lte',	'challenge15.lte',	'.',	49944,	'circuit',	'l',	'2002-03-27',	10,	255),
('http://tonkas.hopto.org/EVO1/CHALLENGE2.LTE',	'CHALLENGE2.LTE',	'CHALLENGE2.LTE',	'.',	48000,	'circuit',	'l',	'2004-07-08',	10,	256),
('http://tonkas.hopto.org/EVO1/challenge5.lte',	'challenge5.lte',	'challenge5.lte',	'.',	50875,	'circuit',	'l',	'2002-03-29',	10,	257),
('http://tonkas.hopto.org/EVO1/challenge7.lte',	'challenge7.lte',	'challenge7.lte',	'.',	50797,	'circuit',	'l',	'2002-04-03',	10,	258),
('http://tonkas.hopto.org/EVO1/challengeb.lte',	'challengeb.lte',	'challengeb.lte',	'.',	63025,	'circuit',	'l',	'2005-05-26',	10,	259),
('http://tonkas.hopto.org/EVO1/challengef.lte',	'challengef.lte',	'challengef.lte',	'.',	51057,	'circuit',	'l',	'2002-04-06',	10,	260),
('http://tonkas.hopto.org/EVO1/championracer.lte',	'championracer.lte',	'championracer.lte',	'.',	17303,	'circuit',	'l',	'2007-11-21',	10,	261),
('http://tonkas.hopto.org/EVO1/Chance.lte',	'Chance.lte',	'Chance.lte',	'.',	82260,	'circuit',	'l',	'2021-01-26',	10,	262),
('http://tonkas.hopto.org/EVO1/Chancex.lte',	'Chancex.lte',	'Chancex.lte',	'.',	5898,	'circuit',	'l',	'2005-06-27',	10,	263),
('http://tonkas.hopto.org/EVO1/CHANCEX1.LTE',	'CHANCEX1.LTE',	'CHANCEX1.LTE',	'.',	100327,	'circuit',	'l',	'2005-07-05',	10,	264),
('http://tonkas.hopto.org/EVO1/chaoswild.lte',	'chaoswild.lte',	'chaoswild.lte',	'.',	35542,	'circuit',	'l',	'2005-12-03',	10,	265),
('http://tonkas.hopto.org/EVO1/chicsoffroading.lte',	'chicsoffroading.lte',	'chicsoffroading.lte',	'.',	36833,	'circuit',	'l',	'2001-09-26',	10,	266),
('http://tonkas.hopto.org/EVO1/CHOPSHOP (12).LTE',	'CHOPSHOP (12).LTE',	'CHOPSHOP (12).LTE',	'.',	74990,	'circuit',	'l',	'2021-01-26',	10,	267),
('http://tonkas.hopto.org/EVO1/chopshop.lte',	'chopshop.lte',	'chopshop.lte',	'.',	54505,	'circuit',	'l',	'2004-06-28',	10,	268),
('http://tonkas.hopto.org/EVO1/CHOPSHOP101.LTE',	'CHOPSHOP101.LTE',	'CHOPSHOP101.LTE',	'.',	8243,	'circuit',	'l',	'2021-01-26',	10,	269),
('http://tonkas.hopto.org/EVO1/chopshop2.lte',	'chopshop2.lte',	'chopshop2.lte',	'.',	62278,	'circuit',	'l',	'2003-08-28',	10,	270),
('http://tonkas.hopto.org/EVO1/chopshoptrails.lte',	'chopshoptrails.lte',	'chopshoptrails.lte',	'.',	78885,	'circuit',	'l',	'2004-12-28',	10,	271),
('http://tonkas.hopto.org/EVO1/chopshoptrails2.lte',	'chopshoptrails2.lte',	'chopshoptrails2.lte',	'.',	78892,	'circuit',	'l',	'2002-10-09',	10,	272),
('http://tonkas.hopto.org/EVO1/chopshoptrails3.lte',	'chopshoptrails3.lte',	'chopshoptrails3.lte',	'.',	78896,	'circuit',	'l',	'2004-09-07',	10,	273),
('http://tonkas.hopto.org/EVO1/CHUBASCO.EXE',	'CHUBASCO.EXE',	'CHUBASCO.EXE',	'.',	7329093,	'circuit',	'e',	'2002-07-28',	10,	274),
('http://tonkas.hopto.org/EVO1/CHUBASCO.pod',	'CHUBASCO.pod',	'CHUBASCO.pod',	'.',	11566837,	'circuit',	'p',	'2001-08-04',	10,	275),
('http://tonkas.hopto.org/EVO1/CHUBASCO.ZIP',	'CHUBASCO.ZIP',	'CHUBASCO.ZIP',	'.',	6374306,	'circuit',	'z',	'2001-11-07',	10,	276),
('http://tonkas.hopto.org/EVO1/cislnd10.lte',	'cislnd10.lte',	'cislnd10.lte',	'.',	26722,	'circuit',	'l',	'2021-01-26',	10,	277),
('http://tonkas.hopto.org/EVO1/CISLND11.LTE',	'CISLND11.LTE',	'CISLND11.LTE',	'.',	26548,	'circuit',	'l',	'2002-06-30',	10,	278),
('http://tonkas.hopto.org/EVO1/citizen.lte',	'citizen.lte',	'citizen.lte',	'.',	72341,	'circuit',	'l',	'2005-04-21',	10,	279),
('http://tonkas.hopto.org/EVO1/citizenx.lte',	'citizenx.lte',	'citizenx.lte',	'.',	70906,	'circuit',	'l',	'2004-09-14',	10,	280),
('http://tonkas.hopto.org/EVO1/city-chase.lte',	'city-chase.lte',	'city-chase.lte',	'.',	17212,	'circuit',	'l',	'2004-04-21',	10,	281),
('http://tonkas.hopto.org/EVO1/ckcoldfusion.lte',	'ckcoldfusion.lte',	'ckcoldfusion.lte',	'.',	57991,	'circuit',	'l',	'2021-01-26',	10,	282),
('http://tonkas.hopto.org/EVO1/CLIFFRACING.LTE',	'CLIFFRACING.LTE',	'CLIFFRACING.LTE',	'.',	53667,	'circuit',	'l',	'2021-01-26',	10,	283),
('http://tonkas.hopto.org/EVO1/CLIMBING.LTE',	'CLIMBING.LTE',	'CLIMBING.LTE',	'.',	25320,	'circuit',	'l',	'2001-08-19',	10,	284),
('http://tonkas.hopto.org/EVO1/coldfusion.lte',	'coldfusion.lte',	'coldfusion.lte',	'.',	42489,	'circuit',	'l',	'2021-01-26',	10,	285),
('http://tonkas.hopto.org/EVO1/CONP.LTE',	'CONP.LTE',	'CONP.LTE',	'.',	15547,	'circuit',	'l',	'2001-08-05',	10,	286),
('http://tonkas.hopto.org/EVO1/constructionzone.lte',	'constructionzone.lte',	'constructionzone.lte',	'.',	78036,	'circuit',	'l',	'2021-01-26',	10,	287),
('http://tonkas.hopto.org/EVO1/cooks.lte',	'cooks.lte',	'cooks.lte',	'.',	75178,	'circuit',	'l',	'2021-01-26',	10,	288),
('http://tonkas.hopto.org/EVO1/copper.lte',	'copper.lte',	'copper.lte',	'.',	100210,	'circuit',	'l',	'2005-05-04',	10,	289),
('http://tonkas.hopto.org/EVO1/Copy of challenge.lte',	'Copy of challenge.lte',	'Copy of challenge.lte',	'.',	65005,	'circuit',	'l',	'2004-07-08',	10,	290),
('http://tonkas.hopto.org/EVO1/Cor.lte',	'Cor.lte',	'Cor.lte',	'.',	53684,	'circuit',	'l',	'2021-01-26',	10,	291),
('http://tonkas.hopto.org/EVO1/CORMOTO911.LTE',	'CORMOTO911.LTE',	'CORMOTO911.LTE',	'.',	46079,	'circuit',	'l',	'2021-01-26',	10,	292),
('http://tonkas.hopto.org/EVO1/Corolla.lte',	'Corolla.lte',	'Corolla.lte',	'.',	6817,	'circuit',	'l',	'2021-01-26',	10,	293),
('http://tonkas.hopto.org/EVO1/COT.LTE',	'COT.LTE',	'COT.LTE',	'.',	11851,	'circuit',	'l',	'2021-01-26',	10,	294),
('http://tonkas.hopto.org/EVO1/COTR.LTE',	'COTR.LTE',	'COTR.LTE',	'.',	11043,	'circuit',	'l',	'2001-02-20',	10,	295),
('http://tonkas.hopto.org/EVO1/COUNTRYKILLERS.LTE',	'COUNTRYKILLERS.LTE',	'COUNTRYKILLERS.LTE',	'.',	32572,	'circuit',	'l',	'2005-02-02',	10,	296),
('http://tonkas.hopto.org/EVO1/COUNTRYMILE.LTE',	'COUNTRYMILE.LTE',	'COUNTRYMILE.LTE',	'.',	59886,	'circuit',	'l',	'2001-08-07',	10,	297),
('http://tonkas.hopto.org/EVO1/COUNTY.LTE',	'COUNTY.LTE',	'COUNTY.LTE',	'.',	42394,	'circuit',	'l',	'2003-04-04',	10,	298),
('http://tonkas.hopto.org/EVO1/COUNTYLINE.LTE',	'COUNTYLINE.LTE',	'COUNTYLINE.LTE',	'.',	43278,	'circuit',	'l',	'2001-06-03',	10,	299),
('http://tonkas.hopto.org/EVO1/cprumble2.pod.zip',	'cprumble2.pod.zip',	'cprumble2.pod.zip',	'.',	971388,	'circuit',	'z',	'2001-04-05',	10,	300),
('http://tonkas.hopto.org/EVO1/CRACYDAYS.pod',	'CRACYDAYS.pod',	'CRACYDAYS.pod',	'.',	13576036,	'circuit',	'p',	'2021-01-25',	10,	301),
('http://tonkas.hopto.org/EVO1/CRASH.LTE',	'CRASH.LTE',	'CRASH.LTE',	'.',	48653,	'circuit',	'l',	'2001-07-10',	10,	302),
('http://tonkas.hopto.org/EVO1/Crazed.lte',	'Crazed.lte',	'Crazed.lte',	'.',	42818,	'circuit',	'l',	'2021-01-26',	10,	303),
('http://tonkas.hopto.org/EVO1/CRAZY1000.LTE',	'CRAZY1000.LTE',	'CRAZY1000.LTE',	'.',	28287,	'circuit',	'l',	'2021-01-26',	10,	304),
('http://tonkas.hopto.org/EVO1/CRAZY2001.LTE',	'CRAZY2001.LTE',	'CRAZY2001.LTE',	'.',	39129,	'circuit',	'l',	'2001-01-13',	10,	305),
('http://tonkas.hopto.org/EVO1/CRAZY2002.LTE',	'CRAZY2002.LTE',	'CRAZY2002.LTE',	'.',	10212,	'circuit',	'l',	'2021-01-26',	10,	306),
('http://tonkas.hopto.org/EVO1/crazy2002off.lte',	'crazy2002off.lte',	'crazy2002off.lte',	'.',	11358,	'circuit',	'l',	'2002-05-26',	10,	307),
('http://tonkas.hopto.org/EVO1/crazycops.lte',	'crazycops.lte',	'crazycops.lte',	'.',	75587,	'circuit',	'l',	'2021-01-26',	10,	308),
('http://tonkas.hopto.org/EVO1/crazyrace2.lte',	'crazyrace2.lte',	'crazyrace2.lte',	'.',	8285,	'circuit',	'l',	'2002-07-13',	10,	309),
('http://tonkas.hopto.org/EVO1/CRTOFF.LTE',	'CRTOFF.LTE',	'CRTOFF.LTE',	'.',	9666,	'circuit',	'l',	'2003-04-19',	10,	310),
('http://tonkas.hopto.org/EVO1/csr1-fl.llte',	'csr1-fl.llte',	'csr1-fl.llte',	'.',	45791,	'circuit',	'l',	'2001-02-04',	10,	311),
('http://tonkas.hopto.org/EVO1/CSR1.LTE',	'CSR1.LTE',	'CSR1.LTE',	'.',	45445,	'circuit',	'l',	'2001-02-04',	10,	312),
('http://tonkas.hopto.org/EVO1/CSR3.LTE',	'CSR3.LTE',	'CSR3.LTE',	'.',	16348,	'circuit',	'l',	'2001-02-05',	10,	313),
('http://tonkas.hopto.org/EVO1/CTC.LTE',	'CTC.LTE',	'CTC.LTE',	'.',	18587,	'circuit',	'l',	'2002-01-21',	10,	314),
('http://tonkas.hopto.org/EVO1/CTEST21.LTE',	'CTEST21.LTE',	'CTEST21.LTE',	'.',	13501,	'circuit',	'l',	'2003-03-07',	10,	315),
('http://tonkas.hopto.org/EVO1/CURVASEUOS.LTE',	'CURVASEUOS.LTE',	'CURVASEUOS.LTE',	'.',	55234,	'circuit',	'l',	'2021-01-26',	10,	316),
('http://tonkas.hopto.org/EVO1/Dabomb.lte',	'Dabomb.lte',	'Dabomb.lte',	'.',	4546,	'circuit',	'l',	'2021-01-26',	10,	317),
('http://tonkas.hopto.org/EVO1/dabombiscold.lte',	'dabombiscold.lte',	'dabombiscold.lte',	'.',	30033,	'circuit',	'l',	'2002-03-29',	10,	318),
('http://tonkas.hopto.org/EVO1/DAKAR1.pod',	'DAKAR1.pod',	'DAKAR1.pod',	'.',	13404798,	'circuit',	'p',	'2007-01-15',	10,	319),
('http://tonkas.hopto.org/EVO1/DAKAR1.zip',	'DAKAR1.zip',	'DAKAR1.zip',	'.',	3748384,	'circuit',	'z',	'2007-01-25',	10,	320),
('http://tonkas.hopto.org/EVO1/DAKAR2.pod',	'DAKAR2.pod',	'DAKAR2.pod',	'.',	14099719,	'circuit',	'p',	'2006-12-24',	10,	321),
('http://tonkas.hopto.org/EVO1/DAKAR2.zip',	'DAKAR2.zip',	'DAKAR2.zip',	'.',	4981154,	'circuit',	'z',	'2006-12-24',	10,	322),
('http://tonkas.hopto.org/EVO1/DAYSNOWNA.POD',	'DAYSNOWNA.POD',	'DAYSNOWNA.POD',	'.',	8051535,	'circuit',	'p',	'2021-01-25',	10,	323),
('http://tonkas.hopto.org/EVO1/DAYSNOWNA.zip',	'DAYSNOWNA.zip',	'DAYSNOWNA.zip',	'.',	2978801,	'circuit',	'z',	'2001-04-03',	10,	324),
('http://tonkas.hopto.org/EVO1/DAYTONA.LTE',	'DAYTONA.LTE',	'DAYTONA.LTE',	'.',	13353,	'circuit',	'l',	'2021-01-26',	10,	325),
('http://tonkas.hopto.org/EVO1/DBLDECKR.LTE',	'DBLDECKR.LTE',	'DBLDECKR.LTE',	'.',	71807,	'circuit',	'l',	'2021-01-26',	10,	326),
('http://tonkas.hopto.org/EVO1/DCROSS.LTE',	'DCROSS.LTE',	'DCROSS.LTE',	'.',	47542,	'circuit',	'l',	'2001-10-18',	10,	327),
('http://tonkas.hopto.org/EVO1/DCSX.LTE',	'DCSX.LTE',	'DCSX.LTE',	'.',	52063,	'circuit',	'l',	'2001-09-30',	10,	328),
('http://tonkas.hopto.org/EVO1/DDDDRAG.LTE',	'DDDDRAG.LTE',	'DDDDRAG.LTE',	'.',	9449,	'circuit',	'l',	'2002-01-27',	10,	329),
('http://tonkas.hopto.org/EVO1/ddddragbc.lte',	'ddddragbc.lte',	'ddddragbc.lte',	'.',	7667,	'circuit',	'l',	'2004-01-04',	10,	330),
('http://tonkas.hopto.org/EVO1/ddddragnt.lte',	'ddddragnt.lte',	'ddddragnt.lte',	'.',	7658,	'circuit',	'l',	'2002-01-27',	10,	331),
('http://tonkas.hopto.org/EVO1/DDRAGBC.LTE',	'DDRAGBC.LTE',	'DDRAGBC.LTE',	'.',	5803,	'circuit',	'l',	'2004-01-04',	10,	332),
('http://tonkas.hopto.org/EVO1/DE1.LTE',	'DE1.LTE',	'DE1.LTE',	'.',	57284,	'circuit',	'l',	'2001-07-31',	10,	333),
('http://tonkas.hopto.org/EVO1/DE2.LTE',	'DE2.LTE',	'DE2.LTE',	'.',	52987,	'circuit',	'l',	'2001-07-29',	10,	334),
('http://tonkas.hopto.org/EVO1/De3.lte',	'De3.lte',	'De3.lte',	'.',	41955,	'circuit',	'l',	'2004-04-30',	10,	335),
('http://tonkas.hopto.org/EVO1/DE4.LTE',	'DE4.LTE',	'DE4.LTE',	'.',	72713,	'circuit',	'l',	'2001-09-07',	10,	336),
('http://tonkas.hopto.org/EVO1/DEABLO.LTE',	'DEABLO.LTE',	'DEABLO.LTE',	'.',	86839,	'circuit',	'l',	'2001-08-19',	10,	337),
('http://tonkas.hopto.org/EVO1/deadmans2004.lte',	'deadmans2004.lte',	'deadmans2004.lte',	'.',	77601,	'circuit',	'l',	'2021-01-26',	10,	338),
('http://tonkas.hopto.org/EVO1/DEADMANSPOINT.LTE',	'DEADMANSPOINT.LTE',	'DEADMANSPOINT.LTE',	'.',	90428,	'circuit',	'l',	'2001-09-24',	10,	339),
('http://tonkas.hopto.org/EVO1/Deadmoto.lte',	'Deadmoto.lte',	'Deadmoto.lte',	'.',	37271,	'circuit',	'l',	'2021-01-26',	10,	340),
('http://tonkas.hopto.org/EVO1/deathmatch.lte',	'deathmatch.lte',	'deathmatch.lte',	'.',	8468,	'circuit',	'l',	'2001-12-14',	10,	341),
('http://tonkas.hopto.org/EVO1/deathrace.lte',	'deathrace.lte',	'deathrace.lte',	'.',	14534,	'circuit',	'l',	'2005-10-25',	10,	342),
('http://tonkas.hopto.org/EVO1/def1.lte',	'def1.lte',	'def1.lte',	'.',	100317,	'circuit',	'l',	'2004-08-26',	10,	343),
('http://tonkas.hopto.org/EVO1/defender.lte',	'defender.lte',	'defender.lte',	'.',	100286,	'circuit',	'l',	'2006-02-19',	10,	344),
('http://tonkas.hopto.org/EVO1/DELFIA.LTE',	'DELFIA.LTE',	'DELFIA.LTE',	'.',	16335,	'circuit',	'l',	'2021-01-26',	10,	345),
('http://tonkas.hopto.org/EVO1/DELIVERANCE.LTE',	'DELIVERANCE.LTE',	'DELIVERANCE.LTE',	'.',	45190,	'circuit',	'l',	'2001-08-05',	10,	346),
('http://tonkas.hopto.org/EVO1/demoberby.zip',	'demoberby.zip',	'demoberby.zip',	'.',	3789,	'circuit',	'z',	'2001-04-18',	10,	347),
('http://tonkas.hopto.org/EVO1/DEMODERBY.LTE',	'DEMODERBY.LTE',	'DEMODERBY.LTE',	'.',	4436,	'circuit',	'l',	'2001-04-17',	10,	348),
('http://tonkas.hopto.org/EVO1/DENVERVA.LTE',	'DENVERVA.LTE',	'DENVERVA.LTE',	'.',	74608,	'circuit',	'l',	'2003-03-21',	10,	349),
('http://tonkas.hopto.org/EVO1/DESCON.pod',	'DESCON.pod',	'DESCON.pod',	'.',	9769846,	'circuit',	'p',	'2021-01-25',	10,	350),
('http://tonkas.hopto.org/EVO1/desertparadise.lte',	'desertparadise.lte',	'desertparadise.lte',	'.',	59024,	'circuit',	'l',	'2002-05-19',	10,	351),
('http://tonkas.hopto.org/EVO1/DESERTRUN.zip',	'DESERTRUN.zip',	'DESERTRUN.zip',	'.',	3476099,	'circuit',	'z',	'2001-04-05',	10,	352),
('http://tonkas.hopto.org/EVO1/DEVIL.LTE',	'DEVIL.LTE',	'DEVIL.LTE',	'.',	8322,	'circuit',	'l',	'2021-01-26',	10,	353),
('http://tonkas.hopto.org/EVO1/devilsgultch.lte',	'devilsgultch.lte',	'devilsgultch.lte',	'.',	53025,	'circuit',	'l',	'2001-07-10',	10,	354),
('http://tonkas.hopto.org/EVO1/dexrace.lte',	'dexrace.lte',	'dexrace.lte',	'.',	7908,	'circuit',	'l',	'2021-01-26',	10,	355),
('http://tonkas.hopto.org/EVO1/dexrace10.lte',	'dexrace10.lte',	'dexrace10.lte',	'.',	8684,	'circuit',	'l',	'2021-01-26',	10,	356),
('http://tonkas.hopto.org/EVO1/DINGDING.LTE',	'DINGDING.LTE',	'DINGDING.LTE',	'.',	75528,	'circuit',	'l',	'2002-03-03',	10,	357),
('http://tonkas.hopto.org/EVO1/dingding2.lte',	'dingding2.lte',	'dingding2.lte',	'.',	58417,	'circuit',	'l',	'2003-07-17',	10,	358),
('http://tonkas.hopto.org/EVO1/dingding3.lte',	'dingding3.lte',	'dingding3.lte',	'.',	67333,	'circuit',	'l',	'2021-01-26',	10,	359),
('http://tonkas.hopto.org/EVO1/dirttrail.lte',	'dirttrail.lte',	'dirttrail.lte',	'.',	13142,	'circuit',	'l',	'2001-09-04',	10,	360),
('http://tonkas.hopto.org/EVO1/DMANS.ZIP',	'DMANS.ZIP',	'DMANS.ZIP',	'.',	3461863,	'circuit',	'z',	'2001-03-03',	10,	361),
('http://tonkas.hopto.org/EVO1/DND.lte',	'DND.lte',	'DND.lte',	'.',	33487,	'circuit',	'l',	'2007-06-09',	10,	362),
('http://tonkas.hopto.org/EVO1/Dogclaw.lte',	'Dogclaw.lte',	'Dogclaw.lte',	'.',	5377,	'circuit',	'l',	'2021-01-26',	10,	363),
('http://tonkas.hopto.org/EVO1/DOGZ.LTE',	'DOGZ.LTE',	'DOGZ.LTE',	'.',	32813,	'circuit',	'l',	'2001-08-31',	10,	364),
('http://tonkas.hopto.org/EVO1/downclimbtest.lte',	'downclimbtest.lte',	'downclimbtest.lte',	'.',	60099,	'circuit',	'l',	'2003-02-01',	10,	365),
('http://tonkas.hopto.org/EVO1/Drag.lte',	'Drag.lte',	'Drag.lte',	'.',	31223,	'circuit',	'l',	'2021-01-26',	10,	366),
('http://tonkas.hopto.org/EVO1/Drag2001.lte',	'Drag2001.lte',	'Drag2001.lte',	'.',	5701,	'circuit',	'l',	'2001-05-02',	10,	367),
('http://tonkas.hopto.org/EVO1/Dragfun.lte',	'Dragfun.lte',	'Dragfun.lte',	'.',	9088,	'circuit',	'l',	'2021-01-26',	10,	368),
('http://tonkas.hopto.org/EVO1/DRAGGONSLAIR.sit',	'DRAGGONSLAIR.sit',	'DRAGGONSLAIR.sit',	'.',	183369,	'circuit',	's',	'2001-08-27',	10,	369),
('http://tonkas.hopto.org/EVO1/DRAGGONSLAIR.zip',	'DRAGGONSLAIR.zip',	'DRAGGONSLAIR.zip',	'.',	18071,	'circuit',	'z',	'2001-08-27',	10,	370),
('http://tonkas.hopto.org/EVO1/DRAGGONSRIDE.LTE',	'DRAGGONSRIDE.LTE',	'DRAGGONSRIDE.LTE',	'.',	70003,	'circuit',	'l',	'2021-01-26',	10,	371),
('http://tonkas.hopto.org/EVO1/Draging.lte',	'Draging.lte',	'Draging.lte',	'.',	6663,	'circuit',	'l',	'2001-05-01',	10,	372),
('http://tonkas.hopto.org/EVO1/DRAGLAND.LTE',	'DRAGLAND.LTE',	'DRAGLAND.LTE',	'.',	5357,	'circuit',	'l',	'2021-01-26',	10,	373),
('http://tonkas.hopto.org/EVO1/DRAGORAMA.LTE',	'DRAGORAMA.LTE',	'DRAGORAMA.LTE',	'.',	5834,	'circuit',	'l',	'2001-02-12',	10,	374),
('http://tonkas.hopto.org/EVO1/DRAGRACER2002.LTE',	'DRAGRACER2002.LTE',	'DRAGRACER2002.LTE',	'.',	4462,	'circuit',	'l',	'2021-01-26',	10,	375),
('http://tonkas.hopto.org/EVO1/DRAGRACIN.LTE',	'DRAGRACIN.LTE',	'DRAGRACIN.LTE',	'.',	4861,	'circuit',	'l',	'2001-01-23',	10,	376),
('http://tonkas.hopto.org/EVO1/DRAGSTRIP.zip',	'DRAGSTRIP.zip',	'DRAGSTRIP.zip',	'.',	617003,	'circuit',	'z',	'2001-01-25',	10,	377),
('http://tonkas.hopto.org/EVO1/DRAGWORLD.LTE',	'DRAGWORLD.LTE',	'DRAGWORLD.LTE',	'.',	24920,	'circuit',	'l',	'2021-01-26',	10,	378),
('http://tonkas.hopto.org/EVO1/dredge.lte',	'dredge.lte',	'dredge.lte',	'.',	67420,	'circuit',	'l',	'2005-03-15',	10,	379),
('http://tonkas.hopto.org/EVO1/dreoffroadcenter.lte',	'dreoffroadcenter.lte',	'dreoffroadcenter.lte',	'.',	73774,	'circuit',	'l',	'2003-02-28',	10,	380),
('http://tonkas.hopto.org/EVO1/dresithv2.lte',	'dresithv2.lte',	'dresithv2.lte',	'.',	7833,	'circuit',	'l',	'2003-06-10',	10,	381),
('http://tonkas.hopto.org/EVO1/DRT1.LTE',	'DRT1.LTE',	'DRT1.LTE',	'.',	22642,	'circuit',	'l',	'2002-05-23',	10,	382),
('http://tonkas.hopto.org/EVO1/DRULO.LTE',	'DRULO.LTE',	'DRULO.LTE',	'.',	11912,	'circuit',	'l',	'2002-10-23',	10,	383),
('http://tonkas.hopto.org/EVO1/drulo4.lte',	'drulo4.lte',	'drulo4.lte',	'.',	20259,	'circuit',	'l',	'2021-01-26',	10,	384),
('http://tonkas.hopto.org/EVO1/DRYLAND.LTE',	'DRYLAND.LTE',	'DRYLAND.LTE',	'.',	33335,	'circuit',	'l',	'2006-08-15',	10,	385),
('http://tonkas.hopto.org/EVO1/DT1.LTE',	'DT1.LTE',	'DT1.LTE',	'.',	54794,	'circuit',	'l',	'2002-10-02',	10,	386),
('http://tonkas.hopto.org/EVO1/dt10.lte',	'dt10.lte',	'dt10.lte',	'.',	60375,	'circuit',	'l',	'2021-01-26',	10,	387),
('http://tonkas.hopto.org/EVO1/Dt2.lte',	'Dt2.lte',	'Dt2.lte',	'.',	35534,	'circuit',	'l',	'2021-01-26',	10,	388),
('http://tonkas.hopto.org/EVO1/Dt6.lte',	'Dt6.lte',	'Dt6.lte',	'.',	59163,	'circuit',	'l',	'2021-01-26',	10,	389),
('http://tonkas.hopto.org/EVO1/dump.lte',	'dump.lte',	'dump.lte',	'.',	20496,	'circuit',	'l',	'2021-01-26',	10,	390),
('http://tonkas.hopto.org/EVO1/DUNEBUGGY2.LTE',	'DUNEBUGGY2.LTE',	'DUNEBUGGY2.LTE',	'.',	31156,	'circuit',	'l',	'2021-01-26',	10,	391),
('http://tonkas.hopto.org/EVO1/dunebuggyheaven.lte',	'dunebuggyheaven.lte',	'dunebuggyheaven.lte',	'.',	29353,	'circuit',	'l',	'2001-08-27',	10,	392),
('http://tonkas.hopto.org/EVO1/dunecentral.lte',	'dunecentral.lte',	'dunecentral.lte',	'.',	47864,	'circuit',	'l',	'2001-08-19',	10,	393),
('http://tonkas.hopto.org/EVO1/Dunes.lte',	'Dunes.lte',	'Dunes.lte',	'.',	80361,	'circuit',	'l',	'2001-05-31',	10,	394),
('http://tonkas.hopto.org/EVO1/dup2_proffroad.lte',	'dup2_proffroad.lte',	'dup2_proffroad.lte',	'.',	62146,	'circuit',	'l',	'2001-08-25',	10,	395),
('http://tonkas.hopto.org/EVO1/DUSTIN4.LTE',	'DUSTIN4.LTE',	'DUSTIN4.LTE',	'.',	7084,	'circuit',	'l',	'2021-01-26',	10,	396),
('http://tonkas.hopto.org/EVO1/EAGLESHOME.LTE',	'EAGLESHOME.LTE',	'EAGLESHOME.LTE',	'.',	24744,	'circuit',	'l',	'2002-12-04',	10,	397),
('http://tonkas.hopto.org/EVO1/EASYGO.ZIP',	'EASYGO.ZIP',	'EASYGO.ZIP',	'.',	2345442,	'circuit',	'z',	'2001-02-02',	10,	398),
('http://tonkas.hopto.org/EVO1/ebpcrazyoffroad.lte',	'ebpcrazyoffroad.lte',	'ebpcrazyoffroad.lte',	'.',	86463,	'circuit',	'l',	'2007-01-13',	10,	399),
('http://tonkas.hopto.org/EVO1/ebpcrazyzonev2.lte',	'ebpcrazyzonev2.lte',	'ebpcrazyzonev2.lte',	'.',	13047,	'circuit',	'l',	'2007-02-12',	10,	400),
('http://tonkas.hopto.org/EVO1/ebpcreatina.lte',	'ebpcreatina.lte',	'ebpcreatina.lte',	'.',	24928,	'circuit',	'l',	'2007-10-20',	10,	401),
('http://tonkas.hopto.org/EVO1/ebplimitevertical.lte',	'ebplimitevertical.lte',	'ebplimitevertical.lte',	'.',	29215,	'circuit',	'l',	'2007-11-22',	10,	402),
('http://tonkas.hopto.org/EVO1/EBPOGURA.LTE',	'EBPOGURA.LTE',	'EBPOGURA.LTE',	'.',	26451,	'circuit',	'l',	'2005-10-10',	10,	403),
('http://tonkas.hopto.org/EVO1/ebptopspeed.lte',	'ebptopspeed.lte',	'ebptopspeed.lte',	'.',	34203,	'circuit',	'l',	'2021-01-26',	10,	404),
('http://tonkas.hopto.org/EVO1/EBPTropicalha.lte',	'EBPTropicalha.lte',	'EBPTropicalha.lte',	'.',	28336,	'circuit',	'l',	'2005-10-17',	10,	405),
('http://tonkas.hopto.org/EVO1/EBPTS.LTE',	'EBPTS.LTE',	'EBPTS.LTE',	'.',	65468,	'circuit',	'l',	'2007-02-04',	10,	406),
('http://tonkas.hopto.org/EVO1/EBPVELO.LTE',	'EBPVELO.LTE',	'EBPVELO.LTE',	'.',	23868,	'circuit',	'l',	'2006-09-03',	10,	407),
('http://tonkas.hopto.org/EVO1/ECHORIDGE.zip',	'ECHORIDGE.zip',	'ECHORIDGE.zip',	'.',	4949625,	'circuit',	'z',	'2001-04-14',	10,	408),
('http://tonkas.hopto.org/EVO1/edgecliff.lte',	'edgecliff.lte',	'edgecliff.lte',	'.',	67976,	'circuit',	'l',	'2021-01-26',	10,	409),
('http://tonkas.hopto.org/EVO1/edgewld.lte',	'edgewld.lte',	'edgewld.lte',	'.',	29119,	'circuit',	'l',	'2021-01-26',	10,	410),
('http://tonkas.hopto.org/EVO1/ENDURO.LTE',	'ENDURO.LTE',	'ENDURO.LTE',	'.',	19518,	'circuit',	'l',	'2003-05-11',	10,	411),
('http://tonkas.hopto.org/EVO1/endurohard.lte',	'endurohard.lte',	'endurohard.lte',	'.',	19317,	'circuit',	'l',	'2004-07-15',	10,	412),
('http://tonkas.hopto.org/EVO1/ENGLISHTWN.LTE',	'ENGLISHTWN.LTE',	'ENGLISHTWN.LTE',	'.',	32474,	'circuit',	'l',	'2021-01-26',	10,	413),
('http://tonkas.hopto.org/EVO1/entrap.lte',	'entrap.lte',	'entrap.lte',	'.',	57053,	'circuit',	'l',	'2021-01-26',	10,	414),
('http://tonkas.hopto.org/EVO1/ERA.LTE',	'ERA.LTE',	'ERA.LTE',	'.',	30491,	'circuit',	'l',	'2001-09-13',	10,	415),
('http://tonkas.hopto.org/EVO1/ERA1.LTE',	'ERA1.LTE',	'ERA1.LTE',	'.',	44015,	'circuit',	'l',	'2001-09-28',	10,	416),
('http://tonkas.hopto.org/EVO1/erarlly.lte',	'erarlly.lte',	'erarlly.lte',	'.',	18363,	'circuit',	'l',	'2008-08-02',	10,	417),
('http://tonkas.hopto.org/EVO1/escapade.lte',	'escapade.lte',	'escapade.lte',	'.',	63441,	'circuit',	'l',	'2005-02-05',	10,	418),
('http://tonkas.hopto.org/EVO1/EVEREST.LTE',	'EVEREST.LTE',	'EVEREST.LTE',	'.',	42537,	'circuit',	'l',	'2007-01-03',	10,	419),
('http://tonkas.hopto.org/EVO1/evo1-n.txt',	'evo1-n.txt',	'evo1-n.txt',	'.',	0,	'circuit',	't',	'2021-02-02',	10,	420),
('http://tonkas.hopto.org/EVO1/EvONaNYUKON.pod',	'EvONaNYUKON.pod',	'EvONaNYUKON.pod',	'.',	3840861,	'circuit',	'p',	'2021-01-25',	10,	421),
('http://tonkas.hopto.org/EVO1/evorace.lte',	'evorace.lte',	'evorace.lte',	'.',	74042,	'circuit',	'l',	'2021-01-26',	10,	422),
('http://tonkas.hopto.org/EVO1/EVORACE2.LTE',	'EVORACE2.LTE',	'EVORACE2.LTE',	'.',	65047,	'circuit',	'l',	'2006-08-06',	10,	423),
('http://tonkas.hopto.org/EVO1/EXTREME.LTE',	'EXTREME.LTE',	'EXTREME.LTE',	'.',	37421,	'circuit',	'l',	'2001-07-30',	10,	424),
('http://tonkas.hopto.org/EVO1/EXTREME.ZIP',	'EXTREME.ZIP',	'EXTREME.ZIP',	'.',	2922841,	'circuit',	'z',	'2001-04-12',	10,	425),
('http://tonkas.hopto.org/EVO1/ExtremelyFarmRoad.zip',	'ExtremelyFarmRoad.zip',	'ExtremelyFarmRoad.zip',	'.',	806638,	'circuit',	'z',	'2000-12-20',	10,	426),
('http://tonkas.hopto.org/EVO1/EXTREMEMOTO.LTE',	'EXTREMEMOTO.LTE',	'EXTREMEMOTO.LTE',	'.',	6918,	'circuit',	'l',	'2004-03-14',	10,	427),
('http://tonkas.hopto.org/EVO1/extremeracing.lte',	'extremeracing.lte',	'extremeracing.lte',	'.',	26248,	'circuit',	'l',	'2003-05-17',	10,	428),
('http://tonkas.hopto.org/EVO1/extremeracing1.lte',	'extremeracing1.lte',	'extremeracing1.lte',	'.',	11037,	'circuit',	'l',	'2001-11-04',	10,	429),
('http://tonkas.hopto.org/EVO1/extremoffroad.lte',	'extremoffroad.lte',	'extremoffroad.lte',	'.',	28369,	'circuit',	'l',	'2003-04-30',	10,	430),
('http://tonkas.hopto.org/EVO1/EYE1.LTE',	'EYE1.LTE',	'EYE1.LTE',	'.',	12291,	'circuit',	'l',	'2002-05-29',	10,	431),
('http://tonkas.hopto.org/EVO1/Farmbomb.lte',	'Farmbomb.lte',	'Farmbomb.lte',	'.',	42851,	'circuit',	'l',	'2001-04-03',	10,	432),
('http://tonkas.hopto.org/EVO1/Farming.lte',	'Farming.lte',	'Farming.lte',	'.',	9072,	'circuit',	'l',	'2021-01-26',	10,	433),
('http://tonkas.hopto.org/EVO1/FARMROAD101.LTE',	'FARMROAD101.LTE',	'FARMROAD101.LTE',	'.',	61752,	'circuit',	'l',	'2021-01-26',	10,	434),
('http://tonkas.hopto.org/EVO1/Farmtag.lte',	'Farmtag.lte',	'Farmtag.lte',	'.',	59365,	'circuit',	'l',	'2001-04-05',	10,	435),
('http://tonkas.hopto.org/EVO1/FART.LTE',	'FART.LTE',	'FART.LTE',	'.',	4794,	'circuit',	'l',	'2021-01-26',	10,	436),
('http://tonkas.hopto.org/EVO1/fasthillclimb.lte',	'fasthillclimb.lte',	'fasthillclimb.lte',	'.',	5285,	'circuit',	'l',	'2002-09-07',	10,	437),
('http://tonkas.hopto.org/EVO1/FATTY.LTE',	'FATTY.LTE',	'FATTY.LTE',	'.',	17694,	'circuit',	'l',	'2001-08-17',	10,	438),
('http://tonkas.hopto.org/EVO1/FB1.LTE',	'FB1.LTE',	'FB1.LTE',	'.',	75706,	'circuit',	'l',	'2003-03-07',	10,	439),
('http://tonkas.hopto.org/EVO1/FESTIVE.LTE',	'FESTIVE.LTE',	'FESTIVE.LTE',	'.',	10303,	'circuit',	'l',	'2001-12-14',	10,	440),
('http://tonkas.hopto.org/EVO1/FEYDER.pod',	'FEYDER.pod',	'FEYDER.pod',	'.',	12216152,	'circuit',	'p',	'2006-04-10',	10,	441),
('http://tonkas.hopto.org/EVO1/FEYDER.ZIP',	'FEYDER.ZIP',	'FEYDER.ZIP',	'.',	3835125,	'circuit',	'z',	'2002-10-16',	10,	442),
('http://tonkas.hopto.org/EVO1/FIELD.ZIP',	'FIELD.ZIP',	'FIELD.ZIP',	'.',	2971721,	'circuit',	'z',	'2001-03-10',	10,	443),
('http://tonkas.hopto.org/EVO1/FIELDFXD.ZIP',	'FIELDFXD.ZIP',	'FIELDFXD.ZIP',	'.',	2971959,	'circuit',	'z',	'2001-03-28',	10,	444),
('http://tonkas.hopto.org/EVO1/finalfrontier.zip',	'finalfrontier.zip',	'finalfrontier.zip',	'.',	5605996,	'circuit',	'z',	'2001-04-24',	10,	445),
('http://tonkas.hopto.org/EVO1/FIRST.pod',	'FIRST.pod',	'FIRST.pod',	'.',	7455225,	'circuit',	'p',	'2021-01-25',	10,	446),
('http://tonkas.hopto.org/EVO1/FIRST.ZIP',	'FIRST.ZIP',	'FIRST.ZIP',	'.',	3754157,	'circuit',	'z',	'2001-01-05',	10,	447),
('http://tonkas.hopto.org/EVO1/FIRSTBLOOD2.zip',	'FIRSTBLOOD2.zip',	'FIRSTBLOOD2.zip',	'.',	3815274,	'circuit',	'z',	'2001-10-26',	10,	448),
('http://tonkas.hopto.org/EVO1/FIRSTLITE890.LTE',	'FIRSTLITE890.LTE',	'FIRSTLITE890.LTE',	'.',	54524,	'circuit',	'l',	'2021-01-26',	10,	449),
('http://tonkas.hopto.org/EVO1/FIRTRACK.LTE',	'FIRTRACK.LTE',	'FIRTRACK.LTE',	'.',	7240,	'circuit',	'l',	'2001-09-17',	10,	450),
('http://tonkas.hopto.org/EVO1/Firws.lte',	'Firws.lte',	'Firws.lte',	'.',	37929,	'circuit',	'l',	'2021-01-26',	10,	451),
('http://tonkas.hopto.org/EVO1/FLIGHT.LTE',	'FLIGHT.LTE',	'FLIGHT.LTE',	'.',	12588,	'circuit',	'l',	'2002-06-14',	10,	452),
('http://tonkas.hopto.org/EVO1/FLYINGMONKEYS.LTE',	'FLYINGMONKEYS.LTE',	'FLYINGMONKEYS.LTE',	'.',	26172,	'circuit',	'l',	'2021-01-26',	10,	453),
('http://tonkas.hopto.org/EVO1/fmbank.lte',	'fmbank.lte',	'fmbank.lte',	'.',	61649,	'circuit',	'l',	'2021-01-26',	10,	454),
('http://tonkas.hopto.org/EVO1/Fnlfront.zip',	'Fnlfront.zip',	'Fnlfront.zip',	'.',	1236992,	'circuit',	'z',	'2001-03-13',	10,	455),
('http://tonkas.hopto.org/EVO1/forcepath.lte',	'forcepath.lte',	'forcepath.lte',	'.',	12301,	'circuit',	'l',	'2003-04-30',	10,	456),
('http://tonkas.hopto.org/EVO1/fordsonly.lte',	'fordsonly.lte',	'fordsonly.lte',	'.',	9361,	'circuit',	'l',	'2021-01-26',	10,	457),
('http://tonkas.hopto.org/EVO1/Forest.lte',	'Forest.lte',	'Forest.lte',	'.',	15507,	'circuit',	'l',	'2021-01-26',	10,	458),
('http://tonkas.hopto.org/EVO1/FORESTMT.LTE',	'FORESTMT.LTE',	'FORESTMT.LTE',	'.',	60233,	'circuit',	'l',	'2001-06-08',	10,	459),
('http://tonkas.hopto.org/EVO1/ForestRun.lte',	'ForestRun.lte',	'ForestRun.lte',	'.',	77801,	'circuit',	'l',	'2021-01-26',	10,	460),
('http://tonkas.hopto.org/EVO1/Formula.lte',	'Formula.lte',	'Formula.lte',	'.',	8184,	'circuit',	'l',	'2021-01-26',	10,	461),
('http://tonkas.hopto.org/EVO1/fortattack_b1.lte',	'fortattack_b1.lte',	'fortattack_b1.lte',	'.',	9732,	'circuit',	'l',	'2021-01-26',	10,	462),
('http://tonkas.hopto.org/EVO1/FORYTH.LTE',	'FORYTH.LTE',	'FORYTH.LTE',	'.',	11080,	'circuit',	'l',	'2003-03-25',	10,	463),
('http://tonkas.hopto.org/EVO1/fr2k7.lte',	'fr2k7.lte',	'fr2k7.lte',	'.',	79920,	'circuit',	'l',	'2021-01-26',	10,	464),
('http://tonkas.hopto.org/EVO1/freaks101.lte',	'freaks101.lte',	'freaks101.lte',	'.',	57117,	'circuit',	'l',	'2021-01-26',	10,	465),
('http://tonkas.hopto.org/EVO1/FREERUN.LTE',	'FREERUN.LTE',	'FREERUN.LTE',	'.',	22049,	'circuit',	'l',	'2006-08-09',	10,	466),
('http://tonkas.hopto.org/EVO1/FREESTYLE.LTE',	'FREESTYLE.LTE',	'FREESTYLE.LTE',	'.',	11008,	'circuit',	'l',	'2021-01-26',	10,	467),
('http://tonkas.hopto.org/EVO1/Fun.lte',	'Fun.lte',	'Fun.lte',	'.',	8308,	'circuit',	'l',	'2021-01-26',	10,	468),
('http://tonkas.hopto.org/EVO1/FUN1.LTE',	'FUN1.LTE',	'FUN1.LTE',	'.',	8400,	'circuit',	'l',	'2001-08-27',	10,	469),
('http://tonkas.hopto.org/EVO1/funoff.lte',	'funoff.lte',	'funoff.lte',	'.',	12505,	'circuit',	'l',	'2007-09-13',	10,	470),
('http://tonkas.hopto.org/EVO1/furyfast.lte',	'furyfast.lte',	'furyfast.lte',	'.',	48897,	'circuit',	'l',	'2021-01-26',	10,	471),
('http://tonkas.hopto.org/EVO1/Fuzion.lte',	'Fuzion.lte',	'Fuzion.lte',	'.',	76783,	'circuit',	'l',	'2021-01-26',	10,	472),
('http://tonkas.hopto.org/EVO1/G1.LTE',	'G1.LTE',	'G1.LTE',	'.',	67285,	'circuit',	'l',	'2003-03-13',	10,	473),
('http://tonkas.hopto.org/EVO1/G3(v2).LTE',	'G3(v2).LTE',	'G3(v2).LTE',	'.',	33261,	'circuit',	'l',	'2021-01-26',	10,	474),
('http://tonkas.hopto.org/EVO1/G6.LTE',	'G6.LTE',	'G6.LTE',	'.',	36668,	'circuit',	'l',	'2021-01-26',	10,	475),
('http://tonkas.hopto.org/EVO1/g7.1.lte',	'g7.1.lte',	'g7.1.lte',	'.',	66528,	'circuit',	'l',	'2003-03-13',	10,	476),
('http://tonkas.hopto.org/EVO1/GarageRash.zip',	'GarageRash.zip',	'GarageRash.zip',	'.',	933646,	'circuit',	'z',	'2001-04-03',	10,	477),
('http://tonkas.hopto.org/EVO1/GATOR.LTE',	'GATOR.LTE',	'GATOR.LTE',	'.',	33001,	'circuit',	'l',	'2001-09-28',	10,	478),
('http://tonkas.hopto.org/EVO1/gb.lte',	'gb.lte',	'gb.lte',	'.',	17691,	'circuit',	'l',	'2021-01-26',	10,	479),
('http://tonkas.hopto.org/EVO1/GDS.LTE',	'GDS.LTE',	'GDS.LTE',	'.',	18489,	'circuit',	'l',	'2002-06-25',	10,	480),
('http://tonkas.hopto.org/EVO1/Gettinit.lte',	'Gettinit.lte',	'Gettinit.lte',	'.',	68683,	'circuit',	'l',	'2001-07-06',	10,	481),
('http://tonkas.hopto.org/EVO1/GHETTO.LTE',	'GHETTO.LTE',	'GHETTO.LTE',	'.',	61584,	'circuit',	'l',	'2001-08-05',	10,	482),
('http://tonkas.hopto.org/EVO1/GHOST.LTE',	'GHOST.LTE',	'GHOST.LTE',	'.',	8864,	'circuit',	'l',	'2001-07-13',	10,	483),
('http://tonkas.hopto.org/EVO1/ghostrun.LTE',	'ghostrun.LTE',	'ghostrun.LTE',	'.',	31955,	'circuit',	'l',	'2007-12-31',	10,	484),
('http://tonkas.hopto.org/EVO1/gkwwmy.lte',	'gkwwmy.lte',	'gkwwmy.lte',	'.',	59052,	'circuit',	'l',	'2021-01-26',	10,	485),
('http://tonkas.hopto.org/EVO1/GmcTrack.lte',	'GmcTrack.lte',	'GmcTrack.lte',	'.',	11112,	'circuit',	'l',	'2021-01-26',	10,	486),
('http://tonkas.hopto.org/EVO1/GO1.LTE',	'GO1.LTE',	'GO1.LTE',	'.',	27221,	'circuit',	'l',	'2005-01-08',	10,	487),
('http://tonkas.hopto.org/EVO1/GO2.lte',	'GO2.lte',	'GO2.lte',	'.',	19049,	'circuit',	'l',	'2004-11-28',	10,	488),
('http://tonkas.hopto.org/EVO1/GO2fasterdownload.zip',	'GO2fasterdownload.zip',	'GO2fasterdownload.zip',	'.',	169766,	'circuit',	'z',	'2001-01-09',	10,	489),
('http://tonkas.hopto.org/EVO1/GO3.lte',	'GO3.lte',	'GO3.lte',	'.',	18729,	'circuit',	'l',	'2005-02-22',	10,	490),
('http://tonkas.hopto.org/EVO1/GO4.lte',	'GO4.lte',	'GO4.lte',	'.',	33987,	'circuit',	'l',	'2005-02-22',	10,	491),
('http://tonkas.hopto.org/EVO1/GO5.LTE',	'GO5.LTE',	'GO5.LTE',	'.',	31466,	'circuit',	'l',	'2007-06-16',	10,	492),
('http://tonkas.hopto.org/EVO1/GOfasterdownload.zip',	'GOfasterdownload.zip',	'GOfasterdownload.zip',	'.',	158713,	'circuit',	'z',	'2001-01-09',	10,	493),
('http://tonkas.hopto.org/EVO1/GOINBIG.LTE',	'GOINBIG.LTE',	'GOINBIG.LTE',	'.',	40445,	'circuit',	'l',	'2001-07-29',	10,	494),
('http://tonkas.hopto.org/EVO1/GOKART.LTE',	'GOKART.LTE',	'GOKART.LTE',	'.',	68716,	'circuit',	'l',	'2001-06-01',	10,	495),
('http://tonkas.hopto.org/EVO1/Goldrush.lte',	'Goldrush.lte',	'Goldrush.lte',	'.',	63718,	'circuit',	'l',	'2001-02-02',	10,	496),
('http://tonkas.hopto.org/EVO1/GONECOLD.ZIP',	'GONECOLD.ZIP',	'GONECOLD.ZIP',	'.',	1388728,	'circuit',	'z',	'2001-01-13',	10,	497),
('http://tonkas.hopto.org/EVO1/GoneFishn.zip',	'GoneFishn.zip',	'GoneFishn.zip',	'.',	1760551,	'circuit',	'z',	'2001-04-23',	10,	498),
('http://tonkas.hopto.org/EVO1/Gone_Fishin_fix.zip',	'Gone_Fishin_fix.zip',	'Gone_Fishin_fix.zip',	'.',	2034114,	'circuit',	'z',	'2001-04-24',	10,	499),
('http://tonkas.hopto.org/EVO1/Goodluck.lte',	'Goodluck.lte',	'Goodluck.lte',	'.',	31630,	'circuit',	'l',	'2021-01-26',	10,	500),
('http://tonkas.hopto.org/EVO1/GOTIME.LTE',	'GOTIME.LTE',	'GOTIME.LTE',	'.',	66616,	'circuit',	'l',	'2001-04-18',	10,	501),
('http://tonkas.hopto.org/EVO1/Gotimepodzip.ZIP',	'Gotimepodzip.ZIP',	'Gotimepodzip.ZIP',	'.',	130776,	'circuit',	'z',	'2001-01-09',	10,	502),
('http://tonkas.hopto.org/EVO1/gpracehome.lte',	'gpracehome.lte',	'gpracehome.lte',	'.',	15220,	'circuit',	'l',	'2021-01-26',	10,	503),
('http://tonkas.hopto.org/EVO1/grapids.lte',	'grapids.lte',	'grapids.lte',	'.',	53716,	'circuit',	'l',	'2004-04-14',	10,	504),
('http://tonkas.hopto.org/EVO1/graveyard.lte',	'graveyard.lte',	'graveyard.lte',	'.',	17921,	'circuit',	'l',	'2002-06-05',	10,	505),
('http://tonkas.hopto.org/EVO1/greasefactory.lte',	'greasefactory.lte',	'greasefactory.lte',	'.',	23809,	'circuit',	'l',	'2021-01-26',	10,	506),
('http://tonkas.hopto.org/EVO1/GreatRush.lte',	'GreatRush.lte',	'GreatRush.lte',	'.',	23797,	'circuit',	'l',	'2001-01-25',	10,	507),
('http://tonkas.hopto.org/EVO1/GROMIT.POD',	'GROMIT.POD',	'GROMIT.POD',	'.',	4809626,	'circuit',	'p',	'2001-01-14',	10,	508),
('http://tonkas.hopto.org/EVO1/Gromitbeta.zip',	'Gromitbeta.zip',	'Gromitbeta.zip',	'.',	2282287,	'circuit',	'z',	'2001-01-09',	10,	509),
('http://tonkas.hopto.org/EVO1/gromit_both_fix.zip',	'gromit_both_fix.zip',	'gromit_both_fix.zip',	'.',	5404715,	'circuit',	'z',	'2001-01-21',	10,	510),
('http://tonkas.hopto.org/EVO1/GROMIT_REVERSED.pod',	'GROMIT_REVERSED.pod',	'GROMIT_REVERSED.pod',	'.',	4806129,	'circuit',	'p',	'2001-01-21',	10,	511),
('http://tonkas.hopto.org/EVO1/gstop404.lte',	'gstop404.lte',	'gstop404.lte',	'.',	82410,	'circuit',	'l',	'2006-04-03',	10,	512),
('http://tonkas.hopto.org/EVO1/GT2.LTE',	'GT2.LTE',	'GT2.LTE',	'.',	14031,	'circuit',	'l',	'2006-09-16',	10,	513),
('http://tonkas.hopto.org/EVO1/GTO1.LTE',	'GTO1.LTE',	'GTO1.LTE',	'.',	63144,	'circuit',	'l',	'2003-01-13',	10,	514),
('http://tonkas.hopto.org/EVO1/GTOCAN.LTE',	'GTOCAN.LTE',	'GTOCAN.LTE',	'.',	49981,	'circuit',	'l',	'2004-03-14',	10,	515),
('http://tonkas.hopto.org/EVO1/GtOfH.lte',	'GtOfH.lte',	'GtOfH.lte',	'.',	17820,	'circuit',	'l',	'2007-08-22',	10,	516),
('http://tonkas.hopto.org/EVO1/gtofh2.lte',	'gtofh2.lte',	'gtofh2.lte',	'.',	20744,	'circuit',	'l',	'2007-08-26',	10,	517),
('http://tonkas.hopto.org/EVO1/GTOSPEEDWAY2.LTE',	'GTOSPEEDWAY2.LTE',	'GTOSPEEDWAY2.LTE',	'.',	7598,	'circuit',	'l',	'2004-03-14',	10,	518),
('http://tonkas.hopto.org/EVO1/GTOSPEEDWAY3.LTE',	'GTOSPEEDWAY3.LTE',	'GTOSPEEDWAY3.LTE',	'.',	8141,	'circuit',	'l',	'2004-03-14',	10,	519),
('http://tonkas.hopto.org/EVO1/GTTESTTRACK.LTE',	'GTTESTTRACK.LTE',	'GTTESTTRACK.LTE',	'.',	25731,	'circuit',	'l',	'2021-01-26',	10,	520),
('http://tonkas.hopto.org/EVO1/GULTCH1.pod',	'GULTCH1.pod',	'GULTCH1.pod',	'.',	6780475,	'circuit',	'p',	'2021-01-25',	10,	521),
('http://tonkas.hopto.org/EVO1/GULTCH1.ZIP',	'GULTCH1.ZIP',	'GULTCH1.ZIP',	'.',	3308263,	'circuit',	'z',	'2001-02-03',	10,	522),
('http://tonkas.hopto.org/EVO1/Gunho.lte',	'Gunho.lte',	'Gunho.lte',	'.',	49761,	'circuit',	'l',	'2021-01-26',	10,	523),
('http://tonkas.hopto.org/EVO1/H2H.LTE',	'H2H.LTE',	'H2H.LTE',	'.',	12474,	'circuit',	'l',	'2021-01-26',	10,	524),
('http://tonkas.hopto.org/EVO1/H2WAY.LTE',	'H2WAY.LTE',	'H2WAY.LTE',	'.',	16609,	'circuit',	'l',	'2001-10-12',	10,	525),
('http://tonkas.hopto.org/EVO1/HAFUN2.pod',	'HAFUN2.pod',	'HAFUN2.pod',	'.',	5337983,	'circuit',	'p',	'2021-01-25',	10,	526),
('http://tonkas.hopto.org/EVO1/hagerstownhills.lte',	'hagerstownhills.lte',	'hagerstownhills.lte',	'.',	11189,	'circuit',	'l',	'2001-09-24',	10,	527),
('http://tonkas.hopto.org/EVO1/HAGERSTOWNV2.LTE',	'HAGERSTOWNV2.LTE',	'HAGERSTOWNV2.LTE',	'.',	33320,	'circuit',	'l',	'2021-01-26',	10,	528),
('http://tonkas.hopto.org/EVO1/halfmile.lte',	'halfmile.lte',	'halfmile.lte',	'.',	8520,	'circuit',	'l',	'2021-01-26',	10,	529),
('http://tonkas.hopto.org/EVO1/HALFMILEDRAG.LTE',	'HALFMILEDRAG.LTE',	'HALFMILEDRAG.LTE',	'.',	12010,	'circuit',	'l',	'2001-01-30',	10,	530),
('http://tonkas.hopto.org/EVO1/HALFMILEDRAG1.LTE',	'HALFMILEDRAG1.LTE',	'HALFMILEDRAG1.LTE',	'.',	12010,	'circuit',	'l',	'2001-01-31',	10,	531),
('http://tonkas.hopto.org/EVO1/Halfway.lte',	'Halfway.lte',	'Halfway.lte',	'.',	76926,	'circuit',	'l',	'2021-01-26',	10,	532),
('http://tonkas.hopto.org/EVO1/hardcore.lte',	'hardcore.lte',	'hardcore.lte',	'.',	48317,	'circuit',	'l',	'2005-02-08',	10,	533),
('http://tonkas.hopto.org/EVO1/HARDEST.LTE',	'HARDEST.LTE',	'HARDEST.LTE',	'.',	19735,	'circuit',	'l',	'2003-04-11',	10,	534),
('http://tonkas.hopto.org/EVO1/hardkorrally.lte',	'hardkorrally.lte',	'hardkorrally.lte',	'.',	59915,	'circuit',	'l',	'2002-04-08',	10,	535),
('http://tonkas.hopto.org/EVO1/hardoffroad2.lte',	'hardoffroad2.lte',	'hardoffroad2.lte',	'.',	7134,	'circuit',	'l',	'2003-03-20',	10,	536),
('http://tonkas.hopto.org/EVO1/hardrock.lte',	'hardrock.lte',	'hardrock.lte',	'.',	64759,	'circuit',	'l',	'2021-01-26',	10,	537),
('http://tonkas.hopto.org/EVO1/hardrockx.lte',	'hardrockx.lte',	'hardrockx.lte',	'.',	71365,	'circuit',	'l',	'2005-05-19',	10,	538),
('http://tonkas.hopto.org/EVO1/HavinFun.ZIP',	'HavinFun.ZIP',	'HavinFun.ZIP',	'.',	478734,	'circuit',	'z',	'2001-02-20',	10,	539),
('http://tonkas.hopto.org/EVO1/Hawai.lte',	'Hawai.lte',	'Hawai.lte',	'.',	17026,	'circuit',	'l',	'2021-01-26',	10,	540),
('http://tonkas.hopto.org/EVO1/HAWK1.lte',	'HAWK1.lte',	'HAWK1.lte',	'.',	83277,	'circuit',	'l',	'2004-10-24',	10,	541),
('http://tonkas.hopto.org/EVO1/hawk2.lte',	'hawk2.lte',	'hawk2.lte',	'.',	73479,	'circuit',	'l',	'2004-10-26',	10,	542),
('http://tonkas.hopto.org/EVO1/hcsv2.lte',	'hcsv2.lte',	'hcsv2.lte',	'.',	8377,	'circuit',	'l',	'2004-05-17',	10,	543),
('http://tonkas.hopto.org/EVO1/head2head.zip',	'head2head.zip',	'head2head.zip',	'.',	2550468,	'circuit',	'z',	'2001-01-13',	10,	544),
('http://tonkas.hopto.org/EVO1/HEATER.LTE',	'HEATER.LTE',	'HEATER.LTE',	'.',	28960,	'circuit',	'l',	'2021-01-26',	10,	545),
('http://tonkas.hopto.org/EVO1/HELICOPTER.LTE',	'HELICOPTER.LTE',	'HELICOPTER.LTE',	'.',	16831,	'circuit',	'l',	'2021-01-26',	10,	546),
('http://tonkas.hopto.org/EVO1/HELL.LTE',	'HELL.LTE',	'HELL.LTE',	'.',	20169,	'circuit',	'l',	'2021-01-26',	10,	547),
('http://tonkas.hopto.org/EVO1/hell2.lte',	'hell2.lte',	'hell2.lte',	'.',	18193,	'circuit',	'l',	'2021-01-26',	10,	548),
('http://tonkas.hopto.org/EVO1/HELL3.LTE',	'HELL3.LTE',	'HELL3.LTE',	'.',	18284,	'circuit',	'l',	'2002-10-31',	10,	549),
('http://tonkas.hopto.org/EVO1/HELLINTHECELL.LTE',	'HELLINTHECELL.LTE',	'HELLINTHECELL.LTE',	'.',	7760,	'circuit',	'l',	'2021-01-26',	10,	550),
('http://tonkas.hopto.org/EVO1/HELLRIDE.LTE',	'HELLRIDE.LTE',	'HELLRIDE.LTE',	'.',	14323,	'circuit',	'l',	'2005-11-08',	10,	551),
('http://tonkas.hopto.org/EVO1/HELLTRACK.LTE',	'HELLTRACK.LTE',	'HELLTRACK.LTE',	'.',	73410,	'circuit',	'l',	'2021-01-26',	10,	552),
('http://tonkas.hopto.org/EVO1/HFun2.zip',	'HFun2.zip',	'HFun2.zip',	'.',	1661854,	'circuit',	'z',	'2001-03-08',	10,	553),
('http://tonkas.hopto.org/EVO1/hhc.lte',	'hhc.lte',	'hhc.lte',	'.',	18019,	'circuit',	'l',	'2021-01-26',	10,	554),
('http://tonkas.hopto.org/EVO1/hiddenfair.lte',	'hiddenfair.lte',	'hiddenfair.lte',	'.',	27073,	'circuit',	'l',	'2003-02-03',	10,	555),
('http://tonkas.hopto.org/EVO1/hiddenhillclimb.lte',	'hiddenhillclimb.lte',	'hiddenhillclimb.lte',	'.',	18019,	'circuit',	'l',	'2003-04-24',	10,	556),
('http://tonkas.hopto.org/EVO1/hiddenhillclimb2.lte',	'hiddenhillclimb2.lte',	'hiddenhillclimb2.lte',	'.',	10681,	'circuit',	'l',	'2004-04-14',	10,	557),
('http://tonkas.hopto.org/EVO1/HiddenHillClimb3.lte',	'HiddenHillClimb3.lte',	'HiddenHillClimb3.lte',	'.',	13579,	'circuit',	'l',	'2004-04-14',	10,	558),
('http://tonkas.hopto.org/EVO1/hiddenhillclimb4.lte',	'hiddenhillclimb4.lte',	'hiddenhillclimb4.lte',	'.',	26805,	'circuit',	'l',	'2006-05-16',	10,	559),
('http://tonkas.hopto.org/EVO1/hiddenhillclimb5.lte',	'hiddenhillclimb5.lte',	'hiddenhillclimb5.lte',	'.',	33998,	'circuit',	'l',	'2004-10-28',	10,	560),
('http://tonkas.hopto.org/EVO1/hidrive.lte',	'hidrive.lte',	'hidrive.lte',	'.',	41490,	'circuit',	'l',	'2021-01-26',	10,	561),
('http://tonkas.hopto.org/EVO1/High.lte',	'High.lte',	'High.lte',	'.',	5484,	'circuit',	'l',	'2001-05-01',	10,	562),
('http://tonkas.hopto.org/EVO1/Highjump.lte',	'Highjump.lte',	'Highjump.lte',	'.',	18072,	'circuit',	'l',	'2001-07-28',	10,	563),
('http://tonkas.hopto.org/EVO1/highlander.lte',	'highlander.lte',	'highlander.lte',	'.',	86143,	'circuit',	'l',	'2006-04-13',	10,	564),
('http://tonkas.hopto.org/EVO1/HIGHSPEED.LTE',	'HIGHSPEED.LTE',	'HIGHSPEED.LTE',	'.',	4297,	'circuit',	'l',	'2021-01-26',	10,	565),
('http://tonkas.hopto.org/EVO1/highspeedo.zip',	'highspeedo.zip',	'highspeedo.zip',	'.',	612911,	'circuit',	'z',	'2000-12-29',	10,	566),
('http://tonkas.hopto.org/EVO1/HILLBILLYROAD.LTE',	'HILLBILLYROAD.LTE',	'HILLBILLYROAD.LTE',	'.',	51979,	'circuit',	'l',	'2001-03-04',	10,	567),
('http://tonkas.hopto.org/EVO1/HILLCLIMB.LTE',	'HILLCLIMB.LTE',	'HILLCLIMB.LTE',	'.',	9855,	'circuit',	'l',	'2021-01-26',	10,	568),
('http://tonkas.hopto.org/EVO1/hillclimbhell.lte',	'hillclimbhell.lte',	'hillclimbhell.lte',	'.',	50623,	'circuit',	'l',	'2004-04-14',	10,	569),
('http://tonkas.hopto.org/EVO1/hillclimbhell2.lte',	'hillclimbhell2.lte',	'hillclimbhell2.lte',	'.',	13105,	'circuit',	'l',	'2006-05-16',	10,	570),
('http://tonkas.hopto.org/EVO1/hillclimb_b1.LTE',	'hillclimb_b1.LTE',	'hillclimb_b1.LTE',	'.',	12098,	'circuit',	'l',	'2001-01-30',	10,	571),
('http://tonkas.hopto.org/EVO1/hillrally.lte',	'hillrally.lte',	'hillrally.lte',	'.',	9485,	'circuit',	'l',	'2003-06-28',	10,	572),
('http://tonkas.hopto.org/EVO1/Hills.lte',	'Hills.lte',	'Hills.lte',	'.',	5422,	'circuit',	'l',	'2001-05-01',	10,	573),
('http://tonkas.hopto.org/EVO1/hillteamff.lte',	'hillteamff.lte',	'hillteamff.lte',	'.',	89367,	'circuit',	'l',	'2021-01-26',	10,	574),
('http://tonkas.hopto.org/EVO1/HILLZv2.lte',	'HILLZv2.lte',	'HILLZv2.lte',	'.',	17215,	'circuit',	'l',	'2004-05-24',	10,	575),
('http://tonkas.hopto.org/EVO1/HISPDRUN1.LTE',	'HISPDRUN1.LTE',	'HISPDRUN1.LTE',	'.',	43613,	'circuit',	'l',	'2021-01-26',	10,	576),
('http://tonkas.hopto.org/EVO1/Hmmm.lte',	'Hmmm.lte',	'Hmmm.lte',	'.',	9291,	'circuit',	'l',	'2021-01-26',	10,	577),
('http://tonkas.hopto.org/EVO1/holorace.pod',	'holorace.pod',	'holorace.pod',	'.',	8199829,	'circuit',	'p',	'2007-03-12',	10,	578),
('http://tonkas.hopto.org/EVO1/Homedeer.lte',	'Homedeer.lte',	'Homedeer.lte',	'.',	8685,	'circuit',	'l',	'2021-01-26',	10,	579),
('http://tonkas.hopto.org/EVO1/hondarace.lte',	'hondarace.lte',	'hondarace.lte',	'.',	31873,	'circuit',	'l',	'2006-07-23',	10,	580),
('http://tonkas.hopto.org/EVO1/hopefalls.lte',	'hopefalls.lte',	'hopefalls.lte',	'.',	23201,	'circuit',	'l',	'2003-05-14',	10,	581),
('http://tonkas.hopto.org/EVO1/HOTRODWINTER.LTE',	'HOTRODWINTER.LTE',	'HOTRODWINTER.LTE',	'.',	36254,	'circuit',	'l',	'2001-01-09',	10,	582),
('http://tonkas.hopto.org/EVO1/HoverTrack.lte',	'HoverTrack.lte',	'HoverTrack.lte',	'.',	61271,	'circuit',	'l',	'2021-01-26',	10,	583),
('http://tonkas.hopto.org/EVO1/HR.LTE',	'HR.LTE',	'HR.LTE',	'.',	71913,	'circuit',	'l',	'2001-08-27',	10,	584),
('http://tonkas.hopto.org/EVO1/hrally2000.lte',	'hrally2000.lte',	'hrally2000.lte',	'.',	10368,	'circuit',	'l',	'2021-01-26',	10,	585),
('http://tonkas.hopto.org/EVO1/HRTRUCKRALLYV2.LTE',	'HRTRUCKRALLYV2.LTE',	'HRTRUCKRALLYV2.LTE',	'.',	60245,	'circuit',	'l',	'2021-01-26',	10,	586),
('http://tonkas.hopto.org/EVO1/hrwoodpeak.lte',	'hrwoodpeak.lte',	'hrwoodpeak.lte',	'.',	59045,	'circuit',	'l',	'2001-11-14',	10,	587),
('http://tonkas.hopto.org/EVO1/HTRNOR.LTE',	'HTRNOR.LTE',	'HTRNOR.LTE',	'.',	13281,	'circuit',	'l',	'2003-01-02',	10,	588),
('http://tonkas.hopto.org/EVO1/Huge.lte',	'Huge.lte',	'Huge.lte',	'.',	5030,	'circuit',	'l',	'2001-05-01',	10,	589),
('http://tonkas.hopto.org/EVO1/hydromoto.lte',	'hydromoto.lte',	'hydromoto.lte',	'.',	80251,	'circuit',	'l',	'2021-01-26',	10,	590),
('http://tonkas.hopto.org/EVO1/hydromoto2.lte',	'hydromoto2.lte',	'hydromoto2.lte',	'.',	90804,	'circuit',	'l',	'2021-01-26',	10,	591),
('http://tonkas.hopto.org/EVO1/H_2way.LTE',	'H_2way.LTE',	'H_2way.LTE',	'.',	18845,	'circuit',	'l',	'2021-01-26',	10,	592),
('http://tonkas.hopto.org/EVO1/H_2ways.lte',	'H_2ways.lte',	'H_2ways.lte',	'.',	16717,	'circuit',	'l',	'2021-01-26',	10,	593),
('http://tonkas.hopto.org/EVO1/H_creek.lte',	'H_creek.lte',	'H_creek.lte',	'.',	23278,	'circuit',	'l',	'2021-01-26',	10,	594),
('http://tonkas.hopto.org/EVO1/h_hillclimb.lte',	'h_hillclimb.lte',	'h_hillclimb.lte',	'.',	50067,	'circuit',	'l',	'2002-05-08',	10,	595),
('http://tonkas.hopto.org/EVO1/H_pit.lte',	'H_pit.lte',	'H_pit.lte',	'.',	20825,	'circuit',	'l',	'2004-12-12',	10,	596),
('http://tonkas.hopto.org/EVO1/H_SWAMP.LTE',	'H_SWAMP.LTE',	'H_SWAMP.LTE',	'.',	16812,	'circuit',	'l',	'2003-07-17',	10,	597),
('http://tonkas.hopto.org/EVO1/IAMINSANE.POD',	'IAMINSANE.POD',	'IAMINSANE.POD',	'.',	1609556,	'circuit',	'p',	'2005-11-22',	10,	598),
('http://tonkas.hopto.org/EVO1/Ice.lte',	'Ice.lte',	'Ice.lte',	'.',	4037,	'circuit',	'l',	'2021-01-26',	10,	599),
('http://tonkas.hopto.org/EVO1/Ice002.lte',	'Ice002.lte',	'Ice002.lte',	'.',	6790,	'circuit',	'l',	'2021-01-26',	10,	600),
('http://tonkas.hopto.org/EVO1/icehell.lte',	'icehell.lte',	'icehell.lte',	'.',	18110,	'circuit',	'l',	'2004-10-24',	10,	601),
('http://tonkas.hopto.org/EVO1/iceland.pod',	'iceland.pod',	'iceland.pod',	'.',	5972281,	'circuit',	'p',	'2021-01-25',	10,	602),
('http://tonkas.hopto.org/EVO1/ICESTATIONZEBRA.LTE',	'ICESTATIONZEBRA.LTE',	'ICESTATIONZEBRA.LTE',	'.',	65260,	'circuit',	'l',	'2021-01-26',	10,	603),
('http://tonkas.hopto.org/EVO1/ICPCLIMB.LTE',	'ICPCLIMB.LTE',	'ICPCLIMB.LTE',	'.',	9549,	'circuit',	'l',	'2003-04-07',	10,	604),
('http://tonkas.hopto.org/EVO1/icpmaze.lte',	'icpmaze.lte',	'icpmaze.lte',	'.',	10461,	'circuit',	'l',	'2006-05-14',	10,	605),
('http://tonkas.hopto.org/EVO1/ICPRALLY.LTE',	'ICPRALLY.LTE',	'ICPRALLY.LTE',	'.',	14274,	'circuit',	'l',	'2003-03-07',	10,	606),
('http://tonkas.hopto.org/EVO1/ILJ.LTE',	'ILJ.LTE',	'ILJ.LTE',	'.',	20746,	'circuit',	'l',	'2001-03-29',	10,	607),
('http://tonkas.hopto.org/EVO1/IMAGE2.LTE',	'IMAGE2.LTE',	'IMAGE2.LTE',	'.',	81204,	'circuit',	'l',	'2021-01-26',	10,	608),
('http://tonkas.hopto.org/EVO1/impulse.lte',	'impulse.lte',	'impulse.lte',	'.',	96099,	'circuit',	'l',	'2005-05-07',	10,	609),
('http://tonkas.hopto.org/EVO1/INDOOR.LTE',	'INDOOR.LTE',	'INDOOR.LTE',	'.',	22935,	'circuit',	'l',	'2002-10-31',	10,	610),
('http://tonkas.hopto.org/EVO1/industrials.zip',	'industrials.zip',	'industrials.zip',	'.',	1344177,	'circuit',	'z',	'2001-01-11',	10,	611),
('http://tonkas.hopto.org/EVO1/INSANE.LTE',	'INSANE.LTE',	'INSANE.LTE',	'.',	10105,	'circuit',	'l',	'2021-01-26',	10,	612),
('http://tonkas.hopto.org/EVO1/insanity.lte',	'insanity.lte',	'insanity.lte',	'.',	12021,	'circuit',	'l',	'2021-01-26',	10,	613),
('http://tonkas.hopto.org/EVO1/INT2.LTE',	'INT2.LTE',	'INT2.LTE',	'.',	14310,	'circuit',	'l',	'2002-06-14',	10,	614),
('http://tonkas.hopto.org/EVO1/intrash.lte',	'intrash.lte',	'intrash.lte',	'.',	18361,	'circuit',	'l',	'2021-01-26',	10,	615),
('http://tonkas.hopto.org/EVO1/Iocdrag.lte',	'Iocdrag.lte',	'Iocdrag.lte',	'.',	9958,	'circuit',	'l',	'2001-01-31',	10,	616),
('http://tonkas.hopto.org/EVO1/IPANEMA.LTE',	'IPANEMA.LTE',	'IPANEMA.LTE',	'.',	39447,	'circuit',	'l',	'2007-02-03',	10,	617),
('http://tonkas.hopto.org/EVO1/Irc.lte',	'Irc.lte',	'Irc.lte',	'.',	8169,	'circuit',	'l',	'2021-01-26',	10,	618),
('http://tonkas.hopto.org/EVO1/Irc2.lte',	'Irc2.lte',	'Irc2.lte',	'.',	13324,	'circuit',	'l',	'2021-01-26',	10,	619),
('http://tonkas.hopto.org/EVO1/ironhorse.lte',	'ironhorse.lte',	'ironhorse.lte',	'.',	25208,	'circuit',	'l',	'2021-01-26',	10,	620),
('http://tonkas.hopto.org/EVO1/ISLAND2.POD',	'ISLAND2.POD',	'ISLAND2.POD',	'.',	10533295,	'circuit',	'p',	'2000-09-18',	10,	621),
('http://tonkas.hopto.org/EVO1/ISLAND2ISLAND.LTE',	'ISLAND2ISLAND.LTE',	'ISLAND2ISLAND.LTE',	'.',	59697,	'circuit',	'l',	'2001-04-21',	10,	622),
('http://tonkas.hopto.org/EVO1/ISLANDX.ZIP',	'ISLANDX.ZIP',	'ISLANDX.ZIP',	'.',	2647045,	'circuit',	'z',	'2001-03-08',	10,	623),
('http://tonkas.hopto.org/EVO1/Itajima.lte',	'Itajima.lte',	'Itajima.lte',	'.',	35275,	'circuit',	'l',	'2002-05-07',	10,	624),
('http://tonkas.hopto.org/EVO1/Jasonsfirst.lte',	'Jasonsfirst.lte',	'Jasonsfirst.lte',	'.',	11028,	'circuit',	'l',	'2021-01-26',	10,	625),
('http://tonkas.hopto.org/EVO1/JEANIE.LTE',	'JEANIE.LTE',	'JEANIE.LTE',	'.',	38688,	'circuit',	'l',	'2001-09-14',	10,	626),
('http://tonkas.hopto.org/EVO1/JEDI.ZIP',	'JEDI.ZIP',	'JEDI.ZIP',	'.',	493109,	'circuit',	'z',	'2002-06-03',	10,	627),
('http://tonkas.hopto.org/EVO1/Jedibata.lte',	'Jedibata.lte',	'Jedibata.lte',	'.',	82079,	'circuit',	'l',	'2008-02-23',	10,	628),
('http://tonkas.hopto.org/EVO1/jediblueridge.lte',	'jediblueridge.lte',	'jediblueridge.lte',	'.',	70048,	'circuit',	'l',	'2004-04-25',	10,	629),
('http://tonkas.hopto.org/EVO1/JediBlueridge2.lte',	'JediBlueridge2.lte',	'JediBlueridge2.lte',	'.',	67076,	'circuit',	'l',	'2004-04-15',	10,	630),
('http://tonkas.hopto.org/EVO1/Jedibrrr.lte',	'Jedibrrr.lte',	'Jedibrrr.lte',	'.',	52981,	'circuit',	'l',	'2006-02-26',	10,	631),
('http://tonkas.hopto.org/EVO1/jedibrrr2.lte',	'jedibrrr2.lte',	'jedibrrr2.lte',	'.',	52927,	'circuit',	'l',	'2007-11-17',	10,	632),
('http://tonkas.hopto.org/EVO1/Jedicanion.lte',	'Jedicanion.lte',	'Jedicanion.lte',	'.',	51483,	'circuit',	'l',	'2004-06-07',	10,	633),
('http://tonkas.hopto.org/EVO1/Jedichallenge.lte',	'Jedichallenge.lte',	'Jedichallenge.lte',	'.',	61962,	'circuit',	'l',	'2002-02-24',	10,	634),
('http://tonkas.hopto.org/EVO1/jedichallenge2.lte',	'jedichallenge2.lte',	'jedichallenge2.lte',	'.',	61818,	'circuit',	'l',	'2007-11-29',	10,	635),
('http://tonkas.hopto.org/EVO1/Jedidejavous.lte',	'Jedidejavous.lte',	'Jedidejavous.lte',	'.',	16983,	'circuit',	'l',	'2008-07-21',	10,	636),
('http://tonkas.hopto.org/EVO1/JEDIDESSERT.LTE',	'JEDIDESSERT.LTE',	'JEDIDESSERT.LTE',	'.',	34904,	'circuit',	'l',	'2002-10-23',	10,	637),
('http://tonkas.hopto.org/EVO1/Jedidrag.lte',	'Jedidrag.lte',	'Jedidrag.lte',	'.',	29234,	'circuit',	'l',	'2001-11-09',	10,	638),
('http://tonkas.hopto.org/EVO1/jedidragoon.lte',	'jedidragoon.lte',	'jedidragoon.lte',	'.',	49433,	'circuit',	'l',	'2007-11-28',	10,	639),
('http://tonkas.hopto.org/EVO1/Jedieagle.lte',	'Jedieagle.lte',	'Jedieagle.lte',	'.',	54093,	'circuit',	'l',	'2005-04-06',	10,	640),
('http://tonkas.hopto.org/EVO1/Jedieasyway.lte',	'Jedieasyway.lte',	'Jedieasyway.lte',	'.',	44423,	'circuit',	'l',	'2004-04-26',	10,	641),
('http://tonkas.hopto.org/EVO1/JediElim.lte',	'JediElim.lte',	'JediElim.lte',	'.',	64389,	'circuit',	'l',	'2001-09-28',	10,	642),
('http://tonkas.hopto.org/EVO1/JediEliminator.lte',	'JediEliminator.lte',	'JediEliminator.lte',	'.',	64389,	'circuit',	'l',	'2004-05-06',	10,	643),
('http://tonkas.hopto.org/EVO1/JediEliminator2.lte',	'JediEliminator2.lte',	'JediEliminator2.lte',	'.',	64327,	'circuit',	'l',	'2002-02-13',	10,	644),
('http://tonkas.hopto.org/EVO1/JediEM.lte',	'JediEM.lte',	'JediEM.lte',	'.',	28632,	'circuit',	'l',	'2002-07-13',	10,	645),
('http://tonkas.hopto.org/EVO1/JediEvolution.lte',	'JediEvolution.lte',	'JediEvolution.lte',	'.',	79048,	'circuit',	'l',	'2004-04-27',	10,	646),
('http://tonkas.hopto.org/EVO1/Jediextreme.lte',	'Jediextreme.lte',	'Jediextreme.lte',	'.',	64780,	'circuit',	'l',	'2002-03-21',	10,	647),
('http://tonkas.hopto.org/EVO1/JEDIFAST.LTE',	'JEDIFAST.LTE',	'JEDIFAST.LTE',	'.',	26090,	'circuit',	'l',	'2002-09-19',	10,	648),
('http://tonkas.hopto.org/EVO1/JediFastTrack.LTE',	'JediFastTrack.LTE',	'JediFastTrack.LTE',	'.',	10584,	'circuit',	'l',	'2002-12-03',	10,	649),
('http://tonkas.hopto.org/EVO1/Jedifly.lte',	'Jedifly.lte',	'Jedifly.lte',	'.',	45545,	'circuit',	'l',	'2004-04-29',	10,	650),
('http://tonkas.hopto.org/EVO1/JEDIFORCE.LTE',	'JEDIFORCE.LTE',	'JEDIFORCE.LTE',	'.',	70812,	'circuit',	'l',	'2001-12-21',	10,	651),
('http://tonkas.hopto.org/EVO1/JediGoblin.lte',	'JediGoblin.lte',	'JediGoblin.lte',	'.',	31197,	'circuit',	'l',	'2002-07-22',	10,	652),
('http://tonkas.hopto.org/EVO1/jediharbor.lte',	'jediharbor.lte',	'jediharbor.lte',	'.',	6067,	'circuit',	'l',	'2007-11-26',	10,	653),
('http://tonkas.hopto.org/EVO1/jediislands.lte',	'jediislands.lte',	'jediislands.lte',	'.',	51788,	'circuit',	'l',	'2007-08-01',	10,	654),
('http://tonkas.hopto.org/EVO1/JediLegend.lte',	'JediLegend.lte',	'JediLegend.lte',	'.',	69041,	'circuit',	'l',	'2004-08-22',	10,	655),
('http://tonkas.hopto.org/EVO1/JediLegend2.lte',	'JediLegend2.lte',	'JediLegend2.lte',	'.',	69000,	'circuit',	'l',	'2004-04-29',	10,	656),
('http://tonkas.hopto.org/EVO1/jedimoparpower.lte',	'jedimoparpower.lte',	'jedimoparpower.lte',	'.',	35165,	'circuit',	'l',	'2004-04-27',	10,	657),
('http://tonkas.hopto.org/EVO1/Jedimoto.lte',	'Jedimoto.lte',	'Jedimoto.lte',	'.',	11639,	'circuit',	'l',	'2002-07-17',	10,	658),
('http://tonkas.hopto.org/EVO1/Jedimountaindew.lte',	'Jedimountaindew.lte',	'Jedimountaindew.lte',	'.',	66619,	'circuit',	'l',	'2004-04-29',	10,	659),
('http://tonkas.hopto.org/EVO1/JediMountainous.lte',	'JediMountainous.lte',	'JediMountainous.lte',	'.',	61963,	'circuit',	'l',	'2001-12-30',	10,	660),
('http://tonkas.hopto.org/EVO1/jedimounttest.lte',	'jedimounttest.lte',	'jedimounttest.lte',	'.',	5932,	'circuit',	'l',	'2007-10-31',	10,	661),
('http://tonkas.hopto.org/EVO1/JediNebula.lte',	'JediNebula.lte',	'JediNebula.lte',	'.',	69400,	'circuit',	'l',	'2006-02-26',	10,	662),
('http://tonkas.hopto.org/EVO1/JediNebuli.lte',	'JediNebuli.lte',	'JediNebuli.lte',	'.',	69319,	'circuit',	'l',	'2003-12-29',	10,	663),
('http://tonkas.hopto.org/EVO1/JediParadox.lte',	'JediParadox.lte',	'JediParadox.lte',	'.',	24301,	'circuit',	'l',	'2002-06-30',	10,	664),
('http://tonkas.hopto.org/EVO1/JediPark.lte',	'JediPark.lte',	'JediPark.lte',	'.',	38811,	'circuit',	'l',	'2002-07-14',	10,	665),
('http://tonkas.hopto.org/EVO1/Jediplayground.lte',	'Jediplayground.lte',	'Jediplayground.lte',	'.',	29400,	'circuit',	'l',	'2001-10-28',	10,	666),
('http://tonkas.hopto.org/EVO1/JediPower.lte',	'JediPower.lte',	'JediPower.lte',	'.',	54472,	'circuit',	'l',	'2004-05-13',	10,	667),
('http://tonkas.hopto.org/EVO1/Jedipunisher.lte',	'Jedipunisher.lte',	'Jedipunisher.lte',	'.',	70678,	'circuit',	'l',	'2002-02-14',	10,	668),
('http://tonkas.hopto.org/EVO1/Jedisaber.lte',	'Jedisaber.lte',	'Jedisaber.lte',	'.',	39847,	'circuit',	'l',	'2001-08-27',	10,	669),
('http://tonkas.hopto.org/EVO1/JediSimson.lte',	'JediSimson.lte',	'JediSimson.lte',	'.',	35513,	'circuit',	'l',	'2005-05-07',	10,	670),
('http://tonkas.hopto.org/EVO1/Jedisimson2.lte',	'Jedisimson2.lte',	'Jedisimson2.lte',	'.',	34960,	'circuit',	'l',	'2001-04-11',	10,	671),
('http://tonkas.hopto.org/EVO1/JedisimsonT.lte',	'JedisimsonT.lte',	'JedisimsonT.lte',	'.',	36440,	'circuit',	'l',	'2006-07-26',	10,	672),
('http://tonkas.hopto.org/EVO1/Jediskie.lte',	'Jediskie.lte',	'Jediskie.lte',	'.',	43065,	'circuit',	'l',	'2002-05-31',	10,	673),
('http://tonkas.hopto.org/EVO1/Jedispeedway.lte',	'Jedispeedway.lte',	'Jedispeedway.lte',	'.',	60436,	'circuit',	'l',	'2005-05-01',	10,	674),
('http://tonkas.hopto.org/EVO1/Jedispeedway1.lte',	'Jedispeedway1.lte',	'Jedispeedway1.lte',	'.',	60435,	'circuit',	'l',	'2003-01-29',	10,	675),
('http://tonkas.hopto.org/EVO1/JediStealth.lte',	'JediStealth.lte',	'JediStealth.lte',	'.',	54146,	'circuit',	'l',	'2005-04-30',	10,	676),
('http://tonkas.hopto.org/EVO1/JediStealth1.lte',	'JediStealth1.lte',	'JediStealth1.lte',	'.',	40310,	'circuit',	'l',	'2001-04-02',	10,	677),
('http://tonkas.hopto.org/EVO1/jedistealtht.lte',	'jedistealtht.lte',	'jedistealtht.lte',	'.',	52986,	'circuit',	'l',	'2006-07-27',	10,	678),
('http://tonkas.hopto.org/EVO1/jedistealthystyle.lte',	'jedistealthystyle.lte',	'jedistealthystyle.lte',	'.',	54146,	'circuit',	'l',	'2004-05-14',	10,	679),
('http://tonkas.hopto.org/EVO1/jedistealtystyle.lte',	'jedistealtystyle.lte',	'jedistealtystyle.lte',	'.',	6207,	'circuit',	'l',	'2004-05-14',	10,	680),
('http://tonkas.hopto.org/EVO1/Jedisub.lte',	'Jedisub.lte',	'Jedisub.lte',	'.',	51192,	'circuit',	'l',	'2001-08-22',	10,	681),
('http://tonkas.hopto.org/EVO1/jedisubzero.lte',	'jedisubzero.lte',	'jedisubzero.lte',	'.',	29257,	'circuit',	'l',	'2004-10-24',	10,	682),
('http://tonkas.hopto.org/EVO1/JediTerror.lte',	'JediTerror.lte',	'JediTerror.lte',	'.',	16332,	'circuit',	'l',	'2002-07-13',	10,	683),
('http://tonkas.hopto.org/EVO1/JediTherapy.lte',	'JediTherapy.lte',	'JediTherapy.lte',	'.',	71005,	'circuit',	'l',	'2004-04-09',	10,	684),
('http://tonkas.hopto.org/EVO1/jeditherapy2.lte',	'jeditherapy2.lte',	'jeditherapy2.lte',	'.',	70747,	'circuit',	'l',	'2003-12-13',	10,	685),
('http://tonkas.hopto.org/EVO1/Jedithunderzone.lte',	'Jedithunderzone.lte',	'Jedithunderzone.lte',	'.',	78573,	'circuit',	'l',	'2004-04-12',	10,	686),
('http://tonkas.hopto.org/EVO1/Jedithunderzone2.lte',	'Jedithunderzone2.lte',	'Jedithunderzone2.lte',	'.',	77106,	'circuit',	'l',	'2002-05-23',	10,	687),
('http://tonkas.hopto.org/EVO1/jeditry.pod',	'jeditry.pod',	'jeditry.pod',	'.',	18407546,	'circuit',	'p',	'2021-01-25',	10,	688),
('http://tonkas.hopto.org/EVO1/Jediunderground.lte',	'Jediunderground.lte',	'Jediunderground.lte',	'.',	23779,	'circuit',	'l',	'2004-04-29',	10,	689),
('http://tonkas.hopto.org/EVO1/JediVacation.lte',	'JediVacation.lte',	'JediVacation.lte',	'.',	27476,	'circuit',	'l',	'2002-07-25',	10,	690),
('http://tonkas.hopto.org/EVO1/jedivet.lte',	'jedivet.lte',	'jedivet.lte',	'.',	83942,	'circuit',	'l',	'2005-07-17',	10,	691),
('http://tonkas.hopto.org/EVO1/Jediwater.lte',	'Jediwater.lte',	'Jediwater.lte',	'.',	65894,	'circuit',	'l',	'2001-10-24',	10,	692),
('http://tonkas.hopto.org/EVO1/jedizodiac.lte',	'jedizodiac.lte',	'jedizodiac.lte',	'.',	51104,	'circuit',	'l',	'2007-02-24',	10,	693),
('http://tonkas.hopto.org/EVO1/Jedizone.lte',	'Jedizone.lte',	'Jedizone.lte',	'.',	53297,	'circuit',	'l',	'2004-04-29',	10,	694),
('http://tonkas.hopto.org/EVO1/JEEPJAMBORIEUSA.LTE',	'JEEPJAMBORIEUSA.LTE',	'JEEPJAMBORIEUSA.LTE',	'.',	39548,	'circuit',	'l',	'2003-02-17',	10,	695),
('http://tonkas.hopto.org/EVO1/JEEPJAMBORIEUSA2.LTE',	'JEEPJAMBORIEUSA2.LTE',	'JEEPJAMBORIEUSA2.LTE',	'.',	42130,	'circuit',	'l',	'2021-01-26',	10,	696),
('http://tonkas.hopto.org/EVO1/JetMoto.lte',	'JetMoto.lte',	'JetMoto.lte',	'.',	17949,	'circuit',	'l',	'2021-01-26',	10,	697),
('http://tonkas.hopto.org/EVO1/jetssavage.lte',	'jetssavage.lte',	'jetssavage.lte',	'.',	38125,	'circuit',	'l',	'2000-12-30',	10,	698),
('http://tonkas.hopto.org/EVO1/Jfan.lte',	'Jfan.lte',	'Jfan.lte',	'.',	11156,	'circuit',	'l',	'2021-01-26',	10,	699),
('http://tonkas.hopto.org/EVO1/Jff.lte',	'Jff.lte',	'Jff.lte',	'.',	20995,	'circuit',	'l',	'2002-07-09',	10,	700),
('http://tonkas.hopto.org/EVO1/Jig.lte',	'Jig.lte',	'Jig.lte',	'.',	21135,	'circuit',	'l',	'2021-01-26',	10,	701),
('http://tonkas.hopto.org/EVO1/JOUST.LTE',	'JOUST.LTE',	'JOUST.LTE',	'.',	58888,	'circuit',	'l',	'2001-08-15',	10,	702),
('http://tonkas.hopto.org/EVO1/Jsalvage.lte',	'Jsalvage.lte',	'Jsalvage.lte',	'.',	8790,	'circuit',	'l',	'2021-01-26',	10,	703),
('http://tonkas.hopto.org/EVO1/jsor-tryouts.lte',	'jsor-tryouts.lte',	'jsor-tryouts.lte',	'.',	75252,	'circuit',	'l',	'2002-03-17',	10,	704),
('http://tonkas.hopto.org/EVO1/jsortrailin.lte',	'jsortrailin.lte',	'jsortrailin.lte',	'.',	9838,	'circuit',	'l',	'2002-12-27',	10,	705),
('http://tonkas.hopto.org/EVO1/jsortrailin1.lte',	'jsortrailin1.lte',	'jsortrailin1.lte',	'.',	9777,	'circuit',	'l',	'2003-01-01',	10,	706),
('http://tonkas.hopto.org/EVO1/JTR.LTE',	'JTR.LTE',	'JTR.LTE',	'.',	13566,	'circuit',	'l',	'2001-08-25',	10,	707),
('http://tonkas.hopto.org/EVO1/JUMP.LTE',	'JUMP.LTE',	'JUMP.LTE',	'.',	7567,	'circuit',	'l',	'2001-07-30',	10,	708),
('http://tonkas.hopto.org/EVO1/JUMP2.LTE',	'JUMP2.LTE',	'JUMP2.LTE',	'.',	10960,	'circuit',	'l',	'2021-01-26',	10,	709),
('http://tonkas.hopto.org/EVO1/jumpnjive.lte',	'jumpnjive.lte',	'jumpnjive.lte',	'.',	74464,	'circuit',	'l',	'2021-01-26',	10,	710),
('http://tonkas.hopto.org/EVO1/JUMPRALLEY.LTE',	'JUMPRALLEY.LTE',	'JUMPRALLEY.LTE',	'.',	10226,	'circuit',	'l',	'2021-01-26',	10,	711),
('http://tonkas.hopto.org/EVO1/junglefever.lte',	'junglefever.lte',	'junglefever.lte',	'.',	90040,	'circuit',	'l',	'2002-11-28',	10,	712),
('http://tonkas.hopto.org/EVO1/junglehill.lte',	'junglehill.lte',	'junglehill.lte',	'.',	13583,	'circuit',	'l',	'2002-07-13',	10,	713),
('http://tonkas.hopto.org/EVO1/Junk.lte',	'Junk.lte',	'Junk.lte',	'.',	35663,	'circuit',	'l',	'2001-06-07',	10,	714),
('http://tonkas.hopto.org/EVO1/JUNKYARD.LTE',	'JUNKYARD.LTE',	'JUNKYARD.LTE',	'.',	63090,	'circuit',	'l',	'2021-01-26',	10,	715),
('http://tonkas.hopto.org/EVO1/JUNKYARDWARS.LTE',	'JUNKYARDWARS.LTE',	'JUNKYARDWARS.LTE',	'.',	9407,	'circuit',	'l',	'2001-04-03',	10,	716),
('http://tonkas.hopto.org/EVO1/khillfun11.lte',	'khillfun11.lte',	'khillfun11.lte',	'.',	5388,	'circuit',	'l',	'2003-06-06',	10,	717),
('http://tonkas.hopto.org/EVO1/kickstart.zip',	'kickstart.zip',	'kickstart.zip',	'.',	1316085,	'circuit',	'z',	'2001-01-09',	10,	718),
('http://tonkas.hopto.org/EVO1/KILLER.LTE',	'KILLER.LTE',	'KILLER.LTE',	'.',	8818,	'circuit',	'l',	'2021-01-26',	10,	719),
('http://tonkas.hopto.org/EVO1/King.lte',	'King.lte',	'King.lte',	'.',	3591,	'circuit',	'l',	'2021-01-26',	10,	720),
('http://tonkas.hopto.org/EVO1/KING.ZIP',	'KING.ZIP',	'KING.ZIP',	'.',	37601,	'circuit',	'z',	'2001-01-09',	10,	721),
('http://tonkas.hopto.org/EVO1/KINGOF.LTE',	'KINGOF.LTE',	'KINGOF.LTE',	'.',	52223,	'circuit',	'l',	'2001-05-30',	10,	722),
('http://tonkas.hopto.org/EVO1/KINGOFTHEFARM.LTE',	'KINGOFTHEFARM.LTE',	'KINGOFTHEFARM.LTE',	'.',	58087,	'circuit',	'l',	'2021-01-26',	10,	723),
('http://tonkas.hopto.org/EVO1/Kingturd.lte',	'Kingturd.lte',	'Kingturd.lte',	'.',	5248,	'circuit',	'l',	'2001-04-23',	10,	724),
('http://tonkas.hopto.org/EVO1/KKR.LTE',	'KKR.LTE',	'KKR.LTE',	'.',	9577,	'circuit',	'l',	'2001-09-07',	10,	725),
('http://tonkas.hopto.org/EVO1/KKRTOOL.LTE',	'KKRTOOL.LTE',	'KKRTOOL.LTE',	'.',	38692,	'circuit',	'l',	'2021-01-26',	10,	726),
('http://tonkas.hopto.org/EVO1/Klown1.lte',	'Klown1.lte',	'Klown1.lte',	'.',	32424,	'circuit',	'l',	'2003-03-01',	10,	727),
('http://tonkas.hopto.org/EVO1/klown2.lte',	'klown2.lte',	'klown2.lte',	'.',	47429,	'circuit',	'l',	'2005-04-29',	10,	728),
('http://tonkas.hopto.org/EVO1/klown3.lte',	'klown3.lte',	'klown3.lte',	'.',	52878,	'circuit',	'l',	'2004-05-01',	10,	729),
('http://tonkas.hopto.org/EVO1/korkoth.lte',	'korkoth.lte',	'korkoth.lte',	'.',	20459,	'circuit',	'l',	'2021-01-26',	10,	730),
('http://tonkas.hopto.org/EVO1/kors.lte',	'kors.lte',	'kors.lte',	'.',	46993,	'circuit',	'l',	'2021-01-26',	10,	731),
('http://tonkas.hopto.org/EVO1/kortryouts.lte',	'kortryouts.lte',	'kortryouts.lte',	'.',	36878,	'circuit',	'l',	'2002-01-30',	10,	732),
('http://tonkas.hopto.org/EVO1/kothamtkt.lte',	'kothamtkt.lte',	'kothamtkt.lte',	'.',	74425,	'circuit',	'l',	'2021-01-26',	10,	733),
('http://tonkas.hopto.org/EVO1/kothcrash1.lte',	'kothcrash1.lte',	'kothcrash1.lte',	'.',	78482,	'circuit',	'l',	'2021-01-26',	10,	734),
('http://tonkas.hopto.org/EVO1/kothcrash10.lte',	'kothcrash10.lte',	'kothcrash10.lte',	'.',	62265,	'circuit',	'l',	'2021-01-26',	10,	735),
('http://tonkas.hopto.org/EVO1/kothcrash2.lte',	'kothcrash2.lte',	'kothcrash2.lte',	'.',	53558,	'circuit',	'l',	'2021-01-26',	10,	736),
('http://tonkas.hopto.org/EVO1/kothcrash3.lte',	'kothcrash3.lte',	'kothcrash3.lte',	'.',	64581,	'circuit',	'l',	'2021-01-26',	10,	737),
('http://tonkas.hopto.org/EVO1/kothcrash4.lte',	'kothcrash4.lte',	'kothcrash4.lte',	'.',	45447,	'circuit',	'l',	'2021-01-26',	10,	738),
('http://tonkas.hopto.org/EVO1/kothcrash5.lte',	'kothcrash5.lte',	'kothcrash5.lte',	'.',	67114,	'circuit',	'l',	'2021-01-26',	10,	739),
('http://tonkas.hopto.org/EVO1/kothcrash6.lte',	'kothcrash6.lte',	'kothcrash6.lte',	'.',	19661,	'circuit',	'l',	'2021-01-26',	10,	740),
('http://tonkas.hopto.org/EVO1/kothcrash7.lte',	'kothcrash7.lte',	'kothcrash7.lte',	'.',	20169,	'circuit',	'l',	'2021-01-26',	10,	741),
('http://tonkas.hopto.org/EVO1/kothcrash8.lte',	'kothcrash8.lte',	'kothcrash8.lte',	'.',	21361,	'circuit',	'l',	'2021-01-26',	10,	742),
('http://tonkas.hopto.org/EVO1/kothcrash9.lte',	'kothcrash9.lte',	'kothcrash9.lte',	'.',	76364,	'circuit',	'l',	'2021-01-26',	10,	743),
('http://tonkas.hopto.org/EVO1/krallylite.lte',	'krallylite.lte',	'krallylite.lte',	'.',	59404,	'circuit',	'l',	'2021-01-26',	10,	744),
('http://tonkas.hopto.org/EVO1/Krawlin.lte',	'Krawlin.lte',	'Krawlin.lte',	'.',	49842,	'circuit',	'l',	'2002-11-01',	10,	745),
('http://tonkas.hopto.org/EVO1/krawlin2.lte',	'krawlin2.lte',	'krawlin2.lte',	'.',	52523,	'circuit',	'l',	'2005-04-24',	10,	746),
('http://tonkas.hopto.org/EVO1/kujostrail.lte',	'kujostrail.lte',	'kujostrail.lte',	'.',	30794,	'circuit',	'l',	'2021-01-26',	10,	747),
('http://tonkas.hopto.org/EVO1/KYA1.LTE',	'KYA1.LTE',	'KYA1.LTE',	'.',	59915,	'circuit',	'l',	'2002-04-26',	10,	748),
('http://tonkas.hopto.org/EVO1/Laguna.lte',	'Laguna.lte',	'Laguna.lte',	'.',	10218,	'circuit',	'l',	'2021-01-26',	10,	749),
('http://tonkas.hopto.org/EVO1/Lagunamx.lte',	'Lagunamx.lte',	'Lagunamx.lte',	'.',	53988,	'circuit',	'l',	'2001-01-09',	10,	750),
('http://tonkas.hopto.org/EVO1/LAGUNAX.ZIP',	'LAGUNAX.ZIP',	'LAGUNAX.ZIP',	'.',	53324,	'circuit',	'z',	'2001-01-09',	10,	751),
('http://tonkas.hopto.org/EVO1/LAKEWOOD.lte',	'LAKEWOOD.lte',	'LAKEWOOD.lte',	'.',	17486,	'circuit',	'l',	'2021-01-26',	10,	752),
('http://tonkas.hopto.org/EVO1/LANDOFTHEHAND.LTE',	'LANDOFTHEHAND.LTE',	'LANDOFTHEHAND.LTE',	'.',	35909,	'circuit',	'l',	'2021-01-26',	10,	753),
('http://tonkas.hopto.org/EVO1/latinrally1.lte',	'latinrally1.lte',	'latinrally1.lte',	'.',	49721,	'circuit',	'l',	'2021-01-26',	10,	754),
('http://tonkas.hopto.org/EVO1/lazy.lte',	'lazy.lte',	'lazy.lte',	'.',	17379,	'circuit',	'l',	'2021-01-26',	10,	755),
('http://tonkas.hopto.org/EVO1/LBC.LTE',	'LBC.LTE',	'LBC.LTE',	'.',	22415,	'circuit',	'l',	'2003-05-23',	10,	756),
('http://tonkas.hopto.org/EVO1/LetItSnow.pod',	'LetItSnow.pod',	'LetItSnow.pod',	'.',	2953910,	'circuit',	'p',	'2001-04-24',	10,	757),
('http://tonkas.hopto.org/EVO1/LetItSnow.zip',	'LetItSnow.zip',	'LetItSnow.zip',	'.',	18145,	'circuit',	'z',	'2001-04-24',	10,	758),
('http://tonkas.hopto.org/EVO1/LIFEBEACH.zip',	'LIFEBEACH.zip',	'LIFEBEACH.zip',	'.',	2810616,	'circuit',	'z',	'2001-01-15',	10,	759),
('http://tonkas.hopto.org/EVO1/locknchase.lte',	'locknchase.lte',	'locknchase.lte',	'.',	53340,	'circuit',	'l',	'2021-01-26',	10,	760),
('http://tonkas.hopto.org/EVO1/LONESOMEPINE.LTE',	'LONESOMEPINE.LTE',	'LONESOMEPINE.LTE',	'.',	31438,	'circuit',	'l',	'2021-01-26',	10,	761),
('http://tonkas.hopto.org/EVO1/longestraceever.lte',	'longestraceever.lte',	'longestraceever.lte',	'.',	49663,	'circuit',	'l',	'2002-12-03',	10,	762),
('http://tonkas.hopto.org/EVO1/Longhill.lte',	'Longhill.lte',	'Longhill.lte',	'.',	43710,	'circuit',	'l',	'2021-01-26',	10,	763),
('http://tonkas.hopto.org/EVO1/lookoutpoint.lte',	'lookoutpoint.lte',	'lookoutpoint.lte',	'.',	31120,	'circuit',	'l',	'2021-01-26',	10,	764),
('http://tonkas.hopto.org/EVO1/Look_Out_Point.lte',	'Look_Out_Point.lte',	'Look_Out_Point.lte',	'.',	31120,	'circuit',	'l',	'2001-04-18',	10,	765),
('http://tonkas.hopto.org/EVO1/LordCaps4x4Pack.zip',	'LordCaps4x4Pack.zip',	'LordCaps4x4Pack.zip',	'.',	3401950,	'circuit',	'z',	'2000-12-02',	10,	766),
('http://tonkas.hopto.org/EVO1/LordsMaze02.lte',	'LordsMaze02.lte',	'LordsMaze02.lte',	'.',	64150,	'circuit',	'l',	'2004-04-19',	10,	767),
('http://tonkas.hopto.org/EVO1/lordsoffroad1.lte',	'lordsoffroad1.lte',	'lordsoffroad1.lte',	'.',	63751,	'circuit',	'l',	'2004-08-20',	10,	768),
('http://tonkas.hopto.org/EVO1/lordsoffroad2.lte',	'lordsoffroad2.lte',	'lordsoffroad2.lte',	'.',	80335,	'circuit',	'l',	'2003-05-31',	10,	769),
('http://tonkas.hopto.org/EVO1/LordsOffroad3.lte',	'LordsOffroad3.lte',	'LordsOffroad3.lte',	'.',	80980,	'circuit',	'l',	'2003-04-30',	10,	770),
('http://tonkas.hopto.org/EVO1/losthighway.lte',	'losthighway.lte',	'losthighway.lte',	'.',	30162,	'circuit',	'l',	'2004-04-18',	10,	771),
('http://tonkas.hopto.org/EVO1/lostisland.lte',	'lostisland.lte',	'lostisland.lte',	'.',	57637,	'circuit',	'l',	'2006-09-13',	10,	772),
('http://tonkas.hopto.org/EVO1/lostislandx.pod',	'lostislandx.pod',	'lostislandx.pod',	'.',	1317958,	'circuit',	'p',	'2021-01-25',	10,	773),
('http://tonkas.hopto.org/EVO1/Lowridercentral.pod',	'Lowridercentral.pod',	'Lowridercentral.pod',	'.',	6990836,	'circuit',	'p',	'2006-07-23',	10,	774),
('http://tonkas.hopto.org/EVO1/LowriderCentral.zip',	'LowriderCentral.zip',	'LowriderCentral.zip',	'.',	1356321,	'circuit',	'z',	'2001-01-09',	10,	775),
('http://tonkas.hopto.org/EVO1/LTD.LTE',	'LTD.LTE',	'LTD.LTE',	'.',	64267,	'circuit',	'l',	'2021-01-26',	10,	776),
('http://tonkas.hopto.org/EVO1/LTDDRAG.LTE',	'LTDDRAG.LTE',	'LTDDRAG.LTE',	'.',	83739,	'circuit',	'l',	'2021-01-26',	10,	777),
('http://tonkas.hopto.org/EVO1/lugethots.zip',	'lugethots.zip',	'lugethots.zip',	'.',	1503816,	'circuit',	'z',	'2001-04-05',	10,	778),
('http://tonkas.hopto.org/EVO1/lunar4x4.pod',	'lunar4x4.pod',	'lunar4x4.pod',	'.',	3644204,	'circuit',	'p',	'2005-05-05',	10,	779),
('http://tonkas.hopto.org/EVO1/mad.lte',	'mad.lte',	'mad.lte',	'.',	100301,	'circuit',	'l',	'2004-04-21',	10,	780),
('http://tonkas.hopto.org/EVO1/Magoo1.LTE',	'Magoo1.LTE',	'Magoo1.LTE',	'.',	13472,	'circuit',	'l',	'2021-01-26',	10,	781),
('http://tonkas.hopto.org/EVO1/Martin_Lake.LTE',	'Martin_Lake.LTE',	'Martin_Lake.LTE',	'.',	20893,	'circuit',	'l',	'2021-01-26',	10,	782),
('http://tonkas.hopto.org/EVO1/MASTEROFFROADER.LTE',	'MASTEROFFROADER.LTE',	'MASTEROFFROADER.LTE',	'.',	4410,	'circuit',	'l',	'2021-01-26',	10,	783),
('http://tonkas.hopto.org/EVO1/MAXPACK2.ZIP',	'MAXPACK2.ZIP',	'MAXPACK2.ZIP',	'.',	563361,	'circuit',	'z',	'2002-10-09',	10,	784),
('http://tonkas.hopto.org/EVO1/MAXPACK3.ZIP',	'MAXPACK3.ZIP',	'MAXPACK3.ZIP',	'.',	929976,	'circuit',	'z',	'2002-10-09',	10,	785),
('http://tonkas.hopto.org/EVO1/maxxedout.zip',	'maxxedout.zip',	'maxxedout.zip',	'.',	759930,	'circuit',	'z',	'2000-12-23',	10,	786),
('http://tonkas.hopto.org/EVO1/MAZE.LTE',	'MAZE.LTE',	'MAZE.LTE',	'.',	5935,	'circuit',	'l',	'2021-01-26',	10,	787),
('http://tonkas.hopto.org/EVO1/Mcdog.lte',	'Mcdog.lte',	'Mcdog.lte',	'.',	53852,	'circuit',	'l',	'2021-01-26',	10,	788),
('http://tonkas.hopto.org/EVO1/medonhonoarizona.lte',	'medonhonoarizona.lte',	'medonhonoarizona.lte',	'.',	75812,	'circuit',	'l',	'2007-11-03',	10,	789),
('http://tonkas.hopto.org/EVO1/megarally2004.lte',	'megarally2004.lte',	'megarally2004.lte',	'.',	76015,	'circuit',	'l',	'2004-08-05',	10,	790),
('http://tonkas.hopto.org/EVO1/mexico57.lte',	'mexico57.lte',	'mexico57.lte',	'.',	59061,	'circuit',	'l',	'2021-01-26',	10,	791),
('http://tonkas.hopto.org/EVO1/Mexicoff.lte',	'Mexicoff.lte',	'Mexicoff.lte',	'.',	67005,	'circuit',	'l',	'2021-01-26',	10,	792),
('http://tonkas.hopto.org/EVO1/MikeDragStrip2.zip',	'MikeDragStrip2.zip',	'MikeDragStrip2.zip',	'.',	31787,	'circuit',	'z',	'2001-01-20',	10,	793),
('http://tonkas.hopto.org/EVO1/Mikescity.zip',	'Mikescity.zip',	'Mikescity.zip',	'.',	2658907,	'circuit',	'z',	'2001-02-11',	10,	794),
('http://tonkas.hopto.org/EVO1/MIKESCITY2.pod',	'MIKESCITY2.pod',	'MIKESCITY2.pod',	'.',	17668663,	'circuit',	'p',	'2021-01-25',	10,	795),
('http://tonkas.hopto.org/EVO1/MIKESDRAGSTRIP.LTE',	'MIKESDRAGSTRIP.LTE',	'MIKESDRAGSTRIP.LTE',	'.',	59632,	'circuit',	'l',	'2001-01-02',	10,	796),
('http://tonkas.hopto.org/EVO1/MIKESDRAGSTRIP2.LTE',	'MIKESDRAGSTRIP2.LTE',	'MIKESDRAGSTRIP2.LTE',	'.',	32276,	'circuit',	'l',	'2001-01-19',	10,	797),
('http://tonkas.hopto.org/EVO1/MIKESFORMULA1.LTE',	'MIKESFORMULA1.LTE',	'MIKESFORMULA1.LTE',	'.',	22666,	'circuit',	'l',	'2001-01-21',	10,	798),
('http://tonkas.hopto.org/EVO1/MikesFormula1.zip',	'MikesFormula1.zip',	'MikesFormula1.zip',	'.',	22326,	'circuit',	'z',	'2001-01-22',	10,	799),
('http://tonkas.hopto.org/EVO1/Mikeshill.zip',	'Mikeshill.zip',	'Mikeshill.zip',	'.',	5306,	'circuit',	'z',	'2001-02-24',	10,	800),
('http://tonkas.hopto.org/EVO1/mikestruck.lte',	'mikestruck.lte',	'mikestruck.lte',	'.',	5834,	'circuit',	'l',	'2005-08-29',	10,	801),
('http://tonkas.hopto.org/EVO1/mikestruckstop.lte',	'mikestruckstop.lte',	'mikestruckstop.lte',	'.',	63267,	'circuit',	'l',	'2005-08-29',	10,	802),
('http://tonkas.hopto.org/EVO1/mikestruclstop.lte',	'mikestruclstop.lte',	'mikestruclstop.lte',	'.',	5933,	'circuit',	'l',	'2005-08-29',	10,	803),
('http://tonkas.hopto.org/EVO1/miles.lte',	'miles.lte',	'miles.lte',	'.',	6364,	'circuit',	'l',	'2021-01-26',	10,	804),
('http://tonkas.hopto.org/EVO1/MINIGOLF.LTE',	'MINIGOLF.LTE',	'MINIGOLF.LTE',	'.',	9530,	'circuit',	'l',	'2003-04-03',	10,	805),
('http://tonkas.hopto.org/EVO1/MISSISSIPPI.LTE',	'MISSISSIPPI.LTE',	'MISSISSIPPI.LTE',	'.',	49522,	'circuit',	'l',	'2001-05-29',	10,	806),
('http://tonkas.hopto.org/EVO1/MIXBYGOTEN.pod',	'MIXBYGOTEN.pod',	'MIXBYGOTEN.pod',	'.',	8477725,	'circuit',	'p',	'2021-01-25',	10,	807),
('http://tonkas.hopto.org/EVO1/MJC.ZIP',	'MJC.ZIP',	'MJC.ZIP',	'.',	759007,	'circuit',	'z',	'2001-01-07',	10,	808),
('http://tonkas.hopto.org/EVO1/MKRS.pod',	'MKRS.pod',	'MKRS.pod',	'.',	9551744,	'circuit',	'p',	'2021-01-25',	10,	809),
('http://tonkas.hopto.org/EVO1/MMMsBeta.lte',	'MMMsBeta.lte',	'MMMsBeta.lte',	'.',	29750,	'circuit',	'l',	'2021-01-26',	10,	810),
('http://tonkas.hopto.org/EVO1/mmt1a.lte',	'mmt1a.lte',	'mmt1a.lte',	'.',	20941,	'circuit',	'l',	'2021-01-26',	10,	811),
('http://tonkas.hopto.org/EVO1/MMTV2.LTE',	'MMTV2.LTE',	'MMTV2.LTE',	'.',	22950,	'circuit',	'l',	'2003-06-19',	10,	812),
('http://tonkas.hopto.org/EVO1/MOBTRACK.LTE',	'MOBTRACK.LTE',	'MOBTRACK.LTE',	'.',	15179,	'circuit',	'l',	'2001-08-20',	10,	813),
('http://tonkas.hopto.org/EVO1/mobtruckstop.lte',	'mobtruckstop.lte',	'mobtruckstop.lte',	'.',	70946,	'circuit',	'l',	'2001-07-01',	10,	814),
('http://tonkas.hopto.org/EVO1/MOBTRUKIN.LTE',	'MOBTRUKIN.LTE',	'MOBTRUKIN.LTE',	'.',	81338,	'circuit',	'l',	'2021-01-26',	10,	815),
('http://tonkas.hopto.org/EVO1/MODArena1.LTE',	'MODArena1.LTE',	'MODArena1.LTE',	'.',	6031,	'circuit',	'l',	'2008-05-15',	10,	816),
('http://tonkas.hopto.org/EVO1/MODArena2.LTE',	'MODArena2.LTE',	'MODArena2.LTE',	'.',	6362,	'circuit',	'l',	'2008-06-29',	10,	817),
('http://tonkas.hopto.org/EVO1/MODRUMBLE1.LTE',	'MODRUMBLE1.LTE',	'MODRUMBLE1.LTE',	'.',	5380,	'circuit',	'l',	'2008-04-17',	10,	818),
('http://tonkas.hopto.org/EVO1/MOJAVE.LTE',	'MOJAVE.LTE',	'MOJAVE.LTE',	'.',	73829,	'circuit',	'l',	'2021-01-26',	10,	819),
('http://tonkas.hopto.org/EVO1/mokycb10.lte',	'mokycb10.lte',	'mokycb10.lte',	'.',	10562,	'circuit',	'l',	'2021-01-26',	10,	820),
('http://tonkas.hopto.org/EVO1/momentum.lte',	'momentum.lte',	'momentum.lte',	'.',	56858,	'circuit',	'l',	'2005-12-27',	10,	821),
('http://tonkas.hopto.org/EVO1/momo.lte',	'momo.lte',	'momo.lte',	'.',	23821,	'circuit',	'l',	'2004-04-27',	10,	822),
('http://tonkas.hopto.org/EVO1/Money.lte',	'Money.lte',	'Money.lte',	'.',	5566,	'circuit',	'l',	'2021-01-26',	10,	823),
('http://tonkas.hopto.org/EVO1/MONSTERJAM.POD',	'MONSTERJAM.POD',	'MONSTERJAM.POD',	'.',	4759218,	'circuit',	'p',	'2021-01-25',	10,	824),
('http://tonkas.hopto.org/EVO1/MONUMENTAL.LTE',	'MONUMENTAL.LTE',	'MONUMENTAL.LTE',	'.',	68093,	'circuit',	'l',	'2021-01-26',	10,	825),
('http://tonkas.hopto.org/EVO1/MOSSY.ZIP',	'MOSSY.ZIP',	'MOSSY.ZIP',	'.',	3518401,	'circuit',	'z',	'2001-02-13',	10,	826),
('http://tonkas.hopto.org/EVO1/MOTERCROSS.LTE',	'MOTERCROSS.LTE',	'MOTERCROSS.LTE',	'.',	38362,	'circuit',	'l',	'2001-01-09',	10,	827),
('http://tonkas.hopto.org/EVO1/MoterCrossMad.LTE',	'MoterCrossMad.LTE',	'MoterCrossMad.LTE',	'.',	38362,	'circuit',	'l',	'2001-01-11',	10,	828),
('http://tonkas.hopto.org/EVO1/MOTOCLIMBS.LTE',	'MOTOCLIMBS.LTE',	'MOTOCLIMBS.LTE',	'.',	60024,	'circuit',	'l',	'2021-01-26',	10,	829),
('http://tonkas.hopto.org/EVO1/motocross2.lte',	'motocross2.lte',	'motocross2.lte',	'.',	42397,	'circuit',	'l',	'2002-05-01',	10,	830),
('http://tonkas.hopto.org/EVO1/MOTOJOJO.pod',	'MOTOJOJO.pod',	'MOTOJOJO.pod',	'.',	8244525,	'circuit',	'p',	'2021-01-25',	10,	831),
('http://tonkas.hopto.org/EVO1/motomania1.lte',	'motomania1.lte',	'motomania1.lte',	'.',	68993,	'circuit',	'l',	'2021-01-26',	10,	832),
('http://tonkas.hopto.org/EVO1/motoperro.lte',	'motoperro.lte',	'motoperro.lte',	'.',	52634,	'circuit',	'l',	'2001-12-05',	10,	833),
('http://tonkas.hopto.org/EVO1/motorhead.lte',	'motorhead.lte',	'motorhead.lte',	'.',	52986,	'circuit',	'l',	'2021-01-26',	10,	834),
('http://tonkas.hopto.org/EVO1/Motoring.lte',	'Motoring.lte',	'Motoring.lte',	'.',	50935,	'circuit',	'l',	'2001-06-08',	10,	835),
('http://tonkas.hopto.org/EVO1/MOTORMADNESS2.LTE',	'MOTORMADNESS2.LTE',	'MOTORMADNESS2.LTE',	'.',	38957,	'circuit',	'l',	'2021-01-26',	10,	836),
('http://tonkas.hopto.org/EVO1/Motospy.lte',	'Motospy.lte',	'Motospy.lte',	'.',	9806,	'circuit',	'l',	'2001-04-24',	10,	837),
('http://tonkas.hopto.org/EVO1/Motov2.lte',	'Motov2.lte',	'Motov2.lte',	'.',	40961,	'circuit',	'l',	'2021-01-26',	10,	838),
('http://tonkas.hopto.org/EVO1/Motozog.lte',	'Motozog.lte',	'Motozog.lte',	'.',	43825,	'circuit',	'l',	'2021-01-26',	10,	839),
('http://tonkas.hopto.org/EVO1/MOTOZONA.LTE',	'MOTOZONA.LTE',	'MOTOZONA.LTE',	'.',	79443,	'circuit',	'l',	'2002-10-23',	10,	840),
('http://tonkas.hopto.org/EVO1/MOTOZONAUL2.LTE',	'MOTOZONAUL2.LTE',	'MOTOZONAUL2.LTE',	'.',	79443,	'circuit',	'l',	'2021-01-26',	10,	841),
('http://tonkas.hopto.org/EVO1/Mountain.lte',	'Mountain.lte',	'Mountain.lte',	'.',	34338,	'circuit',	'l',	'2001-05-31',	10,	842),
('http://tonkas.hopto.org/EVO1/MOUNTAINSHACK.LTE',	'MOUNTAINSHACK.LTE',	'MOUNTAINSHACK.LTE',	'.',	5526,	'circuit',	'l',	'2001-08-27',	10,	843),
('http://tonkas.hopto.org/EVO1/mountain_cross.lte',	'mountain_cross.lte',	'mountain_cross.lte',	'.',	79863,	'circuit',	'l',	'2007-04-01',	10,	844),
('http://tonkas.hopto.org/EVO1/MRevenge.lte',	'MRevenge.lte',	'MRevenge.lte',	'.',	42584,	'circuit',	'l',	'2004-05-07',	10,	845),
('http://tonkas.hopto.org/EVO1/MRO1.lte',	'MRO1.lte',	'MRO1.lte',	'.',	58389,	'circuit',	'l',	'2021-01-26',	10,	846),
('http://tonkas.hopto.org/EVO1/MRO2.LTE',	'MRO2.LTE',	'MRO2.LTE',	'.',	36437,	'circuit',	'l',	'2003-03-05',	10,	847),
('http://tonkas.hopto.org/EVO1/MRO3.LTE',	'MRO3.LTE',	'MRO3.LTE',	'.',	41256,	'circuit',	'l',	'2002-01-11',	10,	848),
('http://tonkas.hopto.org/EVO1/mro4.lte',	'mro4.lte',	'mro4.lte',	'.',	69759,	'circuit',	'l',	'2021-01-26',	10,	849),
('http://tonkas.hopto.org/EVO1/MRO5.LTE',	'MRO5.LTE',	'MRO5.LTE',	'.',	57748,	'circuit',	'l',	'2002-03-29',	10,	850),
('http://tonkas.hopto.org/EVO1/MROoffex.lte',	'MROoffex.lte',	'MROoffex.lte',	'.',	31478,	'circuit',	'l',	'2021-01-26',	10,	851),
('http://tonkas.hopto.org/EVO1/Mrotrail.lte',	'Mrotrail.lte',	'Mrotrail.lte',	'.',	33404,	'circuit',	'l',	'2021-01-26',	10,	852),
('http://tonkas.hopto.org/EVO1/Mtandy.lte',	'Mtandy.lte',	'Mtandy.lte',	'.',	25276,	'circuit',	'l',	'2021-01-26',	10,	853),
('http://tonkas.hopto.org/EVO1/mtm2days.lte',	'mtm2days.lte',	'mtm2days.lte',	'.',	74608,	'circuit',	'l',	'2004-05-18',	10,	854),
('http://tonkas.hopto.org/EVO1/MTTVR2.LTE',	'MTTVR2.LTE',	'MTTVR2.LTE',	'.',	24985,	'circuit',	'l',	'2006-10-30',	10,	855),
('http://tonkas.hopto.org/EVO1/MUD.LTE',	'MUD.LTE',	'MUD.LTE',	'.',	5886,	'circuit',	'l',	'2001-02-05',	10,	856),
('http://tonkas.hopto.org/EVO1/Mud2000.lte',	'Mud2000.lte',	'Mud2000.lte',	'.',	45571,	'circuit',	'l',	'2001-03-17',	10,	857),
('http://tonkas.hopto.org/EVO1/Mud2SandPit.lte',	'Mud2SandPit.lte',	'Mud2SandPit.lte',	'.',	43632,	'circuit',	'l',	'2021-01-26',	10,	858),
('http://tonkas.hopto.org/EVO1/MUDorig.LTE',	'MUDorig.LTE',	'MUDorig.LTE',	'.',	5886,	'circuit',	'l',	'2021-01-26',	10,	859),
('http://tonkas.hopto.org/EVO1/MUDPIE03.pod',	'MUDPIE03.pod',	'MUDPIE03.pod',	'.',	8975573,	'circuit',	'p',	'2021-01-25',	10,	860),
('http://tonkas.hopto.org/EVO1/MUDPIE03.ZIP',	'MUDPIE03.ZIP',	'MUDPIE03.ZIP',	'.',	3664000,	'circuit',	'z',	'2001-01-15',	10,	861),
('http://tonkas.hopto.org/EVO1/mudrace.pod',	'mudrace.pod',	'mudrace.pod',	'.',	2138286,	'circuit',	'p',	'2021-01-25',	10,	862),
('http://tonkas.hopto.org/EVO1/MVALLY.LTE',	'MVALLY.LTE',	'MVALLY.LTE',	'.',	31545,	'circuit',	'l',	'2002-06-27',	10,	863),
('http://tonkas.hopto.org/EVO1/mvrsalv.lte',	'mvrsalv.lte',	'mvrsalv.lte',	'.',	36518,	'circuit',	'l',	'2021-01-26',	10,	864),
('http://tonkas.hopto.org/EVO1/mybackyard.lte',	'mybackyard.lte',	'mybackyard.lte',	'.',	42134,	'circuit',	'l',	'2021-01-26',	10,	865),
('http://tonkas.hopto.org/EVO1/NASCAR.LTE',	'NASCAR.LTE',	'NASCAR.LTE',	'.',	35250,	'circuit',	'l',	'2001-08-27',	10,	866),
('http://tonkas.hopto.org/EVO1/natesheldole.lte',	'natesheldole.lte',	'natesheldole.lte',	'.',	29225,	'circuit',	'l',	'2001-09-14',	10,	867),
('http://tonkas.hopto.org/EVO1/natesheldole2.lte',	'natesheldole2.lte',	'natesheldole2.lte',	'.',	29402,	'circuit',	'l',	'2001-04-18',	10,	868),
('http://tonkas.hopto.org/EVO1/NATURE.LTE',	'NATURE.LTE',	'NATURE.LTE',	'.',	75664,	'circuit',	'l',	'2006-08-25',	10,	869),
('http://tonkas.hopto.org/EVO1/naturex.lte',	'naturex.lte',	'naturex.lte',	'.',	80298,	'circuit',	'l',	'2004-08-15',	10,	870),
('http://tonkas.hopto.org/EVO1/NAVYSEALBOMBTAG.LTE',	'NAVYSEALBOMBTAG.LTE',	'NAVYSEALBOMBTAG.LTE',	'.',	66907,	'circuit',	'l',	'2021-01-26',	10,	871),
('http://tonkas.hopto.org/EVO1/nd.lte',	'nd.lte',	'nd.lte',	'.',	71890,	'circuit',	'l',	'2021-01-26',	10,	872),
('http://tonkas.hopto.org/EVO1/NEW.LTE',	'NEW.LTE',	'NEW.LTE',	'.',	70743,	'circuit',	'l',	'2006-08-15',	10,	873),
('http://tonkas.hopto.org/EVO1/NEWSTUFF.LTE',	'NEWSTUFF.LTE',	'NEWSTUFF.LTE',	'.',	8364,	'circuit',	'l',	'2021-01-26',	10,	874),
('http://tonkas.hopto.org/EVO1/NGL.lte',	'NGL.lte',	'NGL.lte',	'.',	51718,	'circuit',	'l',	'2021-01-26',	10,	875),
('http://tonkas.hopto.org/EVO1/ngr.lte',	'ngr.lte',	'ngr.lte',	'.',	43147,	'circuit',	'l',	'2007-04-26',	10,	876),
('http://tonkas.hopto.org/EVO1/NGR2r.lte',	'NGR2r.lte',	'NGR2r.lte',	'.',	57187,	'circuit',	'l',	'2005-04-10',	10,	877),
('http://tonkas.hopto.org/EVO1/NGRR3.lte',	'NGRR3.lte',	'NGRR3.lte',	'.',	45104,	'circuit',	'l',	'2021-01-26',	10,	878),
('http://tonkas.hopto.org/EVO1/NGRR4.lte',	'NGRR4.lte',	'NGRR4.lte',	'.',	35808,	'circuit',	'l',	'2021-01-26',	10,	879),
('http://tonkas.hopto.org/EVO1/nidrspdwy.lte',	'nidrspdwy.lte',	'nidrspdwy.lte',	'.',	31936,	'circuit',	'l',	'2002-10-25',	10,	880),
('http://tonkas.hopto.org/EVO1/nirclimb.pod',	'nirclimb.pod',	'nirclimb.pod',	'.',	3269677,	'circuit',	'p',	'2005-12-31',	10,	881),
('http://tonkas.hopto.org/EVO1/nirdesertov1.lte',	'nirdesertov1.lte',	'nirdesertov1.lte',	'.',	66484,	'circuit',	'l',	'2006-08-02',	10,	882),
('http://tonkas.hopto.org/EVO1/NIREVO.LTE',	'NIREVO.LTE',	'NIREVO.LTE',	'.',	66626,	'circuit',	'l',	'2004-03-15',	10,	883),
('http://tonkas.hopto.org/EVO1/NIRIVESCHALLENGE.LTE',	'NIRIVESCHALLENGE.LTE',	'NIRIVESCHALLENGE.LTE',	'.',	42273,	'circuit',	'l',	'2004-06-03',	10,	884),
('http://tonkas.hopto.org/EVO1/NIRJEDIREVENGE.LTE',	'NIRJEDIREVENGE.LTE',	'NIRJEDIREVENGE.LTE',	'.',	67887,	'circuit',	'l',	'2002-10-23',	10,	885),
('http://tonkas.hopto.org/EVO1/NIRTOPSPEED.LTE',	'NIRTOPSPEED.LTE',	'NIRTOPSPEED.LTE',	'.',	25764,	'circuit',	'l',	'2004-11-26',	10,	886),
('http://tonkas.hopto.org/EVO1/Nirv1.lte',	'Nirv1.lte',	'Nirv1.lte',	'.',	12127,	'circuit',	'l',	'2021-01-26',	10,	887),
('http://tonkas.hopto.org/EVO1/NIRWAY1.2.LTE',	'NIRWAY1.2.LTE',	'NIRWAY1.2.LTE',	'.',	22910,	'circuit',	'l',	'2021-01-26',	10,	888),
('http://tonkas.hopto.org/EVO1/Nirway1a.lte',	'Nirway1a.lte',	'Nirway1a.lte',	'.',	45526,	'circuit',	'l',	'2003-09-17',	10,	889),
('http://tonkas.hopto.org/EVO1/Nirway2.lte',	'Nirway2.lte',	'Nirway2.lte',	'.',	18561,	'circuit',	'l',	'2003-06-04',	10,	890),
('http://tonkas.hopto.org/EVO1/Nirway3.lte',	'Nirway3.lte',	'Nirway3.lte',	'.',	41643,	'circuit',	'l',	'2021-01-26',	10,	891),
('http://tonkas.hopto.org/EVO1/Nirway3a.lte',	'Nirway3a.lte',	'Nirway3a.lte',	'.',	43779,	'circuit',	'l',	'2003-09-12',	10,	892),
('http://tonkas.hopto.org/EVO1/NIRWAY4.LTE',	'NIRWAY4.LTE',	'NIRWAY4.LTE',	'.',	23049,	'circuit',	'l',	'2003-06-09',	10,	893),
('http://tonkas.hopto.org/EVO1/NirWay5.lte',	'NirWay5.lte',	'NirWay5.lte',	'.',	61126,	'circuit',	'l',	'2021-01-26',	10,	894),
('http://tonkas.hopto.org/EVO1/NirWay6.lte',	'NirWay6.lte',	'NirWay6.lte',	'.',	55010,	'circuit',	'l',	'2021-01-26',	10,	895),
('http://tonkas.hopto.org/EVO1/NirWay7.lte',	'NirWay7.lte',	'NirWay7.lte',	'.',	7840,	'circuit',	'l',	'2021-01-26',	10,	896),
('http://tonkas.hopto.org/EVO1/NIR_Rally.lte',	'NIR_Rally.lte',	'NIR_Rally.lte',	'.',	40131,	'circuit',	'l',	'2006-02-26',	10,	897),
('http://tonkas.hopto.org/EVO1/NIR_Rally2.lte',	'NIR_Rally2.lte',	'NIR_Rally2.lte',	'.',	43616,	'circuit',	'l',	'2006-02-26',	10,	898),
('http://tonkas.hopto.org/EVO1/NITRORALLY.LTE',	'NITRORALLY.LTE',	'NITRORALLY.LTE',	'.',	36289,	'circuit',	'l',	'2001-10-03',	10,	899),
('http://tonkas.hopto.org/EVO1/NKAROADC.ZIP',	'NKAROADC.ZIP',	'NKAROADC.ZIP',	'.',	4184898,	'circuit',	'z',	'2001-03-14',	10,	900),
('http://tonkas.hopto.org/EVO1/nkatrop.lte',	'nkatrop.lte',	'nkatrop.lte',	'.',	21449,	'circuit',	'l',	'2007-09-20',	10,	901),
('http://tonkas.hopto.org/EVO1/nkatropical.lte',	'nkatropical.lte',	'nkatropical.lte',	'.',	21509,	'circuit',	'l',	'2021-01-26',	10,	902),
('http://tonkas.hopto.org/EVO1/nlm.lte',	'nlm.lte',	'nlm.lte',	'.',	15180,	'circuit',	'l',	'2021-01-26',	10,	903),
('http://tonkas.hopto.org/EVO1/nntbackyard.lte',	'nntbackyard.lte',	'nntbackyard.lte',	'.',	17561,	'circuit',	'l',	'2004-05-07',	10,	904),
('http://tonkas.hopto.org/EVO1/NORDS.ZIP',	'NORDS.ZIP',	'NORDS.ZIP',	'.',	359219,	'circuit',	'z',	'2001-04-26',	10,	905),
('http://tonkas.hopto.org/EVO1/NOTAGAIN.LTE',	'NOTAGAIN.LTE',	'NOTAGAIN.LTE',	'.',	21114,	'circuit',	'l',	'2003-04-10',	10,	906),
('http://tonkas.hopto.org/EVO1/NSRTEST1.LTE',	'NSRTEST1.LTE',	'NSRTEST1.LTE',	'.',	22997,	'circuit',	'l',	'2021-01-26',	10,	907),
('http://tonkas.hopto.org/EVO1/NTIEV.POD',	'NTIEV.POD',	'NTIEV.POD',	'.',	2372382,	'circuit',	'p',	'2001-02-11',	10,	908),
('http://tonkas.hopto.org/EVO1/NTIEV.ZIP',	'NTIEV.ZIP',	'NTIEV.ZIP',	'.',	1741850,	'circuit',	'z',	'2001-02-24',	10,	909),
('http://tonkas.hopto.org/EVO1/OBJECTCLIMB.LTE',	'OBJECTCLIMB.LTE',	'OBJECTCLIMB.LTE',	'.',	42730,	'circuit',	'l',	'2003-09-24',	10,	910),
('http://tonkas.hopto.org/EVO1/ocean8.lte',	'ocean8.lte',	'ocean8.lte',	'.',	58125,	'circuit',	'l',	'2021-01-26',	10,	911),
('http://tonkas.hopto.org/EVO1/ody.lte',	'ody.lte',	'ody.lte',	'.',	75327,	'circuit',	'l',	'2021-01-26',	10,	912),
('http://tonkas.hopto.org/EVO1/OFC2.LTE',	'OFC2.LTE',	'OFC2.LTE',	'.',	10247,	'circuit',	'l',	'2001-08-07',	10,	913),
('http://tonkas.hopto.org/EVO1/OFC3.LTE',	'OFC3.LTE',	'OFC3.LTE',	'.',	14077,	'circuit',	'l',	'2001-08-25',	10,	914),
('http://tonkas.hopto.org/EVO1/OFCALLEN.LTE',	'OFCALLEN.LTE',	'OFCALLEN.LTE',	'.',	7933,	'circuit',	'l',	'2021-01-26',	10,	915),
('http://tonkas.hopto.org/EVO1/OFCPLAYGROND.LTE',	'OFCPLAYGROND.LTE',	'OFCPLAYGROND.LTE',	'.',	11909,	'circuit',	'l',	'2021-01-26',	10,	916),
('http://tonkas.hopto.org/EVO1/Off-Road_Durango.zip',	'Off-Road_Durango.zip',	'Off-Road_Durango.zip',	'.',	415503,	'circuit',	'z',	'2001-04-24',	10,	917),
('http://tonkas.hopto.org/EVO1/OFFCRAZE.LTE',	'OFFCRAZE.LTE',	'OFFCRAZE.LTE',	'.',	6505,	'circuit',	'l',	'2003-03-01',	10,	918),
('http://tonkas.hopto.org/EVO1/offdamapclimb.lte',	'offdamapclimb.lte',	'offdamapclimb.lte',	'.',	13211,	'circuit',	'l',	'2003-04-27',	10,	919),
('http://tonkas.hopto.org/EVO1/OFFMOUNT.LTE',	'OFFMOUNT.LTE',	'OFFMOUNT.LTE',	'.',	81072,	'circuit',	'l',	'2002-04-02',	10,	920),
('http://tonkas.hopto.org/EVO1/Offrdmayhem.lte',	'Offrdmayhem.lte',	'Offrdmayhem.lte',	'.',	9500,	'circuit',	'l',	'2001-04-03',	10,	921),
('http://tonkas.hopto.org/EVO1/Offrdmhm.lte',	'Offrdmhm.lte',	'Offrdmhm.lte',	'.',	8586,	'circuit',	'l',	'2001-08-19',	10,	922),
('http://tonkas.hopto.org/EVO1/OFFROAD-2002.LTE',	'OFFROAD-2002.LTE',	'OFFROAD-2002.LTE',	'.',	59657,	'circuit',	'l',	'2021-01-26',	10,	923),
('http://tonkas.hopto.org/EVO1/OFFROAD.LTE',	'OFFROAD.LTE',	'OFFROAD.LTE',	'.',	11984,	'circuit',	'l',	'2002-02-20',	10,	924),
('http://tonkas.hopto.org/EVO1/offroad2004.lte',	'offroad2004.lte',	'offroad2004.lte',	'.',	76113,	'circuit',	'l',	'2021-01-26',	10,	925),
('http://tonkas.hopto.org/EVO1/offroadchallenge.lte',	'offroadchallenge.lte',	'offroadchallenge.lte',	'.',	78581,	'circuit',	'l',	'2004-04-19',	10,	926),
('http://tonkas.hopto.org/EVO1/OFFROADINGMASTER.LTE',	'OFFROADINGMASTER.LTE',	'OFFROADINGMASTER.LTE',	'.',	5399,	'circuit',	'l',	'2021-01-26',	10,	927),
('http://tonkas.hopto.org/EVO1/OFFROADTRAILS.LTE',	'OFFROADTRAILS.LTE',	'OFFROADTRAILS.LTE',	'.',	65451,	'circuit',	'l',	'2021-01-26',	10,	928),
('http://tonkas.hopto.org/EVO1/OFFROADXTREME.LTE',	'OFFROADXTREME.LTE',	'OFFROADXTREME.LTE',	'.',	61685,	'circuit',	'l',	'2001-12-25',	10,	929),
('http://tonkas.hopto.org/EVO1/offthebone.lte',	'offthebone.lte',	'offthebone.lte',	'.',	32252,	'circuit',	'l',	'2021-01-26',	10,	930),
('http://tonkas.hopto.org/EVO1/offthebone2.lte',	'offthebone2.lte',	'offthebone2.lte',	'.',	42994,	'circuit',	'l',	'2003-02-01',	10,	931),
('http://tonkas.hopto.org/EVO1/Ofrd4wd.lte',	'Ofrd4wd.lte',	'Ofrd4wd.lte',	'.',	93811,	'circuit',	'l',	'2004-04-17',	10,	932),
('http://tonkas.hopto.org/EVO1/og.lte',	'og.lte',	'og.lte',	'.',	73495,	'circuit',	'l',	'2021-01-26',	10,	933),
('http://tonkas.hopto.org/EVO1/oiler.lte',	'oiler.lte',	'oiler.lte',	'.',	33209,	'circuit',	'l',	'2005-04-04',	10,	934),
('http://tonkas.hopto.org/EVO1/Oilsland.lte',	'Oilsland.lte',	'Oilsland.lte',	'.',	50868,	'circuit',	'l',	'2021-01-26',	10,	935),
('http://tonkas.hopto.org/EVO1/OILSWELL.LTE',	'OILSWELL.LTE',	'OILSWELL.LTE',	'.',	34024,	'circuit',	'l',	'2001-06-06',	10,	936),
('http://tonkas.hopto.org/EVO1/OLDCASTLE.LTE',	'OLDCASTLE.LTE',	'OLDCASTLE.LTE',	'.',	9763,	'circuit',	'l',	'2021-01-26',	10,	937),
('http://tonkas.hopto.org/EVO1/OLDHOLE.LTE',	'OLDHOLE.LTE',	'OLDHOLE.LTE',	'.',	26922,	'circuit',	'l',	'2007-09-17',	10,	938),
('http://tonkas.hopto.org/EVO1/OLDI-5Truggy.zip',	'OLDI-5Truggy.zip',	'OLDI-5Truggy.zip',	'.',	776049,	'circuit',	'z',	'2007-07-14',	10,	939),
('http://tonkas.hopto.org/EVO1/oldnotagain.lte',	'oldnotagain.lte',	'oldnotagain.lte',	'.',	22623,	'circuit',	'l',	'2002-10-05',	10,	940),
('http://tonkas.hopto.org/EVO1/OLDOFFROAD.LTE',	'OLDOFFROAD.LTE',	'OLDOFFROAD.LTE',	'.',	82683,	'circuit',	'l',	'2006-12-10',	10,	941),
('http://tonkas.hopto.org/EVO1/oldraceway.pod',	'oldraceway.pod',	'oldraceway.pod',	'.',	6140852,	'circuit',	'p',	'2007-03-11',	10,	942),
('http://tonkas.hopto.org/EVO1/oldraceway2.pod',	'oldraceway2.pod',	'oldraceway2.pod',	'.',	8467244,	'circuit',	'p',	'2007-03-11',	10,	943),
('http://tonkas.hopto.org/EVO1/OLDRALLY.LTE',	'OLDRALLY.LTE',	'OLDRALLY.LTE',	'.',	70535,	'circuit',	'l',	'2006-11-11',	10,	944),
('http://tonkas.hopto.org/EVO1/OLDRALLY2.LTE',	'OLDRALLY2.LTE',	'OLDRALLY2.LTE',	'.',	64329,	'circuit',	'l',	'2006-11-22',	10,	945),
('http://tonkas.hopto.org/EVO1/OLDRUN.LTE',	'OLDRUN.LTE',	'OLDRUN.LTE',	'.',	71866,	'circuit',	'l',	'2006-10-20',	10,	946),
('http://tonkas.hopto.org/EVO1/oldrun2.pod',	'oldrun2.pod',	'oldrun2.pod',	'.',	8382874,	'circuit',	'p',	'2021-01-25',	10,	947),
('http://tonkas.hopto.org/EVO1/OLDTest.LTE',	'OLDTest.LTE',	'OLDTest.LTE',	'.',	6049,	'circuit',	'l',	'2008-02-29',	10,	948),
('http://tonkas.hopto.org/EVO1/oldtwist.lte',	'oldtwist.lte',	'oldtwist.lte',	'.',	58524,	'circuit',	'l',	'2007-11-04',	10,	949),
('http://tonkas.hopto.org/EVO1/OLD_DTR4x4.zip',	'OLD_DTR4x4.zip',	'OLD_DTR4x4.zip',	'.',	659237,	'circuit',	'z',	'2000-12-03',	10,	950),
('http://tonkas.hopto.org/EVO1/OLD_FRST_RIDGE.zip',	'OLD_FRST_RIDGE.zip',	'OLD_FRST_RIDGE.zip',	'.',	837563,	'circuit',	'z',	'2000-12-03',	10,	951),
('http://tonkas.hopto.org/EVO1/OLD_MUDPIT.zip',	'OLD_MUDPIT.zip',	'OLD_MUDPIT.zip',	'.',	613612,	'circuit',	'z',	'2000-12-03',	10,	952),
('http://tonkas.hopto.org/EVO1/Omega1(1).lte',	'Omega1(1).lte',	'Omega1(1).lte',	'.',	43167,	'circuit',	'l',	'2021-01-26',	10,	953),
('http://tonkas.hopto.org/EVO1/Omega1.lte',	'Omega1.lte',	'Omega1.lte',	'.',	56838,	'circuit',	'l',	'2021-01-26',	10,	954),
('http://tonkas.hopto.org/EVO1/omegarace.lte',	'omegarace.lte',	'omegarace.lte',	'.',	63315,	'circuit',	'l',	'2021-01-26',	10,	955),
('http://tonkas.hopto.org/EVO1/omegaTrails.lte',	'omegaTrails.lte',	'omegaTrails.lte',	'.',	63489,	'circuit',	'l',	'2021-01-26',	10,	956),
('http://tonkas.hopto.org/EVO1/onan_motocross.lte',	'onan_motocross.lte',	'onan_motocross.lte',	'.',	24013,	'circuit',	'l',	'2001-05-29',	10,	957),
('http://tonkas.hopto.org/EVO1/ONaN_MX.zip',	'ONaN_MX.zip',	'ONaN_MX.zip',	'.',	721576,	'circuit',	'z',	'2000-12-03',	10,	958),
('http://tonkas.hopto.org/EVO1/one.lte',	'one.lte',	'one.lte',	'.',	38795,	'circuit',	'l',	'2021-01-26',	10,	959),
('http://tonkas.hopto.org/EVO1/ONELIFE.LTE',	'ONELIFE.LTE',	'ONELIFE.LTE',	'.',	30987,	'circuit',	'l',	'2002-08-09',	10,	960),
('http://tonkas.hopto.org/EVO1/Oneonone.lte',	'Oneonone.lte',	'Oneonone.lte',	'.',	34747,	'circuit',	'l',	'2021-01-26',	10,	961),
('http://tonkas.hopto.org/EVO1/ontherun.lte',	'ontherun.lte',	'ontherun.lte',	'.',	40715,	'circuit',	'l',	'2006-07-06',	10,	962),
('http://tonkas.hopto.org/EVO1/ONU3.ZIP',	'ONU3.ZIP',	'ONU3.ZIP',	'.',	708906,	'circuit',	'z',	'2000-12-05',	10,	963),
('http://tonkas.hopto.org/EVO1/OOPS_GROMIT.zip',	'OOPS_GROMIT.zip',	'OOPS_GROMIT.zip',	'.',	2248146,	'circuit',	'z',	'2001-01-21',	10,	964),
('http://tonkas.hopto.org/EVO1/OrangeTree.zip',	'OrangeTree.zip',	'OrangeTree.zip',	'.',	2170920,	'circuit',	'z',	'2001-04-05',	10,	965),
('http://tonkas.hopto.org/EVO1/Orcbomb.lte',	'Orcbomb.lte',	'Orcbomb.lte',	'.',	73367,	'circuit',	'l',	'2021-01-26',	10,	966),
('http://tonkas.hopto.org/EVO1/OURWORLD.pod',	'OURWORLD.pod',	'OURWORLD.pod',	'.',	7656440,	'circuit',	'p',	'2021-01-25',	10,	967),
('http://tonkas.hopto.org/EVO1/OUTBACK.ZIP',	'OUTBACK.ZIP',	'OUTBACK.ZIP',	'.',	4551733,	'circuit',	'z',	'2001-02-02',	10,	968),
('http://tonkas.hopto.org/EVO1/OUTBACKbv2.zip',	'OUTBACKbv2.zip',	'OUTBACKbv2.zip',	'.',	4918396,	'circuit',	'z',	'2001-02-06',	10,	969),
('http://tonkas.hopto.org/EVO1/OUTLAW.LTE',	'OUTLAW.LTE',	'OUTLAW.LTE',	'.',	24180,	'circuit',	'l',	'2001-08-05',	10,	970),
('http://tonkas.hopto.org/EVO1/outlawrun.lte',	'outlawrun.lte',	'outlawrun.lte',	'.',	65755,	'circuit',	'l',	'2005-05-01',	10,	971),
('http://tonkas.hopto.org/EVO1/Package.lte',	'Package.lte',	'Package.lte',	'.',	87262,	'circuit',	'l',	'2021-01-26',	10,	972),
('http://tonkas.hopto.org/EVO1/PARADISE.LTE',	'PARADISE.LTE',	'PARADISE.LTE',	'.',	61167,	'circuit',	'l',	'2021-01-26',	10,	973),
('http://tonkas.hopto.org/EVO1/Paris2Dakar.POD',	'Paris2Dakar.POD',	'Paris2Dakar.POD',	'.',	15201068,	'circuit',	'p',	'2002-04-04',	10,	974),
('http://tonkas.hopto.org/EVO1/Pcr160.lte',	'Pcr160.lte',	'Pcr160.lte',	'.',	43619,	'circuit',	'l',	'2021-01-26',	10,	975),
('http://tonkas.hopto.org/EVO1/Pcr260.lte',	'Pcr260.lte',	'Pcr260.lte',	'.',	26876,	'circuit',	'l',	'2001-09-06',	10,	976),
('http://tonkas.hopto.org/EVO1/pcrclockwork.lte',	'pcrclockwork.lte',	'pcrclockwork.lte',	'.',	56723,	'circuit',	'l',	'2001-09-01',	10,	977),
('http://tonkas.hopto.org/EVO1/PCRGATE.LTE',	'PCRGATE.LTE',	'PCRGATE.LTE',	'.',	30118,	'circuit',	'l',	'2001-08-20',	10,	978),
('http://tonkas.hopto.org/EVO1/PCRMOFO.LTE',	'PCRMOFO.LTE',	'PCRMOFO.LTE',	'.',	29380,	'circuit',	'l',	'2001-08-24',	10,	979),
('http://tonkas.hopto.org/EVO1/PHASE 1.zip',	'PHASE 1.zip',	'PHASE 1.zip',	'.',	597495,	'circuit',	'z',	'2001-04-18',	10,	980),
('http://tonkas.hopto.org/EVO1/PHOENIX.LTE',	'PHOENIX.LTE',	'PHOENIX.LTE',	'.',	12098,	'circuit',	'l',	'2001-07-06',	10,	981),
('http://tonkas.hopto.org/EVO1/PHOENIX2.LTE',	'PHOENIX2.LTE',	'PHOENIX2.LTE',	'.',	21371,	'circuit',	'l',	'2001-07-30',	10,	982),
('http://tonkas.hopto.org/EVO1/Pikes.lte',	'Pikes.lte',	'Pikes.lte',	'.',	72899,	'circuit',	'l',	'2021-01-26',	10,	983),
('http://tonkas.hopto.org/EVO1/Pimpster.lte',	'Pimpster.lte',	'Pimpster.lte',	'.',	9086,	'circuit',	'l',	'2021-01-26',	10,	984),
('http://tonkas.hopto.org/EVO1/pioneer-ez.lte',	'pioneer-ez.lte',	'pioneer-ez.lte',	'.',	100326,	'circuit',	'l',	'2005-11-29',	10,	985),
('http://tonkas.hopto.org/EVO1/pioneer-ez2.lte',	'pioneer-ez2.lte',	'pioneer-ez2.lte',	'.',	100329,	'circuit',	'l',	'2021-01-26',	10,	986),
('http://tonkas.hopto.org/EVO1/PIONEER.LTE',	'PIONEER.LTE',	'PIONEER.LTE',	'.',	98090,	'circuit',	'l',	'2004-01-05',	10,	987),
('http://tonkas.hopto.org/EVO1/pirrano.lte',	'pirrano.lte',	'pirrano.lte',	'.',	52629,	'circuit',	'l',	'2021-01-26',	10,	988),
('http://tonkas.hopto.org/EVO1/PITA.LTE',	'PITA.LTE',	'PITA.LTE',	'.',	31541,	'circuit',	'l',	'2002-02-18',	10,	989),
('http://tonkas.hopto.org/EVO1/PITVIPER84.LTE',	'PITVIPER84.LTE',	'PITVIPER84.LTE',	'.',	56829,	'circuit',	'l',	'2001-05-30',	10,	990),
('http://tonkas.hopto.org/EVO1/PODSWAP.BAT',	'PODSWAP.BAT',	'PODSWAP.BAT',	'.',	1886,	'circuit',	'b',	'2002-05-25',	10,	991),
('http://tonkas.hopto.org/EVO1/PODVIEW.ZIP',	'PODVIEW.ZIP',	'PODVIEW.ZIP',	'.',	21705,	'circuit',	'z',	'2001-04-03',	10,	992),
('http://tonkas.hopto.org/EVO1/POINTBLANK.LTE',	'POINTBLANK.LTE',	'POINTBLANK.LTE',	'.',	6792,	'circuit',	'l',	'2001-02-12',	10,	993),
('http://tonkas.hopto.org/EVO1/POP.LTE',	'POP.LTE',	'POP.LTE',	'.',	83739,	'circuit',	'l',	'2021-01-26',	10,	994),
('http://tonkas.hopto.org/EVO1/PPH.LTE',	'PPH.LTE',	'PPH.LTE',	'.',	59269,	'circuit',	'l',	'2001-07-30',	10,	995),
('http://tonkas.hopto.org/EVO1/pro-arena.lte',	'pro-arena.lte',	'pro-arena.lte',	'.',	10694,	'circuit',	'l',	'2007-03-29',	10,	996),
('http://tonkas.hopto.org/EVO1/proffroad.lte',	'proffroad.lte',	'proffroad.lte',	'.',	52195,	'circuit',	'l',	'2001-08-24',	10,	997),
('http://tonkas.hopto.org/EVO1/psykocross.lte',	'psykocross.lte',	'psykocross.lte',	'.',	40593,	'circuit',	'l',	'2006-04-04',	10,	998),
('http://tonkas.hopto.org/EVO1/PURPLECUSH.LTE',	'PURPLECUSH.LTE',	'PURPLECUSH.LTE',	'.',	22679,	'circuit',	'l',	'2021-01-26',	10,	999),
('http://tonkas.hopto.org/EVO1/QUARTERMILE.LTE',	'QUARTERMILE.LTE',	'QUARTERMILE.LTE',	'.',	6385,	'circuit',	'l',	'2021-01-26',	10,	1000),
('http://tonkas.hopto.org/EVO1/quartermiledrag.lte',	'quartermiledrag.lte',	'quartermiledrag.lte',	'.',	6964,	'circuit',	'l',	'2001-10-19',	10,	1001),
('http://tonkas.hopto.org/EVO1/quickie.lte',	'quickie.lte',	'quickie.lte',	'.',	38885,	'circuit',	'l',	'2021-01-26',	10,	1002),
('http://tonkas.hopto.org/EVO1/quickneasy.lte',	'quickneasy.lte',	'quickneasy.lte',	'.',	15934,	'circuit',	'l',	'2007-08-16',	10,	1003),
('http://tonkas.hopto.org/EVO1/R2XHILL.pod',	'R2XHILL.pod',	'R2XHILL.pod',	'.',	12952384,	'circuit',	'p',	'2021-01-25',	10,	1004),
('http://tonkas.hopto.org/EVO1/R2XHill.zip',	'R2XHill.zip',	'R2XHill.zip',	'.',	3865672,	'circuit',	'z',	'2003-02-27',	10,	1005),
('http://tonkas.hopto.org/EVO1/Race2004.lte',	'Race2004.lte',	'Race2004.lte',	'.',	75448,	'circuit',	'l',	'2021-01-26',	10,	1006),
('http://tonkas.hopto.org/EVO1/racenrome.lte',	'racenrome.lte',	'racenrome.lte',	'.',	39759,	'circuit',	'l',	'2021-01-26',	10,	1007),
('http://tonkas.hopto.org/EVO1/racetrackone.lte',	'racetrackone.lte',	'racetrackone.lte',	'.',	9493,	'circuit',	'l',	'2004-04-19',	10,	1008),
('http://tonkas.hopto.org/EVO1/RACEWORLD.LTE',	'RACEWORLD.LTE',	'RACEWORLD.LTE',	'.',	29860,	'circuit',	'l',	'2021-01-26',	10,	1009),
('http://tonkas.hopto.org/EVO1/Racingevolution.lte',	'Racingevolution.lte',	'Racingevolution.lte',	'.',	56050,	'circuit',	'l',	'2021-01-26',	10,	1010),
('http://tonkas.hopto.org/EVO1/RACOUT.LTE',	'RACOUT.LTE',	'RACOUT.LTE',	'.',	51072,	'circuit',	'l',	'2001-03-08',	10,	1011),
('http://tonkas.hopto.org/EVO1/radium.lte',	'radium.lte',	'radium.lte',	'.',	100299,	'circuit',	'l',	'2021-01-26',	10,	1012),
('http://tonkas.hopto.org/EVO1/rage-ez.lte',	'rage-ez.lte',	'rage-ez.lte',	'.',	100302,	'circuit',	'l',	'2021-01-26',	10,	1013),
('http://tonkas.hopto.org/EVO1/rage.lte',	'rage.lte',	'rage.lte',	'.',	99834,	'circuit',	'l',	'2021-01-26',	10,	1014),
('http://tonkas.hopto.org/EVO1/RALLY.LTE',	'RALLY.LTE',	'RALLY.LTE',	'.',	72741,	'circuit',	'l',	'2001-01-21',	10,	1015),
('http://tonkas.hopto.org/EVO1/rallycross.lte',	'rallycross.lte',	'rallycross.lte',	'.',	100298,	'circuit',	'l',	'2021-01-26',	10,	1016),
('http://tonkas.hopto.org/EVO1/RALLYJUNGLE.LTE',	'RALLYJUNGLE.LTE',	'RALLYJUNGLE.LTE',	'.',	16642,	'circuit',	'l',	'2008-08-17',	10,	1017),
('http://tonkas.hopto.org/EVO1/RALLYSTAGE1.LTE',	'RALLYSTAGE1.LTE',	'RALLYSTAGE1.LTE',	'.',	39592,	'circuit',	'l',	'2021-01-26',	10,	1018),
('http://tonkas.hopto.org/EVO1/RAMPING.LTE',	'RAMPING.LTE',	'RAMPING.LTE',	'.',	4401,	'circuit',	'l',	'2021-01-26',	10,	1019),
('http://tonkas.hopto.org/EVO1/Ramps.lte',	'Ramps.lte',	'Ramps.lte',	'.',	10112,	'circuit',	'l',	'2021-01-26',	10,	1020),
('http://tonkas.hopto.org/EVO1/RATRUM.LTE',	'RATRUM.LTE',	'RATRUM.LTE',	'.',	25137,	'circuit',	'l',	'2001-04-21',	10,	1021),
('http://tonkas.hopto.org/EVO1/raveotapes.lte',	'raveotapes.lte',	'raveotapes.lte',	'.',	4012,	'circuit',	'l',	'2003-07-08',	10,	1022),
('http://tonkas.hopto.org/EVO1/RAVHard.lte',	'RAVHard.lte',	'RAVHard.lte',	'.',	9331,	'circuit',	'l',	'2003-02-02',	10,	1023),
('http://tonkas.hopto.org/EVO1/ravland.lte',	'ravland.lte',	'ravland.lte',	'.',	34584,	'circuit',	'l',	'2021-01-26',	10,	1024),
('http://tonkas.hopto.org/EVO1/ravotopes.lte',	'ravotopes.lte',	'ravotopes.lte',	'.',	59587,	'circuit',	'l',	'2021-01-26',	10,	1025),
('http://tonkas.hopto.org/EVO1/RCGFOURCORNERS.LTE',	'RCGFOURCORNERS.LTE',	'RCGFOURCORNERS.LTE',	'.',	65481,	'circuit',	'l',	'2021-01-26',	10,	1026),
('http://tonkas.hopto.org/EVO1/RCGHILL.LTE',	'RCGHILL.LTE',	'RCGHILL.LTE',	'.',	6049,	'circuit',	'l',	'2008-02-29',	10,	1027),
('http://tonkas.hopto.org/EVO1/rcpcchile.lte',	'rcpcchile.lte',	'rcpcchile.lte',	'.',	21570,	'circuit',	'l',	'2003-04-03',	10,	1028),
('http://tonkas.hopto.org/EVO1/rebaltruckstop2.lte',	'rebaltruckstop2.lte',	'rebaltruckstop2.lte',	'.',	48891,	'circuit',	'l',	'2002-01-13',	10,	1029),
('http://tonkas.hopto.org/EVO1/rebeloffroad.pod',	'rebeloffroad.pod',	'rebeloffroad.pod',	'.',	961954,	'circuit',	'p',	'2006-10-27',	10,	1030),
('http://tonkas.hopto.org/EVO1/REDNECK.ZIP',	'REDNECK.ZIP',	'REDNECK.ZIP',	'.',	564587,	'circuit',	'z',	'2001-09-10',	10,	1031),
('http://tonkas.hopto.org/EVO1/REDOUBT.LTE',	'REDOUBT.LTE',	'REDOUBT.LTE',	'.',	10946,	'circuit',	'l',	'2003-02-26',	10,	1032),
('http://tonkas.hopto.org/EVO1/REJECTED.LTE',	'REJECTED.LTE',	'REJECTED.LTE',	'.',	9165,	'circuit',	'l',	'2021-01-26',	10,	1033),
('http://tonkas.hopto.org/EVO1/RETURNO.LTE',	'RETURNO.LTE',	'RETURNO.LTE',	'.',	18755,	'circuit',	'l',	'2021-01-26',	10,	1034),
('http://tonkas.hopto.org/EVO1/Revenge.lte',	'Revenge.lte',	'Revenge.lte',	'.',	4559,	'circuit',	'l',	'2003-04-10',	10,	1035),
('http://tonkas.hopto.org/EVO1/ridgeride.lte',	'ridgeride.lte',	'ridgeride.lte',	'.',	21416,	'circuit',	'l',	'2005-08-01',	10,	1036),
('http://tonkas.hopto.org/EVO1/ridgerunnr.lte',	'ridgerunnr.lte',	'ridgerunnr.lte',	'.',	85424,	'circuit',	'l',	'2001-08-27',	10,	1037),
('http://tonkas.hopto.org/EVO1/ridgerunnr2.lte',	'ridgerunnr2.lte',	'ridgerunnr2.lte',	'.',	56697,	'circuit',	'l',	'2001-08-27',	10,	1038),
('http://tonkas.hopto.org/EVO1/ripper.lte',	'ripper.lte',	'ripper.lte',	'.',	13916,	'circuit',	'l',	'2021-01-26',	10,	1039),
('http://tonkas.hopto.org/EVO1/RIVER.LTE',	'RIVER.LTE',	'RIVER.LTE',	'.',	23362,	'circuit',	'l',	'2001-08-24',	10,	1040),
('http://tonkas.hopto.org/EVO1/RIVERRUN.LTE',	'RIVERRUN.LTE',	'RIVERRUN.LTE',	'.',	71053,	'circuit',	'l',	'2001-06-03',	10,	1041),
('http://tonkas.hopto.org/EVO1/Riversprings.lte',	'Riversprings.lte',	'Riversprings.lte',	'.',	12064,	'circuit',	'l',	'2001-07-30',	10,	1042),
('http://tonkas.hopto.org/EVO1/rkbeach.lte',	'rkbeach.lte',	'rkbeach.lte',	'.',	66954,	'circuit',	'l',	'2007-09-13',	10,	1043),
('http://tonkas.hopto.org/EVO1/Road100.lte',	'Road100.lte',	'Road100.lte',	'.',	61130,	'circuit',	'l',	'2021-01-26',	10,	1044),
('http://tonkas.hopto.org/EVO1/ROADCONSTRUCTION.LTE',	'ROADCONSTRUCTION.LTE',	'ROADCONSTRUCTION.LTE',	'.',	84716,	'circuit',	'l',	'2021-01-26',	10,	1045),
('http://tonkas.hopto.org/EVO1/ROCK.LTE',	'ROCK.LTE',	'ROCK.LTE',	'.',	7112,	'circuit',	'l',	'2021-01-26',	10,	1046),
('http://tonkas.hopto.org/EVO1/ROCKBOTTOM.LTE',	'ROCKBOTTOM.LTE',	'ROCKBOTTOM.LTE',	'.',	4637,	'circuit',	'l',	'2002-05-27',	10,	1047),
('http://tonkas.hopto.org/EVO1/rockcrawlin.lte',	'rockcrawlin.lte',	'rockcrawlin.lte',	'.',	5453,	'circuit',	'l',	'2001-08-18',	10,	1048),
('http://tonkas.hopto.org/EVO1/ROCKET.LTE',	'ROCKET.LTE',	'ROCKET.LTE',	'.',	55952,	'circuit',	'l',	'2001-09-21',	10,	1049),
('http://tonkas.hopto.org/EVO1/ROCKKRAWL.pod',	'ROCKKRAWL.pod',	'ROCKKRAWL.pod',	'.',	6128599,	'circuit',	'p',	'2021-01-25',	10,	1050),
('http://tonkas.hopto.org/EVO1/Rocks.lte',	'Rocks.lte',	'Rocks.lte',	'.',	8472,	'circuit',	'l',	'2021-01-26',	10,	1051),
('http://tonkas.hopto.org/EVO1/Rocky.lte',	'Rocky.lte',	'Rocky.lte',	'.',	14382,	'circuit',	'l',	'2021-01-26',	10,	1052),
('http://tonkas.hopto.org/EVO1/Roll.lte',	'Roll.lte',	'Roll.lte',	'.',	54819,	'circuit',	'l',	'2021-01-26',	10,	1053),
('http://tonkas.hopto.org/EVO1/ROMPCENTRAL.LTE',	'ROMPCENTRAL.LTE',	'ROMPCENTRAL.LTE',	'.',	36667,	'circuit',	'l',	'2001-01-25',	10,	1054),
('http://tonkas.hopto.org/EVO1/Rookie.zip',	'Rookie.zip',	'Rookie.zip',	'.',	1046196,	'circuit',	'z',	'2000-12-03',	10,	1055),
('http://tonkas.hopto.org/EVO1/ROUGHRUN.LTE',	'ROUGHRUN.LTE',	'ROUGHRUN.LTE',	'.',	74417,	'circuit',	'l',	'2001-01-11',	10,	1056),
('http://tonkas.hopto.org/EVO1/ROUTE4X4.LTE',	'ROUTE4X4.LTE',	'ROUTE4X4.LTE',	'.',	79029,	'circuit',	'l',	'2001-10-03',	10,	1057),
('http://tonkas.hopto.org/EVO1/RRTI.pod',	'RRTI.pod',	'RRTI.pod',	'.',	14171214,	'circuit',	'p',	'2007-01-19',	10,	1058),
('http://tonkas.hopto.org/EVO1/Rtrails.lte',	'Rtrails.lte',	'Rtrails.lte',	'.',	66128,	'circuit',	'l',	'2004-03-14',	10,	1059),
('http://tonkas.hopto.org/EVO1/rubiconz.lte',	'rubiconz.lte',	'rubiconz.lte',	'.',	36600,	'circuit',	'l',	'2005-12-22',	10,	1060),
('http://tonkas.hopto.org/EVO1/RUMBLE.LTE',	'RUMBLE.LTE',	'RUMBLE.LTE',	'.',	7168,	'circuit',	'l',	'2021-01-26',	10,	1061),
('http://tonkas.hopto.org/EVO1/RUMBLER.LTE',	'RUMBLER.LTE',	'RUMBLER.LTE',	'.',	9793,	'circuit',	'l',	'2001-11-07',	10,	1062),
('http://tonkas.hopto.org/EVO1/RUMBLES.LTE',	'RUMBLES.LTE',	'RUMBLES.LTE',	'.',	9119,	'circuit',	'l',	'2021-01-26',	10,	1063),
('http://tonkas.hopto.org/EVO1/rusroad.lte',	'rusroad.lte',	'rusroad.lte',	'.',	17527,	'circuit',	'l',	'2006-07-17',	10,	1064),
('http://tonkas.hopto.org/EVO1/russianhills2.lte',	'russianhills2.lte',	'russianhills2.lte',	'.',	43881,	'circuit',	'l',	'2002-02-07',	10,	1065),
('http://tonkas.hopto.org/EVO1/RustyCanzz.zip',	'RustyCanzz.zip',	'RustyCanzz.zip',	'.',	2847137,	'circuit',	'z',	'2001-01-05',	10,	1066),
('http://tonkas.hopto.org/EVO1/sadona.lte',	'sadona.lte',	'sadona.lte',	'.',	30584,	'circuit',	'l',	'2021-01-26',	10,	1067),
('http://tonkas.hopto.org/EVO1/Saggybag.lte',	'Saggybag.lte',	'Saggybag.lte',	'.',	73557,	'circuit',	'l',	'2021-01-26',	10,	1068),
('http://tonkas.hopto.org/EVO1/Salvage2.lte',	'Salvage2.lte',	'Salvage2.lte',	'.',	37648,	'circuit',	'l',	'2021-01-26',	10,	1069),
('http://tonkas.hopto.org/EVO1/SANDRIDE.LTE',	'SANDRIDE.LTE',	'SANDRIDE.LTE',	'.',	57447,	'circuit',	'l',	'2021-01-26',	10,	1070),
('http://tonkas.hopto.org/EVO1/San_Juan.zip',	'San_Juan.zip',	'San_Juan.zip',	'.',	790970,	'circuit',	'z',	'2001-01-07',	10,	1071),
('http://tonkas.hopto.org/EVO1/Sauk.lte',	'Sauk.lte',	'Sauk.lte',	'.',	57094,	'circuit',	'l',	'2021-01-26',	10,	1072),
('http://tonkas.hopto.org/EVO1/SBANSHE.LTE',	'SBANSHE.LTE',	'SBANSHE.LTE',	'.',	42835,	'circuit',	'l',	'2001-06-01',	10,	1073),
('http://tonkas.hopto.org/EVO1/SBANSHEE.LTE',	'SBANSHEE.LTE',	'SBANSHEE.LTE',	'.',	42835,	'circuit',	'l',	'2001-03-08',	10,	1074),
('http://tonkas.hopto.org/EVO1/SCOONR.LTE',	'SCOONR.LTE',	'SCOONR.LTE',	'.',	62085,	'circuit',	'l',	'2002-05-03',	10,	1075),
('http://tonkas.hopto.org/EVO1/scottw.LTE',	'scottw.LTE',	'scottw.LTE',	'.',	11505,	'circuit',	'l',	'2021-01-26',	10,	1076),
('http://tonkas.hopto.org/EVO1/SCRAP.LTE',	'SCRAP.LTE',	'SCRAP.LTE',	'.',	41397,	'circuit',	'l',	'2001-08-27',	10,	1077),
('http://tonkas.hopto.org/EVO1/SCREWAROUND.LTE',	'SCREWAROUND.LTE',	'SCREWAROUND.LTE',	'.',	39380,	'circuit',	'l',	'2001-03-03',	10,	1078),
('http://tonkas.hopto.org/EVO1/seamless2.zip',	'seamless2.zip',	'seamless2.zip',	'.',	490726,	'circuit',	'z',	'2000-12-20',	10,	1079),
('http://tonkas.hopto.org/EVO1/Seaside.lte',	'Seaside.lte',	'Seaside.lte',	'.',	16350,	'circuit',	'l',	'2001-09-14',	10,	1080),
('http://tonkas.hopto.org/EVO1/seilavei.lte',	'seilavei.lte',	'seilavei.lte',	'.',	50734,	'circuit',	'l',	'2021-01-26',	10,	1081),
('http://tonkas.hopto.org/EVO1/SETI.ZIP',	'SETI.ZIP',	'SETI.ZIP',	'.',	5085393,	'circuit',	'z',	'2001-04-14',	10,	1082),
('http://tonkas.hopto.org/EVO1/SG1LTE.LTE',	'SG1LTE.LTE',	'SG1LTE.LTE',	'.',	30246,	'circuit',	'l',	'2001-02-02',	10,	1083),
('http://tonkas.hopto.org/EVO1/SGDD.LTE',	'SGDD.LTE',	'SGDD.LTE',	'.',	13478,	'circuit',	'l',	'2002-07-25',	10,	1084),
('http://tonkas.hopto.org/EVO1/sglf.lte',	'sglf.lte',	'sglf.lte',	'.',	16605,	'circuit',	'l',	'2004-07-15',	10,	1085),
('http://tonkas.hopto.org/EVO1/SGMR.LTE',	'SGMR.LTE',	'SGMR.LTE',	'.',	19804,	'circuit',	'l',	'2002-09-26',	10,	1086),
('http://tonkas.hopto.org/EVO1/sgtrack.lte',	'sgtrack.lte',	'sgtrack.lte',	'.',	30935,	'circuit',	'l',	'2004-05-13',	10,	1087),
('http://tonkas.hopto.org/EVO1/SGTRACK2.LTE',	'SGTRACK2.LTE',	'SGTRACK2.LTE',	'.',	30937,	'circuit',	'l',	'2002-07-09',	10,	1088),
('http://tonkas.hopto.org/EVO1/shame.lte',	'shame.lte',	'shame.lte',	'.',	83767,	'circuit',	'l',	'2006-04-11',	10,	1089),
('http://tonkas.hopto.org/EVO1/SHARKPARKv2.LTE',	'SHARKPARKv2.LTE',	'SHARKPARKv2.LTE',	'.',	62025,	'circuit',	'l',	'2001-04-20',	10,	1090),
('http://tonkas.hopto.org/EVO1/Sharpie.lte',	'Sharpie.lte',	'Sharpie.lte',	'.',	91853,	'circuit',	'l',	'2021-01-26',	10,	1091),
('http://tonkas.hopto.org/EVO1/SHILL.LTE',	'SHILL.LTE',	'SHILL.LTE',	'.',	5889,	'circuit',	'l',	'2003-03-19',	10,	1092),
('http://tonkas.hopto.org/EVO1/shipwreck.lte',	'shipwreck.lte',	'shipwreck.lte',	'.',	51733,	'circuit',	'l',	'2021-01-26',	10,	1093),
('http://tonkas.hopto.org/EVO1/shithclimb.lte',	'shithclimb.lte',	'shithclimb.lte',	'.',	31782,	'circuit',	'l',	'2003-02-19',	10,	1094),
('http://tonkas.hopto.org/EVO1/SHOCKMAN.LTE',	'SHOCKMAN.LTE',	'SHOCKMAN.LTE',	'.',	61987,	'circuit',	'l',	'2002-03-03',	10,	1095),
('http://tonkas.hopto.org/EVO1/SIDEWINDER.LTE',	'SIDEWINDER.LTE',	'SIDEWINDER.LTE',	'.',	22289,	'circuit',	'l',	'2001-03-08',	10,	1096),
('http://tonkas.hopto.org/EVO1/silvertonpass2.lte',	'silvertonpass2.lte',	'silvertonpass2.lte',	'.',	65709,	'circuit',	'l',	'2021-01-26',	10,	1097),
('http://tonkas.hopto.org/EVO1/Simpson.lte',	'Simpson.lte',	'Simpson.lte',	'.',	93188,	'circuit',	'l',	'2021-01-26',	10,	1098),
('http://tonkas.hopto.org/EVO1/sinaloa2004.lte',	'sinaloa2004.lte',	'sinaloa2004.lte',	'.',	35601,	'circuit',	'l',	'2004-04-14',	10,	1099),
('http://tonkas.hopto.org/EVO1/sinkorswim.LTE',	'sinkorswim.LTE',	'sinkorswim.LTE',	'.',	17093,	'circuit',	'l',	'2001-04-02',	10,	1100),
('http://tonkas.hopto.org/EVO1/SINKSWIM.LTE',	'SINKSWIM.LTE',	'SINKSWIM.LTE',	'.',	16482,	'circuit',	'l',	'2001-02-13',	10,	1101),
('http://tonkas.hopto.org/EVO1/sith-icevert.lte',	'sith-icevert.lte',	'sith-icevert.lte',	'.',	16714,	'circuit',	'l',	'2007-02-13',	10,	1102),
('http://tonkas.hopto.org/EVO1/sithallstarshout.lte',	'sithallstarshout.lte',	'sithallstarshout.lte',	'.',	83688,	'circuit',	'l',	'2004-04-26',	10,	1103),
('http://tonkas.hopto.org/EVO1/SITHARIZONA.LTE',	'SITHARIZONA.LTE',	'SITHARIZONA.LTE',	'.',	87242,	'circuit',	'l',	'2003-02-01',	10,	1104),
('http://tonkas.hopto.org/EVO1/sithbhc.lte',	'sithbhc.lte',	'sithbhc.lte',	'.',	27833,	'circuit',	'l',	'2021-01-26',	10,	1105),
('http://tonkas.hopto.org/EVO1/sithc3.lte',	'sithc3.lte',	'sithc3.lte',	'.',	55469,	'circuit',	'l',	'2007-06-06',	10,	1106),
('http://tonkas.hopto.org/EVO1/sithc3te.lte',	'sithc3te.lte',	'sithc3te.lte',	'.',	55578,	'circuit',	'l',	'2021-01-26',	10,	1107),
('http://tonkas.hopto.org/EVO1/SITHCC.LTE',	'SITHCC.LTE',	'SITHCC.LTE',	'.',	43454,	'circuit',	'l',	'2003-10-05',	10,	1108),
('http://tonkas.hopto.org/EVO1/sithclimb.lte',	'sithclimb.lte',	'sithclimb.lte',	'.',	6000,	'circuit',	'l',	'2005-06-13',	10,	1109),
('http://tonkas.hopto.org/EVO1/sithclimb2.lte',	'sithclimb2.lte',	'sithclimb2.lte',	'.',	29791,	'circuit',	'l',	'2004-04-14',	10,	1110),
('http://tonkas.hopto.org/EVO1/sithclimb3.lte',	'sithclimb3.lte',	'sithclimb3.lte',	'.',	34459,	'circuit',	'l',	'2003-02-02',	10,	1111),
('http://tonkas.hopto.org/EVO1/sithcorpus.lte',	'sithcorpus.lte',	'sithcorpus.lte',	'.',	65109,	'circuit',	'l',	'2004-04-29',	10,	1112),
('http://tonkas.hopto.org/EVO1/sithcrazyzone2.lte',	'sithcrazyzone2.lte',	'sithcrazyzone2.lte',	'.',	12589,	'circuit',	'l',	'2004-01-05',	10,	1113),
('http://tonkas.hopto.org/EVO1/sithcrazyzone3.lte',	'sithcrazyzone3.lte',	'sithcrazyzone3.lte',	'.',	12578,	'circuit',	'l',	'2004-04-15',	10,	1114),
('http://tonkas.hopto.org/EVO1/sithcrusher.lte',	'sithcrusher.lte',	'sithcrusher.lte',	'.',	78546,	'circuit',	'l',	'2003-04-11',	10,	1115),
('http://tonkas.hopto.org/EVO1/sithdeathridge.lte',	'sithdeathridge.lte',	'sithdeathridge.lte',	'.',	35322,	'circuit',	'l',	'2005-05-01',	10,	1116),
('http://tonkas.hopto.org/EVO1/sithdeathridgev2.lte',	'sithdeathridgev2.lte',	'sithdeathridgev2.lte',	'.',	38977,	'circuit',	'l',	'2003-02-03',	10,	1117),
('http://tonkas.hopto.org/EVO1/sithdeathridgev3.lte',	'sithdeathridgev3.lte',	'sithdeathridgev3.lte',	'.',	52982,	'circuit',	'l',	'2006-04-08',	10,	1118),
('http://tonkas.hopto.org/EVO1/sithencounter.lte',	'sithencounter.lte',	'sithencounter.lte',	'.',	71711,	'circuit',	'l',	'2003-04-03',	10,	1119),
('http://tonkas.hopto.org/EVO1/sithenigma.lte',	'sithenigma.lte',	'sithenigma.lte',	'.',	53990,	'circuit',	'l',	'2006-09-09',	10,	1120),
('http://tonkas.hopto.org/EVO1/sithevergleam.lte',	'sithevergleam.lte',	'sithevergleam.lte',	'.',	55379,	'circuit',	'l',	'2003-03-06',	10,	1121),
('http://tonkas.hopto.org/EVO1/sithexcavator.lte',	'sithexcavator.lte',	'sithexcavator.lte',	'.',	85003,	'circuit',	'l',	'2002-11-26',	10,	1122),
('http://tonkas.hopto.org/EVO1/sithfarm.lte',	'sithfarm.lte',	'sithfarm.lte',	'.',	55881,	'circuit',	'l',	'2021-01-26',	10,	1123),
('http://tonkas.hopto.org/EVO1/sithhighlife.lte',	'sithhighlife.lte',	'sithhighlife.lte',	'.',	99755,	'circuit',	'l',	'2007-10-23',	10,	1124),
('http://tonkas.hopto.org/EVO1/sithiceman.lte',	'sithiceman.lte',	'sithiceman.lte',	'.',	57090,	'circuit',	'l',	'2005-04-04',	10,	1125),
('http://tonkas.hopto.org/EVO1/sithjagged.lte',	'sithjagged.lte',	'sithjagged.lte',	'.',	100286,	'circuit',	'l',	'2004-08-22',	10,	1126),
('http://tonkas.hopto.org/EVO1/SITHKUJO.LTE',	'SITHKUJO.LTE',	'SITHKUJO.LTE',	'.',	28897,	'circuit',	'l',	'2021-01-26',	10,	1127),
('http://tonkas.hopto.org/EVO1/sithlagoon.lte',	'sithlagoon.lte',	'sithlagoon.lte',	'.',	71827,	'circuit',	'l',	'2006-04-10',	10,	1128),
('http://tonkas.hopto.org/EVO1/sithlord.lte',	'sithlord.lte',	'sithlord.lte',	'.',	66273,	'circuit',	'l',	'2006-02-20',	10,	1129),
('http://tonkas.hopto.org/EVO1/sithmixer.lte',	'sithmixer.lte',	'sithmixer.lte',	'.',	31978,	'circuit',	'l',	'2005-04-28',	10,	1130),
('http://tonkas.hopto.org/EVO1/sithmountin.lte',	'sithmountin.lte',	'sithmountin.lte',	'.',	60414,	'circuit',	'l',	'2003-05-26',	10,	1131),
('http://tonkas.hopto.org/EVO1/SithNeverLand.lte',	'SithNeverLand.lte',	'SithNeverLand.lte',	'.',	78742,	'circuit',	'l',	'2004-06-08',	10,	1132),
('http://tonkas.hopto.org/EVO1/SITHNL2.LTE',	'SITHNL2.LTE',	'SITHNL2.LTE',	'.',	88973,	'circuit',	'l',	'2003-06-01',	10,	1133),
('http://tonkas.hopto.org/EVO1/sithpalmbay.lte',	'sithpalmbay.lte',	'sithpalmbay.lte',	'.',	66402,	'circuit',	'l',	'2003-02-03',	10,	1134),
('http://tonkas.hopto.org/EVO1/Sithpark.lte',	'Sithpark.lte',	'Sithpark.lte',	'.',	56364,	'circuit',	'l',	'2002-11-13',	10,	1135),
('http://tonkas.hopto.org/EVO1/sithparkv2.lte',	'sithparkv2.lte',	'sithparkv2.lte',	'.',	55211,	'circuit',	'l',	'2003-02-03',	10,	1136),
('http://tonkas.hopto.org/EVO1/sithpassage.lte',	'sithpassage.lte',	'sithpassage.lte',	'.',	68434,	'circuit',	'l',	'2006-07-20',	10,	1137),
('http://tonkas.hopto.org/EVO1/sithprospector.lte',	'sithprospector.lte',	'sithprospector.lte',	'.',	98061,	'circuit',	'l',	'2003-04-17',	10,	1138),
('http://tonkas.hopto.org/EVO1/sithrealm.lte',	'sithrealm.lte',	'sithrealm.lte',	'.',	48135,	'circuit',	'l',	'2003-08-25',	10,	1139),
('http://tonkas.hopto.org/EVO1/sithruffrider.lte',	'sithruffrider.lte',	'sithruffrider.lte',	'.',	46512,	'circuit',	'l',	'2003-02-01',	10,	1140),
('http://tonkas.hopto.org/EVO1/sithsense.lte',	'sithsense.lte',	'sithsense.lte',	'.',	89968,	'circuit',	'l',	'2003-02-19',	10,	1141),
('http://tonkas.hopto.org/EVO1/sithshadyshout.lte',	'sithshadyshout.lte',	'sithshadyshout.lte',	'.',	90864,	'circuit',	'l',	'2003-02-20',	10,	1142),
('http://tonkas.hopto.org/EVO1/sithsinister.lte',	'sithsinister.lte',	'sithsinister.lte',	'.',	89519,	'circuit',	'l',	'2006-04-18',	10,	1143),
('http://tonkas.hopto.org/EVO1/SITHSNOW.LTE',	'SITHSNOW.LTE',	'SITHSNOW.LTE',	'.',	12476,	'circuit',	'l',	'2003-03-07',	10,	1144),
('http://tonkas.hopto.org/EVO1/sithstadium.lte',	'sithstadium.lte',	'sithstadium.lte',	'.',	73728,	'circuit',	'l',	'2021-01-26',	10,	1145),
('http://tonkas.hopto.org/EVO1/sithstadiumtrail.lte',	'sithstadiumtrail.lte',	'sithstadiumtrail.lte',	'.',	72466,	'circuit',	'l',	'2021-01-26',	10,	1146),
('http://tonkas.hopto.org/EVO1/sithstellar.lte',	'sithstellar.lte',	'sithstellar.lte',	'.',	53354,	'circuit',	'l',	'2002-12-12',	10,	1147),
('http://tonkas.hopto.org/EVO1/sithtrail.lte',	'sithtrail.lte',	'sithtrail.lte',	'.',	28660,	'circuit',	'l',	'2004-04-25',	10,	1148),
('http://tonkas.hopto.org/EVO1/sithtrail2.lte',	'sithtrail2.lte',	'sithtrail2.lte',	'.',	33611,	'circuit',	'l',	'2003-07-19',	10,	1149),
('http://tonkas.hopto.org/EVO1/sithtrailoffate.lte',	'sithtrailoffate.lte',	'sithtrailoffate.lte',	'.',	100310,	'circuit',	'l',	'2005-03-01',	10,	1150),
('http://tonkas.hopto.org/EVO1/sithvader.lte',	'sithvader.lte',	'sithvader.lte',	'.',	100352,	'circuit',	'l',	'2003-11-15',	10,	1151),
('http://tonkas.hopto.org/EVO1/sixer.lte',	'sixer.lte',	'sixer.lte',	'.',	20291,	'circuit',	'l',	'2004-12-16',	10,	1152),
('http://tonkas.hopto.org/EVO1/Slartsrun.lte',	'Slartsrun.lte',	'Slartsrun.lte',	'.',	31509,	'circuit',	'l',	'2001-06-06',	10,	1153),
('http://tonkas.hopto.org/EVO1/SLOTH1.LTE',	'SLOTH1.LTE',	'SLOTH1.LTE',	'.',	16658,	'circuit',	'l',	'2002-12-26',	10,	1154),
('http://tonkas.hopto.org/EVO1/SLOTH3.LTE',	'SLOTH3.LTE',	'SLOTH3.LTE',	'.',	13728,	'circuit',	'l',	'2002-05-31',	10,	1155),
('http://tonkas.hopto.org/EVO1/SLO_mts.pod',	'SLO_mts.pod',	'SLO_mts.pod',	'.',	6486478,	'circuit',	'p',	'2006-08-13',	10,	1156),
('http://tonkas.hopto.org/EVO1/SM.POD',	'SM.POD',	'SM.POD',	'.',	5909212,	'circuit',	'p',	'2005-11-24',	10,	1157),
('http://tonkas.hopto.org/EVO1/SMASH.LTE',	'SMASH.LTE',	'SMASH.LTE',	'.',	77835,	'circuit',	'l',	'2001-07-30',	10,	1158),
('http://tonkas.hopto.org/EVO1/snakesback.lte',	'snakesback.lte',	'snakesback.lte',	'.',	70626,	'circuit',	'l',	'2009-05-29',	10,	1159),
('http://tonkas.hopto.org/EVO1/Snow2.lte',	'Snow2.lte',	'Snow2.lte',	'.',	55948,	'circuit',	'l',	'2001-07-08',	10,	1160),
('http://tonkas.hopto.org/EVO1/SNOWMANSLAIR.LTE',	'SNOWMANSLAIR.LTE',	'SNOWMANSLAIR.LTE',	'.',	29782,	'circuit',	'l',	'2001-03-25',	10,	1161),
('http://tonkas.hopto.org/EVO1/Soldrdlt.lte',	'Soldrdlt.lte',	'Soldrdlt.lte',	'.',	20430,	'circuit',	'l',	'2021-01-26',	10,	1162),
('http://tonkas.hopto.org/EVO1/SOP.pod',	'SOP.pod',	'SOP.pod',	'.',	7582879,	'circuit',	'p',	'2021-01-25',	10,	1163),
('http://tonkas.hopto.org/EVO1/Space.lte',	'Space.lte',	'Space.lte',	'.',	4940,	'circuit',	'l',	'2001-05-01',	10,	1164),
('http://tonkas.hopto.org/EVO1/sparx.lte',	'sparx.lte',	'sparx.lte',	'.',	54581,	'circuit',	'l',	'2005-02-05',	10,	1165),
('http://tonkas.hopto.org/EVO1/SPB.LTE',	'SPB.LTE',	'SPB.LTE',	'.',	37972,	'circuit',	'l',	'2002-05-15',	10,	1166),
('http://tonkas.hopto.org/EVO1/SPDWY.LTE',	'SPDWY.LTE',	'SPDWY.LTE',	'.',	9545,	'circuit',	'l',	'2001-02-27',	10,	1167),
('http://tonkas.hopto.org/EVO1/Spdwy.zip',	'Spdwy.zip',	'Spdwy.zip',	'.',	8872,	'circuit',	'z',	'2001-04-12',	10,	1168),
('http://tonkas.hopto.org/EVO1/speedbump.lte',	'speedbump.lte',	'speedbump.lte',	'.',	25523,	'circuit',	'l',	'2004-05-11',	10,	1169),
('http://tonkas.hopto.org/EVO1/SPEEDWAY.LTE',	'SPEEDWAY.LTE',	'SPEEDWAY.LTE',	'.',	33799,	'circuit',	'l',	'2001-01-09',	10,	1170),
('http://tonkas.hopto.org/EVO1/SPEEDWAY101.LTE',	'SPEEDWAY101.LTE',	'SPEEDWAY101.LTE',	'.',	75108,	'circuit',	'l',	'2001-02-02',	10,	1171),
('http://tonkas.hopto.org/EVO1/Speedway2.lte',	'Speedway2.lte',	'Speedway2.lte',	'.',	33801,	'circuit',	'l',	'2001-02-02',	10,	1172),
('http://tonkas.hopto.org/EVO1/SPEEDY23.LTE',	'SPEEDY23.LTE',	'SPEEDY23.LTE',	'.',	9130,	'circuit',	'l',	'2021-01-26',	10,	1173),
('http://tonkas.hopto.org/EVO1/SPEEDY24.LTE',	'SPEEDY24.LTE',	'SPEEDY24.LTE',	'.',	10017,	'circuit',	'l',	'2021-01-26',	10,	1174),
('http://tonkas.hopto.org/EVO1/SPEEDY25.LTE',	'SPEEDY25.LTE',	'SPEEDY25.LTE',	'.',	10535,	'circuit',	'l',	'2021-01-26',	10,	1175),
('http://tonkas.hopto.org/EVO1/SPEEDYOFF.LTE',	'SPEEDYOFF.LTE',	'SPEEDYOFF.LTE',	'.',	13483,	'circuit',	'l',	'2021-01-26',	10,	1176),
('http://tonkas.hopto.org/EVO1/spinz.lte',	'spinz.lte',	'spinz.lte',	'.',	55350,	'circuit',	'l',	'2005-01-23',	10,	1177),
('http://tonkas.hopto.org/EVO1/Sprint.lte',	'Sprint.lte',	'Sprint.lte',	'.',	15348,	'circuit',	'l',	'2001-04-03',	10,	1178),
('http://tonkas.hopto.org/EVO1/Sprintcars.zip',	'Sprintcars.zip',	'Sprintcars.zip',	'.',	976738,	'circuit',	'z',	'2001-04-03',	10,	1179),
('http://tonkas.hopto.org/EVO1/Spyder2.lte',	'Spyder2.lte',	'Spyder2.lte',	'.',	24194,	'circuit',	'l',	'2001-07-09',	10,	1180),
('http://tonkas.hopto.org/EVO1/sracer.lte',	'sracer.lte',	'sracer.lte',	'.',	68562,	'circuit',	'l',	'2021-01-26',	10,	1181),
('http://tonkas.hopto.org/EVO1/ssithallstarhout.lte',	'ssithallstarhout.lte',	'ssithallstarhout.lte',	'.',	6099,	'circuit',	'l',	'2004-04-26',	10,	1182),
('http://tonkas.hopto.org/EVO1/ssithlord.lte',	'ssithlord.lte',	'ssithlord.lte',	'.',	6077,	'circuit',	'l',	'2004-05-17',	10,	1183),
('http://tonkas.hopto.org/EVO1/Sstrack.lte',	'Sstrack.lte',	'Sstrack.lte',	'.',	29142,	'circuit',	'l',	'2001-03-17',	10,	1184),
('http://tonkas.hopto.org/EVO1/SSWAMP.LTE',	'SSWAMP.LTE',	'SSWAMP.LTE',	'.',	22659,	'circuit',	'l',	'2021-01-26',	10,	1185),
('http://tonkas.hopto.org/EVO1/STACKED.LTE',	'STACKED.LTE',	'STACKED.LTE',	'.',	69417,	'circuit',	'l',	'2002-08-04',	10,	1186),
('http://tonkas.hopto.org/EVO1/starvmtn.lte',	'starvmtn.lte',	'starvmtn.lte',	'.',	51876,	'circuit',	'l',	'2021-01-26',	10,	1187),
('http://tonkas.hopto.org/EVO1/stc.lte',	'stc.lte',	'stc.lte',	'.',	58773,	'circuit',	'l',	'2004-05-25',	10,	1188),
('http://tonkas.hopto.org/EVO1/stgstdm.pod',	'stgstdm.pod',	'stgstdm.pod',	'.',	10703308,	'circuit',	'p',	'2006-07-23',	10,	1189),
('http://tonkas.hopto.org/EVO1/STICKYICKY.LTE',	'STICKYICKY.LTE',	'STICKYICKY.LTE',	'.',	12880,	'circuit',	'l',	'2001-04-15',	10,	1190),
('http://tonkas.hopto.org/EVO1/STONEWALLED.zip',	'STONEWALLED.zip',	'STONEWALLED.zip',	'.',	1428961,	'circuit',	'z',	'2001-08-27',	10,	1191),
('http://tonkas.hopto.org/EVO1/straddleback.lte',	'straddleback.lte',	'straddleback.lte',	'.',	34560,	'circuit',	'l',	'2004-11-22',	10,	1192),
('http://tonkas.hopto.org/EVO1/STREETPAC1.zip',	'STREETPAC1.zip',	'STREETPAC1.zip',	'.',	3091607,	'circuit',	'z',	'2001-03-01',	10,	1193),
('http://tonkas.hopto.org/EVO1/STREETRACING.LTE',	'STREETRACING.LTE',	'STREETRACING.LTE',	'.',	38190,	'circuit',	'l',	'2021-01-26',	10,	1194),
('http://tonkas.hopto.org/EVO1/STROAD.ZIP',	'STROAD.ZIP',	'STROAD.ZIP',	'.',	3750054,	'circuit',	'z',	'2001-04-25',	10,	1195),
('http://tonkas.hopto.org/EVO1/strongman.lte',	'strongman.lte',	'strongman.lte',	'.',	43289,	'circuit',	'l',	'2021-01-26',	10,	1196),
('http://tonkas.hopto.org/EVO1/STUNTISLAND.LTE',	'STUNTISLAND.LTE',	'STUNTISLAND.LTE',	'.',	25100,	'circuit',	'l',	'2021-01-26',	10,	1197),
('http://tonkas.hopto.org/EVO1/stunts1.lte',	'stunts1.lte',	'stunts1.lte',	'.',	58022,	'circuit',	'l',	'2021-01-26',	10,	1198),
('http://tonkas.hopto.org/EVO1/Summit3.zip',	'Summit3.zip',	'Summit3.zip',	'.',	445122,	'circuit',	'z',	'2001-01-30',	10,	1199),
('http://tonkas.hopto.org/EVO1/supercourse.lte',	'supercourse.lte',	'supercourse.lte',	'.',	56684,	'circuit',	'l',	'2002-09-16',	10,	1200),
('http://tonkas.hopto.org/EVO1/SUPERDRAG.LTE',	'SUPERDRAG.LTE',	'SUPERDRAG.LTE',	'.',	8024,	'circuit',	'l',	'2021-01-26',	10,	1201),
('http://tonkas.hopto.org/EVO1/supersprint .zip',	'supersprint .zip',	'supersprint .zip',	'.',	67696,	'circuit',	'z',	'2001-01-09',	10,	1202),
('http://tonkas.hopto.org/EVO1/suppermoto.lte',	'suppermoto.lte',	'suppermoto.lte',	'.',	21834,	'circuit',	'l',	'2001-09-30',	10,	1203),
('http://tonkas.hopto.org/EVO1/SUPRICE.pod',	'SUPRICE.pod',	'SUPRICE.pod',	'.',	11460067,	'circuit',	'p',	'2021-01-25',	10,	1204),
('http://tonkas.hopto.org/EVO1/SWAMPOFF.LTE',	'SWAMPOFF.LTE',	'SWAMPOFF.LTE',	'.',	38549,	'circuit',	'l',	'2002-05-25',	10,	1205),
('http://tonkas.hopto.org/EVO1/SWMPLIT.LTE',	'SWMPLIT.LTE',	'SWMPLIT.LTE',	'.',	54100,	'circuit',	'l',	'2000-12-25',	10,	1206),
('http://tonkas.hopto.org/EVO1/swmplit.lte..lte',	'swmplit.lte..lte',	'swmplit.lte..lte',	'.',	54100,	'circuit',	'l',	'2000-12-13',	10,	1207),
('http://tonkas.hopto.org/EVO1/Sx.lte',	'Sx.lte',	'Sx.lte',	'.',	20050,	'circuit',	'l',	'2001-04-03',	10,	1208),
('http://tonkas.hopto.org/EVO1/Sx2.lte',	'Sx2.lte',	'Sx2.lte',	'.',	73377,	'circuit',	'l',	'2021-01-26',	10,	1209),
('http://tonkas.hopto.org/EVO1/Synystrym.lte',	'Synystrym.lte',	'Synystrym.lte',	'.',	29285,	'circuit',	'l',	'2005-07-03',	10,	1210),
('http://tonkas.hopto.org/EVO1/t-bone.lte',	't-bone.lte',	't-bone.lte',	'.',	16707,	'circuit',	'l',	'2021-01-26',	10,	1211),
('http://tonkas.hopto.org/EVO1/TAKEOFFEH.zip',	'TAKEOFFEH.zip',	'TAKEOFFEH.zip',	'.',	2805284,	'circuit',	'z',	'2001-04-03',	10,	1212),
('http://tonkas.hopto.org/EVO1/TALIBANHQ.LTE',	'TALIBANHQ.LTE',	'TALIBANHQ.LTE',	'.',	69149,	'circuit',	'l',	'2021-01-26',	10,	1213),
('http://tonkas.hopto.org/EVO1/tbpdestinofinal.lte',	'tbpdestinofinal.lte',	'tbpdestinofinal.lte',	'.',	26284,	'circuit',	'l',	'2021-01-26',	10,	1214),
('http://tonkas.hopto.org/EVO1/TDBAHA.ZIP',	'TDBAHA.ZIP',	'TDBAHA.ZIP',	'.',	3145839,	'circuit',	'z',	'2001-01-05',	10,	1215),
('http://tonkas.hopto.org/EVO1/TDBAJA1.POD',	'TDBAJA1.POD',	'TDBAJA1.POD',	'.',	8189344,	'circuit',	'p',	'2003-06-14',	10,	1216),
('http://tonkas.hopto.org/EVO1/TDBAJALITE.LTE',	'TDBAJALITE.LTE',	'TDBAJALITE.LTE',	'.',	83370,	'circuit',	'l',	'2001-11-11',	10,	1217),
('http://tonkas.hopto.org/EVO1/Tdbomb.lte',	'Tdbomb.lte',	'Tdbomb.lte',	'.',	62572,	'circuit',	'l',	'2001-01-11',	10,	1218),
('http://tonkas.hopto.org/EVO1/Tdbomblg.lte',	'Tdbomblg.lte',	'Tdbomblg.lte',	'.',	62558,	'circuit',	'l',	'2001-01-25',	10,	1219),
('http://tonkas.hopto.org/EVO1/TDCOLISEUM2.pod',	'TDCOLISEUM2.pod',	'TDCOLISEUM2.pod',	'.',	8177030,	'circuit',	'p',	'2001-01-30',	10,	1220),
('http://tonkas.hopto.org/EVO1/TDCOLISEUM2.zip',	'TDCOLISEUM2.zip',	'TDCOLISEUM2.zip',	'.',	2180672,	'circuit',	'z',	'2001-01-31',	10,	1221),
('http://tonkas.hopto.org/EVO1/TDHWY.ZIP',	'TDHWY.ZIP',	'TDHWY.ZIP',	'.',	3643762,	'circuit',	'z',	'2001-04-26',	10,	1222),
('http://tonkas.hopto.org/EVO1/TDKRAZY8.ZIP',	'TDKRAZY8.ZIP',	'TDKRAZY8.ZIP',	'.',	1564211,	'circuit',	'z',	'2001-04-26',	10,	1223),
('http://tonkas.hopto.org/EVO1/TDUC.LTE',	'TDUC.LTE',	'TDUC.LTE',	'.',	62947,	'circuit',	'l',	'2001-11-20',	10,	1224),
('http://tonkas.hopto.org/EVO1/TDUPHILL.ZIP',	'TDUPHILL.ZIP',	'TDUPHILL.ZIP',	'.',	2302929,	'circuit',	'z',	'2001-02-04',	10,	1225),
('http://tonkas.hopto.org/EVO1/TEAMOFC.LTE',	'TEAMOFC.LTE',	'TEAMOFC.LTE',	'.',	10703,	'circuit',	'l',	'2021-01-26',	10,	1226),
('http://tonkas.hopto.org/EVO1/TEST.LTE',	'TEST.LTE',	'TEST.LTE',	'.',	69772,	'circuit',	'l',	'2006-11-11',	10,	1227),
('http://tonkas.hopto.org/EVO1/Testbed1.lte',	'Testbed1.lte',	'Testbed1.lte',	'.',	40978,	'circuit',	'l',	'2001-01-17',	10,	1228),
('http://tonkas.hopto.org/EVO1/TESTTRACK1HOUR.LTE',	'TESTTRACK1HOUR.LTE',	'TESTTRACK1HOUR.LTE',	'.',	12870,	'circuit',	'l',	'2021-01-26',	10,	1229),
('http://tonkas.hopto.org/EVO1/TESTTRACK2HOUR.LTE',	'TESTTRACK2HOUR.LTE',	'TESTTRACK2HOUR.LTE',	'.',	25510,	'circuit',	'l',	'2021-01-26',	10,	1230),
('http://tonkas.hopto.org/EVO1/texasoff.lte',	'texasoff.lte',	'texasoff.lte',	'.',	54432,	'circuit',	'l',	'2006-01-14',	10,	1231),
('http://tonkas.hopto.org/EVO1/texasoffroad.lte',	'texasoffroad.lte',	'texasoffroad.lte',	'.',	59527,	'circuit',	'l',	'2006-07-09',	10,	1232),
('http://tonkas.hopto.org/EVO1/TEXASOIL.LTE',	'TEXASOIL.LTE',	'TEXASOIL.LTE',	'.',	62140,	'circuit',	'l',	'2001-05-30',	10,	1233),
('http://tonkas.hopto.org/EVO1/TEXASTEA.LTE',	'TEXASTEA.LTE',	'TEXASTEA.LTE',	'.',	67177,	'circuit',	'l',	'2001-05-30',	10,	1234),
('http://tonkas.hopto.org/EVO1/THC.LTE',	'THC.LTE',	'THC.LTE',	'.',	39042,	'circuit',	'l',	'2002-06-15',	10,	1235),
('http://tonkas.hopto.org/EVO1/Thc2a.lte',	'Thc2a.lte',	'Thc2a.lte',	'.',	36769,	'circuit',	'l',	'2021-01-26',	10,	1236),
('http://tonkas.hopto.org/EVO1/THEBAY.LTE',	'THEBAY.LTE',	'THEBAY.LTE',	'.',	67077,	'circuit',	'l',	'2021-01-26',	10,	1237),
('http://tonkas.hopto.org/EVO1/thebigracev2.lte',	'thebigracev2.lte',	'thebigracev2.lte',	'.',	58739,	'circuit',	'l',	'2021-01-26',	10,	1238),
('http://tonkas.hopto.org/EVO1/THEFARM.LTE',	'THEFARM.LTE',	'THEFARM.LTE',	'.',	18984,	'circuit',	'l',	'2021-01-26',	10,	1239),
('http://tonkas.hopto.org/EVO1/thegrid.lte',	'thegrid.lte',	'thegrid.lte',	'.',	65946,	'circuit',	'l',	'2004-10-26',	10,	1240),
('http://tonkas.hopto.org/EVO1/thekeys.lte',	'thekeys.lte',	'thekeys.lte',	'.',	65711,	'circuit',	'l',	'2004-12-09',	10,	1241),
('http://tonkas.hopto.org/EVO1/THEKINGRACE.LTE',	'THEKINGRACE.LTE',	'THEKINGRACE.LTE',	'.',	12142,	'circuit',	'l',	'2007-08-16',	10,	1242),
('http://tonkas.hopto.org/EVO1/Thepit.zip',	'Thepit.zip',	'Thepit.zip',	'.',	68571,	'circuit',	'z',	'2001-04-03',	10,	1243),
('http://tonkas.hopto.org/EVO1/Thereal.zip',	'Thereal.zip',	'Thereal.zip',	'.',	718949,	'circuit',	'z',	'2001-01-31',	10,	1244),
('http://tonkas.hopto.org/EVO1/THEROCK.LTE',	'THEROCK.LTE',	'THEROCK.LTE',	'.',	31283,	'circuit',	'l',	'2001-08-27',	10,	1245),
('http://tonkas.hopto.org/EVO1/the_hole.lte',	'the_hole.lte',	'the_hole.lte',	'.',	35133,	'circuit',	'l',	'2021-01-26',	10,	1246),
('http://tonkas.hopto.org/EVO1/tie.lte',	'tie.lte',	'tie.lte',	'.',	55145,	'circuit',	'l',	'2021-01-26',	10,	1247),
('http://tonkas.hopto.org/EVO1/tikisland.lte',	'tikisland.lte',	'tikisland.lte',	'.',	38994,	'circuit',	'l',	'2021-01-26',	10,	1248),
('http://tonkas.hopto.org/EVO1/Timber Lakes.LTE',	'Timber Lakes.LTE',	'Timber Lakes.LTE',	'.',	21389,	'circuit',	'l',	'2001-03-20',	10,	1249),
('http://tonkas.hopto.org/EVO1/timberlakes.lte',	'timberlakes.lte',	'timberlakes.lte',	'.',	21389,	'circuit',	'l',	'2021-01-26',	10,	1250),
('http://tonkas.hopto.org/EVO1/timberland.lte',	'timberland.lte',	'timberland.lte',	'.',	63261,	'circuit',	'l',	'2005-03-15',	10,	1251),
('http://tonkas.hopto.org/EVO1/TIT.LTE',	'TIT.LTE',	'TIT.LTE',	'.',	75561,	'circuit',	'l',	'2003-06-26',	10,	1252),
('http://tonkas.hopto.org/EVO1/TKOTH.LTE',	'TKOTH.LTE',	'TKOTH.LTE',	'.',	6094,	'circuit',	'l',	'2021-01-26',	10,	1253),
('http://tonkas.hopto.org/EVO1/TKOTH2.LTE',	'TKOTH2.LTE',	'TKOTH2.LTE',	'.',	5531,	'circuit',	'l',	'2021-01-26',	10,	1254),
('http://tonkas.hopto.org/EVO1/TM.LTE',	'TM.LTE',	'TM.LTE',	'.',	13237,	'circuit',	'l',	'2002-06-15',	10,	1255),
('http://tonkas.hopto.org/EVO1/TNCPTEAMTRACK.LTE',	'TNCPTEAMTRACK.LTE',	'TNCPTEAMTRACK.LTE',	'.',	42624,	'circuit',	'l',	'2021-01-26',	10,	1256),
('http://tonkas.hopto.org/EVO1/TNTBRAIN.pod',	'TNTBRAIN.pod',	'TNTBRAIN.pod',	'.',	3334510,	'circuit',	'p',	'2021-01-25',	10,	1257),
('http://tonkas.hopto.org/EVO1/tntoka.lte',	'tntoka.lte',	'tntoka.lte',	'.',	19883,	'circuit',	'l',	'2021-01-26',	10,	1258),
('http://tonkas.hopto.org/EVO1/TONKASFUN.LTE',	'TONKASFUN.LTE',	'TONKASFUN.LTE',	'.',	32875,	'circuit',	'l',	'2002-12-25',	10,	1259),
('http://tonkas.hopto.org/EVO1/TOPBAJA.LTE',	'TOPBAJA.LTE',	'TOPBAJA.LTE',	'.',	81776,	'circuit',	'l',	'2003-01-25',	10,	1260),
('http://tonkas.hopto.org/EVO1/topdaf.lte',	'topdaf.lte',	'topdaf.lte',	'.',	15354,	'circuit',	'l',	'2021-01-26',	10,	1261),
('http://tonkas.hopto.org/EVO1/TOPEDGE.LTE',	'TOPEDGE.LTE',	'TOPEDGE.LTE',	'.',	15859,	'circuit',	'l',	'2003-05-31',	10,	1262),
('http://tonkas.hopto.org/EVO1/ToPFun.lte',	'ToPFun.lte',	'ToPFun.lte',	'.',	58532,	'circuit',	'l',	'2021-01-26',	10,	1263),
('http://tonkas.hopto.org/EVO1/topsfa.lte',	'topsfa.lte',	'topsfa.lte',	'.',	27969,	'circuit',	'l',	'2004-06-01',	10,	1264),
('http://tonkas.hopto.org/EVO1/TOPSUPER.LTE',	'TOPSUPER.LTE',	'TOPSUPER.LTE',	'.',	43527,	'circuit',	'l',	'2003-04-10',	10,	1265),
('http://tonkas.hopto.org/EVO1/Toptruck.lte',	'Toptruck.lte',	'Toptruck.lte',	'.',	56166,	'circuit',	'l',	'2004-05-09',	10,	1266),
('http://tonkas.hopto.org/EVO1/TOSLO.LTE',	'TOSLO.LTE',	'TOSLO.LTE',	'.',	32521,	'circuit',	'l',	'2001-05-30',	10,	1267),
('http://tonkas.hopto.org/EVO1/TOUGHTRUCK.LTE',	'TOUGHTRUCK.LTE',	'TOUGHTRUCK.LTE',	'.',	30134,	'circuit',	'l',	'2021-01-26',	10,	1268),
('http://tonkas.hopto.org/EVO1/Town.lte',	'Town.lte',	'Town.lte',	'.',	16585,	'circuit',	'l',	'2021-01-26',	10,	1269),
('http://tonkas.hopto.org/EVO1/townpeak_b1.lte',	'townpeak_b1.lte',	'townpeak_b1.lte',	'.',	72610,	'circuit',	'l',	'2001-08-07',	10,	1270),
('http://tonkas.hopto.org/EVO1/toysintheattic.pod',	'toysintheattic.pod',	'toysintheattic.pod',	'.',	4598461,	'circuit',	'p',	'2005-12-10',	10,	1271),
('http://tonkas.hopto.org/EVO1/TOYSX.ZIP',	'TOYSX.ZIP',	'TOYSX.ZIP',	'.',	1837543,	'circuit',	'z',	'2001-04-18',	10,	1272),
('http://tonkas.hopto.org/EVO1/TRACK.ZIP',	'TRACK.ZIP',	'TRACK.ZIP',	'.',	368889,	'circuit',	'z',	'2000-11-20',	10,	1273),
('http://tonkas.hopto.org/EVO1/TRACK2.LTE',	'TRACK2.LTE',	'TRACK2.LTE',	'.',	9559,	'circuit',	'l',	'2021-01-26',	10,	1274),
('http://tonkas.hopto.org/EVO1/TRAILBLAZIN.LTE',	'TRAILBLAZIN.LTE',	'TRAILBLAZIN.LTE',	'.',	69852,	'circuit',	'l',	'2001-05-30',	10,	1275),
('http://tonkas.hopto.org/EVO1/TRAILIN.LTE',	'TRAILIN.LTE',	'TRAILIN.LTE',	'.',	56036,	'circuit',	'l',	'2002-10-31',	10,	1276),
('http://tonkas.hopto.org/EVO1/trailridin.lte',	'trailridin.lte',	'trailridin.lte',	'.',	52629,	'circuit',	'l',	'2004-04-19',	10,	1277),
('http://tonkas.hopto.org/EVO1/trailsoldier.lte',	'trailsoldier.lte',	'trailsoldier.lte',	'.',	32973,	'circuit',	'l',	'2002-10-31',	10,	1278),
('http://tonkas.hopto.org/EVO1/TRAILZ.LTE',	'TRAILZ.LTE',	'TRAILZ.LTE',	'.',	56298,	'circuit',	'l',	'2002-04-15',	10,	1279),
('http://tonkas.hopto.org/EVO1/Training.lte',	'Training.lte',	'Training.lte',	'.',	9224,	'circuit',	'l',	'2021-01-26',	10,	1280),
('http://tonkas.hopto.org/EVO1/trainingcenter.lte',	'trainingcenter.lte',	'trainingcenter.lte',	'.',	5791,	'circuit',	'l',	'2021-01-26',	10,	1281),
('http://tonkas.hopto.org/EVO1/trassae95.lte',	'trassae95.lte',	'trassae95.lte',	'.',	66072,	'circuit',	'l',	'2002-02-18',	10,	1282),
('http://tonkas.hopto.org/EVO1/treadonme.lte',	'treadonme.lte',	'treadonme.lte',	'.',	77682,	'circuit',	'l',	'2021-01-26',	10,	1283),
('http://tonkas.hopto.org/EVO1/trickville2.lte',	'trickville2.lte',	'trickville2.lte',	'.',	7332,	'circuit',	'l',	'2007-02-16',	10,	1284),
('http://tonkas.hopto.org/EVO1/TRICKY.LTE',	'TRICKY.LTE',	'TRICKY.LTE',	'.',	42092,	'circuit',	'l',	'2001-07-30',	10,	1285),
('http://tonkas.hopto.org/EVO1/TRUCK.POD',	'TRUCK.POD',	'TRUCK.POD',	'.',	45878058,	'circuit',	'p',	'2000-10-02',	10,	1286),
('http://tonkas.hopto.org/EVO1/TRUCK.ZIP',	'TRUCK.ZIP',	'TRUCK.ZIP',	'.',	10872251,	'circuit',	'z',	'2002-12-26',	10,	1287),
('http://tonkas.hopto.org/EVO1/Truck102.lte',	'Truck102.lte',	'Truck102.lte',	'.',	15653,	'circuit',	'l',	'2001-03-08',	10,	1288),
('http://tonkas.hopto.org/EVO1/Truck103.zip',	'Truck103.zip',	'Truck103.zip',	'.',	1800783,	'circuit',	'z',	'2001-03-20',	10,	1289),
('http://tonkas.hopto.org/EVO1/TRUCK2.POD',	'TRUCK2.POD',	'TRUCK2.POD',	'.',	5515571,	'circuit',	'p',	'2000-06-16',	10,	1290),
('http://tonkas.hopto.org/EVO1/TRUCKSTOP102.LTE',	'TRUCKSTOP102.LTE',	'TRUCKSTOP102.LTE',	'.',	65741,	'circuit',	'l',	'2021-01-26',	10,	1291),
('http://tonkas.hopto.org/EVO1/TruckStop1022.lte',	'TruckStop1022.lte',	'TruckStop1022.lte',	'.',	65680,	'circuit',	'l',	'2021-01-26',	10,	1292),
('http://tonkas.hopto.org/EVO1/truckstopoff.lte',	'truckstopoff.lte',	'truckstopoff.lte',	'.',	62922,	'circuit',	'l',	'2002-05-25',	10,	1293),
('http://tonkas.hopto.org/EVO1/truckstoprace.lte',	'truckstoprace.lte',	'truckstoprace.lte',	'.',	22522,	'circuit',	'l',	'2021-01-26',	10,	1294),
('http://tonkas.hopto.org/EVO1/TRUCKTEST.LTE',	'TRUCKTEST.LTE',	'TRUCKTEST.LTE',	'.',	8988,	'circuit',	'l',	'2001-03-12',	10,	1295),
('http://tonkas.hopto.org/EVO1/trucktest.zip',	'trucktest.zip',	'trucktest.zip',	'.',	8825,	'circuit',	'z',	'2001-03-12',	10,	1296),
('http://tonkas.hopto.org/EVO1/tryouts.lte',	'tryouts.lte',	'tryouts.lte',	'.',	34962,	'circuit',	'l',	'2021-01-26',	10,	1297),
('http://tonkas.hopto.org/EVO1/TSPKILLA.LTE',	'TSPKILLA.LTE',	'TSPKILLA.LTE',	'.',	16352,	'circuit',	'l',	'2002-05-25',	10,	1298),
('http://tonkas.hopto.org/EVO1/tspkilla2.lte',	'tspkilla2.lte',	'tspkilla2.lte',	'.',	63081,	'circuit',	'l',	'2002-05-25',	10,	1299),
('http://tonkas.hopto.org/EVO1/TSPLOST.LTE',	'TSPLOST.LTE',	'TSPLOST.LTE',	'.',	66736,	'circuit',	'l',	'2002-05-12',	10,	1300),
('http://tonkas.hopto.org/EVO1/Tspower.lte',	'Tspower.lte',	'Tspower.lte',	'.',	54468,	'circuit',	'l',	'2021-01-26',	10,	1301),
('http://tonkas.hopto.org/EVO1/TT.LTE',	'TT.LTE',	'TT.LTE',	'.',	39671,	'circuit',	'l',	'2001-02-08',	10,	1302),
('http://tonkas.hopto.org/EVO1/Tt.zip',	'Tt.zip',	'Tt.zip',	'.',	39188,	'circuit',	'z',	'2001-02-10',	10,	1303),
('http://tonkas.hopto.org/EVO1/TT1.LTE',	'TT1.LTE',	'TT1.LTE',	'.',	10407,	'circuit',	'l',	'2003-02-12',	10,	1304),
('http://tonkas.hopto.org/EVO1/TTEST.LTE',	'TTEST.LTE',	'TTEST.LTE',	'.',	4305,	'circuit',	'l',	'2006-09-16',	10,	1305),
('http://tonkas.hopto.org/EVO1/TUBE1.LTE',	'TUBE1.LTE',	'TUBE1.LTE',	'.',	15782,	'circuit',	'l',	'2002-05-31',	10,	1306),
('http://tonkas.hopto.org/EVO1/tunneledit.lte',	'tunneledit.lte',	'tunneledit.lte',	'.',	32405,	'circuit',	'l',	'2021-01-26',	10,	1307),
('http://tonkas.hopto.org/EVO1/turbonut.lte',	'turbonut.lte',	'turbonut.lte',	'.',	80880,	'circuit',	'l',	'2005-01-17',	10,	1308),
('http://tonkas.hopto.org/EVO1/TUX.LTE',	'TUX.LTE',	'TUX.LTE',	'.',	15115,	'circuit',	'l',	'2006-11-21',	10,	1309),
('http://tonkas.hopto.org/EVO1/Twa.lte',	'Twa.lte',	'Twa.lte',	'.',	79235,	'circuit',	'l',	'2001-01-09',	10,	1310),
('http://tonkas.hopto.org/EVO1/Twa.zip',	'Twa.zip',	'Twa.zip',	'.',	78634,	'circuit',	'z',	'2001-01-11',	10,	1311),
('http://tonkas.hopto.org/EVO1/TWA2K1.LTE',	'TWA2K1.LTE',	'TWA2K1.LTE',	'.',	24333,	'circuit',	'l',	'2001-04-15',	10,	1312),
('http://tonkas.hopto.org/EVO1/twa_supercross.lte',	'twa_supercross.lte',	'twa_supercross.lte',	'.',	55411,	'circuit',	'l',	'2021-01-26',	10,	1313),
('http://tonkas.hopto.org/EVO1/TWA_SX.LTE',	'TWA_SX.LTE',	'TWA_SX.LTE',	'.',	55364,	'circuit',	'l',	'2001-08-19',	10,	1314),
('http://tonkas.hopto.org/EVO1/Under.lte',	'Under.lte',	'Under.lte',	'.',	4734,	'circuit',	'l',	'2001-05-01',	10,	1315),
('http://tonkas.hopto.org/EVO1/UPANDDOWN.POD',	'UPANDDOWN.POD',	'UPANDDOWN.POD',	'.',	1259459,	'circuit',	'p',	'2006-09-22',	10,	1316),
('http://tonkas.hopto.org/EVO1/UPHILL.LTE',	'UPHILL.LTE',	'UPHILL.LTE',	'.',	61198,	'circuit',	'l',	'2002-07-23',	10,	1317),
('http://tonkas.hopto.org/EVO1/upndown.lte',	'upndown.lte',	'upndown.lte',	'.',	8376,	'circuit',	'l',	'2004-12-12',	10,	1318),
('http://tonkas.hopto.org/EVO1/UTOPIA.LTE',	'UTOPIA.LTE',	'UTOPIA.LTE',	'.',	25262,	'circuit',	'l',	'2005-08-07',	10,	1319),
('http://tonkas.hopto.org/EVO1/uturn.lte',	'uturn.lte',	'uturn.lte',	'.',	16421,	'circuit',	'l',	'2021-01-26',	10,	1320),
('http://tonkas.hopto.org/EVO1/VERTIGO.LTE',	'VERTIGO.LTE',	'VERTIGO.LTE',	'.',	43629,	'circuit',	'l',	'2001-09-21',	10,	1321),
('http://tonkas.hopto.org/EVO1/vertigo_x.lte',	'vertigo_x.lte',	'vertigo_x.lte',	'.',	43709,	'circuit',	'l',	'2021-01-26',	10,	1322),
('http://tonkas.hopto.org/EVO1/VIPER.LTE',	'VIPER.LTE',	'VIPER.LTE',	'.',	52389,	'circuit',	'l',	'2001-01-09',	10,	1323),
('http://tonkas.hopto.org/EVO1/VIPER.ZIP',	'VIPER.ZIP',	'VIPER.ZIP',	'.',	51930,	'circuit',	'z',	'2001-01-09',	10,	1324),
('http://tonkas.hopto.org/EVO1/VisaVersa4x4.pod',	'VisaVersa4x4.pod',	'VisaVersa4x4.pod',	'.',	7683320,	'circuit',	'p',	'2001-06-03',	10,	1325),
('http://tonkas.hopto.org/EVO1/VisaVersa4x4.zip',	'VisaVersa4x4.zip',	'VisaVersa4x4.zip',	'.',	2130471,	'circuit',	'z',	'2002-07-28',	10,	1326),
('http://tonkas.hopto.org/EVO1/Vons.lte',	'Vons.lte',	'Vons.lte',	'.',	18363,	'circuit',	'l',	'2021-01-26',	10,	1327),
('http://tonkas.hopto.org/EVO1/Vp2.lte',	'Vp2.lte',	'Vp2.lte',	'.',	55473,	'circuit',	'l',	'2021-01-26',	10,	1328),
('http://tonkas.hopto.org/EVO1/VRALLY.LTE',	'VRALLY.LTE',	'VRALLY.LTE',	'.',	83689,	'circuit',	'l',	'2001-05-30',	10,	1329),
('http://tonkas.hopto.org/EVO1/vrr.lte',	'vrr.lte',	'vrr.lte',	'.',	66501,	'circuit',	'l',	'2021-01-26',	10,	1330),
('http://tonkas.hopto.org/EVO1/vulture.pod',	'vulture.pod',	'vulture.pod',	'.',	10988245,	'circuit',	'p',	'2021-01-25',	10,	1331),
('http://tonkas.hopto.org/EVO1/wallriderace.lte',	'wallriderace.lte',	'wallriderace.lte',	'.',	14696,	'circuit',	'l',	'2021-01-26',	10,	1332),
('http://tonkas.hopto.org/EVO1/warrior.lte',	'warrior.lte',	'warrior.lte',	'.',	30860,	'circuit',	'l',	'2007-02-03',	10,	1333),
('http://tonkas.hopto.org/EVO1/WASTEDAGAIN2.LTE',	'WASTEDAGAIN2.LTE',	'WASTEDAGAIN2.LTE',	'.',	38935,	'circuit',	'l',	'2001-03-08',	10,	1334),
('http://tonkas.hopto.org/EVO1/WASTEDREVERSE.LTE',	'WASTEDREVERSE.LTE',	'WASTEDREVERSE.LTE',	'.',	38335,	'circuit',	'l',	'2001-01-26',	10,	1335),
('http://tonkas.hopto.org/EVO1/waterworld.lte',	'waterworld.lte',	'waterworld.lte',	'.',	19168,	'circuit',	'l',	'2005-11-12',	10,	1336),
('http://tonkas.hopto.org/EVO1/weekendraces.lte',	'weekendraces.lte',	'weekendraces.lte',	'.',	8034,	'circuit',	'l',	'2002-02-01',	10,	1337),
('http://tonkas.hopto.org/EVO1/Whatsup.zip',	'Whatsup.zip',	'Whatsup.zip',	'.',	1328253,	'circuit',	'z',	'2001-01-09',	10,	1338),
('http://tonkas.hopto.org/EVO1/WHERE2.LTE',	'WHERE2.LTE',	'WHERE2.LTE',	'.',	37820,	'circuit',	'l',	'2001-11-23',	10,	1339),
('http://tonkas.hopto.org/EVO1/Whichway.lte',	'Whichway.lte',	'Whichway.lte',	'.',	65175,	'circuit',	'l',	'2001-03-31',	10,	1340),
('http://tonkas.hopto.org/EVO1/WHITES_CREEK.LTE',	'WHITES_CREEK.LTE',	'WHITES_CREEK.LTE',	'.',	66064,	'circuit',	'l',	'2001-05-30',	10,	1341),
('http://tonkas.hopto.org/EVO1/WILDERNESDRIVE.LTE',	'WILDERNESDRIVE.LTE',	'WILDERNESDRIVE.LTE',	'.',	32962,	'circuit',	'l',	'2021-01-26',	10,	1342),
('http://tonkas.hopto.org/EVO1/wilderness.pod',	'wilderness.pod',	'wilderness.pod',	'.',	7546277,	'circuit',	'p',	'2021-01-25',	10,	1343),
('http://tonkas.hopto.org/EVO1/wildwest.lte',	'wildwest.lte',	'wildwest.lte',	'.',	8886,	'circuit',	'l',	'2021-01-26',	10,	1344),
('http://tonkas.hopto.org/EVO1/wilhelms1.lte',	'wilhelms1.lte',	'wilhelms1.lte',	'.',	14094,	'circuit',	'l',	'2002-07-10',	10,	1345),
('http://tonkas.hopto.org/EVO1/Wilhelms2.lte',	'Wilhelms2.lte',	'Wilhelms2.lte',	'.',	13533,	'circuit',	'l',	'2002-07-21',	10,	1346),
('http://tonkas.hopto.org/EVO1/WINDCLIFF.LTE',	'WINDCLIFF.LTE',	'WINDCLIFF.LTE',	'.',	23716,	'circuit',	'l',	'2021-01-26',	10,	1347),
('http://tonkas.hopto.org/EVO1/windswept.lte',	'windswept.lte',	'windswept.lte',	'.',	64021,	'circuit',	'l',	'2001-06-01',	10,	1348),
('http://tonkas.hopto.org/EVO1/WINTERFEST.LTE',	'WINTERFEST.LTE',	'WINTERFEST.LTE',	'.',	75524,	'circuit',	'l',	'2001-02-11',	10,	1349),
('http://tonkas.hopto.org/EVO1/WINTERFEST2.LTE',	'WINTERFEST2.LTE',	'WINTERFEST2.LTE',	'.',	75332,	'circuit',	'l',	'2001-04-02',	10,	1350),
('http://tonkas.hopto.org/EVO1/winterrun.lte',	'winterrun.lte',	'winterrun.lte',	'.',	75332,	'circuit',	'l',	'2021-01-26',	10,	1351),
('http://tonkas.hopto.org/EVO1/wolfscampout.lte',	'wolfscampout.lte',	'wolfscampout.lte',	'.',	16648,	'circuit',	'l',	'2002-12-09',	10,	1352),
('http://tonkas.hopto.org/EVO1/wolfsiceyrun.lte',	'wolfsiceyrun.lte',	'wolfsiceyrun.lte',	'.',	32544,	'circuit',	'l',	'2006-09-15',	10,	1353),
('http://tonkas.hopto.org/EVO1/wolfsraceway.lte',	'wolfsraceway.lte',	'wolfsraceway.lte',	'.',	38891,	'circuit',	'l',	'2021-01-26',	10,	1354),
('http://tonkas.hopto.org/EVO1/WOLFSRACINGNOT.LTE',	'WOLFSRACINGNOT.LTE',	'WOLFSRACINGNOT.LTE',	'.',	44937,	'circuit',	'l',	'2021-01-26',	10,	1355),
('http://tonkas.hopto.org/EVO1/WOODLAND.LTE',	'WOODLAND.LTE',	'WOODLAND.LTE',	'.',	29560,	'circuit',	'l',	'2001-08-07',	10,	1356),
('http://tonkas.hopto.org/EVO1/WOODLAND2.LTE',	'WOODLAND2.LTE',	'WOODLAND2.LTE',	'.',	11399,	'circuit',	'l',	'2021-01-26',	10,	1357),
('http://tonkas.hopto.org/EVO1/woodlow.lte',	'woodlow.lte',	'woodlow.lte',	'.',	55790,	'circuit',	'l',	'2021-01-26',	10,	1358),
('http://tonkas.hopto.org/EVO1/woodpeak.lte',	'woodpeak.lte',	'woodpeak.lte',	'.',	81065,	'circuit',	'l',	'2005-05-07',	10,	1359),
('http://tonkas.hopto.org/EVO1/WoodPeak2.lte',	'WoodPeak2.lte',	'WoodPeak2.lte',	'.',	81065,	'circuit',	'l',	'2021-01-26',	10,	1360),
('http://tonkas.hopto.org/EVO1/woodruff.lte',	'woodruff.lte',	'woodruff.lte',	'.',	63878,	'circuit',	'l',	'2021-01-26',	10,	1361),
('http://tonkas.hopto.org/EVO1/WORKAHEAD.LTE',	'WORKAHEAD.LTE',	'WORKAHEAD.LTE',	'.',	84021,	'circuit',	'l',	'2021-01-26',	10,	1362),
('http://tonkas.hopto.org/EVO1/wreck.lte',	'wreck.lte',	'wreck.lte',	'.',	100350,	'circuit',	'l',	'2021-01-26',	10,	1363),
('http://tonkas.hopto.org/EVO1/WS_FTP.LOG',	'WS_FTP.LOG',	'WS_FTP.LOG',	'.',	20705,	'circuit',	'l',	'2004-11-12',	10,	1364),
('http://tonkas.hopto.org/EVO1/x-hawk.lte',	'x-hawk.lte',	'x-hawk.lte',	'.',	41563,	'circuit',	'l',	'2021-01-26',	10,	1365),
('http://tonkas.hopto.org/EVO1/x-sandracing.lte',	'x-sandracing.lte',	'x-sandracing.lte',	'.',	48328,	'circuit',	'l',	'2021-01-26',	10,	1366),
('http://tonkas.hopto.org/EVO1/x-sithwolf.lte',	'x-sithwolf.lte',	'x-sithwolf.lte',	'.',	44701,	'circuit',	'l',	'2021-01-26',	10,	1367),
('http://tonkas.hopto.org/EVO1/Xcastle.lte',	'Xcastle.lte',	'Xcastle.lte',	'.',	34961,	'circuit',	'l',	'2003-09-16',	10,	1368),
('http://tonkas.hopto.org/EVO1/XMC3beta.zip',	'XMC3beta.zip',	'XMC3beta.zip',	'.',	808611,	'circuit',	'z',	'2001-02-19',	10,	1369),
('http://tonkas.hopto.org/EVO1/XMOTOMUDX.LTE',	'XMOTOMUDX.LTE',	'XMOTOMUDX.LTE',	'.',	88473,	'circuit',	'l',	'2021-01-26',	10,	1370),
('http://tonkas.hopto.org/EVO1/Xmtj.lte',	'Xmtj.lte',	'Xmtj.lte',	'.',	23606,	'circuit',	'l',	'2021-01-26',	10,	1371),
('http://tonkas.hopto.org/EVO1/xotcrater.lte',	'xotcrater.lte',	'xotcrater.lte',	'.',	56166,	'circuit',	'l',	'2002-06-18',	10,	1372),
('http://tonkas.hopto.org/EVO1/XRMOTOX.LTE',	'XRMOTOX.LTE',	'XRMOTOX.LTE',	'.',	60294,	'circuit',	'l',	'2002-10-15',	10,	1373),
('http://tonkas.hopto.org/EVO1/Xroad.lte',	'Xroad.lte',	'Xroad.lte',	'.',	91599,	'circuit',	'l',	'2021-01-26',	10,	1374),
('http://tonkas.hopto.org/EVO1/xrt-rpm.lte',	'xrt-rpm.lte',	'xrt-rpm.lte',	'.',	58065,	'circuit',	'l',	'2005-11-26',	10,	1375),
('http://tonkas.hopto.org/EVO1/xrt-speed.lte',	'xrt-speed.lte',	'xrt-speed.lte',	'.',	71676,	'circuit',	'l',	'2004-12-28',	10,	1376),
('http://tonkas.hopto.org/EVO1/xsithforbid.lte',	'xsithforbid.lte',	'xsithforbid.lte',	'.',	92877,	'circuit',	'l',	'2003-10-29',	10,	1377),
('http://tonkas.hopto.org/EVO1/xSithkujo.lte',	'xSithkujo.lte',	'xSithkujo.lte',	'.',	44469,	'circuit',	'l',	'2021-01-26',	10,	1378),
('http://tonkas.hopto.org/EVO1/XSITHOCN.LTE',	'XSITHOCN.LTE',	'XSITHOCN.LTE',	'.',	45021,	'circuit',	'l',	'2003-11-15',	10,	1379),
('http://tonkas.hopto.org/EVO1/xsithside.lte',	'xsithside.lte',	'xsithside.lte',	'.',	90356,	'circuit',	'l',	'2021-01-26',	10,	1380),
('http://tonkas.hopto.org/EVO1/xsithskull.lte',	'xsithskull.lte',	'xsithskull.lte',	'.',	71715,	'circuit',	'l',	'2003-10-20',	10,	1381),
('http://tonkas.hopto.org/EVO1/Xsrr.lte',	'Xsrr.lte',	'Xsrr.lte',	'.',	57028,	'circuit',	'l',	'2003-09-16',	10,	1382),
('http://tonkas.hopto.org/EVO1/XTREME.pod',	'XTREME.pod',	'XTREME.pod',	'.',	6764011,	'circuit',	'p',	'2021-01-25',	10,	1383),
('http://tonkas.hopto.org/EVO1/yarou.lte',	'yarou.lte',	'yarou.lte',	'.',	100304,	'circuit',	'l',	'2004-05-13',	10,	1384),
('http://tonkas.hopto.org/EVO1/yarourally.lte',	'yarourally.lte',	'yarourally.lte',	'.',	37303,	'circuit',	'l',	'2008-03-10',	10,	1385),
('http://tonkas.hopto.org/EVO1/YOUNGDOG.LTE',	'YOUNGDOG.LTE',	'YOUNGDOG.LTE',	'.',	51910,	'circuit',	'l',	'2001-06-09',	10,	1386),
('http://tonkas.hopto.org/EVO1/YUPPER.ZIP',	'YUPPER.ZIP',	'YUPPER.ZIP',	'.',	4563165,	'circuit',	'z',	'2001-01-09',	10,	1387),
('http://tonkas.hopto.org/EVO1/ZANY2001.LTE',	'ZANY2001.LTE',	'ZANY2001.LTE',	'.',	40707,	'circuit',	'l',	'2001-01-17',	10,	1388),
('http://tonkas.hopto.org/EVO1/ZANYAPOCA.LTE',	'ZANYAPOCA.LTE',	'ZANYAPOCA.LTE',	'.',	38637,	'circuit',	'l',	'2021-01-26',	10,	1389),
('http://tonkas.hopto.org/EVO1/ZEN.LTE',	'ZEN.LTE',	'ZEN.LTE',	'.',	43073,	'circuit',	'l',	'2021-01-26',	10,	1390),
('http://tonkas.hopto.org/EVO1/Zen1.LTE',	'Zen1.LTE',	'Zen1.LTE',	'.',	43595,	'circuit',	'l',	'2021-01-26',	10,	1391),
('http://tonkas.hopto.org/EVO1/ZEN2.LTE',	'ZEN2.LTE',	'ZEN2.LTE',	'.',	23934,	'circuit',	'l',	'2021-01-26',	10,	1392),
('http://tonkas.hopto.org/EVO1/ZONEB.LTE',	'ZONEB.LTE',	'ZONEB.LTE',	'.',	93096,	'circuit',	'l',	'2001-07-08',	10,	1393),
('http://tonkas.hopto.org/EVO1/ZONEINGOUT.zip',	'ZONEINGOUT.zip',	'ZONEINGOUT.zip',	'.',	16887,	'circuit',	'z',	'2001-08-27',	10,	1394),
('http://tonkas.hopto.org/EVO1/zoomizona.lte',	'zoomizona.lte',	'zoomizona.lte',	'.',	48150,	'circuit',	'l',	'2006-02-13',	10,	1395),
('http://tonkas.hopto.org/EVO1/ZooN-CoasterEVO.zip',	'ZooN-CoasterEVO.zip',	'ZooN-CoasterEVO.zip',	'.',	442120,	'circuit',	'z',	'2005-05-08',	10,	1396),
('http://tonkas.hopto.org/EVO1/ZooN-EUROParkEVO.zip',	'ZooN-EUROParkEVO.zip',	'ZooN-EUROParkEVO.zip',	'.',	906336,	'circuit',	'z',	'2001-01-05',	10,	1397),
('http://tonkas.hopto.org/EVO1/ZooNeTTe-EURO_EVO.zip',	'ZooNeTTe-EURO_EVO.zip',	'ZooNeTTe-EURO_EVO.zip',	'.',	1883568,	'circuit',	'z',	'2001-01-09',	10,	1398),
('http://tonkas.hopto.org/EVO1/ZSRALLY.LTE',	'ZSRALLY.LTE',	'ZSRALLY.LTE',	'.',	38013,	'circuit',	'l',	'2003-02-24',	10,	1399),
('http://tonkas.hopto.org/EVO1/[KTR]Soldierv1.lte',	'[KTR]Soldierv1.lte',	'[KTR]Soldierv1.lte',	'.',	56982,	'circuit',	'l',	'2021-01-26',	10,	1400),
('http://tonkas.hopto.org/EVO1/[rcg]2t.lte',	'[rcg]2t.lte',	'[rcg]2t.lte',	'.',	36459,	'circuit',	'l',	'2008-04-17',	10,	1401),
('http://tonkas.hopto.org/EVO1/[RCG]BajaRace.LTE',	'[RCG]BajaRace.LTE',	'[RCG]BajaRace.LTE',	'.',	81530,	'circuit',	'l',	'2021-01-26',	10,	1402),
('http://tonkas.hopto.org/EVO1/[rcg]baywatch.lte',	'[rcg]baywatch.lte',	'[rcg]baywatch.lte',	'.',	43503,	'circuit',	'l',	'2021-01-26',	10,	1403),
('http://tonkas.hopto.org/EVO1/[RCG]Delfia.lte',	'[RCG]Delfia.lte',	'[RCG]Delfia.lte',	'.',	31680,	'circuit',	'l',	'2004-04-14',	10,	1404),
('http://tonkas.hopto.org/EVO1/[RCG]desert.lte',	'[RCG]desert.lte',	'[RCG]desert.lte',	'.',	59709,	'circuit',	'l',	'2021-01-26',	10,	1405),
('http://tonkas.hopto.org/EVO1/[rcg]deserttrail.lte',	'[rcg]deserttrail.lte',	'[rcg]deserttrail.lte',	'.',	59417,	'circuit',	'l',	'2002-02-24',	10,	1406),
('http://tonkas.hopto.org/EVO1/[rcg]eagle.lte',	'[rcg]eagle.lte',	'[rcg]eagle.lte',	'.',	37013,	'circuit',	'l',	'2004-05-05',	10,	1407),
('http://tonkas.hopto.org/EVO1/[RCG]EdgeRide.lte',	'[RCG]EdgeRide.lte',	'[RCG]EdgeRide.lte',	'.',	43258,	'circuit',	'l',	'2004-04-22',	10,	1408),
('http://tonkas.hopto.org/EVO1/[RCG]FantasyLand.lte',	'[RCG]FantasyLand.lte',	'[RCG]FantasyLand.lte',	'.',	59817,	'circuit',	'l',	'2003-01-11',	10,	1409),
('http://tonkas.hopto.org/EVO1/[RCG]FCtest.lte',	'[RCG]FCtest.lte',	'[RCG]FCtest.lte',	'.',	5234,	'circuit',	'l',	'2008-01-20',	10,	1410),
('http://tonkas.hopto.org/EVO1/[RCG]FjordRace.lte',	'[RCG]FjordRace.lte',	'[RCG]FjordRace.lte',	'.',	47396,	'circuit',	'l',	'2021-01-26',	10,	1411),
('http://tonkas.hopto.org/EVO1/[RCG]FjordRaceOff.lte',	'[RCG]FjordRaceOff.lte',	'[RCG]FjordRaceOff.lte',	'.',	47503,	'circuit',	'l',	'2021-01-26',	10,	1412),
('http://tonkas.hopto.org/EVO1/[rcg]funchall.lte',	'[rcg]funchall.lte',	'[rcg]funchall.lte',	'.',	6455,	'circuit',	'l',	'2008-05-26',	10,	1413),
('http://tonkas.hopto.org/EVO1/[RCG]GBD.LTE',	'[RCG]GBD.LTE',	'[RCG]GBD.LTE',	'.',	14648,	'circuit',	'l',	'2021-01-26',	10,	1414),
('http://tonkas.hopto.org/EVO1/[RCG]GF.lte',	'[RCG]GF.lte',	'[RCG]GF.lte',	'.',	34351,	'circuit',	'l',	'2004-04-24',	10,	1415),
('http://tonkas.hopto.org/EVO1/[RCG]GFD.lte',	'[RCG]GFD.lte',	'[RCG]GFD.lte',	'.',	39476,	'circuit',	'l',	'2021-01-26',	10,	1416),
('http://tonkas.hopto.org/EVO1/[RCG]GGD.lte',	'[RCG]GGD.lte',	'[RCG]GGD.lte',	'.',	33783,	'circuit',	'l',	'2021-01-26',	10,	1417),
('http://tonkas.hopto.org/EVO1/[RCG]GIC.lte',	'[RCG]GIC.lte',	'[RCG]GIC.lte',	'.',	38405,	'circuit',	'l',	'2021-01-26',	10,	1418),
('http://tonkas.hopto.org/EVO1/[RCG]Godemine.lte',	'[RCG]Godemine.lte',	'[RCG]Godemine.lte',	'.',	13409,	'circuit',	'l',	'2021-01-26',	10,	1419),
('http://tonkas.hopto.org/EVO1/[rcg]gw.lte',	'[rcg]gw.lte',	'[rcg]gw.lte',	'.',	8770,	'circuit',	'l',	'2021-01-26',	10,	1420),
('http://tonkas.hopto.org/EVO1/[rcg]Hfun.LTE',	'[rcg]Hfun.LTE',	'[rcg]Hfun.LTE',	'.',	6681,	'circuit',	'l',	'2008-05-25',	10,	1421),
('http://tonkas.hopto.org/EVO1/[RCG]Hideout.lte',	'[RCG]Hideout.lte',	'[RCG]Hideout.lte',	'.',	15888,	'circuit',	'l',	'2021-01-26',	10,	1422),
('http://tonkas.hopto.org/EVO1/[rcg]hillfun.LTE',	'[rcg]hillfun.LTE',	'[rcg]hillfun.LTE',	'.',	6673,	'circuit',	'l',	'2008-05-24',	10,	1423),
('http://tonkas.hopto.org/EVO1/[RCG]HL (1).lte',	'[RCG]HL (1).lte',	'[RCG]HL (1).lte',	'.',	52727,	'circuit',	'l',	'2021-01-26',	10,	1424),
('http://tonkas.hopto.org/EVO1/[rcg]hl.lte',	'[rcg]hl.lte',	'[rcg]hl.lte',	'.',	52730,	'circuit',	'l',	'2004-08-23',	10,	1425),
('http://tonkas.hopto.org/EVO1/[RCG]HLT.lte',	'[RCG]HLT.lte',	'[RCG]HLT.lte',	'.',	52825,	'circuit',	'l',	'2011-09-03',	10,	1426),
('http://tonkas.hopto.org/EVO1/[rcg]hltl.lte',	'[rcg]hltl.lte',	'[rcg]hltl.lte',	'.',	45132,	'circuit',	'l',	'2007-11-23',	10,	1427),
('http://tonkas.hopto.org/EVO1/[RCG]Koth.lte',	'[RCG]Koth.lte',	'[RCG]Koth.lte',	'.',	5106,	'circuit',	'l',	'2021-01-26',	10,	1428),
('http://tonkas.hopto.org/EVO1/[RCG]L,o,j.lte',	'[RCG]L,o,j.lte',	'[RCG]L,o,j.lte',	'.',	51542,	'circuit',	'l',	'2021-01-26',	10,	1429),
('http://tonkas.hopto.org/EVO1/[RCG]O,K.lte',	'[RCG]O,K.lte',	'[RCG]O,K.lte',	'.',	19173,	'circuit',	'l',	'2021-01-26',	10,	1430),
('http://tonkas.hopto.org/EVO1/[RCG]PSP.LTE',	'[RCG]PSP.LTE',	'[RCG]PSP.LTE',	'.',	26293,	'circuit',	'l',	'2021-01-26',	10,	1431),
('http://tonkas.hopto.org/EVO1/[RCG]PSPO (2).lte',	'[RCG]PSPO (2).lte',	'[RCG]PSPO (2).lte',	'.',	26993,	'circuit',	'l',	'2021-01-26',	10,	1432),
('http://tonkas.hopto.org/EVO1/[rcg]pspo.lte',	'[rcg]pspo.lte',	'[rcg]pspo.lte',	'.',	26993,	'circuit',	'l',	'2021-01-26',	10,	1433),
('http://tonkas.hopto.org/EVO1/[rcg]ridgeracing.lte',	'[rcg]ridgeracing.lte',	'[rcg]ridgeracing.lte',	'.',	77108,	'circuit',	'l',	'2011-09-03',	10,	1434),
('http://tonkas.hopto.org/EVO1/[RCG]Sector6.lte',	'[RCG]Sector6.lte',	'[RCG]Sector6.lte',	'.',	63561,	'circuit',	'l',	'2021-01-26',	10,	1435),
('http://tonkas.hopto.org/EVO1/[RCG]SM.lte',	'[RCG]SM.lte',	'[RCG]SM.lte',	'.',	43421,	'circuit',	'l',	'2021-01-26',	10,	1436),
('http://tonkas.hopto.org/EVO1/[RCG]SnowyA.lte',	'[RCG]SnowyA.lte',	'[RCG]SnowyA.lte',	'.',	56959,	'circuit',	'l',	'2021-01-26',	10,	1437),
('http://tonkas.hopto.org/EVO1/[RCG]TheRing.lte',	'[RCG]TheRing.lte',	'[RCG]TheRing.lte',	'.',	21952,	'circuit',	'l',	'2011-09-03',	10,	1438),
('http://tonkas.hopto.org/EVO1/[rcg]tower.lte',	'[rcg]tower.lte',	'[rcg]tower.lte',	'.',	19406,	'circuit',	'l',	'2011-09-03',	10,	1439),
('http://tonkas.hopto.org/EVO1/[RCG]Trail.lte',	'[RCG]Trail.lte',	'[RCG]Trail.lte',	'.',	91833,	'circuit',	'l',	'2021-01-26',	10,	1440),
('http://tonkas.hopto.org/EVO1/[rcg]training.lte',	'[rcg]training.lte',	'[rcg]training.lte',	'.',	22622,	'circuit',	'l',	'2011-09-03',	10,	1441),
('http://tonkas.hopto.org/EVO1/[RCG]wallride.lte',	'[RCG]wallride.lte',	'[RCG]wallride.lte',	'.',	40569,	'circuit',	'l',	'2002-12-27',	10,	1442),
('http://tonkas.hopto.org/EVO1/[RCG]wallrider.lte',	'[RCG]wallrider.lte',	'[RCG]wallrider.lte',	'.',	40833,	'circuit',	'l',	'2003-10-29',	10,	1443),
('http://tonkas.hopto.org/EVO1/[ToP]AT.lte',	'[ToP]AT.lte',	'[ToP]AT.lte',	'.',	2802,	'circuit',	'l',	'2006-04-03',	10,	1444),
('http://tonkas.hopto.org/EVO1/[top]baja.lte',	'[top]baja.lte',	'[top]baja.lte',	'.',	58349,	'circuit',	'l',	'2006-09-11',	10,	1445),
('http://tonkas.hopto.org/EVO1/[top]ct.lte',	'[top]ct.lte',	'[top]ct.lte',	'.',	51184,	'circuit',	'l',	'2021-01-26',	10,	1446),
('http://tonkas.hopto.org/EVO1/[TOP]dep.lte',	'[TOP]dep.lte',	'[TOP]dep.lte',	'.',	72611,	'circuit',	'l',	'2003-08-01',	10,	1447),
('http://tonkas.hopto.org/EVO1/[top]dep2.lte',	'[top]dep2.lte',	'[top]dep2.lte',	'.',	70968,	'circuit',	'l',	'2021-01-26',	10,	1448),
('http://tonkas.hopto.org/EVO1/[top]hawaii.lte',	'[top]hawaii.lte',	'[top]hawaii.lte',	'.',	59001,	'circuit',	'l',	'2003-01-03',	10,	1449),
('http://tonkas.hopto.org/EVO1/[top]jht.lte',	'[top]jht.lte',	'[top]jht.lte',	'.',	47458,	'circuit',	'l',	'2002-12-25',	10,	1450),
('http://tonkas.hopto.org/EVO1/[top]jhtv2.lte',	'[top]jhtv2.lte',	'[top]jhtv2.lte',	'.',	51495,	'circuit',	'l',	'2004-06-12',	10,	1451),
('http://tonkas.hopto.org/EVO1/[top]ma.lte',	'[top]ma.lte',	'[top]ma.lte',	'.',	29392,	'circuit',	'l',	'2021-01-26',	10,	1452),
('http://tonkas.hopto.org/EVO1/[top]ma2.lte',	'[top]ma2.lte',	'[top]ma2.lte',	'.',	30614,	'circuit',	'l',	'2004-06-03',	10,	1453),
('http://tonkas.hopto.org/EVO1/[top]mtht.lte',	'[top]mtht.lte',	'[top]mtht.lte',	'.',	59775,	'circuit',	'l',	'2004-04-14',	10,	1454),
('http://tonkas.hopto.org/EVO1/[top]na.lte',	'[top]na.lte',	'[top]na.lte',	'.',	66839,	'circuit',	'l',	'2021-01-26',	10,	1455),
('http://tonkas.hopto.org/EVO1/[top]tht.lte',	'[top]tht.lte',	'[top]tht.lte',	'.',	48263,	'circuit',	'l',	'2003-01-15',	10,	1456),
('http://tonkas.hopto.org/EVO1/[top]tr.lte',	'[top]tr.lte',	'[top]tr.lte',	'.',	39680,	'circuit',	'l',	'2021-01-26',	10,	1457),
('http://tonkas.hopto.org/EVO1/[TOP]TrailrideV1.lte',	'[TOP]TrailrideV1.lte',	'[TOP]TrailrideV1.lte',	'.',	39359,	'circuit',	'l',	'2003-02-01',	10,	1458),
('http://tonkas.hopto.org/EVO1/[TOP]trailsoldier.lte',	'[TOP]trailsoldier.lte',	'[TOP]trailsoldier.lte',	'.',	45557,	'circuit',	'l',	'2002-10-23',	10,	1459),
('http://tonkas.hopto.org/EVO1/[TOP]Umah.lte',	'[TOP]Umah.lte',	'[TOP]Umah.lte',	'.',	73197,	'circuit',	'l',	'2003-01-05',	10,	1460),
('http://tonkas.hopto.org/EVO1/[ToP]XTHT.LTE',	'[ToP]XTHT.LTE',	'[ToP]XTHT.LTE',	'.',	57487,	'circuit',	'l',	'2003-04-26',	10,	1461),
('http://tonkas.hopto.org/EVO1/[top]xtt.lte',	'[top]xtt.lte',	'[top]xtt.lte',	'.',	57399,	'circuit',	'l',	'2004-06-29',	10,	1462),
('http://tonkas.hopto.org/EVO1/[xt]offrace.lte',	'[xt]offrace.lte',	'[xt]offrace.lte',	'.',	15866,	'circuit',	'l',	'2004-08-27',	10,	1463),
('http://tonkas.hopto.org/EVO1/[xt]wichway.lte',	'[xt]wichway.lte',	'[xt]wichway.lte',	'.',	18750,	'circuit',	'l',	'2004-08-27',	10,	1464);

DROP TABLE IF EXISTS `evo2`;
CREATE TABLE `evo2` (
  `url` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `track_title` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `author` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '.',
  `filesize` int NOT NULL,
  `track_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '.',
  `extension` varchar(1) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `track_date` date NOT NULL,
  `downloads` int NOT NULL DEFAULT '10',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO `evo2` (`url`, `track_title`, `description`, `author`, `filesize`, `track_type`, `extension`, `track_date`, `downloads`, `id`) VALUES
('http://tonkas.hopto.org/EVO1/!!ARENA.ZIP',	'!!ARENA.ZIP',	'!!ARENA.ZIP',	'.',	633932,	'circuit',	'z',	'2001-01-01',	10,	1),
('http://tonkas.hopto.org/EVO2/2002SX.pod',	'2002SX.pod',	'2002SX.pod',	'.',	6378706,	'circuit',	'p',	'2002-03-24',	10,	2),
('http://tonkas.hopto.org/EVO2/2002SX.ZIP',	'2002SX.ZIP',	'2002SX.ZIP',	'.',	1801919,	'circuit',	'z',	'2003-08-29',	10,	3),
('http://tonkas.hopto.org/EVO2/204bast.pod',	'204bast.pod',	'204bast.pod',	'.',	5540652,	'circuit',	'p',	'2011-09-03',	10,	4),
('http://tonkas.hopto.org/EVO2/204BAST.zip',	'204BAST.zip',	'204BAST.zip',	'.',	2439113,	'circuit',	'z',	'2011-09-03',	10,	5),
('http://tonkas.hopto.org/EVO2/204bristol.lte',	'204bristol.lte',	'204bristol.lte',	'.',	26435,	'circuit',	'l',	'2011-09-03',	10,	6),
('http://tonkas.hopto.org/EVO2/204contour.lte',	'204contour.lte',	'204contour.lte',	'.',	32507,	'circuit',	'l',	'2011-09-03',	10,	7),
('http://tonkas.hopto.org/EVO2/204JELRL.pod',	'204JELRL.pod',	'204JELRL.pod',	'.',	7446499,	'circuit',	'p',	'2011-09-03',	10,	8),
('http://tonkas.hopto.org/EVO2/204JELRL.zip',	'204JELRL.zip',	'204JELRL.zip',	'.',	2902463,	'circuit',	'z',	'2005-03-09',	10,	9),
('http://tonkas.hopto.org/EVO2/a1auto.pod',	'a1auto.pod',	'a1auto.pod',	'.',	7229581,	'circuit',	'p',	'2004-08-06',	10,	10),
('http://tonkas.hopto.org/EVO2/A1AUTO.zip',	'A1AUTO.zip',	'A1AUTO.zip',	'.',	3038665,	'circuit',	'z',	'2004-07-05',	10,	11),
('http://tonkas.hopto.org/EVO2/ABCTRAIL.pod',	'ABCTRAIL.pod',	'ABCTRAIL.pod',	'.',	9839665,	'circuit',	'p',	'2004-06-16',	10,	12),
('http://tonkas.hopto.org/EVO2/ABCTrails.zip',	'ABCTrails.zip',	'ABCTrails.zip',	'.',	4351682,	'circuit',	'z',	'2005-03-04',	10,	13),
('http://tonkas.hopto.org/EVO2/Admin.zip',	'Admin.zip',	'Admin.zip',	'.',	1253116,	'circuit',	'z',	'2003-11-04',	10,	14),
('http://tonkas.hopto.org/EVO2/african.pod',	'african.pod',	'african.pod',	'.',	20920407,	'circuit',	'p',	'2004-04-15',	10,	15),
('http://tonkas.hopto.org/EVO2/AFRICAN.ZIP',	'AFRICAN.ZIP',	'AFRICAN.ZIP',	'.',	8579726,	'circuit',	'z',	'2004-03-23',	10,	16),
('http://tonkas.hopto.org/EVO2/AGRAHBAH.pod',	'AGRAHBAH.pod',	'AGRAHBAH.pod',	'.',	15473536,	'circuit',	'p',	'2003-01-10',	10,	17),
('http://tonkas.hopto.org/EVO2/AGRAHBAH.ZIP',	'AGRAHBAH.ZIP',	'AGRAHBAH.ZIP',	'.',	5943182,	'circuit',	'z',	'2003-02-18',	10,	18),
('http://tonkas.hopto.org/EVO2/Alt2.pod',	'Alt2.pod',	'Alt2.pod',	'.',	8709684,	'circuit',	'p',	'2006-08-15',	10,	19),
('http://tonkas.hopto.org/EVO2/Alt2.zip',	'Alt2.zip',	'Alt2.zip',	'.',	3437344,	'circuit',	'z',	'2006-08-21',	10,	20),
('http://tonkas.hopto.org/EVO2/ANTARC.pod',	'ANTARC.pod',	'ANTARC.pod',	'.',	7432596,	'circuit',	'p',	'2003-07-03',	10,	21),
('http://tonkas.hopto.org/EVO2/ANTARC.ZIP',	'ANTARC.ZIP',	'ANTARC.ZIP',	'.',	2508992,	'circuit',	'z',	'2003-11-24',	10,	22),
('http://tonkas.hopto.org/EVO2/ARCHPARK.pod',	'ARCHPARK.pod',	'ARCHPARK.pod',	'.',	8516899,	'circuit',	'p',	'2007-03-17',	10,	23),
('http://tonkas.hopto.org/EVO2/ARCHPARK.zip',	'ARCHPARK.zip',	'ARCHPARK.zip',	'.',	5090997,	'circuit',	'z',	'2007-03-17',	10,	24),
('http://tonkas.hopto.org/EVO2/ASGARD.pod',	'ASGARD.pod',	'ASGARD.pod',	'.',	8545043,	'circuit',	'p',	'2003-01-18',	10,	25),
('http://tonkas.hopto.org/EVO2/ASGARD.ZIP',	'ASGARD.ZIP',	'ASGARD.ZIP',	'.',	3195185,	'circuit',	'z',	'2003-02-18',	10,	26),
('http://tonkas.hopto.org/EVO2/ashhole.lte',	'ashhole.lte',	'ashhole.lte',	'.',	98974,	'circuit',	'l',	'2005-12-18',	10,	27),
('http://tonkas.hopto.org/EVO2/ASPEN2.ZIP',	'ASPEN2.ZIP',	'ASPEN2.ZIP',	'.',	4724161,	'circuit',	'z',	'2003-12-17',	10,	28),
('http://tonkas.hopto.org/EVO2/atosnowtc.lte',	'atosnowtc.lte',	'atosnowtc.lte',	'.',	69893,	'circuit',	'l',	'2005-09-01',	10,	29),
('http://tonkas.hopto.org/EVO2/ATTACKEX.pod',	'ATTACKEX.pod',	'ATTACKEX.pod',	'.',	16519099,	'circuit',	'p',	'2004-08-07',	10,	30),
('http://tonkas.hopto.org/EVO2/ATTACKEX.zip',	'ATTACKEX.zip',	'ATTACKEX.zip',	'.',	6825143,	'circuit',	'z',	'2004-08-23',	10,	31),
('http://tonkas.hopto.org/EVO2/BADHAIR.pod',	'BADHAIR.pod',	'BADHAIR.pod',	'.',	16174138,	'circuit',	'p',	'2004-08-31',	10,	32),
('http://tonkas.hopto.org/EVO2/BADHAIR.zip',	'BADHAIR.zip',	'BADHAIR.zip',	'.',	6960750,	'circuit',	'z',	'2004-09-24',	10,	33),
('http://tonkas.hopto.org/EVO2/BADJOFF.pod',	'BADJOFF.pod',	'BADJOFF.pod',	'.',	9860912,	'circuit',	'p',	'2007-01-25',	10,	34),
('http://tonkas.hopto.org/EVO2/BADJOFF.zip',	'BADJOFF.zip',	'BADJOFF.zip',	'.',	3387793,	'circuit',	'z',	'2007-01-25',	10,	35),
('http://tonkas.hopto.org/EVO2/Bakwood1.2.zip',	'Bakwood1.2.zip',	'Bakwood1.2.zip',	'.',	3903260,	'circuit',	'z',	'2003-02-18',	10,	36),
('http://tonkas.hopto.org/EVO2/BANE.zip',	'BANE.zip',	'BANE.zip',	'.',	2906515,	'circuit',	'z',	'2004-06-03',	10,	37),
('http://tonkas.hopto.org/EVO2/BANKS4.ZIP',	'BANKS4.ZIP',	'BANKS4.ZIP',	'.',	3275573,	'circuit',	'z',	'2003-11-17',	10,	38),
('http://tonkas.hopto.org/EVO2/BCDESERT.pod',	'BCDESERT.pod',	'BCDESERT.pod',	'.',	6310741,	'circuit',	'p',	'2008-05-16',	10,	39),
('http://tonkas.hopto.org/EVO2/BCMOTO.pod',	'BCMOTO.pod',	'BCMOTO.pod',	'.',	10700791,	'circuit',	'p',	'2007-11-22',	10,	40),
('http://tonkas.hopto.org/EVO2/BCMOTO.zip',	'BCMOTO.zip',	'BCMOTO.zip',	'.',	3155200,	'circuit',	'z',	'2007-11-22',	10,	41),
('http://tonkas.hopto.org/EVO2/BCMUD.pod',	'BCMUD.pod',	'BCMUD.pod',	'.',	6391059,	'circuit',	'p',	'2008-04-11',	10,	42),
('http://tonkas.hopto.org/EVO2/BCSCRAP.pod',	'BCSCRAP.pod',	'BCSCRAP.pod',	'.',	7914143,	'circuit',	'p',	'2007-02-06',	10,	43),
('http://tonkas.hopto.org/EVO2/BCSCRAP.zip',	'BCSCRAP.zip',	'BCSCRAP.zip',	'.',	3765473,	'circuit',	'z',	'2008-09-12',	10,	44),
('http://tonkas.hopto.org/EVO2/BC_Desert_Heat.zip',	'BC_Desert_Heat.zip',	'BC_Desert_Heat.zip',	'.',	2927069,	'circuit',	'z',	'2007-11-22',	10,	45),
('http://tonkas.hopto.org/EVO2/BC_Mudwieser.zip',	'BC_Mudwieser.zip',	'BC_Mudwieser.zip',	'.',	2861881,	'circuit',	'z',	'2008-04-11',	10,	46),
('http://tonkas.hopto.org/EVO2/BDAY.ZIP',	'BDAY.ZIP',	'BDAY.ZIP',	'.',	1645981,	'circuit',	'z',	'2003-11-26',	10,	47),
('http://tonkas.hopto.org/EVO2/BEARSKN.pod',	'BEARSKN.pod',	'BEARSKN.pod',	'.',	12000158,	'circuit',	'p',	'2003-05-14',	10,	48),
('http://tonkas.hopto.org/EVO2/BEARSKN.ZIP',	'BEARSKN.ZIP',	'BEARSKN.ZIP',	'.',	5221816,	'circuit',	'z',	'2003-08-29',	10,	49),
('http://tonkas.hopto.org/EVO2/BEDROOM.ZIP',	'BEDROOM.ZIP',	'BEDROOM.ZIP',	'.',	7241653,	'circuit',	'z',	'2003-12-15',	10,	50),
('http://tonkas.hopto.org/EVO2/blametonka.lte',	'blametonka.lte',	'blametonka.lte',	'.',	25148,	'circuit',	'l',	'2004-02-11',	10,	51),
('http://tonkas.hopto.org/EVO2/BORDRACE.pod',	'BORDRACE.pod',	'BORDRACE.pod',	'.',	1399659,	'circuit',	'p',	'2005-07-23',	10,	52),
('http://tonkas.hopto.org/EVO2/BOULDER.pod',	'BOULDER.pod',	'BOULDER.pod',	'.',	7100690,	'circuit',	'p',	'2002-06-12',	10,	53),
('http://tonkas.hopto.org/EVO2/BOULDER.zip',	'BOULDER.zip',	'BOULDER.zip',	'.',	2488575,	'circuit',	'z',	'2008-09-12',	10,	54),
('http://tonkas.hopto.org/EVO2/breathe.lte',	'breathe.lte',	'breathe.lte',	'.',	74419,	'circuit',	'l',	'2005-12-30',	10,	55),
('http://tonkas.hopto.org/EVO2/broken.zip',	'broken.zip',	'broken.zip',	'.',	6033052,	'circuit',	'z',	'2004-06-03',	10,	56),
('http://tonkas.hopto.org/EVO2/BUDLITE.pod',	'BUDLITE.pod',	'BUDLITE.pod',	'.',	7220711,	'circuit',	'p',	'2002-10-04',	10,	57),
('http://tonkas.hopto.org/EVO2/BUDLITE.zip',	'BUDLITE.zip',	'BUDLITE.zip',	'.',	2426150,	'circuit',	'z',	'2008-02-23',	10,	58),
('http://tonkas.hopto.org/EVO2/BUDLITEUL2.zip',	'BUDLITEUL2.zip',	'BUDLITEUL2.zip',	'.',	2424896,	'circuit',	'z',	'2004-03-21',	10,	59),
('http://tonkas.hopto.org/EVO2/BUGATTI_PACK.POD',	'BUGATTI_PACK.POD',	'BUGATTI_PACK.POD',	'.',	23274954,	'circuit',	'p',	'2005-10-15',	10,	60),
('http://tonkas.hopto.org/EVO2/BUGGY.pod',	'BUGGY.pod',	'BUGGY.pod',	'.',	12733863,	'circuit',	'p',	'2005-10-21',	10,	61),
('http://tonkas.hopto.org/EVO2/BUGGY.zip',	'BUGGY.zip',	'BUGGY.zip',	'.',	4086114,	'circuit',	'z',	'2009-04-10',	10,	62),
('http://tonkas.hopto.org/EVO2/BUGVILLE.pod',	'BUGVILLE.pod',	'BUGVILLE.pod',	'.',	25369015,	'circuit',	'p',	'2005-10-17',	10,	63),
('http://tonkas.hopto.org/EVO2/BUGVILLE.zip',	'BUGVILLE.zip',	'BUGVILLE.zip',	'.',	9065611,	'circuit',	'z',	'2009-04-10',	10,	64),
('http://tonkas.hopto.org/EVO2/buun.pod',	'buun.pod',	'buun.pod',	'.',	14605337,	'circuit',	'p',	'2004-10-15',	10,	65),
('http://tonkas.hopto.org/EVO2/BUUN.zip',	'BUUN.zip',	'BUUN.zip',	'.',	7618923,	'circuit',	'z',	'2004-08-06',	10,	66),
('http://tonkas.hopto.org/EVO2/CABIN.POD',	'CABIN.POD',	'CABIN.POD',	'.',	27195769,	'circuit',	'p',	'2003-12-21',	10,	67),
('http://tonkas.hopto.org/EVO2/CANTPASS.zip',	'CANTPASS.zip',	'CANTPASS.zip',	'.',	7108195,	'circuit',	'z',	'2006-01-26',	10,	68),
('http://tonkas.hopto.org/EVO2/canudo.lte',	'canudo.lte',	'canudo.lte',	'.',	47503,	'circuit',	'l',	'2005-11-06',	10,	69),
('http://tonkas.hopto.org/EVO2/canyon-run2.lte',	'canyon-run2.lte',	'canyon-run2.lte',	'.',	37070,	'circuit',	'l',	'2005-11-06',	10,	70),
('http://tonkas.hopto.org/EVO2/CANYONRUN.LTE',	'CANYONRUN.LTE',	'CANYONRUN.LTE',	'.',	25319,	'circuit',	'l',	'2005-01-28',	10,	71),
('http://tonkas.hopto.org/EVO2/carwars.pod',	'carwars.pod',	'carwars.pod',	'.',	13573647,	'circuit',	'p',	'2004-11-20',	10,	72),
('http://tonkas.hopto.org/EVO2/CARWARS.zip',	'CARWARS.zip',	'CARWARS.zip',	'.',	4514585,	'circuit',	'z',	'2004-08-05',	10,	73),
('http://tonkas.hopto.org/EVO2/CAVEY.pod',	'CAVEY.pod',	'CAVEY.pod',	'.',	14336257,	'circuit',	'p',	'2006-09-05',	10,	74),
('http://tonkas.hopto.org/EVO2/CAVEY.zip',	'CAVEY.zip',	'CAVEY.zip',	'.',	6514061,	'circuit',	'z',	'2006-09-05',	10,	75),
('http://tonkas.hopto.org/EVO2/CCANYON.pod',	'CCANYON.pod',	'CCANYON.pod',	'.',	8546413,	'circuit',	'p',	'2006-08-21',	10,	76),
('http://tonkas.hopto.org/EVO2/CCANYON.zip',	'CCANYON.zip',	'CCANYON.zip',	'.',	4531411,	'circuit',	'z',	'2006-08-21',	10,	77),
('http://tonkas.hopto.org/EVO2/CELTIC.zip',	'CELTIC.zip',	'CELTIC.zip',	'.',	7356288,	'circuit',	'z',	'2005-02-12',	10,	78),
('http://tonkas.hopto.org/EVO2/challenge2.lte',	'challenge2.lte',	'challenge2.lte',	'.',	48000,	'circuit',	'l',	'2004-07-08',	10,	79),
('http://tonkas.hopto.org/EVO2/challengeb.lte',	'challengeb.lte',	'challengeb.lte',	'.',	63025,	'circuit',	'l',	'2005-06-06',	10,	80),
('http://tonkas.hopto.org/EVO2/chancex1.lte',	'chancex1.lte',	'chancex1.lte',	'.',	100327,	'circuit',	'l',	'2005-07-05',	10,	81),
('http://tonkas.hopto.org/EVO2/CHRISTA.pod',	'CHRISTA.pod',	'CHRISTA.pod',	'.',	7769682,	'circuit',	'p',	'2005-02-13',	10,	82),
('http://tonkas.hopto.org/EVO2/CHRISTA.zip',	'CHRISTA.zip',	'CHRISTA.zip',	'.',	3000276,	'circuit',	'z',	'2005-02-14',	10,	83),
('http://tonkas.hopto.org/EVO2/citizen.lte',	'citizen.lte',	'citizen.lte',	'.',	72341,	'circuit',	'l',	'2005-07-05',	10,	84),
('http://tonkas.hopto.org/EVO2/CLONOVER.ZIP',	'CLONOVER.ZIP',	'CLONOVER.ZIP',	'.',	1819759,	'circuit',	'z',	'2004-01-26',	10,	85),
('http://tonkas.hopto.org/EVO2/CNTRYRD.zip',	'CNTRYRD.zip',	'CNTRYRD.zip',	'.',	7325650,	'circuit',	'z',	'2006-01-26',	10,	86),
('http://tonkas.hopto.org/EVO2/copper.lte',	'copper.lte',	'copper.lte',	'.',	100210,	'circuit',	'l',	'2005-07-05',	10,	87),
('http://tonkas.hopto.org/EVO2/cougar.pod',	'cougar.pod',	'cougar.pod',	'.',	12442015,	'circuit',	'p',	'2004-10-19',	10,	88),
('http://tonkas.hopto.org/EVO2/COUGAR.ZIP',	'COUGAR.ZIP',	'COUGAR.ZIP',	'.',	5171932,	'circuit',	'z',	'2003-08-27',	10,	89),
('http://tonkas.hopto.org/EVO2/crater.zip',	'crater.zip',	'crater.zip',	'.',	2436708,	'circuit',	'z',	'2005-01-24',	10,	90),
('http://tonkas.hopto.org/EVO2/CRUISE.pod',	'CRUISE.pod',	'CRUISE.pod',	'.',	7963148,	'circuit',	'p',	'2006-02-12',	10,	91),
('http://tonkas.hopto.org/EVO2/CRUISE.zip',	'CRUISE.zip',	'CRUISE.zip',	'.',	4023543,	'circuit',	'z',	'2008-09-12',	10,	92),
('http://tonkas.hopto.org/EVO2/CTO.ZIP',	'CTO.ZIP',	'CTO.ZIP',	'.',	4017628,	'circuit',	'z',	'2004-06-14',	10,	93),
('http://tonkas.hopto.org/EVO2/CWMBAJA.pod',	'CWMBAJA.pod',	'CWMBAJA.pod',	'.',	8767725,	'circuit',	'p',	'2002-08-17',	10,	94),
('http://tonkas.hopto.org/EVO2/CWMBAJA.ZIP',	'CWMBAJA.ZIP',	'CWMBAJA.ZIP',	'.',	3559972,	'circuit',	'z',	'2003-12-20',	10,	95),
('http://tonkas.hopto.org/EVO2/DAPLANE.pod',	'DAPLANE.pod',	'DAPLANE.pod',	'.',	13975383,	'circuit',	'p',	'2007-11-22',	10,	96),
('http://tonkas.hopto.org/EVO2/DAPLANE.zip',	'DAPLANE.zip',	'DAPLANE.zip',	'.',	4952798,	'circuit',	'z',	'2007-11-22',	10,	97),
('http://tonkas.hopto.org/EVO2/DBOLT.pod',	'DBOLT.pod',	'DBOLT.pod',	'.',	8202807,	'circuit',	'p',	'2007-11-22',	10,	98),
('http://tonkas.hopto.org/EVO2/DBOLT.zip',	'DBOLT.zip',	'DBOLT.zip',	'.',	3664587,	'circuit',	'z',	'2007-11-22',	10,	99),
('http://tonkas.hopto.org/EVO2/Defend.pod',	'Defend.pod',	'Defend.pod',	'.',	10427653,	'circuit',	'p',	'2006-06-24',	10,	100),
('http://tonkas.hopto.org/EVO2/Defend.zip',	'Defend.zip',	'Defend.zip',	'.',	4731491,	'circuit',	'z',	'2006-06-24',	10,	101),
('http://tonkas.hopto.org/EVO2/defender.lte',	'defender.lte',	'defender.lte',	'.',	100286,	'circuit',	'l',	'2006-01-20',	10,	102),
('http://tonkas.hopto.org/EVO2/Defender.POD',	'Defender.POD',	'Defender.POD',	'.',	10321288,	'circuit',	'p',	'2008-01-08',	10,	103),
('http://tonkas.hopto.org/EVO2/Defender.zip',	'Defender.zip',	'Defender.zip',	'.',	4635418,	'circuit',	'z',	'2008-01-08',	10,	104),
('http://tonkas.hopto.org/EVO2/DEJATOO.zip',	'DEJATOO.zip',	'DEJATOO.zip',	'.',	2415407,	'circuit',	'z',	'2004-07-05',	10,	105),
('http://tonkas.hopto.org/EVO2/dejavu.pod',	'dejavu.pod',	'dejavu.pod',	'.',	15941468,	'circuit',	'p',	'2004-04-15',	10,	106),
('http://tonkas.hopto.org/EVO2/DEJAVU.ZIP',	'DEJAVU.ZIP',	'DEJAVU.ZIP',	'.',	3856079,	'circuit',	'z',	'2004-04-05',	10,	107),
('http://tonkas.hopto.org/EVO2/den3.pod',	'den3.pod',	'den3.pod',	'.',	7164022,	'circuit',	'p',	'2004-10-19',	10,	108),
('http://tonkas.hopto.org/EVO2/DEN3.zip',	'DEN3.zip',	'DEN3.zip',	'.',	3071932,	'circuit',	'z',	'2004-10-19',	10,	109),
('http://tonkas.hopto.org/EVO2/descent.pod',	'descent.pod',	'descent.pod',	'.',	24660316,	'circuit',	'p',	'2004-11-30',	10,	110),
('http://tonkas.hopto.org/EVO2/DESCENT.ZIP',	'DESCENT.ZIP',	'DESCENT.ZIP',	'.',	8949814,	'circuit',	'z',	'2003-12-08',	10,	111),
('http://tonkas.hopto.org/EVO2/DIEADAY.ZIP',	'DIEADAY.ZIP',	'DIEADAY.ZIP',	'.',	2028052,	'circuit',	'z',	'2003-02-18',	10,	112),
('http://tonkas.hopto.org/EVO2/DIPSY.pod',	'DIPSY.pod',	'DIPSY.pod',	'.',	10032490,	'circuit',	'p',	'2003-01-10',	10,	113),
('http://tonkas.hopto.org/EVO2/DIPSY.zip',	'DIPSY.zip',	'DIPSY.zip',	'.',	3261763,	'circuit',	'z',	'2005-01-25',	10,	114),
('http://tonkas.hopto.org/EVO2/DOH.pod',	'DOH.pod',	'DOH.pod',	'.',	5925836,	'circuit',	'p',	'2007-11-22',	10,	115),
('http://tonkas.hopto.org/EVO2/DOH.zip',	'DOH.zip',	'DOH.zip',	'.',	2070258,	'circuit',	'z',	'2007-11-22',	10,	116),
('http://tonkas.hopto.org/EVO2/DONKEY.pod',	'DONKEY.pod',	'DONKEY.pod',	'.',	14249949,	'circuit',	'p',	'2003-05-09',	10,	117),
('http://tonkas.hopto.org/EVO2/DONKEY.ZIP',	'DONKEY.ZIP',	'DONKEY.ZIP',	'.',	6967485,	'circuit',	'z',	'2003-11-05',	10,	118),
('http://tonkas.hopto.org/EVO2/DOOMISLE.ZIP',	'DOOMISLE.ZIP',	'DOOMISLE.ZIP',	'.',	4499370,	'circuit',	'z',	'2003-02-18',	10,	119),
('http://tonkas.hopto.org/EVO2/DOWNHILL.POD',	'DOWNHILL.POD',	'DOWNHILL.POD',	'.',	24881147,	'circuit',	'p',	'2004-03-23',	10,	120),
('http://tonkas.hopto.org/EVO2/DOWNHILL.ZIP',	'DOWNHILL.ZIP',	'DOWNHILL.ZIP',	'.',	7832295,	'circuit',	'z',	'2004-03-23',	10,	121),
('http://tonkas.hopto.org/EVO2/DRECON.ZIP',	'DRECON.ZIP',	'DRECON.ZIP',	'.',	4763236,	'circuit',	'z',	'2003-08-22',	10,	122),
('http://tonkas.hopto.org/EVO2/DRIFTS.ZIP',	'DRIFTS.ZIP',	'DRIFTS.ZIP',	'.',	6932274,	'circuit',	'z',	'2004-01-23',	10,	123),
('http://tonkas.hopto.org/EVO2/DSNOWNA2.ZIP',	'DSNOWNA2.ZIP',	'DSNOWNA2.ZIP',	'.',	2545651,	'circuit',	'z',	'2003-11-24',	10,	124),
('http://tonkas.hopto.org/EVO2/DTSBJA03.ZIP',	'DTSBJA03.ZIP',	'DTSBJA03.ZIP',	'.',	4772397,	'circuit',	'z',	'2003-02-20',	10,	125),
('http://tonkas.hopto.org/EVO2/EBPCREATINA.LTE',	'EBPCREATINA.LTE',	'EBPCREATINA.LTE',	'.',	24928,	'circuit',	'l',	'2006-01-11',	10,	126),
('http://tonkas.hopto.org/EVO2/EBPOGURA.LTE',	'EBPOGURA.LTE',	'EBPOGURA.LTE',	'.',	26451,	'circuit',	'l',	'2005-10-10',	10,	127),
('http://tonkas.hopto.org/EVO2/EBPTropicalha.lte',	'EBPTropicalha.lte',	'EBPTropicalha.lte',	'.',	28336,	'circuit',	'l',	'2005-10-10',	10,	128),
('http://tonkas.hopto.org/EVO2/ELKCREEK.zip',	'ELKCREEK.zip',	'ELKCREEK.zip',	'.',	2366052,	'circuit',	'z',	'2004-06-03',	10,	129),
('http://tonkas.hopto.org/EVO2/ENDLESS.pod',	'ENDLESS.pod',	'ENDLESS.pod',	'.',	9118488,	'circuit',	'p',	'2004-04-17',	10,	130),
('http://tonkas.hopto.org/EVO2/enm.pod',	'enm.pod',	'enm.pod',	'.',	6124707,	'circuit',	'p',	'2004-04-15',	10,	131),
('http://tonkas.hopto.org/EVO2/ENM.zip',	'ENM.zip',	'ENM.zip',	'.',	2214450,	'circuit',	'z',	'2004-06-03',	10,	132),
('http://tonkas.hopto.org/EVO2/equinox1.pod',	'equinox1.pod',	'equinox1.pod',	'.',	7806342,	'circuit',	'p',	'2004-10-29',	10,	133),
('http://tonkas.hopto.org/EVO2/EQUINOX1.zip',	'EQUINOX1.zip',	'EQUINOX1.zip',	'.',	3002039,	'circuit',	'z',	'2004-10-19',	10,	134),
('http://tonkas.hopto.org/EVO2/FALLCL.ZIP',	'FALLCL.ZIP',	'FALLCL.ZIP',	'.',	2797145,	'circuit',	'z',	'2003-02-18',	10,	135),
('http://tonkas.hopto.org/EVO2/FARPOINT.POD',	'FARPOINT.POD',	'FARPOINT.POD',	'.',	13660872,	'circuit',	'p',	'2004-04-15',	10,	136),
('http://tonkas.hopto.org/EVO2/FARPOINT.ZIP',	'FARPOINT.ZIP',	'FARPOINT.ZIP',	'.',	4945951,	'circuit',	'z',	'2004-03-23',	10,	137),
('http://tonkas.hopto.org/EVO2/FENDER3.zip',	'FENDER3.zip',	'FENDER3.zip',	'.',	2209504,	'circuit',	'z',	'2004-09-29',	10,	138),
('http://tonkas.hopto.org/EVO2/FEWER.pod',	'FEWER.pod',	'FEWER.pod',	'.',	8560055,	'circuit',	'p',	'2007-11-22',	10,	139),
('http://tonkas.hopto.org/EVO2/FEWER.zip',	'FEWER.zip',	'FEWER.zip',	'.',	2671961,	'circuit',	'z',	'2007-11-22',	10,	140),
('http://tonkas.hopto.org/EVO2/fig8.pod',	'fig8.pod',	'fig8.pod',	'.',	6892401,	'circuit',	'p',	'2004-10-15',	10,	141),
('http://tonkas.hopto.org/EVO2/FIG8.ZIP',	'FIG8.ZIP',	'FIG8.ZIP',	'.',	2172272,	'circuit',	'z',	'2003-11-17',	10,	142),
('http://tonkas.hopto.org/EVO2/FIRSTBLD.ZIP',	'FIRSTBLD.ZIP',	'FIRSTBLD.ZIP',	'.',	3479155,	'circuit',	'z',	'2003-08-28',	10,	143),
('http://tonkas.hopto.org/EVO2/FORDRACE.ZIP',	'FORDRACE.ZIP',	'FORDRACE.ZIP',	'.',	2081415,	'circuit',	'z',	'2003-02-18',	10,	144),
('http://tonkas.hopto.org/EVO2/FORMULA.pod',	'FORMULA.pod',	'FORMULA.pod',	'.',	13950434,	'circuit',	'p',	'2003-09-11',	10,	145),
('http://tonkas.hopto.org/EVO2/FORMULA.ZIP',	'FORMULA.ZIP',	'FORMULA.ZIP',	'.',	4013605,	'circuit',	'z',	'2003-12-08',	10,	146),
('http://tonkas.hopto.org/EVO2/FTRSTAD.ZIP',	'FTRSTAD.ZIP',	'FTRSTAD.ZIP',	'.',	1523457,	'circuit',	'z',	'2004-09-24',	10,	147),
('http://tonkas.hopto.org/EVO2/FUNRUN.pod',	'FUNRUN.pod',	'FUNRUN.pod',	'.',	7582556,	'circuit',	'p',	'2005-01-18',	10,	148),
('http://tonkas.hopto.org/EVO2/FUNRUN.zip',	'FUNRUN.zip',	'FUNRUN.zip',	'.',	2229539,	'circuit',	'z',	'2005-01-19',	10,	149),
('http://tonkas.hopto.org/EVO2/FUOW.pod',	'FUOW.pod',	'FUOW.pod',	'.',	1397844,	'circuit',	'p',	'2007-10-02',	10,	150),
('http://tonkas.hopto.org/EVO2/FXBMXSX.ZIP',	'FXBMXSX.ZIP',	'FXBMXSX.ZIP',	'.',	2893633,	'circuit',	'z',	'2003-02-18',	10,	151),
('http://tonkas.hopto.org/EVO2/GARMUNDI.pod',	'GARMUNDI.pod',	'GARMUNDI.pod',	'.',	8060246,	'circuit',	'p',	'2003-10-02',	10,	152),
('http://tonkas.hopto.org/EVO2/GARMUNDI.ZIP',	'GARMUNDI.ZIP',	'GARMUNDI.ZIP',	'.',	2745936,	'circuit',	'z',	'2003-11-17',	10,	153),
('http://tonkas.hopto.org/EVO2/GEEZER.ZIP',	'GEEZER.ZIP',	'GEEZER.ZIP',	'.',	3437666,	'circuit',	'z',	'2003-11-24',	10,	154),
('http://tonkas.hopto.org/EVO2/GENERA.pod',	'GENERA.pod',	'GENERA.pod',	'.',	11497494,	'circuit',	'p',	'2005-11-03',	10,	155),
('http://tonkas.hopto.org/EVO2/GENERA.zip',	'GENERA.zip',	'GENERA.zip',	'.',	4012937,	'circuit',	'z',	'2009-05-31',	10,	156),
('http://tonkas.hopto.org/EVO2/GETAGRIP.pod',	'GETAGRIP.pod',	'GETAGRIP.pod',	'.',	10070500,	'circuit',	'p',	'2007-11-22',	10,	157),
('http://tonkas.hopto.org/EVO2/GETAGRIP.ZIP',	'GETAGRIP.ZIP',	'GETAGRIP.ZIP',	'.',	4227966,	'circuit',	'z',	'2003-02-18',	10,	158),
('http://tonkas.hopto.org/EVO2/go1.lte',	'go1.lte',	'go1.lte',	'.',	27221,	'circuit',	'l',	'2005-01-08',	10,	159),
('http://tonkas.hopto.org/EVO2/go2.lte',	'go2.lte',	'go2.lte',	'.',	19049,	'circuit',	'l',	'2005-12-30',	10,	160),
('http://tonkas.hopto.org/EVO2/go5.lte',	'go5.lte',	'go5.lte',	'.',	31466,	'circuit',	'l',	'2005-02-14',	10,	161),
('http://tonkas.hopto.org/EVO2/goat2002.pod',	'goat2002.pod',	'goat2002.pod',	'.',	12023968,	'circuit',	'p',	'2004-04-15',	10,	162),
('http://tonkas.hopto.org/EVO2/GOAT2002.ZIP',	'GOAT2002.ZIP',	'GOAT2002.ZIP',	'.',	3776004,	'circuit',	'z',	'2004-03-23',	10,	163),
('http://tonkas.hopto.org/EVO2/GRAVEL.zip',	'GRAVEL.zip',	'GRAVEL.zip',	'.',	3792466,	'circuit',	'z',	'2004-09-24',	10,	164),
('http://tonkas.hopto.org/EVO2/GROMIT2.ZIP',	'GROMIT2.ZIP',	'GROMIT2.ZIP',	'.',	5215934,	'circuit',	'z',	'2003-12-08',	10,	165),
('http://tonkas.hopto.org/EVO2/grstkiss.pod',	'grstkiss.pod',	'grstkiss.pod',	'.',	6800197,	'circuit',	'p',	'2004-04-15',	10,	166),
('http://tonkas.hopto.org/EVO2/GRSTKISS.ZIP',	'GRSTKISS.ZIP',	'GRSTKISS.ZIP',	'.',	2117094,	'circuit',	'z',	'2004-03-21',	10,	167),
('http://tonkas.hopto.org/EVO2/GTOFORST.ZIP',	'GTOFORST.ZIP',	'GTOFORST.ZIP',	'.',	3163456,	'circuit',	'z',	'2005-01-24',	10,	168),
('http://tonkas.hopto.org/EVO2/halfpipe.pod',	'halfpipe.pod',	'halfpipe.pod',	'.',	12295327,	'circuit',	'p',	'2004-06-14',	10,	169),
('http://tonkas.hopto.org/EVO2/HALFPIPE.zip',	'HALFPIPE.zip',	'HALFPIPE.zip',	'.',	3685766,	'circuit',	'z',	'2004-06-14',	10,	170),
('http://tonkas.hopto.org/EVO2/hardcore.lte',	'hardcore.lte',	'hardcore.lte',	'.',	48317,	'circuit',	'l',	'2005-10-10',	10,	171),
('http://tonkas.hopto.org/EVO2/hardrockx.lte',	'hardrockx.lte',	'hardrockx.lte',	'.',	71365,	'circuit',	'l',	'2005-10-10',	10,	172),
('http://tonkas.hopto.org/EVO2/HAWK1.lte',	'HAWK1.lte',	'HAWK1.lte',	'.',	83277,	'circuit',	'l',	'2005-03-06',	10,	173),
('http://tonkas.hopto.org/EVO2/hawk2.lte',	'hawk2.lte',	'hawk2.lte',	'.',	73479,	'circuit',	'l',	'2005-08-29',	10,	174),
('http://tonkas.hopto.org/EVO2/HAWKISH.zip',	'HAWKISH.zip',	'HAWKISH.zip',	'.',	4271337,	'circuit',	'z',	'2004-09-24',	10,	175),
('http://tonkas.hopto.org/EVO2/HAZLHIWY.ZIP',	'HAZLHIWY.ZIP',	'HAZLHIWY.ZIP',	'.',	4334097,	'circuit',	'z',	'2003-08-22',	10,	176),
('http://tonkas.hopto.org/EVO2/HDRKCLM2.ZIP',	'HDRKCLM2.ZIP',	'HDRKCLM2.ZIP',	'.',	2342617,	'circuit',	'z',	'2003-11-17',	10,	177),
('http://tonkas.hopto.org/EVO2/HHC2.POD',	'HHC2.POD',	'HHC2.POD',	'.',	1488897,	'circuit',	'p',	'2004-03-09',	10,	178),
('http://tonkas.hopto.org/EVO2/HHC2.ZIP',	'HHC2.ZIP',	'HHC2.ZIP',	'.',	301488,	'circuit',	'z',	'2004-03-09',	10,	179),
('http://tonkas.hopto.org/EVO2/HiddenHillClimb2.lte',	'HiddenHillClimb2.lte',	'HiddenHillClimb2.lte',	'.',	10681,	'circuit',	'l',	'2003-10-16',	10,	180),
('http://tonkas.hopto.org/EVO2/hiddenhillclimb3.lte',	'hiddenhillclimb3.lte',	'hiddenhillclimb3.lte',	'.',	13579,	'circuit',	'l',	'2003-12-30',	10,	181),
('http://tonkas.hopto.org/EVO2/hiddenhillclimb5.lte',	'hiddenhillclimb5.lte',	'hiddenhillclimb5.lte',	'.',	33998,	'circuit',	'l',	'2005-06-09',	10,	182),
('http://tonkas.hopto.org/EVO2/HIGHCTRY.zip',	'HIGHCTRY.zip',	'HIGHCTRY.zip',	'.',	5384472,	'circuit',	'z',	'2004-08-05',	10,	183),
('http://tonkas.hopto.org/EVO2/HILBILY.ZIP',	'HILBILY.ZIP',	'HILBILY.ZIP',	'.',	1071430,	'circuit',	'z',	'2003-11-17',	10,	184),
('http://tonkas.hopto.org/EVO2/hildonen.pod',	'hildonen.pod',	'hildonen.pod',	'.',	14174218,	'circuit',	'p',	'2007-01-25',	10,	185),
('http://tonkas.hopto.org/EVO2/HILDONEN.zip',	'HILDONEN.zip',	'HILDONEN.zip',	'.',	5080290,	'circuit',	'z',	'2004-10-31',	10,	186),
('http://tonkas.hopto.org/EVO2/hillclimbhell.lte',	'hillclimbhell.lte',	'hillclimbhell.lte',	'.',	50623,	'circuit',	'l',	'2005-09-12',	10,	187),
('http://tonkas.hopto.org/EVO2/HOPPING.pod',	'HOPPING.pod',	'HOPPING.pod',	'.',	8855336,	'circuit',	'p',	'2007-11-22',	10,	188),
('http://tonkas.hopto.org/EVO2/HOPPING.zip',	'HOPPING.zip',	'HOPPING.zip',	'.',	2652371,	'circuit',	'z',	'2007-11-22',	10,	189),
('http://tonkas.hopto.org/EVO2/HZHEIGTS.ZIP',	'HZHEIGTS.ZIP',	'HZHEIGTS.ZIP',	'.',	4385241,	'circuit',	'z',	'2003-11-17',	10,	190),
('http://tonkas.hopto.org/EVO2/iceage.pod',	'iceage.pod',	'iceage.pod',	'.',	5146922,	'circuit',	'p',	'2004-12-06',	10,	191),
('http://tonkas.hopto.org/EVO2/ICEAGE.ZIP',	'ICEAGE.ZIP',	'ICEAGE.ZIP',	'.',	1874288,	'circuit',	'z',	'2003-11-24',	10,	192),
('http://tonkas.hopto.org/EVO2/iceage2.pod',	'iceage2.pod',	'iceage2.pod',	'.',	12691596,	'circuit',	'p',	'2004-04-15',	10,	193),
('http://tonkas.hopto.org/EVO2/ICEAGE2.ZIP',	'ICEAGE2.ZIP',	'ICEAGE2.ZIP',	'.',	6964919,	'circuit',	'z',	'2003-11-27',	10,	194),
('http://tonkas.hopto.org/EVO2/ILDONEN.zip',	'ILDONEN.zip',	'ILDONEN.zip',	'.',	5083308,	'circuit',	'z',	'2007-01-25',	10,	195),
('http://tonkas.hopto.org/EVO2/IMLOOPY.pod',	'IMLOOPY.pod',	'IMLOOPY.pod',	'.',	7068822,	'circuit',	'p',	'2007-03-17',	10,	196),
('http://tonkas.hopto.org/EVO2/IMLOOPY.zip',	'IMLOOPY.zip',	'IMLOOPY.zip',	'.',	2276836,	'circuit',	'z',	'2007-01-25',	10,	197),
('http://tonkas.hopto.org/EVO2/ISDONUTS.zip',	'ISDONUTS.zip',	'ISDONUTS.zip',	'.',	2887570,	'circuit',	'z',	'2004-06-03',	10,	198),
('http://tonkas.hopto.org/EVO2/island2.pod',	'island2.pod',	'island2.pod',	'.',	10533295,	'circuit',	'p',	'2005-01-08',	10,	199),
('http://tonkas.hopto.org/EVO2/isstrip.zip',	'isstrip.zip',	'isstrip.zip',	'.',	2393601,	'circuit',	'z',	'2005-01-24',	10,	200),
('http://tonkas.hopto.org/EVO2/JEDI.POD',	'JEDI.POD',	'JEDI.POD',	'.',	1827649,	'circuit',	'p',	'2004-03-05',	10,	201),
('http://tonkas.hopto.org/EVO2/JEDI.ZIP',	'JEDI.ZIP',	'JEDI.ZIP',	'.',	476554,	'circuit',	'z',	'2003-01-19',	10,	202),
('http://tonkas.hopto.org/EVO2/JEDIBLU.POD',	'JEDIBLU.POD',	'JEDIBLU.POD',	'.',	19383705,	'circuit',	'p',	'2004-11-26',	10,	203),
('http://tonkas.hopto.org/EVO2/JEDIBLU.zip',	'JEDIBLU.zip',	'JEDIBLU.zip',	'.',	5872080,	'circuit',	'z',	'2004-11-26',	10,	204),
('http://tonkas.hopto.org/EVO2/JediBlu2.lte',	'JediBlu2.lte',	'JediBlu2.lte',	'.',	73784,	'circuit',	'l',	'2004-06-29',	10,	205),
('http://tonkas.hopto.org/EVO2/JediBlueridge.lte',	'JediBlueridge.lte',	'JediBlueridge.lte',	'.',	70048,	'circuit',	'l',	'2005-06-20',	10,	206),
('http://tonkas.hopto.org/EVO2/JediBlueridge2.lte',	'JediBlueridge2.lte',	'JediBlueridge2.lte',	'.',	67076,	'circuit',	'l',	'2005-11-06',	10,	207),
('http://tonkas.hopto.org/EVO2/jedibrrr.lte',	'jedibrrr.lte',	'jedibrrr.lte',	'.',	52981,	'circuit',	'l',	'2004-07-02',	10,	208),
('http://tonkas.hopto.org/EVO2/JEDIELIM.pod',	'JEDIELIM.pod',	'JEDIELIM.pod',	'.',	13673053,	'circuit',	'p',	'2007-01-15',	10,	209),
('http://tonkas.hopto.org/EVO2/JEDIELIM.zip',	'JEDIELIM.zip',	'JEDIELIM.zip',	'.',	4383069,	'circuit',	'z',	'2007-01-15',	10,	210),
('http://tonkas.hopto.org/EVO2/JEDIELIM2.ZIP',	'JEDIELIM2.ZIP',	'JEDIELIM2.ZIP',	'.',	4439521,	'circuit',	'z',	'2004-10-21',	10,	211),
('http://tonkas.hopto.org/EVO2/JEDIEVO2-2.zip',	'JEDIEVO2-2.zip',	'JEDIEVO2-2.zip',	'.',	342061,	'circuit',	'z',	'2004-04-08',	10,	212),
('http://tonkas.hopto.org/EVO2/JEDIEVO2.POD',	'JEDIEVO2.POD',	'JEDIEVO2.POD',	'.',	12474755,	'circuit',	'p',	'2004-07-18',	10,	213),
('http://tonkas.hopto.org/EVO2/JEDIEVO2.ZIP',	'JEDIEVO2.ZIP',	'JEDIEVO2.ZIP',	'.',	4046678,	'circuit',	'z',	'2004-07-18',	10,	214),
('http://tonkas.hopto.org/EVO2/JediEvolution.lte',	'JediEvolution.lte',	'JediEvolution.lte',	'.',	79048,	'circuit',	'l',	'2005-06-15',	10,	215),
('http://tonkas.hopto.org/EVO2/JEDIEW.pod',	'JEDIEW.pod',	'JEDIEW.pod',	'.',	1394769,	'circuit',	'p',	'2004-07-22',	10,	216),
('http://tonkas.hopto.org/EVO2/jediextreme.lte',	'jediextreme.lte',	'jediextreme.lte',	'.',	64780,	'circuit',	'l',	'2006-01-08',	10,	217),
('http://tonkas.hopto.org/EVO2/JEDILEDG.POD',	'JEDILEDG.POD',	'JEDILEDG.POD',	'.',	7060014,	'circuit',	'p',	'2004-03-09',	10,	218),
('http://tonkas.hopto.org/EVO2/JEDILEDG.ZIP',	'JEDILEDG.ZIP',	'JEDILEDG.ZIP',	'.',	2913864,	'circuit',	'z',	'2004-03-09',	10,	219),
('http://tonkas.hopto.org/EVO2/JediLegend.lte',	'JediLegend.lte',	'JediLegend.lte',	'.',	69084,	'circuit',	'l',	'2005-06-21',	10,	220),
('http://tonkas.hopto.org/EVO2/JEDIMUDD.POD',	'JEDIMUDD.POD',	'JEDIMUDD.POD',	'.',	7393497,	'circuit',	'p',	'2004-01-30',	10,	221),
('http://tonkas.hopto.org/EVO2/JEDIMUDD.ZIP',	'JEDIMUDD.ZIP',	'JEDIMUDD.ZIP',	'.',	2711784,	'circuit',	'z',	'2003-09-03',	10,	222),
('http://tonkas.hopto.org/EVO2/JEDINEB.POD',	'JEDINEB.POD',	'JEDINEB.POD',	'.',	8789124,	'circuit',	'p',	'2005-05-23',	10,	223),
('http://tonkas.hopto.org/EVO2/JEDINEB.ZIP',	'JEDINEB.ZIP',	'JEDINEB.ZIP',	'.',	3317689,	'circuit',	'z',	'2004-08-22',	10,	224),
('http://tonkas.hopto.org/EVO2/JediNebula.lte',	'JediNebula.lte',	'JediNebula.lte',	'.',	69400,	'circuit',	'l',	'2005-06-12',	10,	225),
('http://tonkas.hopto.org/EVO2/JEDIPOW.pod',	'JEDIPOW.pod',	'JEDIPOW.pod',	'.',	16922604,	'circuit',	'p',	'2004-10-16',	10,	226),
('http://tonkas.hopto.org/EVO2/JEDIPOW.ZIP',	'JEDIPOW.ZIP',	'JEDIPOW.ZIP',	'.',	4519892,	'circuit',	'z',	'2004-10-16',	10,	227),
('http://tonkas.hopto.org/EVO2/Jedipunisher.lte',	'Jedipunisher.lte',	'Jedipunisher.lte',	'.',	70678,	'circuit',	'l',	'2005-12-06',	10,	228),
('http://tonkas.hopto.org/EVO2/Jedisimson.lte',	'Jedisimson.lte',	'Jedisimson.lte',	'.',	35513,	'circuit',	'l',	'2005-06-20',	10,	229),
('http://tonkas.hopto.org/EVO2/JediSkie.lte',	'JediSkie.lte',	'JediSkie.lte',	'.',	43065,	'circuit',	'l',	'2003-10-26',	10,	230),
('http://tonkas.hopto.org/EVO2/JediSpeedway.lte',	'JediSpeedway.lte',	'JediSpeedway.lte',	'.',	60436,	'circuit',	'l',	'2005-06-30',	10,	231),
('http://tonkas.hopto.org/EVO2/JEDISTYL.POD',	'JEDISTYL.POD',	'JEDISTYL.POD',	'.',	2533476,	'circuit',	'p',	'2004-03-05',	10,	232),
('http://tonkas.hopto.org/EVO2/JEDISTYL.ZIP',	'JEDISTYL.ZIP',	'JEDISTYL.ZIP',	'.',	663016,	'circuit',	'z',	'2003-01-19',	10,	233),
('http://tonkas.hopto.org/EVO2/JediSubzero.lte',	'JediSubzero.lte',	'JediSubzero.lte',	'.',	29257,	'circuit',	'l',	'2003-10-26',	10,	234),
('http://tonkas.hopto.org/EVO2/JEDISW.pod',	'JEDISW.pod',	'JEDISW.pod',	'.',	3664153,	'circuit',	'p',	'2004-10-31',	10,	235),
('http://tonkas.hopto.org/EVO2/JEDISW.zip',	'JEDISW.zip',	'JEDISW.zip',	'.',	1069533,	'circuit',	'z',	'2004-10-31',	10,	236),
('http://tonkas.hopto.org/EVO2/Jeditherapy.lte',	'Jeditherapy.lte',	'Jeditherapy.lte',	'.',	71005,	'circuit',	'l',	'2005-06-07',	10,	237),
('http://tonkas.hopto.org/EVO2/Jedithunderzone.lte',	'Jedithunderzone.lte',	'Jedithunderzone.lte',	'.',	78573,	'circuit',	'l',	'2005-06-07',	10,	238),
('http://tonkas.hopto.org/EVO2/JEDITRY.POD',	'JEDITRY.POD',	'JEDITRY.POD',	'.',	18407546,	'circuit',	'p',	'2004-05-31',	10,	239),
('http://tonkas.hopto.org/EVO2/JEDITRY.ZIP',	'JEDITRY.ZIP',	'JEDITRY.ZIP',	'.',	5257606,	'circuit',	'z',	'2007-01-15',	10,	240),
('http://tonkas.hopto.org/EVO2/JEDITZ.pod',	'JEDITZ.pod',	'JEDITZ.pod',	'.',	2302669,	'circuit',	'p',	'2004-11-25',	10,	241),
('http://tonkas.hopto.org/EVO2/JEDITZ.zip',	'JEDITZ.zip',	'JEDITZ.zip',	'.',	600151,	'circuit',	'z',	'2004-08-22',	10,	242),
('http://tonkas.hopto.org/EVO2/JEDIWAT2.pod',	'JEDIWAT2.pod',	'JEDIWAT2.pod',	'.',	1663895,	'circuit',	'p',	'2004-09-17',	10,	243),
('http://tonkas.hopto.org/EVO2/JEDIWAVE.pod',	'JEDIWAVE.pod',	'JEDIWAVE.pod',	'.',	1929798,	'circuit',	'p',	'2002-06-12',	10,	244),
('http://tonkas.hopto.org/EVO2/JEDIWAVE.ZIP',	'JEDIWAVE.ZIP',	'JEDIWAVE.ZIP',	'.',	517195,	'circuit',	'z',	'2003-01-19',	10,	245),
('http://tonkas.hopto.org/EVO2/JEDIWHAT-1.pod',	'JEDIWHAT-1.pod',	'JEDIWHAT-1.pod',	'.',	2632341,	'circuit',	'p',	'2004-09-09',	10,	246),
('http://tonkas.hopto.org/EVO2/JEDIWHAT-2.pod',	'JEDIWHAT-2.pod',	'JEDIWHAT-2.pod',	'.',	3314205,	'circuit',	'p',	'2004-09-16',	10,	247),
('http://tonkas.hopto.org/EVO2/JEDIWHAT.pod',	'JEDIWHAT.pod',	'JEDIWHAT.pod',	'.',	11634658,	'circuit',	'p',	'2004-10-17',	10,	248),
('http://tonkas.hopto.org/EVO2/JEDIWHAT.zip',	'JEDIWHAT.zip',	'JEDIWHAT.zip',	'.',	525591,	'circuit',	'z',	'2004-09-13',	10,	249),
('http://tonkas.hopto.org/EVO2/JEDIWHAT2.pod',	'JEDIWHAT2.pod',	'JEDIWHAT2.pod',	'.',	2877189,	'circuit',	'p',	'2004-09-12',	10,	250),
('http://tonkas.hopto.org/EVO2/Jedi_new.zip',	'Jedi_new.zip',	'Jedi_new.zip',	'.',	1129173,	'circuit',	'z',	'2004-02-01',	10,	251),
('http://tonkas.hopto.org/EVO2/JEEP_102.ZIP',	'JEEP_102.ZIP',	'JEEP_102.ZIP',	'.',	5555181,	'circuit',	'z',	'2003-02-22',	10,	252),
('http://tonkas.hopto.org/EVO2/JOUST.pod',	'JOUST.pod',	'JOUST.pod',	'.',	9589420,	'circuit',	'p',	'2002-01-30',	10,	253),
('http://tonkas.hopto.org/EVO2/JOUST.zip',	'JOUST.zip',	'JOUST.zip',	'.',	4319759,	'circuit',	'z',	'2008-09-12',	10,	254),
('http://tonkas.hopto.org/EVO2/JUNGFEV.ZIP',	'JUNGFEV.ZIP',	'JUNGFEV.ZIP',	'.',	7074513,	'circuit',	'z',	'2003-11-17',	10,	255),
('http://tonkas.hopto.org/EVO2/JUSWRLLY.zip',	'JUSWRLLY.zip',	'JUSWRLLY.zip',	'.',	4499119,	'circuit',	'z',	'2004-08-06',	10,	256),
('http://tonkas.hopto.org/EVO2/KART.ZIP',	'KART.ZIP',	'KART.ZIP',	'.',	4880686,	'circuit',	'z',	'2003-11-24',	10,	257),
('http://tonkas.hopto.org/EVO2/KAYENTA.pod',	'KAYENTA.pod',	'KAYENTA.pod',	'.',	9096051,	'circuit',	'p',	'2005-02-10',	10,	258),
('http://tonkas.hopto.org/EVO2/KAYENTA.zip',	'KAYENTA.zip',	'KAYENTA.zip',	'.',	3551011,	'circuit',	'z',	'2005-02-12',	10,	259),
('http://tonkas.hopto.org/EVO2/KC.ZIP',	'KC.ZIP',	'KC.ZIP',	'.',	2773142,	'circuit',	'z',	'2003-02-20',	10,	260),
('http://tonkas.hopto.org/EVO2/keifer2.pod',	'keifer2.pod',	'keifer2.pod',	'.',	10428380,	'circuit',	'p',	'2004-06-14',	10,	261),
('http://tonkas.hopto.org/EVO2/KEIFER2.zip',	'KEIFER2.zip',	'KEIFER2.zip',	'.',	4456763,	'circuit',	'z',	'2004-06-14',	10,	262),
('http://tonkas.hopto.org/EVO2/LaNeige.zip',	'LaNeige.zip',	'LaNeige.zip',	'.',	5846454,	'circuit',	'z',	'2003-12-12',	10,	263),
('http://tonkas.hopto.org/EVO2/LFEBEACH.ZIP',	'LFEBEACH.ZIP',	'LFEBEACH.ZIP',	'.',	5184281,	'circuit',	'z',	'2003-02-18',	10,	264),
('http://tonkas.hopto.org/EVO2/LIGHTUP.pod',	'LIGHTUP.pod',	'LIGHTUP.pod',	'.',	8995903,	'circuit',	'p',	'2007-11-22',	10,	265),
('http://tonkas.hopto.org/EVO2/LIGHTUP.zip',	'LIGHTUP.zip',	'LIGHTUP.zip',	'.',	3278923,	'circuit',	'z',	'2007-11-22',	10,	266),
('http://tonkas.hopto.org/EVO2/livinntheedge3.zip',	'livinntheedge3.zip',	'livinntheedge3.zip',	'.',	744005,	'circuit',	'z',	'2003-11-17',	10,	267),
('http://tonkas.hopto.org/EVO2/LIVNEDGE.ZIP',	'LIVNEDGE.ZIP',	'LIVNEDGE.ZIP',	'.',	4177792,	'circuit',	'z',	'2003-02-18',	10,	268),
('http://tonkas.hopto.org/EVO2/loogylne.pod',	'loogylne.pod',	'loogylne.pod',	'.',	19493698,	'circuit',	'p',	'2004-04-15',	10,	269),
('http://tonkas.hopto.org/EVO2/LOOGYLNE.ZIP',	'LOOGYLNE.ZIP',	'LOOGYLNE.ZIP',	'.',	5771439,	'circuit',	'z',	'2004-01-23',	10,	270),
('http://tonkas.hopto.org/EVO2/LOOKOUT.ZIP',	'LOOKOUT.ZIP',	'LOOKOUT.ZIP',	'.',	3132052,	'circuit',	'z',	'2003-12-12',	10,	271),
('http://tonkas.hopto.org/EVO2/lostisland.lte',	'lostisland.lte',	'lostisland.lte',	'.',	57637,	'circuit',	'l',	'2006-01-19',	10,	272),
('http://tonkas.hopto.org/EVO2/LOWDOON.pod',	'LOWDOON.pod',	'LOWDOON.pod',	'.',	14301001,	'circuit',	'p',	'2007-11-22',	10,	273),
('http://tonkas.hopto.org/EVO2/LOWDOON.zip',	'LOWDOON.zip',	'LOWDOON.zip',	'.',	5460459,	'circuit',	'z',	'2007-11-22',	10,	274),
('http://tonkas.hopto.org/EVO2/lte.zip',	'lte.zip',	'lte.zip',	'.',	29493777,	'circuit',	'z',	'2005-01-22',	10,	275),
('http://tonkas.hopto.org/EVO2/lunar4x4.pod',	'lunar4x4.pod',	'lunar4x4.pod',	'.',	3644204,	'circuit',	'p',	'2005-05-06',	10,	276),
('http://tonkas.hopto.org/EVO2/mad.pod',	'mad.pod',	'mad.pod',	'.',	9113757,	'circuit',	'p',	'2004-10-09',	10,	277),
('http://tonkas.hopto.org/EVO2/mad.zip',	'mad.zip',	'mad.zip',	'.',	1536241,	'circuit',	'z',	'2004-10-09',	10,	278),
('http://tonkas.hopto.org/EVO2/MAGMACTY.pod',	'MAGMACTY.pod',	'MAGMACTY.pod',	'.',	18414399,	'circuit',	'p',	'2003-04-23',	10,	279),
('http://tonkas.hopto.org/EVO2/MAGMACTY.zip',	'MAGMACTY.zip',	'MAGMACTY.zip',	'.',	5620342,	'circuit',	'z',	'2008-05-02',	10,	280),
('http://tonkas.hopto.org/EVO2/MARCOM.pod',	'MARCOM.pod',	'MARCOM.pod',	'.',	9973678,	'circuit',	'p',	'2009-04-10',	10,	281),
('http://tonkas.hopto.org/EVO2/MARCOM.zip',	'MARCOM.zip',	'MARCOM.zip',	'.',	4172353,	'circuit',	'z',	'2009-04-10',	10,	282),
('http://tonkas.hopto.org/EVO2/megarally2004.lte',	'megarally2004.lte',	'megarally2004.lte',	'.',	76015,	'circuit',	'l',	'2005-10-04',	10,	283),
('http://tonkas.hopto.org/EVO2/MIDSNIGHT.zip',	'MIDSNIGHT.zip',	'MIDSNIGHT.zip',	'.',	739486,	'circuit',	'z',	'2003-09-20',	10,	284),
('http://tonkas.hopto.org/EVO2/MIDSNITE.ZIP',	'MIDSNITE.ZIP',	'MIDSNITE.ZIP',	'.',	1296041,	'circuit',	'z',	'2003-11-09',	10,	285),
('http://tonkas.hopto.org/EVO2/mikestruck.lte',	'mikestruck.lte',	'mikestruck.lte',	'.',	5834,	'circuit',	'l',	'2005-08-29',	10,	286),
('http://tonkas.hopto.org/EVO2/mikestruckstop.lte',	'mikestruckstop.lte',	'mikestruckstop.lte',	'.',	63267,	'circuit',	'l',	'2005-08-29',	10,	287),
('http://tonkas.hopto.org/EVO2/mikestruclstop.lte',	'mikestruclstop.lte',	'mikestruclstop.lte',	'.',	5933,	'circuit',	'l',	'2005-08-29',	10,	288),
('http://tonkas.hopto.org/EVO2/minigolf.lte',	'minigolf.lte',	'minigolf.lte',	'.',	11405,	'circuit',	'l',	'2005-02-20',	10,	289),
('http://tonkas.hopto.org/EVO2/missmud.pod',	'missmud.pod',	'missmud.pod',	'.',	10570785,	'circuit',	'p',	'2004-04-15',	10,	290),
('http://tonkas.hopto.org/EVO2/MISSMUD.ZIP',	'MISSMUD.ZIP',	'MISSMUD.ZIP',	'.',	3637964,	'circuit',	'z',	'2003-08-22',	10,	291),
('http://tonkas.hopto.org/EVO2/MOAB_TRAIL.ZIP',	'MOAB_TRAIL.ZIP',	'MOAB_TRAIL.ZIP',	'.',	4011212,	'circuit',	'z',	'2003-02-18',	10,	292),
('http://tonkas.hopto.org/EVO2/MOON1.ZIP',	'MOON1.ZIP',	'MOON1.ZIP',	'.',	6451154,	'circuit',	'z',	'2003-02-18',	10,	293),
('http://tonkas.hopto.org/EVO2/moon3.pod',	'moon3.pod',	'moon3.pod',	'.',	9252717,	'circuit',	'p',	'2004-10-15',	10,	294),
('http://tonkas.hopto.org/EVO2/MOON3.zip',	'MOON3.zip',	'MOON3.zip',	'.',	3848361,	'circuit',	'z',	'2004-06-10',	10,	295),
('http://tonkas.hopto.org/EVO2/motomad.pod',	'motomad.pod',	'motomad.pod',	'.',	10663556,	'circuit',	'p',	'2004-06-20',	10,	296),
('http://tonkas.hopto.org/EVO2/MOTOMAD.zip',	'MOTOMAD.zip',	'MOTOMAD.zip',	'.',	3219110,	'circuit',	'z',	'2007-11-22',	10,	297),
('http://tonkas.hopto.org/EVO2/motor.pod',	'motor.pod',	'motor.pod',	'.',	8318624,	'circuit',	'p',	'2004-10-15',	10,	298),
('http://tonkas.hopto.org/EVO2/MOTOR.zip',	'MOTOR.zip',	'MOTOR.zip',	'.',	3470446,	'circuit',	'z',	'2004-06-14',	10,	299),
('http://tonkas.hopto.org/EVO2/Mouse.zip',	'Mouse.zip',	'Mouse.zip',	'.',	991093,	'circuit',	'z',	'2005-03-09',	10,	300),
('http://tonkas.hopto.org/EVO2/MTMII.pod',	'MTMII.pod',	'MTMII.pod',	'.',	10516992,	'circuit',	'p',	'2002-02-07',	10,	301),
('http://tonkas.hopto.org/EVO2/MTMII.zip',	'MTMII.zip',	'MTMII.zip',	'.',	2834874,	'circuit',	'z',	'2004-06-14',	10,	302),
('http://tonkas.hopto.org/EVO2/MTORALLY.pod',	'MTORALLY.pod',	'MTORALLY.pod',	'.',	16539248,	'circuit',	'p',	'2007-11-27',	10,	303),
('http://tonkas.hopto.org/EVO2/MTORALLY.zip',	'MTORALLY.zip',	'MTORALLY.zip',	'.',	5402711,	'circuit',	'z',	'2007-11-27',	10,	304),
('http://tonkas.hopto.org/EVO2/mtra.pod',	'mtra.pod',	'mtra.pod',	'.',	6317302,	'circuit',	'p',	'2008-03-25',	10,	305),
('http://tonkas.hopto.org/EVO2/MTR_Playground.zip',	'MTR_Playground.zip',	'MTR_Playground.zip',	'.',	1925954,	'circuit',	'z',	'2004-03-21',	10,	306),
('http://tonkas.hopto.org/EVO2/MU0T5A1L.pod',	'MU0T5A1L.pod',	'MU0T5A1L.pod',	'.',	15996478,	'circuit',	'p',	'2007-01-20',	10,	307),
('http://tonkas.hopto.org/EVO2/NAPSSX.zip',	'NAPSSX.zip',	'NAPSSX.zip',	'.',	1976470,	'circuit',	'z',	'2008-02-23',	10,	308),
('http://tonkas.hopto.org/EVO2/naturex.lte',	'naturex.lte',	'naturex.lte',	'.',	80298,	'circuit',	'l',	'2005-10-10',	10,	309),
('http://tonkas.hopto.org/EVO2/NCTCNTRY.zip',	'NCTCNTRY.zip',	'NCTCNTRY.zip',	'.',	6877606,	'circuit',	'z',	'2005-01-24',	10,	310),
('http://tonkas.hopto.org/EVO2/NIREVO2.POD',	'NIREVO2.POD',	'NIREVO2.POD',	'.',	4247041,	'circuit',	'p',	'2004-03-16',	10,	311),
('http://tonkas.hopto.org/EVO2/NIREVO2.ZIP',	'NIREVO2.ZIP',	'NIREVO2.ZIP',	'.',	1597885,	'circuit',	'z',	'2004-03-16',	10,	312),
('http://tonkas.hopto.org/EVO2/NIRIVESCHALLENGE.LTE',	'NIRIVESCHALLENGE.LTE',	'NIRIVESCHALLENGE.LTE',	'.',	42273,	'circuit',	'l',	'2005-03-22',	10,	313),
('http://tonkas.hopto.org/EVO2/NIRRALLY.ZIP',	'NIRRALLY.ZIP',	'NIRRALLY.ZIP',	'.',	738970,	'circuit',	'z',	'2003-09-19',	10,	314),
('http://tonkas.hopto.org/EVO2/NOLIMIT.pod',	'NOLIMIT.pod',	'NOLIMIT.pod',	'.',	59308259,	'circuit',	'p',	'2008-03-04',	10,	315),
('http://tonkas.hopto.org/EVO2/NOLIMIT.zip',	'NOLIMIT.zip',	'NOLIMIT.zip',	'.',	12882171,	'circuit',	'z',	'2008-03-04',	10,	316),
('http://tonkas.hopto.org/EVO2/NRAIDER.zip',	'NRAIDER.zip',	'NRAIDER.zip',	'.',	4926272,	'circuit',	'z',	'2005-03-04',	10,	317),
('http://tonkas.hopto.org/EVO2/NUIKAI.ZIP',	'NUIKAI.ZIP',	'NUIKAI.ZIP',	'.',	3671509,	'circuit',	'z',	'2003-11-24',	10,	318),
('http://tonkas.hopto.org/EVO2/OCNSIDE.ZIP',	'OCNSIDE.ZIP',	'OCNSIDE.ZIP',	'.',	1179191,	'circuit',	'z',	'2003-11-24',	10,	319),
('http://tonkas.hopto.org/EVO2/OFFROAD1.pod',	'OFFROAD1.pod',	'OFFROAD1.pod',	'.',	6366757,	'circuit',	'p',	'2002-02-18',	10,	320),
('http://tonkas.hopto.org/EVO2/offroad1.zip',	'offroad1.zip',	'offroad1.zip',	'.',	2456362,	'circuit',	'z',	'2009-05-31',	10,	321),
('http://tonkas.hopto.org/EVO2/offroad2004.lte',	'offroad2004.lte',	'offroad2004.lte',	'.',	76113,	'circuit',	'l',	'2005-12-29',	10,	322),
('http://tonkas.hopto.org/EVO2/offroadchallenge.lte',	'offroadchallenge.lte',	'offroadchallenge.lte',	'.',	78581,	'circuit',	'l',	'2005-12-30',	10,	323),
('http://tonkas.hopto.org/EVO2/OG.ZIP',	'OG.ZIP',	'OG.ZIP',	'.',	2539177,	'circuit',	'z',	'2003-11-19',	10,	324),
('http://tonkas.hopto.org/EVO2/OGBAJBE.ZIP',	'OGBAJBE.ZIP',	'OGBAJBE.ZIP',	'.',	5830823,	'circuit',	'z',	'2003-11-27',	10,	325),
('http://tonkas.hopto.org/EVO2/OGCity.zip',	'OGCity.zip',	'OGCity.zip',	'.',	5400571,	'circuit',	'z',	'2003-11-19',	10,	326),
('http://tonkas.hopto.org/EVO2/ogcty.pod',	'ogcty.pod',	'ogcty.pod',	'.',	15505032,	'circuit',	'p',	'2004-10-15',	10,	327),
('http://tonkas.hopto.org/EVO2/OGoasis.zip',	'OGoasis.zip',	'OGoasis.zip',	'.',	2977016,	'circuit',	'z',	'2003-11-19',	10,	328),
('http://tonkas.hopto.org/EVO2/OHAIR.ZIP',	'OHAIR.ZIP',	'OHAIR.ZIP',	'.',	7195450,	'circuit',	'z',	'2003-02-18',	10,	329),
('http://tonkas.hopto.org/EVO2/oldraceway.pod',	'oldraceway.pod',	'oldraceway.pod',	'.',	6140852,	'circuit',	'p',	'2007-03-11',	10,	330),
('http://tonkas.hopto.org/EVO2/oldraceway2.pod',	'oldraceway2.pod',	'oldraceway2.pod',	'.',	8467244,	'circuit',	'p',	'2007-03-11',	10,	331),
('http://tonkas.hopto.org/EVO2/OLDWEST.pod',	'OLDWEST.pod',	'OLDWEST.pod',	'.',	15549068,	'circuit',	'p',	'2004-04-25',	10,	332),
('http://tonkas.hopto.org/EVO2/OLDWEST.zip',	'OLDWEST.zip',	'OLDWEST.zip',	'.',	8041255,	'circuit',	'z',	'2008-09-12',	10,	333),
('http://tonkas.hopto.org/EVO2/OLYMPUS.ZIP',	'OLYMPUS.ZIP',	'OLYMPUS.ZIP',	'.',	3225945,	'circuit',	'z',	'2003-11-19',	10,	334),
('http://tonkas.hopto.org/EVO2/OOPSTACLE_PARK.ZIP',	'OOPSTACLE_PARK.ZIP',	'OOPSTACLE_PARK.ZIP',	'.',	1731226,	'circuit',	'z',	'2003-02-18',	10,	335),
('http://tonkas.hopto.org/EVO2/OPENROAD.pod',	'OPENROAD.pod',	'OPENROAD.pod',	'.',	7351597,	'circuit',	'p',	'2007-11-22',	10,	336),
('http://tonkas.hopto.org/EVO2/OPENROAD.zip',	'OPENROAD.zip',	'OPENROAD.zip',	'.',	2572677,	'circuit',	'z',	'2007-11-22',	10,	337),
('http://tonkas.hopto.org/EVO2/ORANGE.zip',	'ORANGE.zip',	'ORANGE.zip',	'.',	4078864,	'circuit',	'z',	'2005-01-24',	10,	338),
('http://tonkas.hopto.org/EVO2/ORINOCO.pod',	'ORINOCO.pod',	'ORINOCO.pod',	'.',	16641169,	'circuit',	'p',	'2003-03-21',	10,	339),
('http://tonkas.hopto.org/EVO2/ORINOCO.ZIP',	'ORINOCO.ZIP',	'ORINOCO.ZIP',	'.',	6531051,	'circuit',	'z',	'2003-08-28',	10,	340),
('http://tonkas.hopto.org/EVO2/outlawrun.lte',	'outlawrun.lte',	'outlawrun.lte',	'.',	65755,	'circuit',	'l',	'2005-12-29',	10,	341),
('http://tonkas.hopto.org/EVO2/OUTLOOK.ZIP',	'OUTLOOK.ZIP',	'OUTLOOK.ZIP',	'.',	3142226,	'circuit',	'z',	'2003-11-24',	10,	342),
('http://tonkas.hopto.org/EVO2/PGROVE.pod',	'PGROVE.pod',	'PGROVE.pod',	'.',	10703871,	'circuit',	'p',	'2004-04-25',	10,	343),
('http://tonkas.hopto.org/EVO2/PGROVE.zip',	'PGROVE.zip',	'PGROVE.zip',	'.',	3427661,	'circuit',	'z',	'2008-09-12',	10,	344),
('http://tonkas.hopto.org/EVO2/pie.pod',	'pie.pod',	'pie.pod',	'.',	8059439,	'circuit',	'p',	'2004-11-25',	10,	345),
('http://tonkas.hopto.org/EVO2/PIE.zip',	'PIE.zip',	'PIE.zip',	'.',	2740855,	'circuit',	'z',	'2007-11-22',	10,	346),
('http://tonkas.hopto.org/EVO2/PLATEAU1.pod',	'PLATEAU1.pod',	'PLATEAU1.pod',	'.',	7698851,	'circuit',	'p',	'2007-11-22',	10,	347),
('http://tonkas.hopto.org/EVO2/PLATEAU1.zip',	'PLATEAU1.zip',	'PLATEAU1.zip',	'.',	3060448,	'circuit',	'z',	'2007-11-22',	10,	348),
('http://tonkas.hopto.org/EVO2/POLARCAP.pod',	'POLARCAP.pod',	'POLARCAP.pod',	'.',	6323085,	'circuit',	'p',	'2002-03-03',	10,	349),
('http://tonkas.hopto.org/EVO2/POLARCAP.ZIP',	'POLARCAP.ZIP',	'POLARCAP.ZIP',	'.',	1819881,	'circuit',	'z',	'2004-01-24',	10,	350),
('http://tonkas.hopto.org/EVO2/PP.pod',	'PP.pod',	'PP.pod',	'.',	23010205,	'circuit',	'p',	'2008-05-16',	10,	351),
('http://tonkas.hopto.org/EVO2/PP.zip',	'PP.zip',	'PP.zip',	'.',	6056287,	'circuit',	'z',	'2007-11-22',	10,	352),
('http://tonkas.hopto.org/EVO2/R2.POD',	'R2.POD',	'R2.POD',	'.',	10515073,	'circuit',	'p',	'2004-10-15',	10,	353),
('http://tonkas.hopto.org/EVO2/R2.ZIP',	'R2.ZIP',	'R2.ZIP',	'.',	4495551,	'circuit',	'z',	'2004-02-16',	10,	354),
('http://tonkas.hopto.org/EVO2/radaRrd.pod',	'radaRrd.pod',	'radaRrd.pod',	'.',	19813574,	'circuit',	'p',	'2004-12-03',	10,	355),
('http://tonkas.hopto.org/EVO2/RADARRD.zip',	'RADARRD.zip',	'RADARRD.zip',	'.',	5733136,	'circuit',	'z',	'2004-11-30',	10,	356),
('http://tonkas.hopto.org/EVO2/RALLE2.pod',	'RALLE2.pod',	'RALLE2.pod',	'.',	2454309,	'circuit',	'p',	'2004-07-06',	10,	357),
('http://tonkas.hopto.org/EVO2/RALLE2.zip',	'RALLE2.zip',	'RALLE2.zip',	'.',	703181,	'circuit',	'z',	'2005-02-07',	10,	358),
('http://tonkas.hopto.org/EVO2/rayz.zip',	'rayz.zip',	'rayz.zip',	'.',	4368778,	'circuit',	'z',	'2004-06-03',	10,	359),
('http://tonkas.hopto.org/EVO2/RBICONWY.pod',	'RBICONWY.pod',	'RBICONWY.pod',	'.',	13126315,	'circuit',	'p',	'2003-04-17',	10,	360),
('http://tonkas.hopto.org/EVO2/RBICONWY.zip',	'RBICONWY.zip',	'RBICONWY.zip',	'.',	5103768,	'circuit',	'z',	'2008-05-02',	10,	361),
('http://tonkas.hopto.org/EVO2/RCGHLT.pod',	'RCGHLT.pod',	'RCGHLT.pod',	'.',	5993735,	'circuit',	'p',	'2003-06-30',	10,	362),
('http://tonkas.hopto.org/EVO2/RCGHLT.ZIP',	'RCGHLT.ZIP',	'RCGHLT.ZIP',	'.',	1275431,	'circuit',	'z',	'2003-10-09',	10,	363),
('http://tonkas.hopto.org/EVO2/RCGW.POD',	'RCGW.POD',	'RCGW.POD',	'.',	16557566,	'circuit',	'p',	'2004-02-23',	10,	364),
('http://tonkas.hopto.org/EVO2/RCGW.zip',	'RCGW.zip',	'RCGW.zip',	'.',	7930857,	'circuit',	'z',	'2004-06-03',	10,	365),
('http://tonkas.hopto.org/EVO2/RDE95.pod',	'RDE95.pod',	'RDE95.pod',	'.',	8319950,	'circuit',	'p',	'2003-02-12',	10,	366),
('http://tonkas.hopto.org/EVO2/RDE95.ZIP',	'RDE95.ZIP',	'RDE95.ZIP',	'.',	3202442,	'circuit',	'z',	'2003-02-20',	10,	367),
('http://tonkas.hopto.org/EVO2/Recess.zip',	'Recess.zip',	'Recess.zip',	'.',	4114434,	'circuit',	'z',	'2004-03-21',	10,	368),
('http://tonkas.hopto.org/EVO2/REDROCK.pod',	'REDROCK.pod',	'REDROCK.pod',	'.',	7710626,	'circuit',	'p',	'2004-09-04',	10,	369),
('http://tonkas.hopto.org/EVO2/Redrock.zip',	'Redrock.zip',	'Redrock.zip',	'.',	4547628,	'circuit',	'z',	'2004-09-24',	10,	370),
('http://tonkas.hopto.org/EVO2/RETURNOF.pod',	'RETURNOF.pod',	'RETURNOF.pod',	'.',	7354466,	'circuit',	'p',	'2004-07-02',	10,	371),
('http://tonkas.hopto.org/EVO2/RETURNOF.zip',	'RETURNOF.zip',	'RETURNOF.zip',	'.',	3276182,	'circuit',	'z',	'2004-08-06',	10,	372),
('http://tonkas.hopto.org/EVO2/REVDSRT.pod',	'REVDSRT.pod',	'REVDSRT.pod',	'.',	6224845,	'circuit',	'p',	'2004-05-21',	10,	373),
('http://tonkas.hopto.org/EVO2/REVDSRT.zip',	'REVDSRT.zip',	'REVDSRT.zip',	'.',	2779802,	'circuit',	'z',	'2004-06-03',	10,	374),
('http://tonkas.hopto.org/EVO2/rigor.pod',	'rigor.pod',	'rigor.pod',	'.',	29335491,	'circuit',	'p',	'2007-11-22',	10,	375),
('http://tonkas.hopto.org/EVO2/RIGOR.zip',	'RIGOR.zip',	'RIGOR.zip',	'.',	6471725,	'circuit',	'z',	'2004-11-30',	10,	376),
('http://tonkas.hopto.org/EVO2/rkbeach.lte',	'rkbeach.lte',	'rkbeach.lte',	'.',	66954,	'circuit',	'l',	'2007-10-04',	10,	377),
('http://tonkas.hopto.org/EVO2/ROADRUNR.pod',	'ROADRUNR.pod',	'ROADRUNR.pod',	'.',	12624528,	'circuit',	'p',	'2002-05-25',	10,	378),
('http://tonkas.hopto.org/EVO2/ROADRUNR.zip',	'ROADRUNR.zip',	'ROADRUNR.zip',	'.',	4316532,	'circuit',	'z',	'2008-09-12',	10,	379),
('http://tonkas.hopto.org/EVO2/ROCKMEA.pod',	'ROCKMEA.pod',	'ROCKMEA.pod',	'.',	8367980,	'circuit',	'p',	'2004-04-25',	10,	380),
('http://tonkas.hopto.org/EVO2/ROCKMEA.zip',	'ROCKMEA.zip',	'ROCKMEA.zip',	'.',	2746898,	'circuit',	'z',	'2008-09-12',	10,	381),
('http://tonkas.hopto.org/EVO2/RON9ROAD.pod',	'RON9ROAD.pod',	'RON9ROAD.pod',	'.',	12432244,	'circuit',	'p',	'2007-11-22',	10,	382),
('http://tonkas.hopto.org/EVO2/RON9ROAD.zip',	'RON9ROAD.zip',	'RON9ROAD.zip',	'.',	5241276,	'circuit',	'z',	'2007-11-22',	10,	383),
('http://tonkas.hopto.org/EVO2/ROOFTOP.pod',	'ROOFTOP.pod',	'ROOFTOP.pod',	'.',	15966534,	'circuit',	'p',	'2004-04-25',	10,	384),
('http://tonkas.hopto.org/EVO2/ROOFTOP.zip',	'ROOFTOP.zip',	'ROOFTOP.zip',	'.',	5142008,	'circuit',	'z',	'2008-09-12',	10,	385),
('http://tonkas.hopto.org/EVO2/ROUND.pod',	'ROUND.pod',	'ROUND.pod',	'.',	12871619,	'circuit',	'p',	'2002-02-17',	10,	386),
('http://tonkas.hopto.org/EVO2/ROUND.zip',	'ROUND.zip',	'ROUND.zip',	'.',	4626371,	'circuit',	'z',	'2008-02-23',	10,	387),
('http://tonkas.hopto.org/EVO2/RPDAKAR.pod',	'RPDAKAR.pod',	'RPDAKAR.pod',	'.',	3512191,	'circuit',	'p',	'2002-11-13',	10,	388),
('http://tonkas.hopto.org/EVO2/RPDAKAR.ZIP',	'RPDAKAR.ZIP',	'RPDAKAR.ZIP',	'.',	1056722,	'circuit',	'z',	'2003-02-18',	10,	389),
('http://tonkas.hopto.org/EVO2/RRTI.pod',	'RRTI.pod',	'RRTI.pod',	'.',	13240059,	'circuit',	'p',	'2006-09-17',	10,	390),
('http://tonkas.hopto.org/EVO2/rsw.pod',	'rsw.pod',	'rsw.pod',	'.',	9967177,	'circuit',	'p',	'2004-05-20',	10,	391),
('http://tonkas.hopto.org/EVO2/RSW.zip',	'RSW.zip',	'RSW.zip',	'.',	4157195,	'circuit',	'z',	'2004-05-20',	10,	392),
('http://tonkas.hopto.org/EVO2/RTMAC.ZIP',	'RTMAC.ZIP',	'RTMAC.ZIP',	'.',	18338865,	'circuit',	'z',	'2004-06-14',	10,	393),
('http://tonkas.hopto.org/EVO2/RTMAC2.ZIP',	'RTMAC2.ZIP',	'RTMAC2.ZIP',	'.',	18338760,	'circuit',	'z',	'2003-12-29',	10,	394),
('http://tonkas.hopto.org/EVO2/rtmacrev.zip',	'rtmacrev.zip',	'rtmacrev.zip',	'.',	1528933,	'circuit',	'z',	'2004-08-25',	10,	395),
('http://tonkas.hopto.org/EVO2/rtmacspeed.ZIP',	'rtmacspeed.ZIP',	'rtmacspeed.ZIP',	'.',	1516066,	'circuit',	'z',	'2003-12-30',	10,	396),
('http://tonkas.hopto.org/EVO2/rtmacspeed2.zip',	'rtmacspeed2.zip',	'rtmacspeed2.zip',	'.',	1528795,	'circuit',	'z',	'2004-01-01',	10,	397),
('http://tonkas.hopto.org/EVO2/rubicon.pod',	'rubicon.pod',	'rubicon.pod',	'.',	15322074,	'circuit',	'p',	'2004-09-07',	10,	398),
('http://tonkas.hopto.org/EVO2/RubiconTrail.zip',	'RubiconTrail.zip',	'RubiconTrail.zip',	'.',	6934305,	'circuit',	'z',	'2003-02-03',	10,	399),
('http://tonkas.hopto.org/EVO2/RUNWILD.pod',	'RUNWILD.pod',	'RUNWILD.pod',	'.',	16116247,	'circuit',	'p',	'2002-12-26',	10,	400),
('http://tonkas.hopto.org/EVO2/RUNWILD.ZIP',	'RUNWILD.ZIP',	'RUNWILD.ZIP',	'.',	6382500,	'circuit',	'z',	'2004-03-23',	10,	401),
('http://tonkas.hopto.org/EVO2/SABER.pod',	'SABER.pod',	'SABER.pod',	'.',	9640355,	'circuit',	'p',	'2002-05-22',	10,	402),
('http://tonkas.hopto.org/EVO2/SABER.zip',	'SABER.zip',	'SABER.zip',	'.',	3682112,	'circuit',	'z',	'2008-05-02',	10,	403),
('http://tonkas.hopto.org/EVO2/SADDLE.pod',	'SADDLE.pod',	'SADDLE.pod',	'.',	9770228,	'circuit',	'p',	'2006-08-21',	10,	404),
('http://tonkas.hopto.org/EVO2/SADDLE.zip',	'SADDLE.zip',	'SADDLE.zip',	'.',	3990101,	'circuit',	'z',	'2006-08-21',	10,	405),
('http://tonkas.hopto.org/EVO2/SAFARIS6.pod',	'SAFARIS6.pod',	'SAFARIS6.pod',	'.',	6704840,	'circuit',	'p',	'2007-11-22',	10,	406),
('http://tonkas.hopto.org/EVO2/SAFARIW6.pod',	'SAFARIW6.pod',	'SAFARIW6.pod',	'.',	8481779,	'circuit',	'p',	'2007-11-22',	10,	407),
('http://tonkas.hopto.org/EVO2/SALEV01.pod',	'SALEV01.pod',	'SALEV01.pod',	'.',	33528693,	'circuit',	'p',	'2004-04-29',	10,	408),
('http://tonkas.hopto.org/EVO2/SALEV01.zip',	'SALEV01.zip',	'SALEV01.zip',	'.',	12332203,	'circuit',	'z',	'2004-06-21',	10,	409),
('http://tonkas.hopto.org/EVO2/SALEV02.zip',	'SALEV02.zip',	'SALEV02.zip',	'.',	396085,	'circuit',	'z',	'2004-06-21',	10,	410),
('http://tonkas.hopto.org/EVO2/SALEV03.zip',	'SALEV03.zip',	'SALEV03.zip',	'.',	395974,	'circuit',	'z',	'2004-06-21',	10,	411),
('http://tonkas.hopto.org/EVO2/SALEV04.zip',	'SALEV04.zip',	'SALEV04.zip',	'.',	397318,	'circuit',	'z',	'2004-06-21',	10,	412),
('http://tonkas.hopto.org/EVO2/SALEV05.zip',	'SALEV05.zip',	'SALEV05.zip',	'.',	388032,	'circuit',	'z',	'2004-06-21',	10,	413),
('http://tonkas.hopto.org/EVO2/SALEV06.zip',	'SALEV06.zip',	'SALEV06.zip',	'.',	396060,	'circuit',	'z',	'2004-06-21',	10,	414),
('http://tonkas.hopto.org/EVO2/SALEV07.zip',	'SALEV07.zip',	'SALEV07.zip',	'.',	399089,	'circuit',	'z',	'2004-06-21',	10,	415),
('http://tonkas.hopto.org/EVO2/SALEV08.zip',	'SALEV08.zip',	'SALEV08.zip',	'.',	402409,	'circuit',	'z',	'2004-06-21',	10,	416),
('http://tonkas.hopto.org/EVO2/SASSY.pod',	'SASSY.pod',	'SASSY.pod',	'.',	12258531,	'circuit',	'p',	'2004-07-11',	10,	417),
('http://tonkas.hopto.org/EVO2/SASSY.zip',	'SASSY.zip',	'SASSY.zip',	'.',	4036932,	'circuit',	'z',	'2004-08-06',	10,	418),
('http://tonkas.hopto.org/EVO2/SBANSHEE.pod',	'SBANSHEE.pod',	'SBANSHEE.pod',	'.',	6899694,	'circuit',	'p',	'2002-05-19',	10,	419),
('http://tonkas.hopto.org/EVO2/SBANSHEE.ZIP',	'SBANSHEE.ZIP',	'SBANSHEE.ZIP',	'.',	2245736,	'circuit',	'z',	'2004-02-16',	10,	420),
('http://tonkas.hopto.org/EVO2/SCIMITAR.pod',	'SCIMITAR.pod',	'SCIMITAR.pod',	'.',	9888100,	'circuit',	'p',	'2002-11-17',	10,	421),
('http://tonkas.hopto.org/EVO2/SCIMITAR.ZIP',	'SCIMITAR.ZIP',	'SCIMITAR.ZIP',	'.',	3128431,	'circuit',	'z',	'2003-11-02',	10,	422),
('http://tonkas.hopto.org/EVO2/seglockforest.lte',	'seglockforest.lte',	'seglockforest.lte',	'.',	73600,	'circuit',	'l',	'2006-01-19',	10,	423),
('http://tonkas.hopto.org/EVO2/serendip.pod',	'serendip.pod',	'serendip.pod',	'.',	11485112,	'circuit',	'p',	'2004-12-03',	10,	424),
('http://tonkas.hopto.org/EVO2/SERENDIP.zip',	'SERENDIP.zip',	'SERENDIP.zip',	'.',	4620590,	'circuit',	'z',	'2004-11-30',	10,	425),
('http://tonkas.hopto.org/EVO2/SIDEWNDR.pod',	'SIDEWNDR.pod',	'SIDEWNDR.pod',	'.',	10827642,	'circuit',	'p',	'2003-11-07',	10,	426),
('http://tonkas.hopto.org/EVO2/SIDEWNDR.ZIP',	'SIDEWNDR.ZIP',	'SIDEWNDR.ZIP',	'.',	4769069,	'circuit',	'z',	'2003-12-02',	10,	427),
('http://tonkas.hopto.org/EVO2/sithallstarshout.lte',	'sithallstarshout.lte',	'sithallstarshout.lte',	'.',	83688,	'circuit',	'l',	'2005-03-06',	10,	428),
('http://tonkas.hopto.org/EVO2/sithclimb3.lte',	'sithclimb3.lte',	'sithclimb3.lte',	'.',	34459,	'circuit',	'l',	'2005-09-12',	10,	429),
('http://tonkas.hopto.org/EVO2/SithEncounTer.lte',	'SithEncounTer.lte',	'SithEncounTer.lte',	'.',	71711,	'circuit',	'l',	'2005-09-26',	10,	430),
('http://tonkas.hopto.org/EVO2/sithenigma.lte',	'sithenigma.lte',	'sithenigma.lte',	'.',	53990,	'circuit',	'l',	'2005-10-12',	10,	431),
('http://tonkas.hopto.org/EVO2/SithExcavator.lte',	'SithExcavator.lte',	'SithExcavator.lte',	'.',	85003,	'circuit',	'l',	'2005-09-26',	10,	432),
('http://tonkas.hopto.org/EVO2/sithiceman.lte',	'sithiceman.lte',	'sithiceman.lte',	'.',	57090,	'circuit',	'l',	'2004-01-10',	10,	433),
('http://tonkas.hopto.org/EVO2/SithJagged.lte',	'SithJagged.lte',	'SithJagged.lte',	'.',	100286,	'circuit',	'l',	'2005-01-28',	10,	434),
('http://tonkas.hopto.org/EVO2/Sithmountin.lte',	'Sithmountin.lte',	'Sithmountin.lte',	'.',	61106,	'circuit',	'l',	'2005-03-22',	10,	435),
('http://tonkas.hopto.org/EVO2/SITHONE.pod',	'SITHONE.pod',	'SITHONE.pod',	'.',	5321099,	'circuit',	'p',	'2003-10-31',	10,	436),
('http://tonkas.hopto.org/EVO2/SITHONE.zip',	'SITHONE.zip',	'SITHONE.zip',	'.',	1687973,	'circuit',	'z',	'2006-09-09',	10,	437),
('http://tonkas.hopto.org/EVO2/sithpassage.lte',	'sithpassage.lte',	'sithpassage.lte',	'.',	68434,	'circuit',	'l',	'2005-01-28',	10,	438),
('http://tonkas.hopto.org/EVO2/sithruffrider.lte',	'sithruffrider.lte',	'sithruffrider.lte',	'.',	46512,	'circuit',	'l',	'2005-09-26',	10,	439),
('http://tonkas.hopto.org/EVO2/sithsinister.lte',	'sithsinister.lte',	'sithsinister.lte',	'.',	89519,	'circuit',	'l',	'2005-07-05',	10,	440),
('http://tonkas.hopto.org/EVO2/SithTrailofFate.lte',	'SithTrailofFate.lte',	'SithTrailofFate.lte',	'.',	100310,	'circuit',	'l',	'2005-08-08',	10,	441),
('http://tonkas.hopto.org/EVO2/skiddle.pod',	'skiddle.pod',	'skiddle.pod',	'.',	8577197,	'circuit',	'p',	'2004-04-15',	10,	442),
('http://tonkas.hopto.org/EVO2/SKIDDLE.ZIP',	'SKIDDLE.ZIP',	'SKIDDLE.ZIP',	'.',	3007311,	'circuit',	'z',	'2004-03-23',	10,	443),
('http://tonkas.hopto.org/EVO2/SKILHIL2.ZIP',	'SKILHIL2.ZIP',	'SKILHIL2.ZIP',	'.',	742984,	'circuit',	'z',	'2003-11-17',	10,	444),
('http://tonkas.hopto.org/EVO2/SKILLHIL.ZIP',	'SKILLHIL.ZIP',	'SKILLHIL.ZIP',	'.',	263464,	'circuit',	'z',	'2003-11-17',	10,	445),
('http://tonkas.hopto.org/EVO2/SNAPSSX.pod',	'SNAPSSX.pod',	'SNAPSSX.pod',	'.',	7171550,	'circuit',	'p',	'2004-04-25',	10,	446),
('http://tonkas.hopto.org/EVO2/SNOWBALL.pod',	'SNOWBALL.pod',	'SNOWBALL.pod',	'.',	9801422,	'circuit',	'p',	'2004-01-24',	10,	447),
('http://tonkas.hopto.org/EVO2/SNOWBALL.zip',	'SNOWBALL.zip',	'SNOWBALL.zip',	'.',	3417598,	'circuit',	'z',	'2005-01-24',	10,	448),
('http://tonkas.hopto.org/EVO2/SNOWCAT.pod',	'SNOWCAT.pod',	'SNOWCAT.pod',	'.',	4949803,	'circuit',	'p',	'2003-12-03',	10,	449),
('http://tonkas.hopto.org/EVO2/SNOWCAT.ZIP',	'SNOWCAT.ZIP',	'SNOWCAT.ZIP',	'.',	1864127,	'circuit',	'z',	'2003-12-12',	10,	450),
('http://tonkas.hopto.org/EVO2/SNOWFLD.pod',	'SNOWFLD.pod',	'SNOWFLD.pod',	'.',	6164218,	'circuit',	'p',	'2003-11-09',	10,	451),
('http://tonkas.hopto.org/EVO2/SNOWFLD.ZIP',	'SNOWFLD.ZIP',	'SNOWFLD.ZIP',	'.',	2392887,	'circuit',	'z',	'2003-11-24',	10,	452),
('http://tonkas.hopto.org/EVO2/SNOWFLOW.pod',	'SNOWFLOW.pod',	'SNOWFLOW.pod',	'.',	8572988,	'circuit',	'p',	'2004-01-13',	10,	453),
('http://tonkas.hopto.org/EVO2/SNOWFLOW.ZIP',	'SNOWFLOW.ZIP',	'SNOWFLOW.ZIP',	'.',	3846682,	'circuit',	'z',	'2004-01-24',	10,	454),
('http://tonkas.hopto.org/EVO2/SNOWLOAD.pod',	'SNOWLOAD.pod',	'SNOWLOAD.pod',	'.',	3992157,	'circuit',	'p',	'2004-01-06',	10,	455),
('http://tonkas.hopto.org/EVO2/SNOWLOAD.ZIP',	'SNOWLOAD.ZIP',	'SNOWLOAD.ZIP',	'.',	1354130,	'circuit',	'z',	'2004-01-23',	10,	456),
('http://tonkas.hopto.org/EVO2/SNOWPAI.pod',	'SNOWPAI.pod',	'SNOWPAI.pod',	'.',	8165622,	'circuit',	'p',	'2003-11-10',	10,	457),
('http://tonkas.hopto.org/EVO2/SNOWPAI.ZIP',	'SNOWPAI.ZIP',	'SNOWPAI.ZIP',	'.',	3324660,	'circuit',	'z',	'2003-11-24',	10,	458),
('http://tonkas.hopto.org/EVO2/SNOWSHOE.pod',	'SNOWSHOE.pod',	'SNOWSHOE.pod',	'.',	5710000,	'circuit',	'p',	'2003-11-09',	10,	459),
('http://tonkas.hopto.org/EVO2/SNOWSHOE.ZIP',	'SNOWSHOE.ZIP',	'SNOWSHOE.ZIP',	'.',	2545540,	'circuit',	'z',	'2003-12-12',	10,	460),
('http://tonkas.hopto.org/EVO2/SNOWX.ZIP',	'SNOWX.ZIP',	'SNOWX.ZIP',	'.',	2459655,	'circuit',	'z',	'2003-02-18',	10,	461),
('http://tonkas.hopto.org/EVO2/SPACEAG2.ZIP',	'SPACEAG2.ZIP',	'SPACEAG2.ZIP',	'.',	982505,	'circuit',	'z',	'2003-11-17',	10,	462),
('http://tonkas.hopto.org/EVO2/SPACEAGE.ZIP',	'SPACEAGE.ZIP',	'SPACEAGE.ZIP',	'.',	820444,	'circuit',	'z',	'2003-11-17',	10,	463),
('http://tonkas.hopto.org/EVO2/Sparx.lte',	'Sparx.lte',	'Sparx.lte',	'.',	54581,	'circuit',	'l',	'2005-11-27',	10,	464),
('http://tonkas.hopto.org/EVO2/SPEEDRATS_PACK.zip',	'SPEEDRATS_PACK.zip',	'SPEEDRATS_PACK.zip',	'.',	1856865,	'circuit',	'z',	'2009-04-10',	10,	465),
('http://tonkas.hopto.org/EVO2/SPINVADE.zip',	'SPINVADE.zip',	'SPINVADE.zip',	'.',	3392918,	'circuit',	'z',	'2004-11-07',	10,	466),
('http://tonkas.hopto.org/EVO2/SPTHAW.ZIP',	'SPTHAW.ZIP',	'SPTHAW.ZIP',	'.',	3041291,	'circuit',	'z',	'2003-11-24',	10,	467),
('http://tonkas.hopto.org/EVO2/SPUD.pod',	'SPUD.pod',	'SPUD.pod',	'.',	14931509,	'circuit',	'p',	'2005-02-28',	10,	468),
('http://tonkas.hopto.org/EVO2/SPUD.zip',	'SPUD.zip',	'SPUD.zip',	'.',	4456696,	'circuit',	'z',	'2005-03-01',	10,	469),
('http://tonkas.hopto.org/EVO2/SR.pod',	'SR.pod',	'SR.pod',	'.',	29156487,	'circuit',	'p',	'2008-05-07',	10,	470),
('http://tonkas.hopto.org/EVO2/SR.zip',	'SR.zip',	'SR.zip',	'.',	8994054,	'circuit',	'z',	'2008-09-12',	10,	471),
('http://tonkas.hopto.org/EVO2/SR_TnT.zip',	'SR_TnT.zip',	'SR_TnT.zip',	'.',	9127068,	'circuit',	'z',	'2008-05-07',	10,	472),
('http://tonkas.hopto.org/EVO2/STACKED.pod',	'STACKED.pod',	'STACKED.pod',	'.',	10610146,	'circuit',	'p',	'2002-10-18',	10,	473),
('http://tonkas.hopto.org/EVO2/STACKED.zip',	'STACKED.zip',	'STACKED.zip',	'.',	4041276,	'circuit',	'z',	'2008-09-12',	10,	474),
('http://tonkas.hopto.org/EVO2/stg2road.pod',	'stg2road.pod',	'stg2road.pod',	'.',	17755409,	'circuit',	'p',	'2004-10-19',	10,	475),
('http://tonkas.hopto.org/EVO2/STG2ROAD.zip',	'STG2ROAD.zip',	'STG2ROAD.zip',	'.',	6016203,	'circuit',	'z',	'2004-10-19',	10,	476),
('http://tonkas.hopto.org/EVO2/STGREVO2.pod',	'STGREVO2.pod',	'STGREVO2.pod',	'.',	12018157,	'circuit',	'p',	'2005-02-23',	10,	477),
('http://tonkas.hopto.org/EVO2/STGREVO2.zip',	'STGREVO2.zip',	'STGREVO2.zip',	'.',	3943915,	'circuit',	'z',	'2005-03-01',	10,	478),
('http://tonkas.hopto.org/EVO2/STHHLL1.ZIP',	'STHHLL1.ZIP',	'STHHLL1.ZIP',	'.',	3639886,	'circuit',	'z',	'2003-11-25',	10,	479),
('http://tonkas.hopto.org/EVO2/stsofsf.pod',	'stsofsf.pod',	'stsofsf.pod',	'.',	40611583,	'circuit',	'p',	'2004-04-15',	10,	480),
('http://tonkas.hopto.org/EVO2/STSOFSF.ZIP',	'STSOFSF.ZIP',	'STSOFSF.ZIP',	'.',	8589420,	'circuit',	'z',	'2004-04-05',	10,	481),
('http://tonkas.hopto.org/EVO2/SUBURBIA.pod',	'SUBURBIA.pod',	'SUBURBIA.pod',	'.',	20578360,	'circuit',	'p',	'2004-04-25',	10,	482),
('http://tonkas.hopto.org/EVO2/SUBURBIA.zip',	'SUBURBIA.zip',	'SUBURBIA.zip',	'.',	7203416,	'circuit',	'z',	'2008-05-02',	10,	483),
('http://tonkas.hopto.org/EVO2/suburbs.pod',	'suburbs.pod',	'suburbs.pod',	'.',	14808761,	'circuit',	'p',	'2004-04-15',	10,	484),
('http://tonkas.hopto.org/EVO2/SUBURBS.ZIP',	'SUBURBS.ZIP',	'SUBURBS.ZIP',	'.',	7427549,	'circuit',	'z',	'2004-04-05',	10,	485),
('http://tonkas.hopto.org/EVO2/SUNSTRL.JPG',	'SUNSTRL.JPG',	'SUNSTRL.JPG',	'.',	164887,	'circuit',	'j',	'2003-08-31',	10,	486),
('http://tonkas.hopto.org/EVO2/SUNSTRL.ZIP',	'SUNSTRL.ZIP',	'SUNSTRL.ZIP',	'.',	5411912,	'circuit',	'z',	'2003-12-02',	10,	487),
('http://tonkas.hopto.org/EVO2/SWAMPER.pod',	'SWAMPER.pod',	'SWAMPER.pod',	'.',	11922789,	'circuit',	'p',	'2002-12-12',	10,	488),
('http://tonkas.hopto.org/EVO2/swampertrack.zip',	'swampertrack.zip',	'swampertrack.zip',	'.',	4774971,	'circuit',	'z',	'2005-04-09',	10,	489),
('http://tonkas.hopto.org/EVO2/SWITCHBK.pod',	'SWITCHBK.pod',	'SWITCHBK.pod',	'.',	7307882,	'circuit',	'p',	'2004-02-04',	10,	490),
('http://tonkas.hopto.org/EVO2/SWITCHBK.ZIP',	'SWITCHBK.ZIP',	'SWITCHBK.ZIP',	'.',	2567820,	'circuit',	'z',	'2004-03-23',	10,	491),
('http://tonkas.hopto.org/EVO2/TACITURN.pod',	'TACITURN.pod',	'TACITURN.pod',	'.',	21988162,	'circuit',	'p',	'2004-06-23',	10,	492),
('http://tonkas.hopto.org/EVO2/TACITURN.zip',	'TACITURN.zip',	'TACITURN.zip',	'.',	7081123,	'circuit',	'z',	'2004-08-06',	10,	493),
('http://tonkas.hopto.org/EVO2/TENAGRA.pod',	'TENAGRA.pod',	'TENAGRA.pod',	'.',	8681427,	'circuit',	'p',	'2005-03-06',	10,	494),
('http://tonkas.hopto.org/EVO2/TENAGRA.zip',	'TENAGRA.zip',	'TENAGRA.zip',	'.',	2965390,	'circuit',	'z',	'2008-05-02',	10,	495),
('http://tonkas.hopto.org/EVO2/TERRAMAR.pod',	'TERRAMAR.pod',	'TERRAMAR.pod',	'.',	8317700,	'circuit',	'p',	'2007-11-22',	10,	496),
('http://tonkas.hopto.org/EVO2/TERRAMAR.zip',	'TERRAMAR.zip',	'TERRAMAR.zip',	'.',	4194283,	'circuit',	'z',	'2005-01-24',	10,	497),
('http://tonkas.hopto.org/EVO2/texasoil.pod',	'texasoil.pod',	'texasoil.pod',	'.',	10082605,	'circuit',	'p',	'2004-11-20',	10,	498),
('http://tonkas.hopto.org/EVO2/TEXASOIL.zip',	'TEXASOIL.zip',	'TEXASOIL.zip',	'.',	3266518,	'circuit',	'z',	'2004-11-20',	10,	499),
('http://tonkas.hopto.org/EVO2/THE4X4ST.zip',	'THE4X4ST.zip',	'THE4X4ST.zip',	'.',	2607226,	'circuit',	'z',	'2004-08-06',	10,	500),
('http://tonkas.hopto.org/EVO2/THEBBBBB.ZIP',	'THEBBBBB.ZIP',	'THEBBBBB.ZIP',	'.',	1562407,	'circuit',	'z',	'2003-11-17',	10,	501),
('http://tonkas.hopto.org/EVO2/THECABIN.zip',	'THECABIN.zip',	'THECABIN.zip',	'.',	6330425,	'circuit',	'z',	'2004-09-24',	10,	502),
('http://tonkas.hopto.org/EVO2/THEPITS.ZIP',	'THEPITS.ZIP',	'THEPITS.ZIP',	'.',	8151635,	'circuit',	'z',	'2003-12-11',	10,	503),
('http://tonkas.hopto.org/EVO2/THETRON.zip',	'THETRON.zip',	'THETRON.zip',	'.',	7274414,	'circuit',	'z',	'2004-08-05',	10,	504),
('http://tonkas.hopto.org/EVO2/TIBERIAN.pod',	'TIBERIAN.pod',	'TIBERIAN.pod',	'.',	15856774,	'circuit',	'p',	'2005-03-13',	10,	505),
('http://tonkas.hopto.org/EVO2/TIBERIAN.zip',	'TIBERIAN.zip',	'TIBERIAN.zip',	'.',	5219289,	'circuit',	'z',	'2005-03-16',	10,	506),
('http://tonkas.hopto.org/EVO2/tie.lte',	'tie.lte',	'tie.lte',	'.',	55145,	'circuit',	'l',	'2005-12-18',	10,	507),
('http://tonkas.hopto.org/EVO2/tit.lte',	'tit.lte',	'tit.lte',	'.',	75561,	'circuit',	'l',	'2006-01-20',	10,	508),
('http://tonkas.hopto.org/EVO2/TMF2004.POD',	'TMF2004.POD',	'TMF2004.POD',	'.',	7588259,	'circuit',	'p',	'2007-01-25',	10,	509),
('http://tonkas.hopto.org/EVO2/TMF2004.zip',	'TMF2004.zip',	'TMF2004.zip',	'.',	2513274,	'circuit',	'z',	'2007-01-25',	10,	510),
('http://tonkas.hopto.org/EVO2/tomb.pod',	'tomb.pod',	'tomb.pod',	'.',	8673831,	'circuit',	'p',	'2004-04-15',	10,	511),
('http://tonkas.hopto.org/EVO2/TOMB.ZIP',	'TOMB.ZIP',	'TOMB.ZIP',	'.',	4316361,	'circuit',	'z',	'2004-03-23',	10,	512),
('http://tonkas.hopto.org/EVO2/Tonka.zip',	'Tonka.zip',	'Tonka.zip',	'.',	642751,	'circuit',	'z',	'2007-11-27',	10,	513),
('http://tonkas.hopto.org/EVO2/Toptruck.lte',	'Toptruck.lte',	'Toptruck.lte',	'.',	56166,	'circuit',	'l',	'2004-11-11',	10,	514),
('http://tonkas.hopto.org/EVO2/TOYOTA.ZIP',	'TOYOTA.ZIP',	'TOYOTA.ZIP',	'.',	3786788,	'circuit',	'z',	'2003-02-18',	10,	515),
('http://tonkas.hopto.org/EVO2/TP.pod',	'TP.pod',	'TP.pod',	'.',	5419861,	'circuit',	'p',	'2005-02-06',	10,	516),
('http://tonkas.hopto.org/EVO2/TP.zip',	'TP.zip',	'TP.zip',	'.',	2102042,	'circuit',	'z',	'2005-02-12',	10,	517),
('http://tonkas.hopto.org/EVO2/TRACKNAM.zip',	'TRACKNAM.zip',	'TRACKNAM.zip',	'.',	3723765,	'circuit',	'z',	'2004-08-06',	10,	518),
('http://tonkas.hopto.org/EVO2/TRAKKER.zip',	'TRAKKER.zip',	'TRAKKER.zip',	'.',	5251457,	'circuit',	'z',	'2004-11-07',	10,	519),
('http://tonkas.hopto.org/EVO2/TRINITY.pod',	'TRINITY.pod',	'TRINITY.pod',	'.',	7123866,	'circuit',	'p',	'2007-03-17',	10,	520),
('http://tonkas.hopto.org/EVO2/TRINITY.zip',	'TRINITY.zip',	'TRINITY.zip',	'.',	3085705,	'circuit',	'z',	'2007-03-17',	10,	521),
('http://tonkas.hopto.org/EVO2/trinityt.pod',	'trinityt.pod',	'trinityt.pod',	'.',	20434676,	'circuit',	'p',	'2004-04-15',	10,	522),
('http://tonkas.hopto.org/EVO2/TRINITYT.ZIP',	'TRINITYT.ZIP',	'TRINITYT.ZIP',	'.',	6097830,	'circuit',	'z',	'2004-03-21',	10,	523),
('http://tonkas.hopto.org/EVO2/TRIPOLI.pod',	'TRIPOLI.pod',	'TRIPOLI.pod',	'.',	14563928,	'circuit',	'p',	'2004-04-28',	10,	524),
('http://tonkas.hopto.org/EVO2/TRIPOLI.zip',	'TRIPOLI.zip',	'TRIPOLI.zip',	'.',	6155429,	'circuit',	'z',	'2004-07-05',	10,	525),
('http://tonkas.hopto.org/EVO2/tuesday.pod',	'tuesday.pod',	'tuesday.pod',	'.',	8274341,	'circuit',	'p',	'2004-10-19',	10,	526),
('http://tonkas.hopto.org/EVO2/TUESDAY.zip',	'TUESDAY.zip',	'TUESDAY.zip',	'.',	2828220,	'circuit',	'z',	'2004-10-19',	10,	527),
('http://tonkas.hopto.org/EVO2/utopia.lte',	'utopia.lte',	'utopia.lte',	'.',	25262,	'circuit',	'l',	'2005-10-10',	10,	528),
('http://tonkas.hopto.org/EVO2/VERACIN.ZIP',	'VERACIN.ZIP',	'VERACIN.ZIP',	'.',	1876589,	'circuit',	'z',	'2003-02-20',	10,	529),
('http://tonkas.hopto.org/EVO2/VERN.pod',	'VERN.pod',	'VERN.pod',	'.',	9664741,	'circuit',	'p',	'2007-03-17',	10,	530),
('http://tonkas.hopto.org/EVO2/VERN.zip',	'VERN.zip',	'VERN.zip',	'.',	4714247,	'circuit',	'z',	'2007-11-22',	10,	531),
('http://tonkas.hopto.org/EVO2/VJROAD.pod',	'VJROAD.pod',	'VJROAD.pod',	'.',	8881791,	'circuit',	'p',	'2008-05-16',	10,	532),
('http://tonkas.hopto.org/EVO2/VJROAD.zip',	'VJROAD.zip',	'VJROAD.zip',	'.',	4356786,	'circuit',	'z',	'2007-11-22',	10,	533),
('http://tonkas.hopto.org/EVO2/VJTEST.pod',	'VJTEST.pod',	'VJTEST.pod',	'.',	10964618,	'circuit',	'p',	'2007-01-24',	10,	534),
('http://tonkas.hopto.org/EVO2/VJTEST.zip',	'VJTEST.zip',	'VJTEST.zip',	'.',	4702637,	'circuit',	'z',	'2008-09-12',	10,	535),
('http://tonkas.hopto.org/EVO2/WARWICKS.pod',	'WARWICKS.pod',	'WARWICKS.pod',	'.',	16742658,	'circuit',	'p',	'2005-03-07',	10,	536),
('http://tonkas.hopto.org/EVO2/WARWICKS.zip',	'WARWICKS.zip',	'WARWICKS.zip',	'.',	6856053,	'circuit',	'z',	'2005-03-16',	10,	537),
('http://tonkas.hopto.org/EVO2/WD40.pod',	'WD40.pod',	'WD40.pod',	'.',	9802878,	'circuit',	'p',	'2003-11-13',	10,	538),
('http://tonkas.hopto.org/EVO2/WD40.ZIP',	'WD40.ZIP',	'WD40.ZIP',	'.',	3475075,	'circuit',	'z',	'2003-12-12',	10,	539),
('http://tonkas.hopto.org/EVO2/WEEEEEE.zip',	'WEEEEEE.zip',	'WEEEEEE.zip',	'.',	5144998,	'circuit',	'z',	'2004-06-06',	10,	540),
('http://tonkas.hopto.org/EVO2/WEEEHA.pod',	'WEEEHA.pod',	'WEEEHA.pod',	'.',	8364436,	'circuit',	'p',	'2003-03-24',	10,	541),
('http://tonkas.hopto.org/EVO2/WEEEHA.zip',	'WEEEHA.zip',	'WEEEHA.zip',	'.',	3545772,	'circuit',	'z',	'2004-06-06',	10,	542),
('http://tonkas.hopto.org/EVO2/WELCOME.POD',	'WELCOME.POD',	'WELCOME.POD',	'.',	6324351,	'circuit',	'p',	'2004-04-15',	10,	543),
('http://tonkas.hopto.org/EVO2/WELCOME.ZIP',	'WELCOME.ZIP',	'WELCOME.ZIP',	'.',	2882862,	'circuit',	'z',	'2004-03-23',	10,	544),
('http://tonkas.hopto.org/EVO2/WHATTRAC.zip',	'WHATTRAC.zip',	'WHATTRAC.zip',	'.',	6091105,	'circuit',	'z',	'2004-08-27',	10,	545),
('http://tonkas.hopto.org/EVO2/WHITE.ZIP',	'WHITE.ZIP',	'WHITE.ZIP',	'.',	3252354,	'circuit',	'z',	'2003-12-20',	10,	546),
('http://tonkas.hopto.org/EVO2/WOLFRUN.pod',	'WOLFRUN.pod',	'WOLFRUN.pod',	'.',	7256424,	'circuit',	'p',	'2005-02-06',	10,	547),
('http://tonkas.hopto.org/EVO2/WOLFRUN.zip',	'WOLFRUN.zip',	'WOLFRUN.zip',	'.',	3497724,	'circuit',	'z',	'2005-02-12',	10,	548),
('http://tonkas.hopto.org/EVO2/woop.pod',	'woop.pod',	'woop.pod',	'.',	9355363,	'circuit',	'p',	'2004-05-22',	10,	549),
('http://tonkas.hopto.org/EVO2/WOOP.ZIP',	'WOOP.ZIP',	'WOOP.ZIP',	'.',	3761388,	'circuit',	'z',	'2003-11-02',	10,	550),
('http://tonkas.hopto.org/EVO2/XEON.ZIP',	'XEON.ZIP',	'XEON.ZIP',	'.',	3281440,	'circuit',	'z',	'2003-11-17',	10,	551),
('http://tonkas.hopto.org/EVO2/XPLGRND.ZIP',	'XPLGRND.ZIP',	'XPLGRND.ZIP',	'.',	2134433,	'circuit',	'z',	'2003-11-17',	10,	552),
('http://tonkas.hopto.org/EVO2/XPNDTHIS.pod',	'XPNDTHIS.pod',	'XPNDTHIS.pod',	'.',	13914169,	'circuit',	'p',	'2004-10-23',	10,	553),
('http://tonkas.hopto.org/EVO2/XPNDTHIS.zip',	'XPNDTHIS.zip',	'XPNDTHIS.zip',	'.',	4412556,	'circuit',	'z',	'2004-11-07',	10,	554),
('http://tonkas.hopto.org/EVO2/xsithskull.lte',	'xsithskull.lte',	'xsithskull.lte',	'.',	71715,	'circuit',	'l',	'2005-06-12',	10,	555),
('http://tonkas.hopto.org/EVO2/XTREMEX.pod',	'XTREMEX.pod',	'XTREMEX.pod',	'.',	2061554,	'circuit',	'p',	'2003-11-02',	10,	556),
('http://tonkas.hopto.org/EVO2/XTREMEX.ZIP',	'XTREMEX.ZIP',	'XTREMEX.ZIP',	'.',	485498,	'circuit',	'z',	'2003-11-17',	10,	557),
('http://tonkas.hopto.org/EVO2/YAKATON.pod',	'YAKATON.pod',	'YAKATON.pod',	'.',	9897421,	'circuit',	'p',	'2003-10-11',	10,	558),
('http://tonkas.hopto.org/EVO2/YAKATON.ZIP',	'YAKATON.ZIP',	'YAKATON.ZIP',	'.',	4597816,	'circuit',	'z',	'2003-11-17',	10,	559),
('http://tonkas.hopto.org/EVO2/YAY.pod',	'YAY.pod',	'YAY.pod',	'.',	10372033,	'circuit',	'p',	'2004-03-21',	10,	560),
('http://tonkas.hopto.org/EVO2/YES.pod',	'YES.pod',	'YES.pod',	'.',	15577034,	'circuit',	'p',	'2002-05-22',	10,	561),
('http://tonkas.hopto.org/EVO2/YES.ZIP',	'YES.ZIP',	'YES.ZIP',	'.',	6527857,	'circuit',	'z',	'2003-11-11',	10,	562),
('http://tonkas.hopto.org/EVO2/ZAMBIA.pod',	'ZAMBIA.pod',	'ZAMBIA.pod',	'.',	24863405,	'circuit',	'p',	'2003-12-15',	10,	563),
('http://tonkas.hopto.org/EVO2/ZAMBIA.zip',	'ZAMBIA.zip',	'ZAMBIA.zip',	'.',	8890977,	'circuit',	'z',	'2008-05-02',	10,	564),
('http://tonkas.hopto.org/EVO2/ZEP2STU2.pod',	'ZEP2STU2.pod',	'ZEP2STU2.pod',	'.',	5447257,	'circuit',	'p',	'2004-04-04',	10,	565),
('http://tonkas.hopto.org/EVO2/ZEP2STU2.zip',	'ZEP2STU2.zip',	'ZEP2STU2.zip',	'.',	2756045,	'circuit',	'z',	'2004-04-12',	10,	566),
('http://tonkas.hopto.org/EVO2/ZONTOR.pod',	'ZONTOR.pod',	'ZONTOR.pod',	'.',	13112229,	'circuit',	'p',	'2003-02-14',	10,	567),
('http://tonkas.hopto.org/EVO2/ZONTOR.ZIP',	'ZONTOR.ZIP',	'ZONTOR.ZIP',	'.',	5121313,	'circuit',	'z',	'2003-02-20',	10,	568),
('http://tonkas.hopto.org/EVO2/ZSRETURN.POD',	'ZSRETURN.POD',	'ZSRETURN.POD',	'.',	4254674,	'circuit',	'p',	'2004-01-29',	10,	569),
('http://tonkas.hopto.org/EVO2/ZSRETURN.ZIP',	'ZSRETURN.ZIP',	'ZSRETURN.ZIP',	'.',	1297416,	'circuit',	'z',	'2003-11-09',	10,	570),
('http://tonkas.hopto.org/EVO2/[RCG]Eagle.lte',	'[RCG]Eagle.lte',	'[RCG]Eagle.lte',	'.',	37013,	'circuit',	'l',	'2005-10-12',	10,	571),
('http://tonkas.hopto.org/EVO2/[RCG]HLT.lte',	'[RCG]HLT.lte',	'[RCG]HLT.lte',	'.',	52825,	'circuit',	'l',	'2005-04-13',	10,	572),
('http://tonkas.hopto.org/EVO2/[rcg]hltl.lte',	'[rcg]hltl.lte',	'[rcg]hltl.lte',	'.',	45132,	'circuit',	'l',	'2004-01-10',	10,	573),
('http://tonkas.hopto.org/EVO2/[RCG]SnowyA.lte',	'[RCG]SnowyA.lte',	'[RCG]SnowyA.lte',	'.',	56959,	'circuit',	'l',	'2003-11-27',	10,	574),
('http://tonkas.hopto.org/EVO2/[top]mtht.lte',	'[top]mtht.lte',	'[top]mtht.lte',	'.',	59775,	'circuit',	'l',	'2005-02-18',	10,	575),
('http://tonkas.hopto.org/EVO2/[TOP]trailsoldier.lte',	'[TOP]trailsoldier.lte',	'[TOP]trailsoldier.lte',	'.',	45557,	'circuit',	'l',	'2005-02-18',	10,	576);

-- 2021-02-05 11:28:36
