/* upd-server.c
 *
 * Copyright (c) 2000 Sean Walton and Macmillan Publishers.  Use may be in
 * whole or in part in accordance to the General Public License (GPL).
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

/*****************************************************************************/
/*** upd-server.c                                                          ***/
/***                                                                       ***/
/*** Create a datagram server that waits for client messages (which it     ***/
/*** echoes back).                                                         ***/
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/socket.h>
#include <resolv.h>
#include <string.h>

#define DEFAULT_UDP_PORT	1234

int main(int count, char *strings[])
{	int sd;
//	int i;		//use for counter
	int fport;  	//from port
	int lastport = 0;	//set last port for compare to from port
	int uport;  	//upper byte of from port
	int lport;  	//lower byte of from port
	int sbytes = 20; //# of bytes to send back
	int users;	//number of users on irc server
	int port=DEFAULT_UDP_PORT;
	struct sockaddr_in addr;
	char buffer[32];	//receive buffer
	char sbuffer[32];	//send buffer
	char temp[32]={0x0};	//results of netstat
	
	char o1[5], o2[5], o3[5], o4[5];  //set string rep of each octet
	int io1, io2, io3, io4;		//set int value for each octet

	
	if ( count != 2 )
		printf("usage: %s <port>\n...Using UDP default port (%d).\n", strings[0], port);
	else
		port = atoi(strings[1]);
	sd = socket(PF_INET, SOCK_DGRAM, 0);
	bzero(&addr, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	addr.sin_addr.s_addr = INADDR_ANY;
	if ( bind(sd, (struct sockaddr*)&addr, sizeof(addr)) != 0 )
		perror("bind");
	while (1)
	{	int bytes, addr_len=sizeof(addr);

		bytes = recvfrom(sd, buffer, sizeof(buffer), 0, (struct sockaddr*)&addr, &addr_len);

		//sscanf(inet_ntoa(addr.sin_addr), "%hu.%hu.%hu.%hu", &ip[0],&ip[1],&ip[2],&ip[3]);
		sscanf(inet_ntoa(addr.sin_addr), "%4[^.].%4[^.].%4[^.].%4[^.]", o1, o2, o3, o4);

		//set from port to port received from
		fport = ntohs(addr.sin_port);

		//set upper byte of port	
		uport = fport / 256;

		//set lower byte of port
		lport = fport - (uport * 256);
	
		//int of each octet
		io1 = atoi(o1);
		io2 = atoi(o2);
		io3 = atoi(o3);
		io4 = atoi(o4);

		//set send buffer to stuff I want
		sbuffer[0] = buffer[4];
		sbuffer[1] = buffer[5];
		sbuffer[2] = buffer[6];
		sbuffer[3] = buffer[7];
		sbuffer[4] = buffer[8];
		sbuffer[5] = buffer[9];
		sbuffer[6] = buffer[10];
		sbuffer[7] = buffer[11];

		//set this to from ip		
		sbuffer[8] = io1;
		sbuffer[9] = io2;
		sbuffer[10] = io3;
		sbuffer[11] = io4;

		//set this to port
		sbuffer[12] = uport;
		sbuffer[13] = lport;
		
		//pad the junk
		sbuffer[14] = 0;
		sbuffer[15] = 66;

		//prepare files
		FILE *inFile = NULL;
		FILE *ipFile = NULL;

		//open users file from current folder this is run from
		//to read user count
		inFile = fopen("/home/Tom/ircd/users","r");

		//open udpip file from current folder this is run from 
		//to write "w" to over writing old or append to "a"
		ipFile = fopen("/home/Tom/ircd/udpip","w");

		//test for users file existence
		if (!inFile)
		{
			printf("Error opening users\n");
		}

		//read user count from users file
		fscanf(inFile, "%d",&users);

		//close the users file now that I have the count
		fclose(inFile);

		//printf("from port = %d, lastport = %d",fport,lastport);

		//write the ip to udpip file
		/* this is ok but maybe the next one will work
 		 *if (fport != lastport)
		{
			fprintf(ipFile,"%s\n",inet_ntoa(addr.sin_addr));
			lastport = fport;
		}
		*/

		fprintf(ipFile,"%s\n",inet_ntoa(addr.sin_addr));
		
		//close the udpip file
		fclose(ipFile);

		//fprintf("%d users",users);

		//#   of users here all to 255 gives ? to users
		sbuffer[16] = 0;
		sbuffer[17] = 0;
		sbuffer[18] = 0;

		//i dont expect more than 255 uusers here at 19 otherwise use 18 and 19
		sbuffer[19] = users;

		sendto(sd, sbuffer, sbytes, 0, (struct sockaddr*)&addr, sizeof(addr));
	}
	close(sd);
}

