/* upd-server.c
 *
 * Copyright (c) 2000 Sean Walton and Macmillan Publishers.  Use may be in
 * whole or in part in accordance to the General Public License (GPL).
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

/*****************************************************************************/
/*** upd-server.c                                                          ***/
/***                                                                       ***/
/*** Create a datagram server that waits for client messages (which it     ***/
/*** echoes back).                                                         ***/
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/socket.h>
#include <resolv.h>
#include <string.h>
#include <arpa/inet.h>

#define DEFAULT_PORT	1234

int main(int count, char *strings[])
{	int sd;
//	int i;		//use for counter
	int fport;  	//from port
	int uport;  	//upper byte of from port
	int lport;  	//lower byte of from port
	int sbytes = 20; //# of bytes to send back
	int users;	//number on irc server
	int port=DEFAULT_PORT;
	struct sockaddr_in addr;
	char buffer[32];	//receive buffer
	char sbuffer[32];	//send buffer
	char temp[32]={0x0};	//results of netstat
	
	char o1[5], o2[5], o3[5], o4[5];  //set string rep of each octet
	int io1, io2, io3, io4;		//set int value for each octet

	if ( count != 2 )
		printf("usage: %s <port>\n...Using default port (%d).\n", strings[0], port);
	else
		port = atoi(strings[1]);
	sd = socket(PF_INET, SOCK_DGRAM, 0);
	bzero(&addr, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	addr.sin_addr.s_addr = INADDR_ANY;
	if ( bind(sd, (struct sockaddr*)&addr, sizeof(addr)) != 0 )
		perror("bind");
	while (1)
	{	int bytes, addr_len=sizeof(addr);

		/*
		for (i = 0; i < 12; i++)
		{
			sbuffer[i] = 0;
		}
		*/

		bytes = recvfrom(sd, buffer, sizeof(buffer), 0, (struct sockaddr*)&addr, &addr_len);

/*
		printf("msg from %s:%d (%d bytes)\n", inet_ntoa(addr.sin_addr),
						ntohs(addr.sin_port), bytes);
*/

		sscanf(inet_ntoa(addr.sin_addr), "%4[^.].%4[^.].%4[^.].%4[^.]", o1, o2, o3, o4);

		//set from port to port received from
		fport = ntohs(addr.sin_port);

		//set upper byte of port	
		uport = fport / 256;
		//printf("upper uport = %d\n",uport);

		//set lower byte of port
		lport = fport - (uport * 256);
		//printf("lower lport = %d\n",lport);
	
		//printf("sport = %s and fport = %d\n",sport, fport);

		//int of each octet
		io1 = atoi(o1);
		io2 = atoi(o2);
		io3 = atoi(o3);
		io4 = atoi(o4);

		//printf("From IP:%s %s %s %s: %d\n", o1, o2, o3, o4, fport);

		//this is what we received in hex
/*		printf("Received:\n");
		printf("%2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x\n",
			buffer[0], buffer[1], buffer[2], buffer[3], buffer[4], buffer[5], 
			buffer[6], buffer[7], buffer[8], buffer[9], buffer[10], buffer[11]);
*/
		//set send buffer to stuff I want
		sbuffer[0] = buffer[4];
		sbuffer[1] = buffer[5];
		sbuffer[2] = buffer[6];
		sbuffer[3] = buffer[7];
		sbuffer[4] = buffer[8];
		sbuffer[5] = buffer[9];
		sbuffer[6] = buffer[10];
		sbuffer[7] = buffer[11];
		//sbuffer[0] = buffer[4];

		/*for (i = 4; i < 12; i++)
		{
			sbuffer[i-4]=buffer[i];
		}
		*/
		//sprintf(sport, "%x", fport);

		//printf("From port in HEX: %s\n",sport);

		//sprintf(sport, "%x", port);
		//printf("To port in HEX: %s LEN = %d\n", sport, strlen(sport));

		//set this to from ip		
		sbuffer[8] = io1;
		sbuffer[9] = io2;
		sbuffer[10] = io3;
		sbuffer[11] = io4;

		//set this to port
		sbuffer[12] = uport;
		sbuffer[13] = lport;
		
		//not sure why i couldnt set it earlier
		//sbuffer[0] = buffer[4];
		
		//printf("%2x %2x\n",sbuffer[0], buffer[4]);

		//pad the junk
		sbuffer[14] = 0;
		sbuffer[15] = 66;

		//test doing netstat
		
  	/*FILE *in=popen("netstat -an | grep 192.168.1.7.6667 | wc -l", "r");
		while (fgets(temp,sizeof(temp),in)!=NULL)
		{
			//printf("Received: %s\n",temp);
		}
		pclose(in);
		
		users = atoi(temp);
	*/
		users=255;
		//#   of users here all to 255 gives ? to users
		sbuffer[16] = 255;
		sbuffer[17] = 255;
		sbuffer[18] = 255;
		//i dont expect more than 64 put here at 19 otherwise use 18 and 19
		sbuffer[19] = users;

/*		printf("Sending:\n");
		printf("%2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x\n",
			sbuffer[0], sbuffer[1], sbuffer[2], sbuffer[3], sbuffer[4], sbuffer[5], 
			sbuffer[6], sbuffer[7], sbuffer[8], sbuffer[9], sbuffer[10], sbuffer[11],
			sbuffer[12], sbuffer[13], sbuffer[14], sbuffer[15], sbuffer[16],
			sbuffer[17], sbuffer[18], sbuffer[19]);
*/
		sendto(sd, sbuffer, sbytes, 0, (struct sockaddr*)&addr, sizeof(addr));
	}
	close(sd);
}

