/*\
 *       Author: culb
 *      Version: 2
 *  Description: Get user count from a 4x4 Evolution server
 *      Compile: clang++ -std=c++20 evoucountcpp -o evoucount
 *
 *  Versions: 0 - Initial
 *            1 - Let user specify the IP
 *            2 - Let user specify the PORT
\*/

#include <array>        /* array */
#include <string>
//#include <system_error>
#include <cctype>       /* isdigit */
#include <cerrno>       /* errno */
#include <cstdint>      /* integer types */
#include <cstring>      /* strerror strlen */
#include <iostream>     /* cerr */
#include <algorithm>    /* all_of */
#include <unistd.h>     /* close() */
#include <arpa/inet.h>  /* inet_pton htons */
#include <sys/socket.h>
#include <netinet/in.h>

using std::cout;
using std::endl;
using std::stoi;
using std::cerr;
using std::array;
using std::all_of;
using std::strlen;
using std::isdigit;
using std::strerror;
using std::size_t;
using std::int32_t;
using std::int16_t;

constexpr bool ZERO = 0;
constexpr bool ONE  = 1;

int32_t main( const int32_t argc, const char *argv[] )
{
    //static const char* arg = argv[2];                                                                                                           /* Make sure an ip and port are specified */
    //uint8_t a = static_cast<uint8_t>( argv[2] );                                                                                                if( static_cast<int16_t>( argc ) != 3 )
    {
        cerr << "Usage: " << argv[2] << " <IP> <PORT>" << endl;
        return EXIT_FAILURE;
    }

    /* Check if port is numbers */
    if( not all_of( argv[2], argv[2] + strlen( argv[2] ),
                    [](uint8_t c){return isdigit( c );} ))
    {
        cerr << "Invalid port, use only digits." << endl;
        return EXIT_FAILURE;
    }

    /* Check if the first arguement is a valid ip */
    sockaddr_in check;
    if( static_cast<int32_t>( argc ) != 3 and inet_pton( AF_INET, argv[1], &check.sin_addr ) <= ZERO )
    {
        cerr << "Invalid address: " << argv[1] << endl;
        return EXIT_FAILURE;
    }

    const char *serverIP = argv[1];
    const int16_t serverPort = stoi( argv[2] );

    /* Socket creation */
    static int32_t sockfd = socket( AF_INET, SOCK_DGRAM, ZERO );
    if( sockfd < ZERO )
    {
        cerr << "Failed to create socket: " << strerror( errno ) << endl;
        return EXIT_FAILURE;
    }

    /* Socket setup */
    sockaddr_in serverAddr;
    serverAddr.sin_family = AF_INET;
    serverAddr.sin_port = htons( serverPort );
    if( inet_pton( AF_INET, serverIP, &serverAddr.sin_addr ) <= ZERO )
    {
        cerr << "Invalid address: " << serverIP << endl;
        close( sockfd );
        return EXIT_FAILURE;
    }

    /* Array of data to send. 23202020232020203f33790a */
    constexpr array<uint8_t, 12> dataSend =
                                 { 0x23, 0x20, 0x20, 0x20, 0x20, 0x20,
                                   0x20, 0x20, 0x3f, 0x33, 0x79, 0x0a };

    /* Send to the server */
    ssize_t bytesSent =
            sendto( sockfd, dataSend.data(), dataSend.size(),
                    ZERO, reinterpret_cast<const sockaddr*>( &serverAddr ), sizeof( serverAddr ));

    if( bytesSent != static_cast<ssize_t>( dataSend.size()) )
    {
        cerr << "Failed to send data: " << strerror( errno ) << endl;
        close( sockfd );
        return EXIT_FAILURE;
    }

    /* Response from server */
    array<uint8_t, 32> recvBuffer;
    sockaddr_in fromAddr;
    socklen_t fromLen = sizeof( fromAddr );
    ssize_t bytesRecv =
            recvfrom( sockfd, recvBuffer.data(), recvBuffer.size(),
                      ZERO, reinterpret_cast<sockaddr*>( &fromAddr ), &fromLen );

    if( bytesRecv < ZERO )
    {
        cerr << "Failed to receive data: " << strerror( errno ) << endl;
        close( sockfd );
        return EXIT_FAILURE;
    }

    if( bytesRecv == ZERO )
    {
        cout << "No data received." << endl;
        close( sockfd );
        return EXIT_FAILURE;
    }

    /* Last byte received has the user count */
    static uint8_t byteLast = recvBuffer[bytesRecv - ONE];

    cout << "Number of users " << static_cast<int>( byteLast ) << endl;

    close( sockfd );
    return EXIT_SUCC